/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzdq;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbft;
import com.google.android.gms.internal.ads.zzbgf;
import com.google.android.gms.internal.ads.zzbmo;
import com.google.android.gms.internal.ads.zzbms;
import com.google.android.gms.internal.ads.zzcbn;
import com.google.android.gms.internal.ads.zzccn;
import com.google.android.gms.internal.ads.zzctr;
import com.google.android.gms.internal.ads.zzdkf;
import com.google.android.gms.internal.ads.zzdkk;
import com.google.android.gms.internal.ads.zzdoj;
import java.util.Collections;

public final class zzdok
extends zzbmo
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzbft {
    private View zza;
    private zzdq zzb;
    private zzdkf zzc;
    private boolean zzd;
    private boolean zze;

    @Nullable
    public final zzdq zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            zzcbn.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    @Nullable
    public final zzbgf zzc() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdok)((Object)zzdkf2)).zzd) {
            zzcbn.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzdkf zzdkf2 = ((zzdok)((Object)zzdkf2)).zzc;
        if (zzdkf2 != null && zzdkf2.zzc() != null) {
            return zzdkf2.zzc().zza();
        }
        return null;
    }

    public zzdok(zzdkf zzdkf2, zzdkk zzdkk2) {
        this.zza = zzdkk2.zzf();
        this.zzb = zzdkk2.zzj();
        this.zzc = zzdkf2;
        this.zzd = false;
        this.zze = false;
        if (zzdkk2.zzs() != null) {
            zzdkk2.zzs().zzam(this);
            return;
        }
    }

    public final void zzd() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzh();
        zzdkf zzdkf2 = this.zzc;
        if (zzdkf2 != null) {
            ((zzctr)zzdkf2).zzb();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view;
        zzdkf zzdkf2 = this.zzc;
        if (zzdkf2 != null && (view = this.zza) != null) {
            zzdkf2.zzA(view, Collections.emptyMap(), Collections.emptyMap(), zzdkf.zzW(this.zza));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzh() {
        View view = this.zza;
        if (view == null || !((view = view.getParent()) instanceof ViewGroup)) {
            return;
        }
        ((ViewGroup)view).removeView(this.zza);
    }

    public final void onGlobalLayout() {
        this.zzg();
    }

    public final void onScrollChanged() {
        this.zzg();
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzf(iObjectWrapper, (zzbms)new zzdoj(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzf(IObjectWrapper iObjectWrapper, zzbms zzbms2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdok)((Object)string2)).zzd) {
            zzcbn.zzg((String)"Instream ad can not be shown after destroy().");
            zzdok.zzi(zzbms2, 2);
            return;
        }
        View view = ((zzdok)((Object)string2)).zza;
        if (view == null || ((zzdok)((Object)string2)).zzb == null) {
            String string2 = view == null ? "can not get video view." : "can not get video controller.";
            zzcbn.zzg((String)"Instream internal error: ".concat(string2));
            zzdok.zzi(zzbms2, 0);
            return;
        }
        if (((zzdok)((Object)string2)).zze) {
            zzcbn.zzg((String)"Instream ad should not be used again.");
            zzdok.zzi(zzbms2, 1);
            return;
        }
        ((zzdok)((Object)string2)).zze = true;
        super.zzh();
        ((ViewGroup)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).addView(((zzdok)((Object)string2)).zza, new ViewGroup.LayoutParams(-1, -1));
        zzt.zzx();
        zzccn.zza(((zzdok)((Object)string2)).zza, (ViewTreeObserver.OnGlobalLayoutListener)string2);
        zzt.zzx();
        zzccn.zzb(((zzdok)((Object)string2)).zza, (ViewTreeObserver.OnScrollChangedListener)string2);
        super.zzg();
        try {
            zzbms2.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            zzcbn.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    private static final void zzi(zzbms zzbms2, int n) {
        try {
            zzbms2.zze(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzcbn.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

