/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.overlay.zzz;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzcbn;

public final class zza {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean zzc(Context context, Uri uri, zzz zzz2, zzx zzx2) {
        int n;
        try {
            n = zzt.zzp().zzm(context, uri);
            if (zzz2 != null) {
                zzz2.zzg();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzcbn.zzj((String)activityNotFoundException.getMessage());
            n = 6;
        }
        if (zzx2 != null) {
            zzx2.zzb(n);
        }
        return n == 5;
    }

    public static final boolean zza(Context context, Intent intent, zzz zzz2, @Nullable zzx zzx2, boolean bl) {
        block7: {
            if (bl) {
                return zza.zzc(context, intent.getData(), zzz2, zzx2);
            }
            try {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Launching an intent: ");
                stringBuilder.append(intent.toURI());
                String string2 = stringBuilder.toString();
                zze.zza(string2);
                zzt.zzp();
                com.google.android.gms.ads.internal.util.zzt.zzS(context, intent);
                if (zzz2 == null) break block7;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                zzcbn.zzj((String)activityNotFoundException.getMessage());
                if (zzx2 != null) {
                    zzx2.zza(false);
                }
                return false;
            }
            zzz2.zzg();
        }
        if (zzx2 != null) {
            zzx2.zza(true);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean zzb(Context object, @Nullable zzc zzc2, zzz zzz2, @Nullable zzx zzx2) {
        void var3_4;
        void var2_3;
        void var1_2;
        if (var1_2 == null) {
            zzcbn.zzj((String)"No intent data for launcher overlay.");
            return false;
        }
        zzbdc.zza((Context)object);
        String[] stringArray = var1_2.zzh;
        if (stringArray != null) {
            return zza.zza(object, (Intent)stringArray, (zzz)var2_3, (zzx)var3_4, var1_2.zzj);
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)var1_2.zzb)) {
            zzcbn.zzj((String)"Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)var1_2.zzc)) {
            stringArray = var1_2.zzc;
            intent.setDataAndType(Uri.parse((String)var1_2.zzb), (String)stringArray);
        } else {
            intent.setData(Uri.parse((String)var1_2.zzb));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)var1_2.zzd)) {
            intent.setPackage(var1_2.zzd);
        }
        if (!TextUtils.isEmpty((CharSequence)var1_2.zze)) {
            stringArray = var1_2.zze.split("/", 2);
            if (stringArray.length < 2) {
                String string2 = var1_2.zze;
                zzcbn.zzj((String)"Could not parse component name from open GMSG: ".concat(String.valueOf(string2)));
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = var1_2.zzf))) {
            int n;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zzcbn.zzj((String)"Could not parse intent flags.");
                n = 0;
            }
            intent.addFlags(n);
        }
        zzbcu zzbcu2 = zzbdc.zzes;
        if (((Boolean)zzba.zzc().zza(zzbcu2)).booleanValue()) {
            intent.addFlags(0x10000000);
            intent.putExtra("android.support.customtabs.extra.user_opt_out", true);
            return zza.zza(object, intent, (zzz)var2_3, (zzx)var3_4, var1_2.zzj);
        }
        zzbcu2 = zzbdc.zzer;
        if ((Boolean)zzba.zzc().zza(zzbcu2) == false) return zza.zza(object, intent, (zzz)var2_3, (zzx)var3_4, var1_2.zzj);
        zzt.zzp();
        com.google.android.gms.ads.internal.util.zzt.zzo(object, intent);
        return zza.zza(object, intent, (zzz)var2_3, (zzx)var3_4, var1_2.zzj);
    }
}

