/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAdMapper;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzane;
import com.google.android.gms.internal.ads.zzqv;
import com.google.android.gms.internal.ads.zzxt;
import com.google.android.gms.internal.ads.zzyi;

@zzadh
public final class zzyl
implements MediationBannerListener,
MediationInterstitialListener,
MediationNativeListener {
    private final zzxt zzbuu;
    private NativeAdMapper zzbuv;
    private UnifiedNativeAdMapper zzbuw;
    private NativeCustomTemplateAd zzbux;

    public zzyl(zzxt zzxt2) {
        this.zzbuu = zzxt2;
    }

    @Override
    public final void zza(MediationBannerAdapter mediationBannerAdapter, String string, String string2) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAppEvent.");
        try {
            this.zzbuu.onAppEvent(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdClicked.");
        try {
            this.zzbuu.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdClosed.");
        try {
            this.zzbuu.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationBannerAdapter mediationBannerAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error. ").append(n).toString());
        try {
            this.zzbuu.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdLeftApplication.");
        try {
            this.zzbuu.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdOpened.");
        try {
            this.zzbuu.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdLoaded.");
        try {
            this.zzbuu.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdClicked.");
        try {
            this.zzbuu.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdClosed.");
        try {
            this.zzbuu.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationInterstitialAdapter mediationInterstitialAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzbuu.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdLeftApplication.");
        try {
            this.zzbuu.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdOpened.");
        try {
            this.zzbuu.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdLoaded.");
        try {
            this.zzbuu.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, NativeAdMapper nativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdLoaded.");
        this.zzbuv = nativeAdMapper;
        this.zzbuw = null;
        zzyl.zza(mediationNativeAdapter, this.zzbuw, this.zzbuv);
        try {
            this.zzbuu.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, UnifiedNativeAdMapper unifiedNativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdLoaded.");
        this.zzbuw = unifiedNativeAdMapper;
        this.zzbuv = null;
        zzyl.zza(mediationNativeAdapter, this.zzbuw, this.zzbuv);
        try {
            this.zzbuu.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private static void zza(MediationNativeAdapter mediationNativeAdapter, @Nullable UnifiedNativeAdMapper unifiedNativeAdMapper, @Nullable NativeAdMapper nativeAdMapper) {
        if (mediationNativeAdapter instanceof AdMobAdapter) {
            return;
        }
        VideoController videoController = new VideoController();
        videoController.zza(new zzyi());
        if (unifiedNativeAdMapper != null && unifiedNativeAdMapper.hasVideoContent()) {
            unifiedNativeAdMapper.zza(videoController);
        }
        if (nativeAdMapper != null && nativeAdMapper.hasVideoContent()) {
            nativeAdMapper.zza(videoController);
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        String string = String.valueOf(nativeCustomTemplateAd.getCustomTemplateId());
        zzane.zzck(string.length() != 0 ? "Adapter called onAdLoaded with template id ".concat(string) : new String("Adapter called onAdLoaded with template id "));
        this.zzbux = nativeCustomTemplateAd;
        try {
            this.zzbuu.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
        if (nativeCustomTemplateAd instanceof zzqv) {
            try {
                this.zzbuu.zzb(((zzqv)nativeCustomTemplateAd).zzku(), string);
                return;
            }
            catch (RemoteException remoteException) {
                zzane.zzd("#007 Could not call remote method.", remoteException);
                return;
            }
        }
        zzane.zzdk("Unexpected native custom template ad type.");
    }

    @Override
    public final void onAdFailedToLoad(MediationNativeAdapter mediationNativeAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzbuu.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdOpened.");
        try {
            this.zzbuu.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdClosed.");
        try {
            this.zzbuu.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onAdLeftApplication.");
        try {
            this.zzbuu.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzbuv;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzbuw;
        if (this.zzbux == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzane.zzd("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideClickHandling()) {
                zzane.zzck("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideClickHandling()) {
                zzane.zzck("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
        }
        zzane.zzck("Adapter called onAdClicked.");
        try {
            this.zzbuu.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdImpression(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzbuv;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzbuw;
        if (this.zzbux == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzane.zzd("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideImpressionRecording()) {
                zzane.zzck("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideImpressionRecording()) {
                zzane.zzck("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
        }
        zzane.zzck("Adapter called onAdImpression.");
        try {
            this.zzbuu.onAdImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onVideoEnd(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzane.zzck("Adapter called onVideoEnd.");
        try {
            this.zzbuu.onVideoEnd();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final NativeAdMapper zzmx() {
        return this.zzbuv;
    }

    public final UnifiedNativeAdMapper zzmy() {
        return this.zzbuw;
    }

    public final NativeCustomTemplateAd zzmz() {
        return this.zzbux;
    }
}

