/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzane;
import com.google.android.gms.internal.ads.zzlo;
import com.google.android.gms.internal.ads.zzpw;
import com.google.android.gms.internal.ads.zzpz;
import com.google.android.gms.internal.ads.zzqs;
import java.util.List;
import java.util.WeakHashMap;

@zzadh
public final class zzqv
implements NativeCustomTemplateAd {
    private static WeakHashMap<IBinder, zzqv> zzbkt = new WeakHashMap();
    private final zzqs zzbku;
    private final MediaView zzbkv;
    private final VideoController zzasv = new VideoController();

    @VisibleForTesting
    private zzqv(zzqs zzqs2) {
        this.zzbku = zzqs2;
        Context context = null;
        try {
            context = (Context)ObjectWrapper.unwrap((IObjectWrapper)zzqs2.zzkh());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzane.zzb("", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            Object object = context;
            mediaView = new MediaView((Context)object);
            try {
                if (!this.zzbku.zzh(ObjectWrapper.wrap((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                object = remoteException;
                zzane.zzb("", (Throwable)object);
            }
        }
        this.zzbkv = mediaView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzqv zza(zzqs zzqs2) {
        WeakHashMap<IBinder, zzqv> weakHashMap = zzbkt;
        synchronized (weakHashMap) {
            zzqv zzqv2 = zzbkt.get(zzqs2.asBinder());
            if (zzqv2 != null) {
                return zzqv2;
            }
            zzqv2 = new zzqv(zzqs2);
            zzbkt.put(zzqs2.asBinder(), zzqv2);
            return zzqv2;
        }
    }

    public final zzqs zzku() {
        return this.zzbku;
    }

    @Override
    public final CharSequence getText(String string) {
        try {
            return this.zzbku.zzao(string);
        }
        catch (RemoteException remoteException) {
            zzane.zzb("", remoteException);
            return null;
        }
    }

    @Override
    public final NativeAd.Image getImage(String string) {
        try {
            zzpw zzpw2 = this.zzbku.zzap(string);
            if (zzpw2 != null) {
                return new zzpz(zzpw2);
            }
        }
        catch (RemoteException remoteException) {
            zzane.zzb("", remoteException);
        }
        return null;
    }

    @Override
    public final VideoController getVideoController() {
        try {
            zzlo zzlo2 = this.zzbku.getVideoController();
            if (zzlo2 != null) {
                this.zzasv.zza(zzlo2);
            }
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Exception occurred while getting video controller", remoteException);
        }
        return this.zzasv;
    }

    @Override
    public final MediaView getVideoMediaView() {
        return this.zzbkv;
    }

    @Override
    public final List<String> getAvailableAssetNames() {
        try {
            return this.zzbku.getAvailableAssetNames();
        }
        catch (RemoteException remoteException) {
            zzane.zzb("", remoteException);
            return null;
        }
    }

    @Override
    public final String getCustomTemplateId() {
        try {
            return this.zzbku.getCustomTemplateId();
        }
        catch (RemoteException remoteException) {
            zzane.zzb("", remoteException);
            return null;
        }
    }

    @Override
    public final void performClick(String string) {
        try {
            this.zzbku.performClick(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("", remoteException);
            return;
        }
    }

    @Override
    public final void recordImpression() {
        try {
            this.zzbku.recordImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("", remoteException);
            return;
        }
    }

    @Override
    public final void destroy() {
        try {
            this.zzbku.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("", remoteException);
            return;
        }
    }
}

