/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzagz;
import com.google.android.gms.internal.ads.zzahm;
import com.google.android.gms.internal.ads.zzane;
import com.google.android.gms.internal.ads.zzjr;
import com.google.android.gms.internal.ads.zzjw;
import com.google.android.gms.internal.ads.zzjz;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzlj;
import com.google.android.gms.internal.ads.zzmc;
import com.google.android.gms.internal.ads.zzmd;
import com.google.android.gms.internal.ads.zzxm;
import javax.annotation.concurrent.GuardedBy;

@zzadh
public final class zzmb {
    @GuardedBy(value="sLock")
    private static zzmb zzate;
    private static final Object sLock;
    private zzlj zzatf;
    private RewardedVideoAd zzatg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzmb zziv() {
        Object object = sLock;
        synchronized (object) {
            if (zzate == null) {
                zzate = new zzmb();
            }
            return zzate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Context context, String string, zzmd zzmd2) {
        Object object = sLock;
        synchronized (object) {
            if (this.zzatf != null) {
                return;
            }
            if (context == null) {
                throw new IllegalArgumentException("Context cannot be null.");
            }
            try {
                Context context2 = context;
                zzjr zzjr2 = zzkb.zzig();
                zzjw zzjw2 = new zzjw(zzjr2, context2);
                Context context3 = context2;
                this.zzatf = zzjr.zza(context3, false, zzjw2);
                this.zzatf.zza();
                if (string != null) {
                    this.zzatf.zza(string, ObjectWrapper.wrap((Object)new zzmc(this, context)));
                }
            }
            catch (RemoteException remoteException) {
                zzane.zzc("MobileAdsSettingManager initialization failed", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RewardedVideoAd getRewardedVideoAdInstance(Context context) {
        Object object = sLock;
        synchronized (object) {
            zzxm zzxm2;
            if (this.zzatg != null) {
                return this.zzatg;
            }
            zzxm zzxm3 = zzxm2 = new zzxm();
            Context context2 = context;
            zzjr zzjr2 = zzkb.zzig();
            zzjz zzjz2 = new zzjz(zzjr2, context2, zzxm3);
            Context context3 = context2;
            zzagz zzagz2 = zzjr.zza(context3, false, zzjz2);
            this.zzatg = new zzahm(context, zzagz2);
            return this.zzatg;
        }
    }

    public final void setAppVolume(float f) {
        Preconditions.checkArgument((0.0f <= f && f <= 1.0f ? 1 : 0) != 0, (Object)"The app volume must be a value between 0 and 1 inclusive.");
        Preconditions.checkState((this.zzatf != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting the app volume.");
        try {
            this.zzatf.setAppVolume(f);
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to set app volume.", remoteException);
            return;
        }
    }

    public final float zzdo() {
        float f = 1.0f;
        if (this.zzatf == null) {
            return 1.0f;
        }
        try {
            f = this.zzatf.zzdo();
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to get app volume.", remoteException);
        }
        return f;
    }

    public final void setAppMuted(boolean bl) {
        Preconditions.checkState((this.zzatf != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting app muted state.");
        try {
            this.zzatf.setAppMuted(bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to set app mute state.", remoteException);
            return;
        }
    }

    public final boolean zzdp() {
        boolean bl = false;
        if (this.zzatf == null) {
            return false;
        }
        try {
            bl = this.zzatf.zzdp();
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to get app mute state.", remoteException);
        }
        return bl;
    }

    public final void openDebugMenu(Context context, String string) {
        Preconditions.checkState((this.zzatf != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to opening debug menu.");
        try {
            this.zzatf.zzb(ObjectWrapper.wrap((Object)context), string);
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to open debug menu.", remoteException);
            return;
        }
    }

    private zzmb() {
    }

    static {
        sLock = new Object();
    }
}

