/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzane;
import com.google.android.gms.internal.ads.zzjd;
import com.google.android.gms.internal.ads.zzje;
import com.google.android.gms.internal.ads.zzjf;
import com.google.android.gms.internal.ads.zzjm;
import com.google.android.gms.internal.ads.zzjn;
import com.google.android.gms.internal.ads.zzjp;
import com.google.android.gms.internal.ads.zzjq;
import com.google.android.gms.internal.ads.zzjr;
import com.google.android.gms.internal.ads.zzjs;
import com.google.android.gms.internal.ads.zzjt;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zzks;
import com.google.android.gms.internal.ads.zzlo;
import com.google.android.gms.internal.ads.zzlw;
import com.google.android.gms.internal.ads.zzlz;
import com.google.android.gms.internal.ads.zzmu;
import com.google.android.gms.internal.ads.zzog;
import com.google.android.gms.internal.ads.zzxm;
import java.util.concurrent.atomic.AtomicBoolean;

@zzadh
public final class zzly {
    private final zzxm zzast = new zzxm();
    private final zzjm zzuk;
    private final AtomicBoolean zzasu;
    private final VideoController zzasv = new VideoController();
    @VisibleForTesting
    private final zzkd zzasw = new zzlz(this);
    private zzjd zzapt;
    private AdListener zzapu;
    private AdSize[] zzarh;
    private AppEventListener zzvo;
    private Correlator zzasx;
    private zzks zzasy;
    private OnCustomRenderedAdLoadedListener zzasz;
    private VideoOptions zzvg;
    private String zzye;
    private ViewGroup zzata;
    private int zzatb;
    private boolean zzvm;

    public zzly(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzjm.zzara, 0);
    }

    public zzly(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zzjm.zzara, n);
    }

    public zzly(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzjm.zzara, 0);
    }

    public zzly(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zzjm.zzara, n);
    }

    @VisibleForTesting
    private zzly(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzjm zzjm2, zzks zzks2, int n) {
        this.zzata = viewGroup;
        this.zzuk = zzjm2;
        this.zzasy = null;
        this.zzasu = new AtomicBoolean(false);
        this.zzatb = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzjq zzjq2 = new zzjq(context, attributeSet);
                this.zzarh = zzjq2.zzi(bl);
                this.zzye = zzjq2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzkb.zzif().zza(viewGroup, new zzjn(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                boolean bl2;
                int n2 = this.zzatb;
                AdSize adSize = this.zzarh[0];
                Context context2 = context;
                zzjn zzjn2 = new zzjn(context2, adSize);
                new zzjn(context2, adSize).zzarg = bl2 = zzly.zzu(n2);
                zzkb.zzif().zza(viewGroup, zzjn2, "Ads by Google");
            }
        }
    }

    @VisibleForTesting
    private zzly(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzjm zzjm2, int n) {
        this(viewGroup, attributeSet, bl, zzjm2, null, n);
    }

    public final void destroy() {
        try {
            if (this.zzasy != null) {
                this.zzasy.destroy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final AdListener getAdListener() {
        return this.zzapu;
    }

    public final AdSize getAdSize() {
        try {
            zzjn zzjn2;
            if (this.zzasy != null && (zzjn2 = this.zzasy.zzbk()) != null) {
                return zzjn2.zzhy();
            }
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
        }
        if (this.zzarh != null) {
            return this.zzarh[0];
        }
        return null;
    }

    public final AdSize[] getAdSizes() {
        return this.zzarh;
    }

    public final String getAdUnitId() {
        if (this.zzye == null && this.zzasy != null) {
            try {
                this.zzye = this.zzasy.getAdUnitId();
            }
            catch (RemoteException remoteException) {
                zzane.zzd("#007 Could not call remote method.", remoteException);
            }
        }
        return this.zzye;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzvo;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzasz;
    }

    public final void zza(zzlw zzlw2) {
        try {
            if (this.zzasy == null) {
                zzks zzks2;
                zzjn zzjn2;
                zzly zzly2 = this;
                if ((zzly2.zzarh == null || zzly2.zzye == null) && zzly2.zzasy == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzly zzly3 = zzly2;
                Context context = zzly3.zzata.getContext();
                Object object = zzjn2 = zzly.zza(context, zzly3.zzarh, zzly3.zzatb);
                if ("search_v2".equals(object.zzarb)) {
                    String string = zzly3.zzye;
                    zzjn zzjn3 = zzjn2;
                    Context context2 = context;
                    object = zzkb.zzig();
                    zzjt zzjt2 = new zzjt((zzjr)object, context2, zzjn3, string);
                    Context context3 = context2;
                    zzks2 = zzjr.zza(context3, false, zzjt2);
                } else {
                    zzxm zzxm2 = zzly3.zzast;
                    String string = zzly3.zzye;
                    zzjn zzjn4 = zzjn2;
                    Context context4 = context;
                    object = zzkb.zzig();
                    zzjs zzjs2 = new zzjs((zzjr)object, context4, zzjn4, string, zzxm2);
                    Context context5 = context4;
                    zzks2 = zzjr.zza(context5, false, zzjs2);
                }
                zzly2.zzasy = zzks2;
                zzly2.zzasy.zza(new zzjf(zzly2.zzasw));
                if (zzly2.zzapt != null) {
                    zzly2.zzasy.zza(new zzje(zzly2.zzapt));
                }
                if (zzly2.zzvo != null) {
                    zzly2.zzasy.zza(new zzjp(zzly2.zzvo));
                }
                if (zzly2.zzasz != null) {
                    zzly2.zzasy.zza(new zzog(zzly2.zzasz));
                }
                if (zzly2.zzasx != null) {
                    zzly2.zzasy.zza(zzly2.zzasx.zzaz());
                }
                if (zzly2.zzvg != null) {
                    zzly2.zzasy.zza(new zzmu(zzly2.zzvg));
                }
                zzly2.zzasy.setManualImpressionsEnabled(zzly2.zzvm);
                zzly zzly4 = zzly2;
                try {
                    IObjectWrapper iObjectWrapper = zzly4.zzasy.zzbj();
                    if (iObjectWrapper != null) {
                        zzly4.zzata.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzane.zzd("#007 Could not call remote method.", remoteException);
                }
            }
            if (this.zzasy.zzb(zzjm.zza(this.zzata.getContext(), zzlw2))) {
                this.zzast.zzj(zzlw2.zzir());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void pause() {
        try {
            if (this.zzasy != null) {
                this.zzasy.pause();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void recordManualImpression() {
        if (this.zzasu.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzasy != null) {
                this.zzasy.zzbm();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void resume() {
        try {
            if (this.zzasy != null) {
                this.zzasy.resume();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        this.zzapu = adListener;
        this.zzasw.zza(adListener);
    }

    public final void zza(zzjd zzjd2) {
        try {
            this.zzapt = zzjd2;
            if (this.zzasy != null) {
                this.zzasy.zza(zzjd2 != null ? new zzje(zzjd2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzarh != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public final void zza(AdSize ... adSizeArray) {
        this.zzarh = adSizeArray;
        try {
            if (this.zzasy != null) {
                this.zzasy.zza(zzly.zza(this.zzata.getContext(), this.zzarh, this.zzatb));
            }
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
        }
        this.zzata.requestLayout();
    }

    public final void setAdUnitId(String string) {
        if (this.zzye != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzye = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzvo = appEventListener;
            if (this.zzasy != null) {
                this.zzasy.zza(appEventListener != null ? new zzjp(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzasz = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzasy != null) {
                this.zzasy.zza(onCustomRenderedAdLoadedListener != null ? new zzog(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzvm = bl;
        try {
            if (this.zzasy != null) {
                this.zzasy.setManualImpressionsEnabled(this.zzvm);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzasx = correlator;
        try {
            if (this.zzasy != null) {
                this.zzasy.zza(this.zzasx == null ? null : this.zzasx.zzaz());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzasy != null) {
                return this.zzasy.zzck();
            }
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
        }
        return null;
    }

    public final boolean isLoading() {
        try {
            if (this.zzasy != null) {
                return this.zzasy.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
        }
        return false;
    }

    public final VideoController getVideoController() {
        return this.zzasv;
    }

    public final zzlo zzbc() {
        if (this.zzasy == null) {
            return null;
        }
        try {
            return this.zzasy.getVideoController();
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return null;
        }
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzvg = videoOptions;
        try {
            if (this.zzasy != null) {
                this.zzasy.zza(videoOptions == null ? null : new zzmu(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final VideoOptions getVideoOptions() {
        return this.zzvg;
    }

    public final boolean zza(zzks zzks2) {
        IObjectWrapper iObjectWrapper;
        if (zzks2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzks2.zzbj();
        }
        catch (RemoteException remoteException) {
            zzane.zzd("#007 Could not call remote method.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzata.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        this.zzasy = zzks2;
        return true;
    }

    private static zzjn zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        zzjn zzjn2 = new zzjn(context, adSizeArray);
        new zzjn(context, adSizeArray).zzarg = bl = zzly.zzu(n);
        return zzjn2;
    }

    private static boolean zzu(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzly zzly2) {
        return zzly2.zzasv;
    }
}

