/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.internal.ads.zzaao;
import com.google.android.gms.internal.ads.zzaap;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzahi;
import com.google.android.gms.internal.ads.zzamu;
import com.google.android.gms.internal.ads.zzane;
import com.google.android.gms.internal.ads.zzjg;
import com.google.android.gms.internal.ads.zzjh;
import com.google.android.gms.internal.ads.zzjv;
import com.google.android.gms.internal.ads.zzjx;
import com.google.android.gms.internal.ads.zzjy;
import com.google.android.gms.internal.ads.zzka;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzkn;
import com.google.android.gms.internal.ads.zzld;
import com.google.android.gms.internal.ads.zzle;
import com.google.android.gms.internal.ads.zzme;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zzqa;
import com.google.android.gms.internal.ads.zzqf;
import com.google.android.gms.internal.ads.zzrv;
import com.google.android.gms.internal.ads.zzrw;
import com.google.android.gms.internal.ads.zzxn;
import java.util.HashMap;
import javax.annotation.concurrent.GuardedBy;

@zzadh
public class zzjr {
    @GuardedBy(value="mLock")
    private zzld zzari;
    private final Object mLock = new Object();
    private final zzjh zzarj;
    private final zzjg zzark;
    private final zzme zzarl;
    private final zzrv zzarm;
    private final zzahi zzarn;
    private final zzaao zzaro;
    private final zzrw zzarp;

    public zzjr(zzjh zzjh2, zzjg zzjg2, zzme zzme2, zzrv zzrv2, zzahi zzahi2, zzaao zzaao2, zzrw zzrw2) {
        this.zzarj = zzjh2;
        this.zzark = zzjg2;
        this.zzarl = zzme2;
        this.zzarm = zzrv2;
        this.zzarn = zzahi2;
        this.zzaro = zzaao2;
        this.zzarp = zzrw2;
    }

    @Nullable
    private static zzld zzhz() {
        try {
            Object obj = zzjr.class.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi").newInstance();
            if (!(obj instanceof IBinder)) {
                zzane.zzdk("ClientApi class is not an instance of IBinder");
                return null;
            }
            return zzle.asInterface((IBinder)obj);
        }
        catch (Exception exception) {
            zzane.zzc("Failed to instantiate ClientApi class.", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final zzld zzia() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzari == null) {
                this.zzari = zzjr.zzhz();
            }
            return this.zzari;
        }
    }

    @VisibleForTesting
    static <T> T zza(Context context, boolean bl, zza<T> zza2) {
        T t;
        boolean bl2 = bl;
        if (!bl2) {
            zzkb.zzif();
            if (!zzamu.zzbe(context)) {
                zzane.zzck("Google Play Services is not available");
                bl2 = true;
            }
        }
        zzkb.zzif();
        int n = zzamu.zzbg(context);
        zzkb.zzif();
        if (n > zzamu.zzbf(context)) {
            bl2 = true;
        }
        zznk.initialize(context);
        zzna<Boolean> zzna2 = zznk.zzber;
        if (zzkb.zzik().zzd(zzna2).booleanValue()) {
            bl2 = false;
        }
        if (bl2) {
            t = zza2.zzic();
            if (t == null) {
                t = zza2.zzid();
            }
        } else {
            t = zza2.zzid();
            if (t == null) {
                t = zza2.zzic();
            }
        }
        return t;
    }

    private static void zza(Context context, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("action", "no_ads_fallback");
        bundle.putString("flow", string);
        zzkb.zzif().zza(context, null, "gmob-apps", bundle, true);
    }

    public final zzkn zzb(Context context, String string, zzxn zzxn2) {
        zzjv zzjv2 = new zzjv(this, context, string, zzxn2);
        Context context2 = context;
        return zzjr.zza(context2, false, zzjv2);
    }

    public final zzqa zza(Context context, FrameLayout frameLayout, FrameLayout frameLayout2) {
        zzjx zzjx2 = new zzjx(this, frameLayout, frameLayout2, context);
        Context context2 = context;
        return zzjr.zza(context2, false, zzjx2);
    }

    public final zzqf zza(View view, HashMap<String, View> hashMap, HashMap<String, View> hashMap2) {
        zzjy zzjy2 = new zzjy(this, view, hashMap, hashMap2);
        Context context = view.getContext();
        return zzjr.zza(context, false, zzjy2);
    }

    @Nullable
    public final zzaap zzb(Activity activity) {
        boolean bl;
        String string = "com.google.android.gms.ads.internal.overlay.useClientJar";
        Intent intent = activity.getIntent();
        if (!intent.hasExtra(string)) {
            zzane.e("useClientJar flag not found in activity intent extras.");
            bl = false;
        } else {
            bl = intent.getBooleanExtra(string, false);
        }
        return zzjr.zza((Context)activity, bl, new zzka(this, activity));
    }

    static /* synthetic */ zzjh zzb(zzjr zzjr2) {
        return zzjr2.zzarj;
    }

    static /* synthetic */ void zza(zzjr zzjr2, Context context, String string) {
        zzjr.zza(context, string);
    }

    static /* synthetic */ zzjg zzc(zzjr zzjr2) {
        return zzjr2.zzark;
    }

    static /* synthetic */ zzme zzd(zzjr zzjr2) {
        return zzjr2.zzarl;
    }

    static /* synthetic */ zzrv zze(zzjr zzjr2) {
        return zzjr2.zzarm;
    }

    static /* synthetic */ zzrw zzf(zzjr zzjr2) {
        return zzjr2.zzarp;
    }

    static /* synthetic */ zzahi zzg(zzjr zzjr2) {
        return zzjr2.zzarn;
    }

    static /* synthetic */ zzaao zzh(zzjr zzjr2) {
        return zzjr2.zzaro;
    }

    @VisibleForTesting
    abstract class zza<T> {
        zza() {
        }

        @Nullable
        protected abstract T zza(zzld var1) throws RemoteException;

        @Nullable
        protected abstract T zzib() throws RemoteException;

        @Nullable
        protected final T zzic() {
            zzld zzld2 = zzjr.this.zzia();
            if (zzld2 == null) {
                zzane.zzdk("ClientApi class cannot be loaded.");
                return null;
            }
            try {
                return this.zza(zzld2);
            }
            catch (RemoteException remoteException) {
                zzane.zzc("Cannot invoke local loader using ClientApi class", remoteException);
                return null;
            }
        }

        @Nullable
        protected final T zzid() {
            try {
                return this.zzib();
            }
            catch (RemoteException remoteException) {
                zzane.zzc("Cannot invoke remote loader", remoteException);
                return null;
            }
        }
    }
}

