/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.zzb;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzamu;
import com.google.android.gms.internal.ads.zzjo;
import com.google.android.gms.internal.ads.zzkb;

@zzadh
@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AdSizeParcelCreator")
public class zzjn
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzjn> CREATOR = new zzjo();
    @SafeParcelable.Field(id=2)
    public final String zzarb;
    @SafeParcelable.Field(id=3)
    public final int height;
    @SafeParcelable.Field(id=4)
    public final int heightPixels;
    @SafeParcelable.Field(id=5)
    public final boolean zzarc;
    @SafeParcelable.Field(id=6)
    public final int width;
    @SafeParcelable.Field(id=7)
    public final int widthPixels;
    @SafeParcelable.Field(id=8)
    public final zzjn[] zzard;
    @SafeParcelable.Field(id=9)
    public final boolean zzare;
    @SafeParcelable.Field(id=10)
    public final boolean zzarf;
    @SafeParcelable.Field(id=11)
    public boolean zzarg;

    public static int zzb(DisplayMetrics displayMetrics) {
        return displayMetrics.widthPixels;
    }

    public static int zzc(DisplayMetrics displayMetrics) {
        return (int)((float)zzjn.zzd(displayMetrics) * displayMetrics.density);
    }

    private static int zzd(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static zzjn zzf(Context context) {
        return new zzjn("320x50_mb", 0, 0, false, 0, 0, null, true, false, false);
    }

    public static zzjn zzhx() {
        return new zzjn("reward_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public zzjn() {
        this("interstitial_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public zzjn(Context context, AdSize adSize) {
        this(context, new AdSize[]{adSize});
    }

    /*
     * Unable to fully structure code
     */
    public zzjn(Context var1_1, AdSize[] var2_2) {
        block11: {
            block10: {
                super();
                var3_3 = var2_2[0];
                this.zzarc = false;
                this.zzarf = var3_3.isFluid();
                if (this.zzarf) {
                    this.width = AdSize.BANNER.getWidth();
                    this.height = AdSize.BANNER.getHeight();
                } else {
                    this.width = var3_3.getWidth();
                    this.height = var3_3.getHeight();
                }
                var4_4 = this.width == -1;
                var5_5 = this.height == -2;
                var6_6 = var1_1.getResources().getDisplayMetrics();
                if (!var4_4) break block10;
                zzkb.zzif();
                if (!zzamu.zzbi(var1_1)) ** GOTO lbl-1000
                zzkb.zzif();
                if (zzamu.zzbj(var1_1)) {
                    v0 = var6_6.widthPixels;
                    zzkb.zzif();
                    this.widthPixels = v0 - zzamu.zzbk(var1_1);
                } else lbl-1000:
                // 2 sources

                {
                    this.widthPixels = var6_6.widthPixels;
                }
                var9_7 = (float)this.widthPixels / var6_6.density;
                var7_10 = (int)var9_7;
                if (var9_7 - (double)((int)var9_7) >= 0.01) {
                    ++var7_10;
                }
                break block11;
            }
            var7_10 = this.width;
            zzkb.zzif();
            this.widthPixels = zzamu.zza(var6_6, this.width);
        }
        var8_11 = var5_5 != false ? zzjn.zzd(var6_6) : this.height;
        zzkb.zzif();
        this.heightPixels = zzamu.zza(var6_6, var8_11);
        if (var4_4 || var5_5) {
            var9_8 = var7_10;
            this.zzarb = new StringBuilder(26).append(var9_8).append("x").append(var8_11).append("_as").toString();
        } else {
            this.zzarb = this.zzarf != false ? "320x50_mb" : var3_3.toString();
        }
        if (var2_2.length > 1) {
            this.zzard = new zzjn[var2_2.length];
            for (var9_9 = 0; var9_9 < var2_2.length; ++var9_9) {
                this.zzard[var9_9] = new zzjn(var1_1, var2_2[var9_9]);
            }
        } else {
            this.zzard = null;
        }
        this.zzare = false;
        this.zzarg = false;
    }

    public zzjn(zzjn zzjn2, zzjn[] zzjnArray) {
        this(zzjn2.zzarb, zzjn2.height, zzjn2.heightPixels, zzjn2.zzarc, zzjn2.width, zzjn2.widthPixels, zzjnArray, zzjn2.zzare, zzjn2.zzarf, zzjn2.zzarg);
    }

    @SafeParcelable.Constructor
    zzjn(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=6) int n3, @SafeParcelable.Param(id=7) int n4, @SafeParcelable.Param(id=8) zzjn[] zzjnArray, @SafeParcelable.Param(id=9) boolean bl2, @SafeParcelable.Param(id=10) boolean bl3, @SafeParcelable.Param(id=11) boolean bl4) {
        this.zzarb = string;
        this.height = n;
        this.heightPixels = n2;
        this.zzarc = bl;
        this.width = n3;
        this.widthPixels = n4;
        this.zzard = zzjnArray;
        this.zzare = bl2;
        this.zzarf = bl3;
        this.zzarg = bl4;
    }

    public final AdSize zzhy() {
        return zzb.zza(this.width, this.height, this.zzarb);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzjn zzjn2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzjn2.zzarb, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)zzjn2.height);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)zzjn2.heightPixels);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)zzjn2.zzarc);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)6, (int)zzjn2.width);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)7, (int)zzjn2.widthPixels);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)8, (Parcelable[])zzjn2.zzard, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)zzjn2.zzare);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)10, (boolean)zzjn2.zzarf);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)11, (boolean)zzjn2.zzarg);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

