/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.doubleclick.PublisherAdView;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.search.SearchAdView;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzamv;
import com.google.android.gms.internal.ads.zzamx;
import com.google.android.gms.internal.ads.zzane;
import com.google.android.gms.internal.ads.zzjn;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.UUID;

@zzadh
public final class zzamu {
    public static final Handler zzsy = new Handler(Looper.getMainLooper());
    private static final String zzcup = AdView.class.getName();
    private static final String zzcuq = InterstitialAd.class.getName();
    private static final String zzcur = PublisherAdView.class.getName();
    private static final String zzcus = PublisherInterstitialAd.class.getName();
    private static final String zzcut = SearchAdView.class.getName();
    private static final String zzcuu = AdLoader.class.getName();

    public static void zza(boolean bl, HttpURLConnection httpURLConnection, @Nullable String string) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setReadTimeout(60000);
        if (string != null) {
            httpURLConnection.setRequestProperty("User-Agent", string);
        }
        httpURLConnection.setUseCaches(false);
    }

    public static int zza(Context context, int n) {
        return zzamu.zza(context.getResources().getDisplayMetrics(), n);
    }

    public static int zza(DisplayMetrics displayMetrics, int n) {
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)displayMetrics);
    }

    public static int zzb(Context context, int n) {
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        return zzamu.zzb(displayMetrics, n);
    }

    public static int zzb(DisplayMetrics displayMetrics, int n) {
        return Math.round((float)n / displayMetrics.density);
    }

    public final void zza(ViewGroup viewGroup, zzjn zzjn2, String string, String string2) {
        zzane.zzdk(string2);
        this.zza(viewGroup, zzjn2, string, -65536, -16777216);
    }

    public final void zza(ViewGroup viewGroup, zzjn zzjn2, String string) {
        this.zza(viewGroup, zzjn2, string, -16777216, -1);
    }

    private final void zza(ViewGroup viewGroup, zzjn zzjn2, String string, int n, int n2) {
        if (viewGroup.getChildCount() != 0) {
            return;
        }
        Context context = viewGroup.getContext();
        TextView textView = new TextView(context);
        textView.setGravity(17);
        textView.setText((CharSequence)string);
        textView.setTextColor(n);
        textView.setBackgroundColor(n2);
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setBackgroundColor(n);
        int n3 = zzamu.zza(context, 3);
        frameLayout.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(zzjn2.widthPixels - n3, zzjn2.heightPixels - n3, 17));
        viewGroup.addView((View)frameLayout, zzjn2.widthPixels, zzjn2.heightPixels);
    }

    public static String zzbc(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        String string = contentResolver == null ? null : Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
        return zzamu.zzde(string == null || zzamu.zzsg() ? "emulator" : string);
    }

    @Nullable
    public static String zzbd(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        if (contentResolver == null) {
            return null;
        }
        return Settings.Secure.getString((ContentResolver)contentResolver, (String)"android_id");
    }

    public static boolean zzsg() {
        return Build.DEVICE.startsWith("generic");
    }

    public static boolean zzsh() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static String zzde(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(string.getBytes());
                return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                return null;
            }
        }
        return null;
    }

    public static boolean zzbe(Context context) {
        return 0 == GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context, 12451000);
    }

    public static int zzbf(Context context) {
        return DynamiteModule.getRemoteVersion((Context)context, (String)"com.google.android.gms.ads.dynamite");
    }

    public static int zzbg(Context context) {
        return DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.ads.dynamite");
    }

    public static boolean zzbh(Context context) {
        int n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context, 12451000);
        return n == 0 || n == 2;
    }

    public static boolean zzbi(Context context) {
        if (context.getResources().getConfiguration().orientation != 2) {
            return false;
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((float)displayMetrics.heightPixels / displayMetrics.density) < 600;
    }

    @TargetApi(value=17)
    public static boolean zzbj(Context context) {
        int n;
        int n2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
            display.getRealMetrics(displayMetrics);
            n2 = displayMetrics.heightPixels;
            n = displayMetrics.widthPixels;
        } else {
            try {
                n2 = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
                n = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                return false;
            }
        }
        display.getMetrics(displayMetrics);
        int n3 = displayMetrics.heightPixels;
        int n4 = displayMetrics.widthPixels;
        return n3 == n2 && n4 == n;
    }

    public static int zzbk(Context context) {
        int n = context.getResources().getIdentifier("navigation_bar_width", "dimen", "android");
        if (n > 0) {
            return context.getResources().getDimensionPixelSize(n);
        }
        return 0;
    }

    @Nullable
    @VisibleForTesting
    public static String zza(StackTraceElement[] stackTraceElementArray, String string) {
        String string2 = null;
        int n = 0;
        while (n + 1 < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            String string3 = stackTraceElement.getClassName();
            String string4 = stackTraceElement.getMethodName();
            if ("loadAd".equalsIgnoreCase(string4) && (zzcup.equalsIgnoreCase(string3) || zzcuq.equalsIgnoreCase(string3) || zzcur.equalsIgnoreCase(string3) || zzcus.equalsIgnoreCase(string3) || zzcut.equalsIgnoreCase(string3) || zzcuu.equalsIgnoreCase(string3))) {
                string2 = stackTraceElementArray[n + 1].getClassName();
                break;
            }
            ++n;
        }
        if (string != null) {
            String string5;
            String string6;
            int n2 = 3;
            String string7 = ".";
            String string8 = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string8, string7);
            StringBuilder stringBuilder = new StringBuilder();
            --n2;
            if (!stringTokenizer.hasMoreElements()) {
                string6 = string8;
            } else {
                stringBuilder.append(stringTokenizer.nextToken());
                while (n2-- > 0 && stringTokenizer.hasMoreElements()) {
                    stringBuilder.append(".").append(stringTokenizer.nextToken());
                }
                string6 = string5 = stringBuilder.toString();
            }
            if (string2 != null && !string2.contains(string5)) {
                return string2;
            }
        }
        return null;
    }

    public final void zza(Context context, @Nullable String string, String string2, Bundle bundle, boolean bl) {
        zzamu.zza(context, null, string2, bundle, true, new zzamv(this));
    }

    public static void zza(Context context, @Nullable String string, String string2, Bundle bundle, boolean bl, zzamx zzamx2) {
        Context context2;
        if (bl) {
            context2 = context.getApplicationContext();
            if (context2 == null) {
                context2 = context;
            }
            bundle.putString("os", Build.VERSION.RELEASE);
            bundle.putString("api", String.valueOf(Build.VERSION.SDK_INT));
            bundle.putString("appid", context2.getPackageName());
            if (string == null) {
                int n = GoogleApiAvailabilityLight.getInstance().getApkVersion(context);
                string = new StringBuilder(20).append(n).append(".12451000").toString();
            }
            bundle.putString("js", string);
        }
        context2 = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", string2);
        for (String string3 : bundle.keySet()) {
            context2.appendQueryParameter(string3, bundle.getString(string3));
        }
        zzamx2.zzcz(context2.toString());
    }

    public static String zzsi() {
        UUID uUID = UUID.randomUUID();
        byte[] byArray = BigInteger.valueOf(uUID.getLeastSignificantBits()).toByteArray();
        byte[] byArray2 = BigInteger.valueOf(uUID.getMostSignificantBits()).toByteArray();
        String string = new BigInteger(1, byArray).toString();
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(byArray);
                messageDigest.update(byArray2);
                byte[] byArray3 = new byte[8];
                System.arraycopy(messageDigest.digest(), 0, byArray3, 0, 8);
                string = new BigInteger(1, byArray3).toString();
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return string;
    }

    public static Throwable zzc(Throwable throwable) {
        Throwable throwable2;
        Object object = zznk.zzauj;
        if (zzkb.zzik().zzd(object).booleanValue()) {
            return throwable;
        }
        LinkedList<Throwable> linkedList = new LinkedList<Throwable>();
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            linkedList.push(throwable2);
        }
        Throwable throwable3 = null;
        while (!linkedList.isEmpty()) {
            throwable2 = (Throwable)linkedList.pop();
            StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            arrayList.add(new StackTraceElement(throwable2.getClass().getName(), "<filtered>", "<filtered>", 1));
            boolean bl = false;
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            int n = stackTraceElementArray.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray2[i];
                if (zzamu.zzdf(stackTraceElement.getClassName())) {
                    bl = true;
                    arrayList.add(stackTraceElement);
                    continue;
                }
                object = stackTraceElement.getClassName();
                if (!TextUtils.isEmpty((CharSequence)object) && (((String)object).startsWith("android.") || ((String)object).startsWith("java."))) {
                    arrayList.add(stackTraceElement);
                    continue;
                }
                StackTraceElement stackTraceElement2 = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                arrayList.add(stackTraceElement2);
            }
            if (!bl) continue;
            throwable3 = throwable3 == null ? new Throwable(throwable2.getMessage()) : new Throwable(throwable2.getMessage(), throwable3);
            throwable3.setStackTrace(arrayList.toArray(new StackTraceElement[0]));
        }
        return throwable3;
    }

    @VisibleForTesting
    public static boolean zzdf(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzna<String> zzna2 = zznk.zzauk;
        if (string.startsWith(zzkb.zzik().zzd(zzna2))) {
            return true;
        }
        try {
            return Class.forName(string).isAnnotationPresent(zzadh.class);
        }
        catch (Exception exception) {
            String string2 = String.valueOf(string);
            zzane.zza(string2.length() != 0 ? "Fail to check class type for class ".concat(string2) : new String("Fail to check class type for class "), exception);
            return false;
        }
    }
}

