/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzadc;
import com.google.android.gms.internal.ads.zzadd;
import com.google.android.gms.internal.ads.zzade;
import com.google.android.gms.internal.ads.zzadf;
import com.google.android.gms.internal.ads.zzadg;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzamu;
import com.google.android.gms.internal.ads.zzane;
import com.google.android.gms.internal.ads.zzanf;
import com.google.android.gms.internal.ads.zzang;
import com.google.android.gms.internal.ads.zzazr;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzna;
import com.google.android.gms.internal.ads.zznk;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.ParametersAreNonnullByDefault;

@zzadh
@ParametersAreNonnullByDefault
public final class zzadb
implements zzadf {
    private static final Object sLock = new Object();
    @VisibleForTesting
    private static zzadf zzcbw = null;
    @VisibleForTesting
    private static zzadf zzcbx = null;
    private final Object zzcby = new Object();
    private final Context zzatx;
    private final WeakHashMap<Thread, Boolean> zzcbz = new WeakHashMap();
    private final ExecutorService zzru = Executors.newCachedThreadPool();
    private final zzang zzzw;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzadf zzl(Context context) {
        Object object = sLock;
        synchronized (object) {
            if (zzcbw == null) {
                zzna<Boolean> zzna2 = zznk.zzauh;
                zzcbw = zzkb.zzik().zzd(zzna2) != false ? new zzadb(context) : new zzadg();
            }
        }
        return zzcbw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzadf zzc(Context context, zzang zzang2) {
        Object object = sLock;
        synchronized (object) {
            if (zzcbx == null) {
                Object object2 = zznk.zzauh;
                if (zzkb.zzik().zzd(object2).booleanValue()) {
                    zzadb zzadb2 = new zzadb(context, zzang2);
                    Thread thread = Looper.getMainLooper().getThread();
                    zzadb zzadb3 = zzadb2;
                    if (thread != null) {
                        Object object3 = zzadb3.zzcby;
                        synchronized (object3) {
                            zzadb3.zzcbz.put(thread, true);
                        }
                        object3 = thread.getUncaughtExceptionHandler();
                        thread.setUncaughtExceptionHandler(new zzadd(zzadb3, (Thread.UncaughtExceptionHandler)object3));
                    }
                    object2 = zzadb2;
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                    Thread.setDefaultUncaughtExceptionHandler(new zzadc((zzadb)object2, uncaughtExceptionHandler));
                    zzcbx = zzadb2;
                } else {
                    zzcbx = new zzadg();
                }
            }
        }
        return zzcbx;
    }

    private zzadb(Context context) {
        this(context, zzang.zzsl());
    }

    private zzadb(Context context, zzang zzang2) {
        this.zzatx = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        this.zzzw = zzang2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void zza(Thread thread, Throwable throwable) {
        Throwable throwable2;
        zzadb zzadb2 = this;
        if (throwable2 == null) return;
        boolean bl = false;
        boolean bl2 = false;
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            for (StackTraceElement stackTraceElement : throwable2.getStackTrace()) {
                if (zzamu.zzdf(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!zzadb2.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
        }
        if (!bl) return;
        if (bl2) return;
        boolean bl3 = true;
        if (!bl3) return;
        throwable2 = throwable;
        String string = "";
        Throwable throwable3 = throwable2;
        this.zza(throwable2, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string) {
        this.zza(throwable, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string, float f) {
        if (zzamu.zzc(throwable) == null) {
            return;
        }
        String string2 = throwable.getClass().getName();
        StringWriter stringWriter = new StringWriter();
        zzazr.zza((Throwable)throwable, (PrintWriter)new PrintWriter(stringWriter));
        String string3 = stringWriter.toString();
        boolean bl = Math.random() < (double)f;
        int n = f > 0.0f ? (int)(1.0f / f) : 1;
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = n;
            String string4 = string;
            String string5 = string3;
            Object object = string2;
            arrayList.add(this.zza((String)object, string5, string4, n2).toString());
            object = arrayList;
            zzadb zzadb2 = this;
            ArrayList arrayList2 = (ArrayList)object;
            int n3 = arrayList2.size();
            string5 = null;
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList2.get(i);
                string4 = (String)e;
                zzanf zzanf2 = new zzanf();
                zzadb2.zzru.submit(new zzade(zzadb2, zzanf2, string4));
            }
        }
    }

    @VisibleForTesting
    private final Uri.Builder zza(String string, String string2, String string3, int n) {
        boolean bl = false;
        try {
            bl = Wrappers.packageManager((Context)this.zzatx).isCallerInstantApp();
        }
        catch (Throwable throwable) {
            zzane.zzb("Error fetching instant app info", throwable);
        }
        String string4 = "unknown";
        try {
            string4 = this.zzatx.getPackageName();
        }
        catch (Throwable throwable) {
            zzane.zzdk("Cannot obtain package name, proceeding.");
        }
        String string5 = Build.MANUFACTURER;
        String string6 = Build.MODEL;
        zzna<String> zzna2 = zznk.zzbfo;
        return new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("is_aia", Boolean.toString(bl)).appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter("device", string6.startsWith(string5) ? string6 : new StringBuilder(1 + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string5).append(" ").append(string6).toString()).appendQueryParameter("js", this.zzzw.zzcw).appendQueryParameter("appid", string4).appendQueryParameter("exceptiontype", string).appendQueryParameter("stacktrace", string2).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zznk.zzjb())).appendQueryParameter("exceptionkey", string3).appendQueryParameter("cl", "193400285").appendQueryParameter("rc", "dev").appendQueryParameter("session_id", zzkb.zzih()).appendQueryParameter("sampling_rate", Integer.toString(n)).appendQueryParameter("pb_tm", String.valueOf(zzkb.zzik().zzd(zzna2)));
    }
}

