/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.formats.AdChoicesView;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzane;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzqa;

public final class UnifiedNativeAdView
extends FrameLayout {
    private final FrameLayout zzvp;
    private final zzqa zzvq;

    public UnifiedNativeAdView(Context context) {
        super(context);
        this.zzvp = this.zzb(context);
        this.zzvq = this.zzbf();
    }

    public UnifiedNativeAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzvp = this.zzb(context);
        this.zzvq = this.zzbf();
    }

    public UnifiedNativeAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzvp = this.zzb(context);
        this.zzvq = this.zzbf();
    }

    @TargetApi(value=21)
    public UnifiedNativeAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.zzvp = this.zzb(context);
        this.zzvq = this.zzbf();
    }

    private final void zza(String string, View view) {
        try {
            this.zzvq.zzb(string, ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to call setAssetView on delegate", remoteException);
            return;
        }
    }

    public final void setHeadlineView(View view) {
        this.zza("3001", view);
    }

    public final void setCallToActionView(View view) {
        this.zza("3002", view);
    }

    public final void setIconView(View view) {
        this.zza("3003", view);
    }

    public final void setBodyView(View view) {
        this.zza("3004", view);
    }

    public final void setAdvertiserView(View view) {
        this.zza("3005", view);
    }

    public final void setStoreView(View view) {
        this.zza("3006", view);
    }

    public final void setClickConfirmingView(View view) {
        try {
            this.zzvq.zzc(ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }

    public final void setPriceView(View view) {
        this.zza("3007", view);
    }

    public final void setImageView(View view) {
        this.zza("3008", view);
    }

    public final void setStarRatingView(View view) {
        this.zza("3009", view);
    }

    public final void setMediaView(MediaView mediaView) {
        this.zza("3010", (View)mediaView);
    }

    public final void setAdChoicesView(AdChoicesView adChoicesView) {
        this.zza("3011", (View)adChoicesView);
    }

    public final void setNativeAd(UnifiedNativeAd unifiedNativeAd) {
        try {
            this.zzvq.zza((IObjectWrapper)unifiedNativeAd.zzbe());
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    private final View zzp(String string) {
        try {
            IObjectWrapper iObjectWrapper = this.zzvq.zzak(string);
            if (iObjectWrapper != null) {
                return (View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            }
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to call getAssetView on delegate", remoteException);
        }
        return null;
    }

    public final View getHeadlineView() {
        return this.zzp("3001");
    }

    public final View getCallToActionView() {
        return this.zzp("3002");
    }

    public final View getIconView() {
        return this.zzp("3003");
    }

    public final View getBodyView() {
        return this.zzp("3004");
    }

    public final View getStoreView() {
        return this.zzp("3006");
    }

    public final View getPriceView() {
        return this.zzp("3007");
    }

    public final View getAdvertiserView() {
        return this.zzp("3005");
    }

    public final View getImageView() {
        return this.zzp("3008");
    }

    public final View getStarRatingView() {
        return this.zzp("3009");
    }

    public final MediaView getMediaView() {
        View view = this.zzp("3010");
        if (view instanceof MediaView) {
            return (MediaView)view;
        }
        if (view != null) {
            zzane.zzck("View is not an instance of MediaView");
        }
        return null;
    }

    public final AdChoicesView getAdChoicesView() {
        View view = this.zzp("3011");
        if (view instanceof AdChoicesView) {
            return (AdChoicesView)view;
        }
        return null;
    }

    public final void destroy() {
        try {
            this.zzvq.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to destroy native ad view", remoteException);
            return;
        }
    }

    private final FrameLayout zzb(Context context) {
        Context context2 = context;
        FrameLayout frameLayout = new FrameLayout(context2);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)frameLayout);
        return frameLayout;
    }

    private final zzqa zzbf() {
        Preconditions.checkNotNull((Object)this.zzvp, (Object)"createDelegate must be called after overlayFrame has been created");
        if (this.isInEditMode()) {
            return null;
        }
        return zzkb.zzig().zza(this.zzvp.getContext(), this, this.zzvp);
    }

    public final void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        super.bringChildToFront((View)this.zzvp);
    }

    public final void removeView(View view) {
        if (this.zzvp == view) {
            return;
        }
        super.removeView(view);
    }

    public final void removeAllViews() {
        super.removeAllViews();
        super.addView((View)this.zzvp);
    }

    public final void bringChildToFront(View view) {
        super.bringChildToFront(view);
        if (this.zzvp != view) {
            super.bringChildToFront((View)this.zzvp);
        }
    }

    public final void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (this.zzvq != null) {
            try {
                this.zzvq.zzb(ObjectWrapper.wrap((Object)view), n);
                return;
            }
            catch (RemoteException remoteException) {
                zzane.zzb("Unable to call onVisibilityChanged on delegate", remoteException);
            }
        }
    }
}

