/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzane;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzqf;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class NativeAdViewHolder {
    private zzqf zzvj;
    public static WeakHashMap<View, NativeAdViewHolder> zzvk = new WeakHashMap();
    private WeakReference<View> zzvl;

    public NativeAdViewHolder(View view, Map<String, View> map, Map<String, View> map2) {
        HashMap<String, View> hashMap;
        Preconditions.checkNotNull((Object)view, (Object)"ContainerView must not be null");
        if (view instanceof NativeAdView || view instanceof UnifiedNativeAdView) {
            zzane.e("The provided containerView is of type of NativeAdView, which cannot be usedwith NativeAdViewHolder.");
            return;
        }
        if (zzvk.get(view) != null) {
            zzane.e("The provided containerView is already in use with another NativeAdViewHolder.");
            return;
        }
        zzvk.put(view, this);
        this.zzvl = new WeakReference<View>(view);
        HashMap<String, View> hashMap2 = NativeAdViewHolder.zzb(map);
        HashMap<String, View> hashMap3 = hashMap = NativeAdViewHolder.zzb(map2);
        HashMap<String, View> hashMap4 = hashMap2;
        View view2 = view;
        this.zzvj = zzkb.zzig().zza(view2, hashMap4, hashMap3);
    }

    private static HashMap<String, View> zzb(Map<String, View> map) {
        if (map == null) {
            return new HashMap<String, View>();
        }
        return new HashMap<String, View>(map);
    }

    public final void setNativeAd(NativeAd nativeAd) {
        this.zza((IObjectWrapper)nativeAd.zzbe());
    }

    public final void setNativeAd(UnifiedNativeAd unifiedNativeAd) {
        this.zza((IObjectWrapper)unifiedNativeAd.zzbe());
    }

    private final void zza(IObjectWrapper iObjectWrapper) {
        View view = this.zzvl != null ? (View)this.zzvl.get() : null;
        if (view == null) {
            zzane.zzdk("NativeAdViewHolder.setNativeAd containerView doesn't exist, returning");
            return;
        }
        if (!zzvk.containsKey(view)) {
            zzvk.put(view, this);
        }
        if (this.zzvj != null) {
            try {
                this.zzvj.zza(iObjectWrapper);
                return;
            }
            catch (RemoteException remoteException) {
                zzane.zzb("Unable to call setNativeAd on delegate", remoteException);
            }
        }
    }

    public final void unregisterNativeAd() {
        View view;
        if (this.zzvj != null) {
            try {
                this.zzvj.unregisterNativeAd();
            }
            catch (RemoteException remoteException) {
                zzane.zzb("Unable to call unregisterNativeAd on delegate", remoteException);
            }
        }
        if ((view = this.zzvl != null ? (View)this.zzvl.get() : null) != null) {
            zzvk.remove(view);
        }
    }

    public final void setClickConfirmingView(View view) {
        try {
            this.zzvj.zzc(ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }
}

