/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.formats.AdChoicesView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzane;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzqa;

public class NativeAdView
extends FrameLayout {
    private final FrameLayout zzvh;
    private final zzqa zzvi;

    public NativeAdView(Context context) {
        super(context);
        this.zzvh = this.zzb(context);
        this.zzvi = this.zzbf();
    }

    public NativeAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzvh = this.zzb(context);
        this.zzvi = this.zzbf();
    }

    public NativeAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzvh = this.zzb(context);
        this.zzvi = this.zzbf();
    }

    @TargetApi(value=21)
    public NativeAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.zzvh = this.zzb(context);
        this.zzvi = this.zzbf();
    }

    public void setAdChoicesView(AdChoicesView adChoicesView) {
        this.zza("1098", (View)adChoicesView);
    }

    public AdChoicesView getAdChoicesView() {
        View view = this.zzp("1098");
        if (view instanceof AdChoicesView) {
            return (AdChoicesView)view;
        }
        return null;
    }

    protected final void zza(String string, View view) {
        try {
            this.zzvi.zzb(string, ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to call setAssetView on delegate", remoteException);
            return;
        }
    }

    protected final View zzp(String string) {
        try {
            IObjectWrapper iObjectWrapper = this.zzvi.zzak(string);
            if (iObjectWrapper != null) {
                return (View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            }
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to call getAssetView on delegate", remoteException);
        }
        return null;
    }

    public void setNativeAd(NativeAd nativeAd) {
        try {
            this.zzvi.zza((IObjectWrapper)nativeAd.zzbe());
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    public void destroy() {
        try {
            this.zzvi.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Unable to destroy native ad view", remoteException);
            return;
        }
    }

    private final FrameLayout zzb(Context context) {
        Context context2 = context;
        FrameLayout frameLayout = new FrameLayout(context2);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)frameLayout);
        return frameLayout;
    }

    private final zzqa zzbf() {
        Preconditions.checkNotNull((Object)this.zzvh, (Object)"createDelegate must be called after mOverlayFrame has been created");
        if (this.isInEditMode()) {
            return null;
        }
        return zzkb.zzig().zza(this.zzvh.getContext(), this, this.zzvh);
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        super.bringChildToFront((View)this.zzvh);
    }

    public void removeView(View view) {
        if (this.zzvh == view) {
            return;
        }
        super.removeView(view);
    }

    public void removeAllViews() {
        super.removeAllViews();
        super.addView((View)this.zzvh);
    }

    public void bringChildToFront(View view) {
        super.bringChildToFront(view);
        if (this.zzvh != view) {
            super.bringChildToFront((View)this.zzvh);
        }
    }

    public void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (this.zzvi != null) {
            try {
                this.zzvi.zzb(ObjectWrapper.wrap((Object)view), n);
                return;
            }
            catch (RemoteException remoteException) {
                zzane.zzb("Unable to call onVisibilityChanged on delegate", remoteException);
            }
        }
    }
}

