/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.doubleclick;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.doubleclick.zza;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzlw;
import com.google.android.gms.internal.ads.zzlx;
import java.util.Date;
import java.util.List;
import java.util.Set;

@VisibleForTesting
public final class PublisherAdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final String DEVICE_ID_EMULATOR = "B3EEABB8EE11C2BE770B684D95219ECB";
    private final zzlw zzun;

    private PublisherAdRequest(Builder builder) {
        this.zzun = new zzlw(builder.zzuo);
    }

    public final Date getBirthday() {
        return this.zzun.getBirthday();
    }

    public final String getContentUrl() {
        return this.zzun.getContentUrl();
    }

    public final int getGender() {
        return this.zzun.getGender();
    }

    public final Set<String> getKeywords() {
        return this.zzun.getKeywords();
    }

    public final Location getLocation() {
        return this.zzun.getLocation();
    }

    public final boolean getManualImpressionsEnabled() {
        return this.zzun.getManualImpressionsEnabled();
    }

    @Deprecated
    public final <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzun.getNetworkExtras(clazz);
    }

    public final <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzun.getNetworkExtrasBundle(clazz);
    }

    public final <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzun.getCustomEventExtrasBundle(clazz);
    }

    public final String getPublisherProvidedId() {
        return this.zzun.getPublisherProvidedId();
    }

    public final boolean isTestDevice(Context context) {
        return this.zzun.isTestDevice(context);
    }

    public final Bundle getCustomTargeting() {
        return this.zzun.getCustomTargeting();
    }

    public static void updateCorrelator() {
    }

    public final zzlw zzay() {
        return this.zzun;
    }

    /* synthetic */ PublisherAdRequest(Builder builder, zza zza2) {
        this(builder);
    }

    @VisibleForTesting
    public static final class Builder {
        private final zzlx zzuo = new zzlx();

        public Builder() {
        }

        public final Builder addKeyword(String string) {
            this.zzuo.zzac(string);
            return this;
        }

        public final Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzuo.zza(networkExtras);
            return this;
        }

        public final Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> clazz, Bundle bundle) {
            this.zzuo.zza(clazz, bundle);
            return this;
        }

        public final Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzuo.zzb(clazz, bundle);
            return this;
        }

        public final Builder addTestDevice(String string) {
            this.zzuo.zzad(string);
            return this;
        }

        public final PublisherAdRequest build() {
            return new PublisherAdRequest(this, null);
        }

        public final Builder setBirthday(Date date) {
            this.zzuo.zza(date);
            return this;
        }

        public final Builder setContentUrl(String string) {
            Preconditions.checkNotNull((Object)string, (Object)"Content URL must be non-null.");
            Preconditions.checkNotEmpty((String)string, (Object)"Content URL must be non-empty.");
            Preconditions.checkArgument((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zzuo.zzaf(string);
            return this;
        }

        public final Builder setGender(int n) {
            this.zzuo.zzt(n);
            return this;
        }

        public final Builder setLocation(Location location) {
            this.zzuo.zzb(location);
            return this;
        }

        @Deprecated
        public final Builder setManualImpressionsEnabled(boolean bl) {
            this.zzuo.setManualImpressionsEnabled(bl);
            return this;
        }

        public final Builder setPublisherProvidedId(String string) {
            this.zzuo.zzag(string);
            return this;
        }

        public final Builder setRequestAgent(String string) {
            this.zzuo.zzah(string);
            return this;
        }

        public final Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzuo.zzj(bl);
            return this;
        }

        public final Builder addCustomTargeting(String string, String string2) {
            this.zzuo.zzc(string, string2);
            return this;
        }

        public final Builder addCustomTargeting(String string, List<String> list) {
            if (list != null) {
                this.zzuo.zzc(string, TextUtils.join((CharSequence)",", list));
            }
            return this;
        }

        public final Builder addCategoryExclusion(String string) {
            this.zzuo.zzai(string);
            return this;
        }

        public final Builder setIsDesignedForFamilies(boolean bl) {
            this.zzuo.zzk(bl);
            return this;
        }
    }
}

