/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzane;
import com.google.android.gms.internal.ads.zzlo;
import com.google.android.gms.internal.ads.zzmt;
import javax.annotation.concurrent.GuardedBy;

@zzadh
public final class VideoController {
    @KeepForSdk
    public static final int PLAYBACK_STATE_UNKNOWN = 0;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PLAYING = 1;
    @KeepForSdk
    public static final int PLAYBACK_STATE_PAUSED = 2;
    @KeepForSdk
    public static final int PLAYBACK_STATE_ENDED = 3;
    @KeepForSdk
    public static final int PLAYBACK_STATE_READY = 5;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    @Nullable
    private zzlo zzux;
    @GuardedBy(value="mLock")
    @Nullable
    private VideoLifecycleCallbacks zzuy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzlo zzlo2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzux = zzlo2;
            if (this.zzuy != null) {
                this.setVideoLifecycleCallbacks(this.zzuy);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzlo zzbc() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzux;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void play() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzux == null) {
                return;
            }
            try {
                this.zzux.play();
            }
            catch (RemoteException remoteException) {
                zzane.zzb("Unable to call play on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzux == null) {
                return;
            }
            try {
                this.zzux.pause();
            }
            catch (RemoteException remoteException) {
                zzane.zzb("Unable to call pause on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mute(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzux == null) {
                return;
            }
            try {
                this.zzux.mute(bl);
            }
            catch (RemoteException remoteException) {
                zzane.zzb("Unable to call mute on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isMuted() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzux == null) {
                return true;
            }
            try {
                return this.zzux.isMuted();
            }
            catch (RemoteException remoteException) {
                zzane.zzb("Unable to call isMuted on video controller.", remoteException);
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final int getPlaybackState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzux == null) {
                return 0;
            }
            try {
                return this.zzux.getPlaybackState();
            }
            catch (RemoteException remoteException) {
                zzane.zzb("Unable to call getPlaybackState on video controller.", remoteException);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isCustomControlsEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzux == null) {
                return false;
            }
            try {
                return this.zzux.isCustomControlsEnabled();
            }
            catch (RemoteException remoteException) {
                zzane.zzb("Unable to call isUsingCustomPlayerControls.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClickToExpandEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzux == null) {
                return false;
            }
            try {
                return this.zzux.isClickToExpandEnabled();
            }
            catch (RemoteException remoteException) {
                zzane.zzb("Unable to call isClickToExpandEnabled.", remoteException);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVideoLifecycleCallbacks(VideoLifecycleCallbacks videoLifecycleCallbacks) {
        Preconditions.checkNotNull((Object)videoLifecycleCallbacks, (Object)"VideoLifecycleCallbacks may not be null.");
        Object object = this.mLock;
        synchronized (object) {
            this.zzuy = videoLifecycleCallbacks;
            if (this.zzux == null) {
                return;
            }
            try {
                this.zzux.zza(new zzmt(videoLifecycleCallbacks));
            }
            catch (RemoteException remoteException) {
                zzane.zzb("Unable to call setVideoLifecycleCallbacks on video controller.", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VideoLifecycleCallbacks getVideoLifecycleCallbacks() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzuy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasVideoContent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzux != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getAspectRatio() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzux == null) {
                return 0.0f;
            }
            try {
                return this.zzux.getAspectRatio();
            }
            catch (RemoteException remoteException) {
                zzane.zzb("Unable to call getAspectRatio on video controller.", remoteException);
                return 0.0f;
            }
        }
    }

    public static abstract class VideoLifecycleCallbacks {
        public VideoLifecycleCallbacks() {
        }

        public void onVideoStart() {
        }

        public void onVideoPlay() {
        }

        public void onVideoPause() {
        }

        public void onVideoEnd() {
        }

        public void onVideoMute(boolean bl) {
        }
    }
}

