/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnPublisherAdViewLoadedListener;
import com.google.android.gms.ads.formats.PublisherAdViewOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzane;
import com.google.android.gms.internal.ads.zzjf;
import com.google.android.gms.internal.ads.zzjm;
import com.google.android.gms.internal.ads.zzjn;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzkk;
import com.google.android.gms.internal.ads.zzkn;
import com.google.android.gms.internal.ads.zzlw;
import com.google.android.gms.internal.ads.zzpl;
import com.google.android.gms.internal.ads.zzrx;
import com.google.android.gms.internal.ads.zzry;
import com.google.android.gms.internal.ads.zzrz;
import com.google.android.gms.internal.ads.zzsa;
import com.google.android.gms.internal.ads.zzsb;
import com.google.android.gms.internal.ads.zzsd;
import com.google.android.gms.internal.ads.zzxm;

public class AdLoader {
    private final zzjm zzuk;
    private final Context mContext;
    private final zzkk zzul;

    AdLoader(Context context, zzkk zzkk2) {
        this(context, zzkk2, zzjm.zzara);
    }

    private AdLoader(Context context, zzkk zzkk2, zzjm zzjm2) {
        this.mContext = context;
        this.zzul = zzkk2;
        this.zzuk = zzjm2;
    }

    private final void zza(zzlw zzlw2) {
        try {
            this.zzul.zzd(zzjm.zza(this.mContext, zzlw2));
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Failed to load ad.", remoteException);
            return;
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzay());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(AdRequest adRequest, int n) {
        zzlw zzlw2 = adRequest.zzay();
        AdLoader adLoader = this;
        try {
            adLoader.zzul.zza(zzjm.zza(adLoader.mContext, zzlw2), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzane.zzb("Failed to load ads.", remoteException);
            return;
        }
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzay());
    }

    @Deprecated
    public String getMediationAdapterClassName() {
        try {
            return this.zzul.zzck();
        }
        catch (RemoteException remoteException) {
            zzane.zzc("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzul.isLoading();
        }
        catch (RemoteException remoteException) {
            zzane.zzc("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context mContext;
        private final zzkn zzum;

        public Builder(Context context, String string) {
            this((Context)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null"), zzkb.zzig().zzb(context, string, new zzxm()));
        }

        private Builder(Context context, zzkn zzkn2) {
            this.mContext = context;
            this.zzum = zzkn2;
        }

        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzum.zza(new zzry(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzane.zzc("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzum.zza(new zzrx(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzane.zzc("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forUnifiedNativeAd(UnifiedNativeAd.OnUnifiedNativeAdLoadedListener onUnifiedNativeAdLoadedListener) {
            try {
                this.zzum.zza(new zzsd(onUnifiedNativeAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzane.zzc("Failed to add google native ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzum.zza(string, new zzsa(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzrz(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzane.zzc("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder forPublisherAdView(OnPublisherAdViewLoadedListener onPublisherAdViewLoadedListener, AdSize ... adSizeArray) {
            if (adSizeArray == null || adSizeArray.length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                zzjn zzjn2 = new zzjn(this.mContext, adSizeArray);
                this.zzum.zza(new zzsb(onPublisherAdViewLoadedListener), zzjn2);
            }
            catch (RemoteException remoteException) {
                zzane.zzc("Failed to add publisher banner ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzum.zzb(new zzjf(adListener));
            }
            catch (RemoteException remoteException) {
                zzane.zzc("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzum.zza(new zzpl(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzane.zzc("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withPublisherAdViewOptions(PublisherAdViewOptions publisherAdViewOptions) {
            try {
                this.zzum.zza(publisherAdViewOptions);
            }
            catch (RemoteException remoteException) {
                zzane.zzc("Failed to specify DFP banner ad options", remoteException);
            }
            return this;
        }

        public Builder withCorrelator(@NonNull Correlator correlator) {
            Preconditions.checkNotNull((Object)correlator);
            try {
                this.zzum.zzb(correlator.zzuu);
            }
            catch (RemoteException remoteException) {
                zzane.zzc("Failed to set correlator.", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.mContext, this.zzum.zzdh());
            }
            catch (RemoteException remoteException) {
                zzane.zzb("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

