/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzbbq;
import com.google.android.gms.internal.ads.zzbbt;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbbm
extends zzbab<Float>
implements zzbbt<Float>,
RandomAccess {
    private static final zzbbm zzdtq = new zzbbm();
    private float[] zzdtr;
    private int size;

    zzbbm() {
        this(new float[10], 0);
    }

    private zzbbm(float[] fArray, int n) {
        this.zzdtr = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaba();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzdtr, n2, this.zzdtr, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbbm)) {
            return super.equals(object);
        }
        zzbbm zzbbm2 = (zzbbm)object;
        if (this.size != zzbbm2.size) {
            return false;
        }
        float[] fArray = zzbbm2.zzdtr;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzdtr[i] == fArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzdtr[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzaba();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzbl(n));
        }
        if (this.size < this.zzdtr.length) {
            System.arraycopy(this.zzdtr, n, this.zzdtr, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzdtr, 0, fArray, 0, n);
            System.arraycopy(this.zzdtr, n, fArray, n + 1, this.size - n);
            this.zzdtr = fArray;
        }
        this.zzdtr[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzaba();
        zzbbq.checkNotNull(collection);
        if (!(collection instanceof zzbbm)) {
            return super.addAll(collection);
        }
        zzbbm zzbbm2 = (zzbbm)collection;
        if (zzbbm2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbbm2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbbm2.size;
        if (n > this.zzdtr.length) {
            this.zzdtr = Arrays.copyOf(this.zzdtr, n);
        }
        System.arraycopy(zzbbm2.zzdtr, 0, this.zzdtr, this.size, zzbbm2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaba();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzdtr[i]))) continue;
            System.arraycopy(this.zzdtr, i + 1, this.zzdtr, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzbk(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzbl(n));
        }
    }

    private final String zzbl(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzbbm zzbbm2 = this;
        zzbbm2.zzaba();
        zzbbm2.zzbk(n);
        float f3 = zzbbm2.zzdtr[n];
        zzbbm2.zzdtr[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbbm zzbbm2 = this;
        zzbbm2.zzaba();
        zzbbm2.zzbk(n);
        float f = zzbbm2.zzdtr[n];
        if (n < zzbbm2.size - 1) {
            System.arraycopy(zzbbm2.zzdtr, n + 1, zzbbm2.zzdtr, n, zzbbm2.size - n);
        }
        --zzbbm2.size;
        ++zzbbm2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzbbt zzbm(int n) {
        int n2 = n;
        zzbbm zzbbm2 = this;
        if (n2 < zzbbm2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbbm(Arrays.copyOf(zzbbm2.zzdtr, n2), zzbbm2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbbm zzbbm2 = this;
        zzbbm2.zzbk(n);
        return Float.valueOf(zzbbm2.zzdtr[n]);
    }

    static {
        zzdtq.zzaaz();
    }
}

