/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzbbq;
import com.google.android.gms.internal.ads.zzbbt;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbay
extends zzbab<Double>
implements zzbbt<Double>,
RandomAccess {
    private static final zzbay zzdqo = new zzbay();
    private double[] zzdqp;
    private int size;

    zzbay() {
        this(new double[10], 0);
    }

    private zzbay(double[] dArray, int n) {
        this.zzdqp = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaba();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzdqp, n2, this.zzdqp, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbay)) {
            return super.equals(object);
        }
        zzbay zzbay2 = (zzbay)object;
        if (this.size != zzbay2.size) {
            return false;
        }
        double[] dArray = zzbay2.zzdqp;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzdqp[i] == dArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzdqp[i]);
            n = n * 31 + zzbbq.zzv(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzaba();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzbl(n));
        }
        if (this.size < this.zzdqp.length) {
            System.arraycopy(this.zzdqp, n, this.zzdqp, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzdqp, 0, dArray, 0, n);
            System.arraycopy(this.zzdqp, n, dArray, n + 1, this.size - n);
            this.zzdqp = dArray;
        }
        this.zzdqp[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzaba();
        zzbbq.checkNotNull(collection);
        if (!(collection instanceof zzbay)) {
            return super.addAll(collection);
        }
        zzbay zzbay2 = (zzbay)collection;
        if (zzbay2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbay2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbay2.size;
        if (n > this.zzdqp.length) {
            this.zzdqp = Arrays.copyOf(this.zzdqp, n);
        }
        System.arraycopy(zzbay2.zzdqp, 0, this.zzdqp, this.size, zzbay2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaba();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzdqp[i])) continue;
            System.arraycopy(this.zzdqp, i + 1, this.zzdqp, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzbk(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzbl(n));
        }
    }

    private final String zzbl(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzbay zzbay2 = this;
        zzbay2.zzaba();
        zzbay2.zzbk(n);
        double d3 = zzbay2.zzdqp[n];
        zzbay2.zzdqp[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbay zzbay2 = this;
        zzbay2.zzaba();
        zzbay2.zzbk(n);
        double d = zzbay2.zzdqp[n];
        if (n < zzbay2.size - 1) {
            System.arraycopy(zzbay2.zzdqp, n + 1, zzbay2.zzdqp, n, zzbay2.size - n);
        }
        --zzbay2.size;
        ++zzbay2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzbbt zzbm(int n) {
        int n2 = n;
        zzbay zzbay2 = this;
        if (n2 < zzbay2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbay(Arrays.copyOf(zzbay2.zzdqp, n2), zzbay2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzbay zzbay2 = this;
        zzbay2.zzbk(n);
        return zzbay2.zzdqp[n];
    }

    static {
        zzdqo.zzaaz();
    }
}

