/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.flexbox;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.view.MarginLayoutParamsCompat;
import android.support.v4.view.ViewCompat;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.flexbox.FlexContainer;
import com.google.android.flexbox.FlexItem;
import com.google.android.flexbox.FlexLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class FlexboxHelper {
    private static final int INITIAL_CAPACITY = 10;
    private static final long MEASURE_SPEC_WIDTH_MASK = 0xFFFFFFFFL;
    private final FlexContainer mFlexContainer;
    private boolean[] mChildrenFrozen;
    @Nullable
    int[] mIndexToFlexLine;
    @Nullable
    long[] mMeasureSpecCache;
    @Nullable
    private long[] mMeasuredSizeCache;

    FlexboxHelper(FlexContainer flexContainer) {
        this.mFlexContainer = flexContainer;
    }

    int[] createReorderedIndices(View viewBeforeAdded, int indexForViewBeforeAdded, ViewGroup.LayoutParams paramsForViewBeforeAdded, SparseIntArray orderCache) {
        int childCount = this.mFlexContainer.getFlexItemCount();
        List<Order> orders = this.createOrders(childCount);
        Order orderForViewToBeAdded = new Order();
        orderForViewToBeAdded.order = viewBeforeAdded != null && paramsForViewBeforeAdded instanceof FlexItem ? ((FlexItem)paramsForViewBeforeAdded).getOrder() : 1;
        if (indexForViewBeforeAdded == -1 || indexForViewBeforeAdded == childCount) {
            orderForViewToBeAdded.index = childCount;
        } else if (indexForViewBeforeAdded < this.mFlexContainer.getFlexItemCount()) {
            orderForViewToBeAdded.index = indexForViewBeforeAdded;
            for (int i = indexForViewBeforeAdded; i < childCount; ++i) {
                ++orders.get((int)i).index;
            }
        } else {
            orderForViewToBeAdded.index = childCount;
        }
        orders.add(orderForViewToBeAdded);
        return this.sortOrdersIntoReorderedIndices(childCount + 1, orders, orderCache);
    }

    int[] createReorderedIndices(SparseIntArray orderCache) {
        int childCount = this.mFlexContainer.getFlexItemCount();
        List<Order> orders = this.createOrders(childCount);
        return this.sortOrdersIntoReorderedIndices(childCount, orders, orderCache);
    }

    @NonNull
    private List<Order> createOrders(int childCount) {
        ArrayList<Order> orders = new ArrayList<Order>(childCount);
        int i = 0;
        while (i < childCount) {
            View child = this.mFlexContainer.getFlexItemAt(i);
            FlexItem flexItem = (FlexItem)child.getLayoutParams();
            Order order = new Order();
            order.order = flexItem.getOrder();
            order.index = i++;
            orders.add(order);
        }
        return orders;
    }

    boolean isOrderChangedFromLastMeasurement(SparseIntArray orderCache) {
        int childCount = this.mFlexContainer.getFlexItemCount();
        if (orderCache.size() != childCount) {
            return true;
        }
        for (int i = 0; i < childCount; ++i) {
            FlexItem flexItem;
            View view = this.mFlexContainer.getFlexItemAt(i);
            if (view == null || (flexItem = (FlexItem)view.getLayoutParams()).getOrder() == orderCache.get(i)) continue;
            return true;
        }
        return false;
    }

    private int[] sortOrdersIntoReorderedIndices(int childCount, List<Order> orders, SparseIntArray orderCache) {
        Collections.sort(orders);
        orderCache.clear();
        int[] reorderedIndices = new int[childCount];
        int i = 0;
        for (Order order : orders) {
            reorderedIndices[i] = order.index;
            orderCache.append(order.index, order.order);
            ++i;
        }
        return reorderedIndices;
    }

    void calculateHorizontalFlexLines(FlexLinesResult result, int widthMeasureSpec, int heightMeasureSpec) {
        this.calculateFlexLines(result, widthMeasureSpec, heightMeasureSpec, Integer.MAX_VALUE, 0, -1, null);
    }

    void calculateHorizontalFlexLines(FlexLinesResult result, int widthMeasureSpec, int heightMeasureSpec, int needsCalcAmount, int fromIndex, @Nullable List<FlexLine> existingLines) {
        this.calculateFlexLines(result, widthMeasureSpec, heightMeasureSpec, needsCalcAmount, fromIndex, -1, existingLines);
    }

    void calculateHorizontalFlexLinesToIndex(FlexLinesResult result, int widthMeasureSpec, int heightMeasureSpec, int needsCalcAmount, int toIndex, List<FlexLine> existingLines) {
        this.calculateFlexLines(result, widthMeasureSpec, heightMeasureSpec, needsCalcAmount, 0, toIndex, existingLines);
    }

    void calculateVerticalFlexLines(FlexLinesResult result, int widthMeasureSpec, int heightMeasureSpec) {
        this.calculateFlexLines(result, heightMeasureSpec, widthMeasureSpec, Integer.MAX_VALUE, 0, -1, null);
    }

    void calculateVerticalFlexLines(FlexLinesResult result, int widthMeasureSpec, int heightMeasureSpec, int needsCalcAmount, int fromIndex, @Nullable List<FlexLine> existingLines) {
        this.calculateFlexLines(result, heightMeasureSpec, widthMeasureSpec, needsCalcAmount, fromIndex, -1, existingLines);
    }

    void calculateVerticalFlexLinesToIndex(FlexLinesResult result, int widthMeasureSpec, int heightMeasureSpec, int needsCalcAmount, int toIndex, List<FlexLine> existingLines) {
        this.calculateFlexLines(result, heightMeasureSpec, widthMeasureSpec, needsCalcAmount, 0, toIndex, existingLines);
    }

    void calculateFlexLines(FlexLinesResult result, int mainMeasureSpec, int crossMeasureSpec, int needsCalcAmount, int fromIndex, int toIndex, @Nullable List<FlexLine> existingLines) {
        boolean isMainHorizontal = this.mFlexContainer.isMainAxisDirectionHorizontal();
        int mainMode = View.MeasureSpec.getMode((int)mainMeasureSpec);
        int mainSize = View.MeasureSpec.getSize((int)mainMeasureSpec);
        int childState = 0;
        List<FlexLine> flexLines = existingLines == null ? new ArrayList<FlexLine>() : existingLines;
        result.mFlexLines = flexLines;
        boolean reachedToIndex = toIndex == -1;
        int mainPaddingStart = this.getPaddingStartMain(isMainHorizontal);
        int mainPaddingEnd = this.getPaddingEndMain(isMainHorizontal);
        int crossPaddingStart = this.getPaddingStartCross(isMainHorizontal);
        int crossPaddingEnd = this.getPaddingEndCross(isMainHorizontal);
        int largestSizeInCross = Integer.MIN_VALUE;
        int sumCrossSize = 0;
        int indexInFlexLine = 0;
        FlexLine flexLine = new FlexLine();
        flexLine.mFirstIndex = fromIndex;
        flexLine.mMainSize = mainPaddingStart + mainPaddingEnd;
        int childCount = this.mFlexContainer.getFlexItemCount();
        for (int i = fromIndex; i < childCount; ++i) {
            int childCrossMeasureSpec;
            int childMainMeasureSpec;
            View child = this.mFlexContainer.getReorderedFlexItemAt(i);
            if (child == null) {
                if (!this.isLastFlexItem(i, childCount, flexLine)) continue;
                this.addFlexLine(flexLines, flexLine, i, sumCrossSize);
                continue;
            }
            if (child.getVisibility() == 8) {
                ++flexLine.mGoneItemCount;
                ++flexLine.mItemCount;
                if (!this.isLastFlexItem(i, childCount, flexLine)) continue;
                this.addFlexLine(flexLines, flexLine, i, sumCrossSize);
                continue;
            }
            FlexItem flexItem = (FlexItem)child.getLayoutParams();
            if (flexItem.getAlignSelf() == 4) {
                flexLine.mIndicesAlignSelfStretch.add(i);
            }
            int childMainSize = this.getFlexItemSizeMain(flexItem, isMainHorizontal);
            if (flexItem.getFlexBasisPercent() != -1.0f && mainMode == 0x40000000) {
                childMainSize = Math.round((float)mainSize * flexItem.getFlexBasisPercent());
            }
            if (isMainHorizontal) {
                childMainMeasureSpec = this.mFlexContainer.getChildWidthMeasureSpec(mainMeasureSpec, mainPaddingStart + mainPaddingEnd + this.getFlexItemMarginStartMain(flexItem, true) + this.getFlexItemMarginEndMain(flexItem, true), childMainSize);
                childCrossMeasureSpec = this.mFlexContainer.getChildHeightMeasureSpec(crossMeasureSpec, crossPaddingStart + crossPaddingEnd + this.getFlexItemMarginStartCross(flexItem, true) + this.getFlexItemMarginEndCross(flexItem, true) + sumCrossSize, this.getFlexItemSizeCross(flexItem, true));
                child.measure(childMainMeasureSpec, childCrossMeasureSpec);
                this.updateMeasureCache(i, childMainMeasureSpec, childCrossMeasureSpec, child);
            } else {
                childCrossMeasureSpec = this.mFlexContainer.getChildWidthMeasureSpec(crossMeasureSpec, crossPaddingStart + crossPaddingEnd + this.getFlexItemMarginStartCross(flexItem, false) + this.getFlexItemMarginEndCross(flexItem, false) + sumCrossSize, this.getFlexItemSizeCross(flexItem, false));
                childMainMeasureSpec = this.mFlexContainer.getChildHeightMeasureSpec(mainMeasureSpec, mainPaddingStart + mainPaddingEnd + this.getFlexItemMarginStartMain(flexItem, false) + this.getFlexItemMarginEndMain(flexItem, false), childMainSize);
                child.measure(childCrossMeasureSpec, childMainMeasureSpec);
                this.updateMeasureCache(i, childCrossMeasureSpec, childMainMeasureSpec, child);
            }
            this.mFlexContainer.updateViewCache(i, child);
            this.checkSizeConstraints(child, i);
            childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)child));
            if (this.isWrapRequired(child, mainMode, mainSize, flexLine.mMainSize, this.getViewMeasuredSizeMain(child, isMainHorizontal) + this.getFlexItemMarginStartMain(flexItem, isMainHorizontal) + this.getFlexItemMarginEndMain(flexItem, isMainHorizontal), flexItem, i, indexInFlexLine)) {
                if (flexLine.getItemCountNotGone() > 0) {
                    this.addFlexLine(flexLines, flexLine, i > 0 ? i - 1 : 0, sumCrossSize);
                    sumCrossSize += flexLine.mCrossSize;
                }
                if (isMainHorizontal) {
                    if (flexItem.getHeight() == -1) {
                        childCrossMeasureSpec = this.mFlexContainer.getChildHeightMeasureSpec(crossMeasureSpec, this.mFlexContainer.getPaddingTop() + this.mFlexContainer.getPaddingBottom() + flexItem.getMarginTop() + flexItem.getMarginBottom() + sumCrossSize, flexItem.getHeight());
                        child.measure(childMainMeasureSpec, childCrossMeasureSpec);
                        this.checkSizeConstraints(child, i);
                    }
                } else if (flexItem.getWidth() == -1) {
                    childCrossMeasureSpec = this.mFlexContainer.getChildWidthMeasureSpec(crossMeasureSpec, this.mFlexContainer.getPaddingLeft() + this.mFlexContainer.getPaddingRight() + flexItem.getMarginLeft() + flexItem.getMarginRight() + sumCrossSize, flexItem.getWidth());
                    child.measure(childCrossMeasureSpec, childMainMeasureSpec);
                    this.checkSizeConstraints(child, i);
                }
                flexLine = new FlexLine();
                flexLine.mItemCount = 1;
                flexLine.mMainSize = mainPaddingStart + mainPaddingEnd;
                flexLine.mFirstIndex = i;
                indexInFlexLine = 0;
                largestSizeInCross = Integer.MIN_VALUE;
            } else {
                ++flexLine.mItemCount;
                ++indexInFlexLine;
            }
            if (this.mIndexToFlexLine != null) {
                this.mIndexToFlexLine[i] = flexLines.size();
            }
            flexLine.mMainSize += this.getViewMeasuredSizeMain(child, isMainHorizontal) + this.getFlexItemMarginStartMain(flexItem, isMainHorizontal) + this.getFlexItemMarginEndMain(flexItem, isMainHorizontal);
            flexLine.mTotalFlexGrow += flexItem.getFlexGrow();
            flexLine.mTotalFlexShrink += flexItem.getFlexShrink();
            this.mFlexContainer.onNewFlexItemAdded(child, i, indexInFlexLine, flexLine);
            largestSizeInCross = Math.max(largestSizeInCross, this.getViewMeasuredSizeCross(child, isMainHorizontal) + this.getFlexItemMarginStartCross(flexItem, isMainHorizontal) + this.getFlexItemMarginEndCross(flexItem, isMainHorizontal) + this.mFlexContainer.getDecorationLengthCrossAxis(child));
            flexLine.mCrossSize = Math.max(flexLine.mCrossSize, largestSizeInCross);
            if (isMainHorizontal) {
                flexLine.mMaxBaseline = this.mFlexContainer.getFlexWrap() != 2 ? Math.max(flexLine.mMaxBaseline, child.getBaseline() + flexItem.getMarginTop()) : Math.max(flexLine.mMaxBaseline, child.getMeasuredHeight() - child.getBaseline() + flexItem.getMarginBottom());
            }
            if (this.isLastFlexItem(i, childCount, flexLine)) {
                this.addFlexLine(flexLines, flexLine, i, sumCrossSize);
                sumCrossSize += flexLine.mCrossSize;
            }
            if (toIndex != -1 && flexLines.size() > 0 && flexLines.get((int)(flexLines.size() - 1)).mLastIndex >= toIndex && i >= toIndex && !reachedToIndex) {
                sumCrossSize = -flexLine.getCrossSize();
                reachedToIndex = true;
            }
            if (sumCrossSize > needsCalcAmount && reachedToIndex) break;
        }
        result.mChildState = childState;
    }

    private int getPaddingStartMain(boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return this.mFlexContainer.getPaddingStart();
        }
        return this.mFlexContainer.getPaddingTop();
    }

    private int getPaddingEndMain(boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return this.mFlexContainer.getPaddingEnd();
        }
        return this.mFlexContainer.getPaddingBottom();
    }

    private int getPaddingStartCross(boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return this.mFlexContainer.getPaddingTop();
        }
        return this.mFlexContainer.getPaddingStart();
    }

    private int getPaddingEndCross(boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return this.mFlexContainer.getPaddingBottom();
        }
        return this.mFlexContainer.getPaddingEnd();
    }

    private int getViewMeasuredSizeMain(View view, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return view.getMeasuredWidth();
        }
        return view.getMeasuredHeight();
    }

    private int getViewMeasuredSizeCross(View view, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return view.getMeasuredHeight();
        }
        return view.getMeasuredWidth();
    }

    private int getFlexItemSizeMain(FlexItem flexItem, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return flexItem.getWidth();
        }
        return flexItem.getHeight();
    }

    private int getFlexItemSizeCross(FlexItem flexItem, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return flexItem.getHeight();
        }
        return flexItem.getWidth();
    }

    private int getFlexItemMarginStartMain(FlexItem flexItem, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return flexItem.getMarginStart();
        }
        return flexItem.getMarginTop();
    }

    private int getFlexItemMarginEndMain(FlexItem flexItem, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return flexItem.getMarginEnd();
        }
        return flexItem.getMarginBottom();
    }

    private int getFlexItemMarginStartCross(FlexItem flexItem, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return flexItem.getMarginTop();
        }
        return flexItem.getMarginStart();
    }

    private int getFlexItemMarginEndCross(FlexItem flexItem, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return flexItem.getMarginBottom();
        }
        return flexItem.getMarginEnd();
    }

    private boolean isWrapRequired(View view, int mode, int maxSize, int currentLength, int childLength, FlexItem flexItem, int index, int indexInFlexLine) {
        if (this.mFlexContainer.getFlexWrap() == 0) {
            return false;
        }
        if (flexItem.isWrapBefore()) {
            return true;
        }
        if (mode == 0) {
            return false;
        }
        int decorationLength = this.mFlexContainer.getDecorationLengthMainAxis(view, index, indexInFlexLine);
        if (decorationLength > 0) {
            childLength += decorationLength;
        }
        return maxSize < currentLength + childLength;
    }

    private boolean isLastFlexItem(int childIndex, int childCount, FlexLine flexLine) {
        return childIndex == childCount - 1 && flexLine.getItemCountNotGone() != 0;
    }

    private void addFlexLine(List<FlexLine> flexLines, FlexLine flexLine, int viewIndex, int usedCrossSizeSoFar) {
        flexLine.mSumCrossSizeBefore = usedCrossSizeSoFar;
        this.mFlexContainer.onNewFlexLineAdded(flexLine);
        flexLine.mLastIndex = viewIndex;
        flexLines.add(flexLine);
    }

    private void checkSizeConstraints(View view, int index) {
        boolean needsMeasure = false;
        FlexItem flexItem = (FlexItem)view.getLayoutParams();
        int childWidth = view.getMeasuredWidth();
        int childHeight = view.getMeasuredHeight();
        if (childWidth < flexItem.getMinWidth()) {
            needsMeasure = true;
            childWidth = flexItem.getMinWidth();
        } else if (childWidth > flexItem.getMaxWidth()) {
            needsMeasure = true;
            childWidth = flexItem.getMaxWidth();
        }
        if (childHeight < flexItem.getMinHeight()) {
            needsMeasure = true;
            childHeight = flexItem.getMinHeight();
        } else if (childHeight > flexItem.getMaxHeight()) {
            needsMeasure = true;
            childHeight = flexItem.getMaxHeight();
        }
        if (needsMeasure) {
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000);
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000);
            view.measure(widthSpec, heightSpec);
            this.updateMeasureCache(index, widthSpec, heightSpec, view);
            this.mFlexContainer.updateViewCache(index, view);
        }
    }

    void determineMainSize(int widthMeasureSpec, int heightMeasureSpec) {
        this.determineMainSize(widthMeasureSpec, heightMeasureSpec, 0);
    }

    void determineMainSize(int widthMeasureSpec, int heightMeasureSpec, int fromIndex) {
        int paddingAlongMainAxis;
        int mainSize;
        this.ensureChildrenFrozen(this.mFlexContainer.getFlexItemCount());
        if (fromIndex >= this.mFlexContainer.getFlexItemCount()) {
            return;
        }
        int flexDirection = this.mFlexContainer.getFlexDirection();
        switch (this.mFlexContainer.getFlexDirection()) {
            case 0: 
            case 1: {
                int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
                int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
                mainSize = widthMode == 0x40000000 ? widthSize : this.mFlexContainer.getLargestMainSize();
                paddingAlongMainAxis = this.mFlexContainer.getPaddingLeft() + this.mFlexContainer.getPaddingRight();
                break;
            }
            case 2: 
            case 3: {
                int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
                mainSize = heightMode == 0x40000000 ? heightSize : this.mFlexContainer.getLargestMainSize();
                paddingAlongMainAxis = this.mFlexContainer.getPaddingTop() + this.mFlexContainer.getPaddingBottom();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
            }
        }
        int flexLineIndex = 0;
        if (this.mIndexToFlexLine != null) {
            flexLineIndex = this.mIndexToFlexLine[fromIndex];
        }
        List<FlexLine> flexLines = this.mFlexContainer.getFlexLinesInternal();
        int size = flexLines.size();
        for (int i = flexLineIndex; i < size; ++i) {
            FlexLine flexLine = flexLines.get(i);
            if (flexLine.mMainSize < mainSize) {
                this.expandFlexItems(widthMeasureSpec, heightMeasureSpec, flexLine, mainSize, paddingAlongMainAxis, false);
                continue;
            }
            this.shrinkFlexItems(widthMeasureSpec, heightMeasureSpec, flexLine, mainSize, paddingAlongMainAxis, false);
        }
    }

    private void ensureChildrenFrozen(int size) {
        if (this.mChildrenFrozen == null) {
            this.mChildrenFrozen = new boolean[size < 10 ? 10 : size];
        } else if (this.mChildrenFrozen.length < size) {
            int newCapacity = this.mChildrenFrozen.length * 2;
            this.mChildrenFrozen = new boolean[newCapacity >= size ? newCapacity : size];
        } else {
            Arrays.fill(this.mChildrenFrozen, false);
        }
    }

    private void expandFlexItems(int widthMeasureSpec, int heightMeasureSpec, FlexLine flexLine, int maxMainSize, int paddingAlongMainAxis, boolean calledRecursively) {
        if (flexLine.mTotalFlexGrow <= 0.0f || maxMainSize < flexLine.mMainSize) {
            return;
        }
        int sizeBeforeExpand = flexLine.mMainSize;
        boolean needsReexpand = false;
        float unitSpace = (float)(maxMainSize - flexLine.mMainSize) / flexLine.mTotalFlexGrow;
        flexLine.mMainSize = paddingAlongMainAxis + flexLine.mDividerLengthInMainSize;
        int largestCrossSize = 0;
        if (!calledRecursively) {
            flexLine.mCrossSize = Integer.MIN_VALUE;
        }
        float accumulatedRoundError = 0.0f;
        for (int i = 0; i < flexLine.mItemCount; ++i) {
            int index = flexLine.mFirstIndex + i;
            View child = this.mFlexContainer.getReorderedFlexItemAt(index);
            if (child == null || child.getVisibility() == 8) continue;
            FlexItem flexItem = (FlexItem)child.getLayoutParams();
            int flexDirection = this.mFlexContainer.getFlexDirection();
            if (flexDirection == 0 || flexDirection == 1) {
                int childMeasuredWidth = child.getMeasuredWidth();
                if (this.mMeasuredSizeCache != null) {
                    childMeasuredWidth = this.extractLowerInt(this.mMeasuredSizeCache[index]);
                }
                int childMeasuredHeight = child.getMeasuredHeight();
                if (this.mMeasuredSizeCache != null) {
                    childMeasuredHeight = this.extractHigherInt(this.mMeasuredSizeCache[index]);
                }
                if (!this.mChildrenFrozen[index] && flexItem.getFlexGrow() > 0.0f) {
                    int newWidth;
                    float rawCalculatedWidth = (float)childMeasuredWidth + unitSpace * flexItem.getFlexGrow();
                    if (i == flexLine.mItemCount - 1) {
                        rawCalculatedWidth += accumulatedRoundError;
                        accumulatedRoundError = 0.0f;
                    }
                    if ((newWidth = Math.round(rawCalculatedWidth)) > flexItem.getMaxWidth()) {
                        needsReexpand = true;
                        newWidth = flexItem.getMaxWidth();
                        this.mChildrenFrozen[index] = true;
                        flexLine.mTotalFlexGrow -= flexItem.getFlexGrow();
                    } else if ((double)(accumulatedRoundError += rawCalculatedWidth - (float)newWidth) > 1.0) {
                        ++newWidth;
                        accumulatedRoundError = (float)((double)accumulatedRoundError - 1.0);
                    } else if ((double)accumulatedRoundError < -1.0) {
                        --newWidth;
                        accumulatedRoundError = (float)((double)accumulatedRoundError + 1.0);
                    }
                    int childHeightMeasureSpec = this.getChildHeightMeasureSpecInternal(heightMeasureSpec, flexItem, flexLine.mSumCrossSizeBefore);
                    int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    childMeasuredWidth = child.getMeasuredWidth();
                    childMeasuredHeight = child.getMeasuredHeight();
                    this.updateMeasureCache(index, childWidthMeasureSpec, childHeightMeasureSpec, child);
                    this.mFlexContainer.updateViewCache(index, child);
                }
                largestCrossSize = Math.max(largestCrossSize, childMeasuredHeight + flexItem.getMarginTop() + flexItem.getMarginBottom() + this.mFlexContainer.getDecorationLengthCrossAxis(child));
                flexLine.mMainSize += childMeasuredWidth + flexItem.getMarginLeft() + flexItem.getMarginRight();
            } else {
                int childMeasuredHeight = child.getMeasuredHeight();
                if (this.mMeasuredSizeCache != null) {
                    childMeasuredHeight = this.extractHigherInt(this.mMeasuredSizeCache[index]);
                }
                int childMeasuredWidth = child.getMeasuredWidth();
                if (this.mMeasuredSizeCache != null) {
                    childMeasuredWidth = this.extractLowerInt(this.mMeasuredSizeCache[index]);
                }
                if (!this.mChildrenFrozen[index] && flexItem.getFlexGrow() > 0.0f) {
                    int newHeight;
                    float rawCalculatedHeight = (float)childMeasuredHeight + unitSpace * flexItem.getFlexGrow();
                    if (i == flexLine.mItemCount - 1) {
                        rawCalculatedHeight += accumulatedRoundError;
                        accumulatedRoundError = 0.0f;
                    }
                    if ((newHeight = Math.round(rawCalculatedHeight)) > flexItem.getMaxHeight()) {
                        needsReexpand = true;
                        newHeight = flexItem.getMaxHeight();
                        this.mChildrenFrozen[index] = true;
                        flexLine.mTotalFlexGrow -= flexItem.getFlexGrow();
                    } else if ((double)(accumulatedRoundError += rawCalculatedHeight - (float)newHeight) > 1.0) {
                        ++newHeight;
                        accumulatedRoundError = (float)((double)accumulatedRoundError - 1.0);
                    } else if ((double)accumulatedRoundError < -1.0) {
                        --newHeight;
                        accumulatedRoundError = (float)((double)accumulatedRoundError + 1.0);
                    }
                    int childWidthMeasureSpec = this.getChildWidthMeasureSpecInternal(widthMeasureSpec, flexItem, flexLine.mSumCrossSizeBefore);
                    int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    childMeasuredWidth = child.getMeasuredWidth();
                    childMeasuredHeight = child.getMeasuredHeight();
                    this.updateMeasureCache(index, childWidthMeasureSpec, childHeightMeasureSpec, child);
                    this.mFlexContainer.updateViewCache(index, child);
                }
                largestCrossSize = Math.max(largestCrossSize, childMeasuredWidth + flexItem.getMarginLeft() + flexItem.getMarginRight() + this.mFlexContainer.getDecorationLengthCrossAxis(child));
                flexLine.mMainSize += childMeasuredHeight + flexItem.getMarginTop() + flexItem.getMarginBottom();
            }
            flexLine.mCrossSize = Math.max(flexLine.mCrossSize, largestCrossSize);
        }
        if (needsReexpand && sizeBeforeExpand != flexLine.mMainSize) {
            this.expandFlexItems(widthMeasureSpec, heightMeasureSpec, flexLine, maxMainSize, paddingAlongMainAxis, true);
        }
    }

    private void shrinkFlexItems(int widthMeasureSpec, int heightMeasureSpec, FlexLine flexLine, int maxMainSize, int paddingAlongMainAxis, boolean calledRecursively) {
        int sizeBeforeShrink = flexLine.mMainSize;
        if (flexLine.mTotalFlexShrink <= 0.0f || maxMainSize > flexLine.mMainSize) {
            return;
        }
        boolean needsReshrink = false;
        float unitShrink = (float)(flexLine.mMainSize - maxMainSize) / flexLine.mTotalFlexShrink;
        float accumulatedRoundError = 0.0f;
        flexLine.mMainSize = paddingAlongMainAxis + flexLine.mDividerLengthInMainSize;
        int largestCrossSize = 0;
        if (!calledRecursively) {
            flexLine.mCrossSize = Integer.MIN_VALUE;
        }
        for (int i = 0; i < flexLine.mItemCount; ++i) {
            int index = flexLine.mFirstIndex + i;
            View child = this.mFlexContainer.getReorderedFlexItemAt(index);
            if (child == null || child.getVisibility() == 8) continue;
            FlexItem flexItem = (FlexItem)child.getLayoutParams();
            int flexDirection = this.mFlexContainer.getFlexDirection();
            if (flexDirection == 0 || flexDirection == 1) {
                int childMeasuredWidth = child.getMeasuredWidth();
                if (this.mMeasuredSizeCache != null) {
                    childMeasuredWidth = this.extractLowerInt(this.mMeasuredSizeCache[index]);
                }
                int childMeasuredHeight = child.getMeasuredHeight();
                if (this.mMeasuredSizeCache != null) {
                    childMeasuredHeight = this.extractHigherInt(this.mMeasuredSizeCache[index]);
                }
                if (!this.mChildrenFrozen[index] && flexItem.getFlexShrink() > 0.0f) {
                    int newWidth;
                    float rawCalculatedWidth = (float)childMeasuredWidth - unitShrink * flexItem.getFlexShrink();
                    if (i == flexLine.mItemCount - 1) {
                        rawCalculatedWidth += accumulatedRoundError;
                        accumulatedRoundError = 0.0f;
                    }
                    if ((newWidth = Math.round(rawCalculatedWidth)) < flexItem.getMinWidth()) {
                        needsReshrink = true;
                        newWidth = flexItem.getMinWidth();
                        this.mChildrenFrozen[index] = true;
                        flexLine.mTotalFlexShrink -= flexItem.getFlexShrink();
                    } else if ((double)(accumulatedRoundError += rawCalculatedWidth - (float)newWidth) > 1.0) {
                        ++newWidth;
                        accumulatedRoundError -= 1.0f;
                    } else if ((double)accumulatedRoundError < -1.0) {
                        --newWidth;
                        accumulatedRoundError += 1.0f;
                    }
                    int childHeightMeasureSpec = this.getChildHeightMeasureSpecInternal(heightMeasureSpec, flexItem, flexLine.mSumCrossSizeBefore);
                    int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    childMeasuredWidth = child.getMeasuredWidth();
                    childMeasuredHeight = child.getMeasuredHeight();
                    this.updateMeasureCache(index, childWidthMeasureSpec, childHeightMeasureSpec, child);
                    this.mFlexContainer.updateViewCache(index, child);
                }
                largestCrossSize = Math.max(largestCrossSize, childMeasuredHeight + flexItem.getMarginTop() + flexItem.getMarginBottom() + this.mFlexContainer.getDecorationLengthCrossAxis(child));
                flexLine.mMainSize += childMeasuredWidth + flexItem.getMarginLeft() + flexItem.getMarginRight();
            } else {
                int childMeasuredHeight = child.getMeasuredHeight();
                if (this.mMeasuredSizeCache != null) {
                    childMeasuredHeight = this.extractHigherInt(this.mMeasuredSizeCache[index]);
                }
                int childMeasuredWidth = child.getMeasuredWidth();
                if (this.mMeasuredSizeCache != null) {
                    childMeasuredWidth = this.extractLowerInt(this.mMeasuredSizeCache[index]);
                }
                if (!this.mChildrenFrozen[index] && flexItem.getFlexShrink() > 0.0f) {
                    int newHeight;
                    float rawCalculatedHeight = (float)childMeasuredHeight - unitShrink * flexItem.getFlexShrink();
                    if (i == flexLine.mItemCount - 1) {
                        rawCalculatedHeight += accumulatedRoundError;
                        accumulatedRoundError = 0.0f;
                    }
                    if ((newHeight = Math.round(rawCalculatedHeight)) < flexItem.getMinHeight()) {
                        needsReshrink = true;
                        newHeight = flexItem.getMinHeight();
                        this.mChildrenFrozen[index] = true;
                        flexLine.mTotalFlexShrink -= flexItem.getFlexShrink();
                    } else if ((double)(accumulatedRoundError += rawCalculatedHeight - (float)newHeight) > 1.0) {
                        ++newHeight;
                        accumulatedRoundError -= 1.0f;
                    } else if ((double)accumulatedRoundError < -1.0) {
                        --newHeight;
                        accumulatedRoundError += 1.0f;
                    }
                    int childWidthMeasureSpec = this.getChildWidthMeasureSpecInternal(widthMeasureSpec, flexItem, flexLine.mSumCrossSizeBefore);
                    int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    childMeasuredWidth = child.getMeasuredWidth();
                    childMeasuredHeight = child.getMeasuredHeight();
                    this.updateMeasureCache(index, childWidthMeasureSpec, childHeightMeasureSpec, child);
                    this.mFlexContainer.updateViewCache(index, child);
                }
                largestCrossSize = Math.max(largestCrossSize, childMeasuredWidth + flexItem.getMarginLeft() + flexItem.getMarginRight() + this.mFlexContainer.getDecorationLengthCrossAxis(child));
                flexLine.mMainSize += childMeasuredHeight + flexItem.getMarginTop() + flexItem.getMarginBottom();
            }
            flexLine.mCrossSize = Math.max(flexLine.mCrossSize, largestCrossSize);
        }
        if (needsReshrink && sizeBeforeShrink != flexLine.mMainSize) {
            this.shrinkFlexItems(widthMeasureSpec, heightMeasureSpec, flexLine, maxMainSize, paddingAlongMainAxis, true);
        }
    }

    private int getChildWidthMeasureSpecInternal(int widthMeasureSpec, FlexItem flexItem, int padding) {
        int childWidthMeasureSpec = this.mFlexContainer.getChildWidthMeasureSpec(widthMeasureSpec, this.mFlexContainer.getPaddingLeft() + this.mFlexContainer.getPaddingRight() + flexItem.getMarginLeft() + flexItem.getMarginRight() + padding, flexItem.getWidth());
        int childWidth = View.MeasureSpec.getSize((int)childWidthMeasureSpec);
        if (childWidth > flexItem.getMaxWidth()) {
            childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)flexItem.getMaxWidth(), (int)View.MeasureSpec.getMode((int)childWidthMeasureSpec));
        } else if (childWidth < flexItem.getMinWidth()) {
            childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)flexItem.getMinWidth(), (int)View.MeasureSpec.getMode((int)childWidthMeasureSpec));
        }
        return childWidthMeasureSpec;
    }

    private int getChildHeightMeasureSpecInternal(int heightMeasureSpec, FlexItem flexItem, int padding) {
        int childHeightMeasureSpec = this.mFlexContainer.getChildHeightMeasureSpec(heightMeasureSpec, this.mFlexContainer.getPaddingTop() + this.mFlexContainer.getPaddingBottom() + flexItem.getMarginTop() + flexItem.getMarginBottom() + padding, flexItem.getHeight());
        int childHeight = View.MeasureSpec.getSize((int)childHeightMeasureSpec);
        if (childHeight > flexItem.getMaxHeight()) {
            childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)flexItem.getMaxHeight(), (int)View.MeasureSpec.getMode((int)childHeightMeasureSpec));
        } else if (childHeight < flexItem.getMinHeight()) {
            childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)flexItem.getMinHeight(), (int)View.MeasureSpec.getMode((int)childHeightMeasureSpec));
        }
        return childHeightMeasureSpec;
    }

    void determineCrossSize(int widthMeasureSpec, int heightMeasureSpec, int paddingAlongCrossAxis) {
        int size;
        int mode;
        int flexDirection = this.mFlexContainer.getFlexDirection();
        switch (flexDirection) {
            case 0: 
            case 1: {
                mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
                size = View.MeasureSpec.getSize((int)heightMeasureSpec);
                break;
            }
            case 2: 
            case 3: {
                mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
                size = View.MeasureSpec.getSize((int)widthMeasureSpec);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
            }
        }
        List<FlexLine> flexLines = this.mFlexContainer.getFlexLinesInternal();
        if (mode == 0x40000000) {
            int totalCrossSize = this.mFlexContainer.getSumOfCrossSize() + paddingAlongCrossAxis;
            if (flexLines.size() == 1) {
                flexLines.get((int)0).mCrossSize = size - paddingAlongCrossAxis;
            } else if (flexLines.size() >= 2) {
                switch (this.mFlexContainer.getAlignContent()) {
                    case 5: {
                        if (totalCrossSize >= size) break;
                        float freeSpaceUnit = (float)(size - totalCrossSize) / (float)flexLines.size();
                        float accumulatedError = 0.0f;
                        int flexLinesSize = flexLines.size();
                        for (int i = 0; i < flexLinesSize; ++i) {
                            int newCrossSize;
                            FlexLine flexLine = flexLines.get(i);
                            float newCrossSizeAsFloat = (float)flexLine.mCrossSize + freeSpaceUnit;
                            if (i == flexLines.size() - 1) {
                                newCrossSizeAsFloat += accumulatedError;
                                accumulatedError = 0.0f;
                            }
                            if ((accumulatedError += newCrossSizeAsFloat - (float)(newCrossSize = Math.round(newCrossSizeAsFloat))) > 1.0f) {
                                accumulatedError -= 1.0f;
                            } else if (accumulatedError < -1.0f) {
                                --newCrossSize;
                                accumulatedError += 1.0f;
                            }
                            flexLine.mCrossSize = ++newCrossSize;
                        }
                        break;
                    }
                    case 4: {
                        if (totalCrossSize >= size) {
                            this.mFlexContainer.setFlexLines(this.constructFlexLinesForAlignContentCenter(flexLines, size, totalCrossSize));
                            break;
                        }
                        int spaceTopAndBottom = size - totalCrossSize;
                        int numberOfSpaces = flexLines.size() * 2;
                        ArrayList<FlexLine> newFlexLines = new ArrayList<FlexLine>();
                        FlexLine dummySpaceFlexLine = new FlexLine();
                        dummySpaceFlexLine.mCrossSize = spaceTopAndBottom /= numberOfSpaces;
                        for (FlexLine flexLine : flexLines) {
                            newFlexLines.add(dummySpaceFlexLine);
                            newFlexLines.add(flexLine);
                            newFlexLines.add(dummySpaceFlexLine);
                        }
                        this.mFlexContainer.setFlexLines(newFlexLines);
                        break;
                    }
                    case 3: {
                        if (totalCrossSize >= size) break;
                        float spaceBetweenFlexLine = size - totalCrossSize;
                        int numberOfSpaces = flexLines.size() - 1;
                        spaceBetweenFlexLine /= (float)numberOfSpaces;
                        float accumulatedError = 0.0f;
                        ArrayList<FlexLine> newFlexLines = new ArrayList<FlexLine>();
                        int flexLineSize = flexLines.size();
                        for (int i = 0; i < flexLineSize; ++i) {
                            FlexLine flexLine = flexLines.get(i);
                            newFlexLines.add(flexLine);
                            if (i == flexLines.size() - 1) continue;
                            FlexLine dummySpaceFlexLine = new FlexLine();
                            if (i == flexLines.size() - 2) {
                                dummySpaceFlexLine.mCrossSize = Math.round(spaceBetweenFlexLine + accumulatedError);
                                accumulatedError = 0.0f;
                            } else {
                                dummySpaceFlexLine.mCrossSize = Math.round(spaceBetweenFlexLine);
                            }
                            accumulatedError += spaceBetweenFlexLine - (float)dummySpaceFlexLine.mCrossSize;
                            if (accumulatedError > 1.0f) {
                                ++dummySpaceFlexLine.mCrossSize;
                                accumulatedError -= 1.0f;
                            } else if (accumulatedError < -1.0f) {
                                --dummySpaceFlexLine.mCrossSize;
                                accumulatedError += 1.0f;
                            }
                            newFlexLines.add(dummySpaceFlexLine);
                        }
                        this.mFlexContainer.setFlexLines(newFlexLines);
                        break;
                    }
                    case 2: {
                        this.mFlexContainer.setFlexLines(this.constructFlexLinesForAlignContentCenter(flexLines, size, totalCrossSize));
                        break;
                    }
                    case 1: {
                        int spaceTop = size - totalCrossSize;
                        FlexLine dummySpaceFlexLine = new FlexLine();
                        dummySpaceFlexLine.mCrossSize = spaceTop;
                        flexLines.add(0, dummySpaceFlexLine);
                        break;
                    }
                }
            }
        }
    }

    private List<FlexLine> constructFlexLinesForAlignContentCenter(List<FlexLine> flexLines, int size, int totalCrossSize) {
        int spaceAboveAndBottom = size - totalCrossSize;
        ArrayList<FlexLine> newFlexLines = new ArrayList<FlexLine>();
        FlexLine dummySpaceFlexLine = new FlexLine();
        dummySpaceFlexLine.mCrossSize = spaceAboveAndBottom /= 2;
        int flexLineSize = flexLines.size();
        for (int i = 0; i < flexLineSize; ++i) {
            if (i == 0) {
                newFlexLines.add(dummySpaceFlexLine);
            }
            FlexLine flexLine = flexLines.get(i);
            newFlexLines.add(flexLine);
            if (i != flexLines.size() - 1) continue;
            newFlexLines.add(dummySpaceFlexLine);
        }
        return newFlexLines;
    }

    void stretchViews() {
        this.stretchViews(0);
    }

    void stretchViews(int fromIndex) {
        if (fromIndex >= this.mFlexContainer.getFlexItemCount()) {
            return;
        }
        int flexDirection = this.mFlexContainer.getFlexDirection();
        if (this.mFlexContainer.getAlignItems() == 4) {
            int flexLineIndex = 0;
            if (this.mIndexToFlexLine != null) {
                flexLineIndex = this.mIndexToFlexLine[fromIndex];
            }
            List<FlexLine> flexLines = this.mFlexContainer.getFlexLinesInternal();
            int size = flexLines.size();
            for (int i = flexLineIndex; i < size; ++i) {
                FlexLine flexLine = flexLines.get(i);
                int itemCount = flexLine.mItemCount;
                block9: for (int j = 0; j < itemCount; ++j) {
                    FlexItem flexItem;
                    View view;
                    int viewIndex = flexLine.mFirstIndex + j;
                    if (j >= this.mFlexContainer.getFlexItemCount() || (view = this.mFlexContainer.getReorderedFlexItemAt(viewIndex)) == null || view.getVisibility() == 8 || (flexItem = (FlexItem)view.getLayoutParams()).getAlignSelf() != -1 && flexItem.getAlignSelf() != 4) continue;
                    switch (flexDirection) {
                        case 0: 
                        case 1: {
                            this.stretchViewVertically(view, flexLine.mCrossSize, viewIndex);
                            continue block9;
                        }
                        case 2: 
                        case 3: {
                            this.stretchViewHorizontally(view, flexLine.mCrossSize, viewIndex);
                            continue block9;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
                        }
                    }
                }
            }
        } else {
            for (FlexLine flexLine : this.mFlexContainer.getFlexLinesInternal()) {
                block11: for (Integer index : flexLine.mIndicesAlignSelfStretch) {
                    View view = this.mFlexContainer.getReorderedFlexItemAt(index);
                    switch (flexDirection) {
                        case 0: 
                        case 1: {
                            this.stretchViewVertically(view, flexLine.mCrossSize, index);
                            continue block11;
                        }
                        case 2: 
                        case 3: {
                            this.stretchViewHorizontally(view, flexLine.mCrossSize, index);
                            continue block11;
                        }
                    }
                    throw new IllegalArgumentException("Invalid flex direction: " + flexDirection);
                }
            }
        }
    }

    private void stretchViewVertically(View view, int crossSize, int index) {
        FlexItem flexItem = (FlexItem)view.getLayoutParams();
        int newHeight = crossSize - flexItem.getMarginTop() - flexItem.getMarginBottom() - this.mFlexContainer.getDecorationLengthCrossAxis(view);
        newHeight = Math.max(newHeight, flexItem.getMinHeight());
        newHeight = Math.min(newHeight, flexItem.getMaxHeight());
        int measuredWidth = this.mMeasuredSizeCache != null ? this.extractLowerInt(this.mMeasuredSizeCache[index]) : view.getMeasuredWidth();
        int childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)measuredWidth, (int)0x40000000);
        int childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000);
        view.measure(childWidthSpec, childHeightSpec);
        this.updateMeasureCache(index, childWidthSpec, childHeightSpec, view);
        this.mFlexContainer.updateViewCache(index, view);
    }

    private void stretchViewHorizontally(View view, int crossSize, int index) {
        FlexItem flexItem = (FlexItem)view.getLayoutParams();
        int newWidth = crossSize - flexItem.getMarginLeft() - flexItem.getMarginRight() - this.mFlexContainer.getDecorationLengthCrossAxis(view);
        newWidth = Math.max(newWidth, flexItem.getMinWidth());
        newWidth = Math.min(newWidth, flexItem.getMaxWidth());
        int measuredHeight = this.mMeasuredSizeCache != null ? this.extractHigherInt(this.mMeasuredSizeCache[index]) : view.getMeasuredHeight();
        int childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)measuredHeight, (int)0x40000000);
        int childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000);
        view.measure(childWidthSpec, childHeightSpec);
        this.updateMeasureCache(index, childWidthSpec, childHeightSpec, view);
        this.mFlexContainer.updateViewCache(index, view);
    }

    void layoutSingleChildHorizontal(View view, FlexLine flexLine, int left, int top, int right, int bottom) {
        FlexItem flexItem = (FlexItem)view.getLayoutParams();
        int alignItems = this.mFlexContainer.getAlignItems();
        if (flexItem.getAlignSelf() != -1) {
            alignItems = flexItem.getAlignSelf();
        }
        int crossSize = flexLine.mCrossSize;
        switch (alignItems) {
            case 0: 
            case 4: {
                if (this.mFlexContainer.getFlexWrap() != 2) {
                    view.layout(left, top + flexItem.getMarginTop(), right, bottom + flexItem.getMarginTop());
                    break;
                }
                view.layout(left, top - flexItem.getMarginBottom(), right, bottom - flexItem.getMarginBottom());
                break;
            }
            case 3: {
                if (this.mFlexContainer.getFlexWrap() != 2) {
                    int marginTop = flexLine.mMaxBaseline - view.getBaseline();
                    marginTop = Math.max(marginTop, flexItem.getMarginTop());
                    view.layout(left, top + marginTop, right, bottom + marginTop);
                    break;
                }
                int marginBottom = flexLine.mMaxBaseline - view.getMeasuredHeight() + view.getBaseline();
                marginBottom = Math.max(marginBottom, flexItem.getMarginBottom());
                view.layout(left, top - marginBottom, right, bottom - marginBottom);
                break;
            }
            case 1: {
                if (this.mFlexContainer.getFlexWrap() != 2) {
                    view.layout(left, top + crossSize - view.getMeasuredHeight() - flexItem.getMarginBottom(), right, top + crossSize - flexItem.getMarginBottom());
                    break;
                }
                view.layout(left, top - crossSize + view.getMeasuredHeight() + flexItem.getMarginTop(), right, bottom - crossSize + view.getMeasuredHeight() + flexItem.getMarginTop());
                break;
            }
            case 2: {
                int topFromCrossAxis = (crossSize - view.getMeasuredHeight() + flexItem.getMarginTop() - flexItem.getMarginBottom()) / 2;
                if (this.mFlexContainer.getFlexWrap() != 2) {
                    view.layout(left, top + topFromCrossAxis, right, top + topFromCrossAxis + view.getMeasuredHeight());
                    break;
                }
                view.layout(left, top - topFromCrossAxis, right, top - topFromCrossAxis + view.getMeasuredHeight());
            }
        }
    }

    void layoutSingleChildVertical(View view, FlexLine flexLine, boolean isRtl, int left, int top, int right, int bottom) {
        FlexItem flexItem = (FlexItem)view.getLayoutParams();
        int alignItems = this.mFlexContainer.getAlignItems();
        if (flexItem.getAlignSelf() != -1) {
            alignItems = flexItem.getAlignSelf();
        }
        int crossSize = flexLine.mCrossSize;
        switch (alignItems) {
            case 0: 
            case 3: 
            case 4: {
                if (!isRtl) {
                    view.layout(left + flexItem.getMarginLeft(), top, right + flexItem.getMarginLeft(), bottom);
                    break;
                }
                view.layout(left - flexItem.getMarginRight(), top, right - flexItem.getMarginRight(), bottom);
                break;
            }
            case 1: {
                if (!isRtl) {
                    view.layout(left + crossSize - view.getMeasuredWidth() - flexItem.getMarginRight(), top, right + crossSize - view.getMeasuredWidth() - flexItem.getMarginRight(), bottom);
                    break;
                }
                view.layout(left - crossSize + view.getMeasuredWidth() + flexItem.getMarginLeft(), top, right - crossSize + view.getMeasuredWidth() + flexItem.getMarginLeft(), bottom);
                break;
            }
            case 2: {
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
                int leftFromCrossAxis = (crossSize - view.getMeasuredWidth() + MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)lp) - MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)lp)) / 2;
                if (!isRtl) {
                    view.layout(left + leftFromCrossAxis, top, right + leftFromCrossAxis, bottom);
                    break;
                }
                view.layout(left - leftFromCrossAxis, top, right - leftFromCrossAxis, bottom);
            }
        }
    }

    void ensureMeasuredSizeCache(int size) {
        if (this.mMeasuredSizeCache == null) {
            this.mMeasuredSizeCache = new long[size < 10 ? 10 : size];
        } else if (this.mMeasuredSizeCache.length < size) {
            int newCapacity = this.mMeasuredSizeCache.length * 2;
            newCapacity = newCapacity >= size ? newCapacity : size;
            this.mMeasuredSizeCache = Arrays.copyOf(this.mMeasuredSizeCache, newCapacity);
        }
    }

    void ensureMeasureSpecCache(int size) {
        if (this.mMeasureSpecCache == null) {
            this.mMeasureSpecCache = new long[size < 10 ? 10 : size];
        } else if (this.mMeasureSpecCache.length < size) {
            int newCapacity = this.mMeasureSpecCache.length * 2;
            newCapacity = newCapacity >= size ? newCapacity : size;
            this.mMeasureSpecCache = Arrays.copyOf(this.mMeasureSpecCache, newCapacity);
        }
    }

    int extractLowerInt(long longValue) {
        return (int)longValue;
    }

    int extractHigherInt(long longValue) {
        return (int)(longValue >> 32);
    }

    @VisibleForTesting
    long makeCombinedLong(int widthMeasureSpec, int heightMeasureSpec) {
        return (long)heightMeasureSpec << 32 | (long)widthMeasureSpec & 0xFFFFFFFFL;
    }

    private void updateMeasureCache(int index, int widthMeasureSpec, int heightMeasureSpec, View view) {
        if (this.mMeasureSpecCache != null) {
            this.mMeasureSpecCache[index] = this.makeCombinedLong(widthMeasureSpec, heightMeasureSpec);
        }
        if (this.mMeasuredSizeCache != null) {
            this.mMeasuredSizeCache[index] = this.makeCombinedLong(view.getMeasuredWidth(), view.getMeasuredHeight());
        }
    }

    void ensureIndexToFlexLine(int size) {
        if (this.mIndexToFlexLine == null) {
            this.mIndexToFlexLine = new int[size < 10 ? 10 : size];
        } else if (this.mIndexToFlexLine.length < size) {
            int newCapacity = this.mIndexToFlexLine.length * 2;
            newCapacity = newCapacity >= size ? newCapacity : size;
            this.mIndexToFlexLine = Arrays.copyOf(this.mIndexToFlexLine, newCapacity);
        }
    }

    void clearFlexLines(List<FlexLine> flexLines, int fromFlexItem) {
        assert (this.mIndexToFlexLine != null);
        assert (this.mMeasureSpecCache != null);
        int fromFlexLine = this.mIndexToFlexLine[fromFlexItem];
        if (fromFlexLine == -1) {
            fromFlexLine = 0;
        }
        for (int i = flexLines.size() - 1; i >= fromFlexLine; --i) {
            flexLines.remove(i);
        }
        int fillTo = this.mIndexToFlexLine.length - 1;
        if (fromFlexItem > fillTo) {
            Arrays.fill(this.mIndexToFlexLine, -1);
        } else {
            Arrays.fill(this.mIndexToFlexLine, fromFlexItem, fillTo, -1);
        }
        fillTo = this.mMeasureSpecCache.length - 1;
        if (fromFlexItem > fillTo) {
            Arrays.fill(this.mMeasureSpecCache, 0L);
        } else {
            Arrays.fill(this.mMeasureSpecCache, fromFlexItem, fillTo, 0L);
        }
    }

    static class FlexLinesResult {
        List<FlexLine> mFlexLines;
        int mChildState;

        FlexLinesResult() {
        }

        void reset() {
            this.mFlexLines = null;
            this.mChildState = 0;
        }
    }

    private static class Order
    implements Comparable<Order> {
        int index;
        int order;

        private Order() {
        }

        @Override
        public int compareTo(@NonNull Order another) {
            if (this.order != another.order) {
                return this.order - another.order;
            }
            return this.index - another.index;
        }

        public String toString() {
            return "Order{order=" + this.order + ", index=" + this.index + '}';
        }
    }
}

