/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.flexbox;

import android.content.Context;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v7.widget.OrientationHelper;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.flexbox.FlexContainer;
import com.google.android.flexbox.FlexItem;
import com.google.android.flexbox.FlexLine;
import com.google.android.flexbox.FlexboxHelper;
import java.util.ArrayList;
import java.util.List;

public class FlexboxLayoutManager
extends RecyclerView.LayoutManager
implements FlexContainer {
    private static final String TAG = "FlexboxLayoutManager";
    private static final Rect TEMP_RECT = new Rect();
    private static final boolean DEBUG = false;
    private int mFlexDirection;
    private int mFlexWrap;
    private int mJustifyContent;
    private int mAlignItems;
    private boolean mIsRtl;
    private boolean mFromBottomToTop;
    private List<FlexLine> mFlexLines = new ArrayList<FlexLine>();
    private final FlexboxHelper mFlexboxHelper = new FlexboxHelper(this);
    private RecyclerView.Recycler mRecycler;
    private RecyclerView.State mState;
    private LayoutState mLayoutState;
    private AnchorInfo mAnchorInfo = new AnchorInfo();
    private OrientationHelper mOrientationHelper;
    private SavedState mPendingSavedState;
    private int mPendingScrollPosition = -1;
    private int mPendingScrollPositionOffset = Integer.MIN_VALUE;
    private int mLastWidth = Integer.MIN_VALUE;
    private int mLastHeight = Integer.MIN_VALUE;
    private boolean mRecycleChildrenOnDetach;
    private SparseArray<View> mViewCache = new SparseArray();

    public FlexboxLayoutManager() {
        this(0, 1);
    }

    public FlexboxLayoutManager(int flexDirection) {
        this(flexDirection, 1);
    }

    public FlexboxLayoutManager(int flexDirection, int flexWrap) {
        this.setFlexDirection(flexDirection);
        this.setFlexWrap(flexWrap);
        this.setAlignItems(4);
        this.setAutoMeasureEnabled(true);
    }

    public FlexboxLayoutManager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        RecyclerView.LayoutManager.Properties properties = FlexboxLayoutManager.getProperties((Context)context, (AttributeSet)attrs, (int)defStyleAttr, (int)defStyleRes);
        switch (properties.orientation) {
            case 0: {
                if (properties.reverseLayout) {
                    this.setFlexDirection(1);
                    break;
                }
                this.setFlexDirection(0);
                break;
            }
            case 1: {
                if (properties.reverseLayout) {
                    this.setFlexDirection(3);
                    break;
                }
                this.setFlexDirection(2);
            }
        }
        this.setFlexWrap(1);
        this.setAlignItems(4);
        this.setAutoMeasureEnabled(true);
    }

    @Override
    public int getFlexDirection() {
        return this.mFlexDirection;
    }

    @Override
    public void setFlexDirection(int flexDirection) {
        if (this.mFlexDirection != flexDirection) {
            this.removeAllViews();
            this.clearFlexLines();
            this.mFlexDirection = flexDirection;
            this.mOrientationHelper = null;
            this.requestLayout();
        }
    }

    @Override
    public int getFlexWrap() {
        return this.mFlexWrap;
    }

    @Override
    public void setFlexWrap(int flexWrap) {
        if (flexWrap == 2) {
            throw new UnsupportedOperationException("wrap_reverse is not supported in FlexboxLayoutManager");
        }
        if (this.mFlexWrap != flexWrap) {
            if (this.mFlexWrap == 0 || flexWrap == 0) {
                this.removeAllViews();
                this.clearFlexLines();
            }
            this.mFlexWrap = flexWrap;
            this.mOrientationHelper = null;
            this.requestLayout();
        }
    }

    @Override
    public int getJustifyContent() {
        return this.mJustifyContent;
    }

    @Override
    public void setJustifyContent(int justifyContent) {
        if (this.mJustifyContent != justifyContent) {
            this.mJustifyContent = justifyContent;
            this.requestLayout();
        }
    }

    @Override
    public int getAlignItems() {
        return this.mAlignItems;
    }

    @Override
    public void setAlignItems(int alignItems) {
        if (this.mAlignItems != alignItems) {
            if (this.mAlignItems == 4 || alignItems == 4) {
                this.removeAllViews();
                this.clearFlexLines();
            }
            this.mAlignItems = alignItems;
            this.requestLayout();
        }
    }

    @Override
    public int getAlignContent() {
        return 5;
    }

    @Override
    public void setAlignContent(int alignContent) {
        throw new UnsupportedOperationException("Setting the alignContent in the FlexboxLayoutManager is not supported. Use FlexboxLayout if you need to reorder using the attribute.");
    }

    @Override
    public List<FlexLine> getFlexLines() {
        ArrayList<FlexLine> result = new ArrayList<FlexLine>(this.mFlexLines.size());
        int size = this.mFlexLines.size();
        for (int i = 0; i < size; ++i) {
            FlexLine flexLine = this.mFlexLines.get(i);
            if (flexLine.getItemCount() == 0) continue;
            result.add(flexLine);
        }
        return result;
    }

    @Override
    public int getDecorationLengthMainAxis(View view, int index, int indexInFlexLine) {
        if (this.isMainAxisDirectionHorizontal()) {
            return this.getLeftDecorationWidth(view) + this.getRightDecorationWidth(view);
        }
        return this.getTopDecorationHeight(view) + this.getBottomDecorationHeight(view);
    }

    @Override
    public int getDecorationLengthCrossAxis(View view) {
        if (this.isMainAxisDirectionHorizontal()) {
            return this.getTopDecorationHeight(view) + this.getBottomDecorationHeight(view);
        }
        return this.getLeftDecorationWidth(view) + this.getRightDecorationWidth(view);
    }

    @Override
    public void onNewFlexItemAdded(View view, int index, int indexInFlexLine, FlexLine flexLine) {
        this.calculateItemDecorationsForChild(view, TEMP_RECT);
        if (this.isMainAxisDirectionHorizontal()) {
            int decorationWidth = this.getLeftDecorationWidth(view) + this.getRightDecorationWidth(view);
            flexLine.mMainSize += decorationWidth;
            flexLine.mDividerLengthInMainSize += decorationWidth;
        } else {
            int decorationHeight = this.getTopDecorationHeight(view) + this.getBottomDecorationHeight(view);
            flexLine.mMainSize += decorationHeight;
            flexLine.mDividerLengthInMainSize += decorationHeight;
        }
    }

    @Override
    public int getFlexItemCount() {
        return this.mState.getItemCount();
    }

    @Override
    public View getFlexItemAt(int index) {
        View cachedView = (View)this.mViewCache.get(index);
        if (cachedView != null) {
            return cachedView;
        }
        List scrapList = this.mRecycler.getScrapList();
        int scrapCount = scrapList.size();
        for (int i = 0; i < scrapCount; ++i) {
            RecyclerView.ViewHolder viewHolder = (RecyclerView.ViewHolder)scrapList.get(i);
            if (viewHolder.getAdapterPosition() != index) continue;
            return viewHolder.itemView;
        }
        return this.mRecycler.getViewForPosition(index);
    }

    @Override
    public View getReorderedFlexItemAt(int index) {
        return this.getFlexItemAt(index);
    }

    @Override
    public void onNewFlexLineAdded(FlexLine flexLine) {
    }

    @Override
    public int getChildWidthMeasureSpec(int widthSpec, int padding, int childDimension) {
        return FlexboxLayoutManager.getChildMeasureSpec((int)this.getWidth(), (int)this.getWidthMode(), (int)padding, (int)childDimension, (boolean)this.canScrollHorizontally());
    }

    @Override
    public int getChildHeightMeasureSpec(int heightSpec, int padding, int childDimension) {
        return FlexboxLayoutManager.getChildMeasureSpec((int)this.getHeight(), (int)this.getHeightMode(), (int)padding, (int)childDimension, (boolean)this.canScrollVertically());
    }

    @Override
    public int getLargestMainSize() {
        int largestSize = Integer.MIN_VALUE;
        int size = this.mFlexLines.size();
        for (int i = 0; i < size; ++i) {
            FlexLine flexLine = this.mFlexLines.get(i);
            largestSize = Math.max(largestSize, flexLine.mMainSize);
        }
        return largestSize;
    }

    @Override
    public int getSumOfCrossSize() {
        int sum = 0;
        int size = this.mFlexLines.size();
        for (int i = 0; i < size; ++i) {
            FlexLine flexLine = this.mFlexLines.get(i);
            sum += flexLine.mCrossSize;
        }
        return sum;
    }

    @Override
    public void setFlexLines(List<FlexLine> flexLines) {
        this.mFlexLines = flexLines;
    }

    @Override
    public List<FlexLine> getFlexLinesInternal() {
        return this.mFlexLines;
    }

    @Override
    public void updateViewCache(int position, View view) {
        this.mViewCache.put(position, (Object)view);
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public RecyclerView.LayoutParams generateLayoutParams(Context c, AttributeSet attrs) {
        return new LayoutParams(c, attrs);
    }

    public boolean checkLayoutParams(RecyclerView.LayoutParams lp) {
        return lp instanceof LayoutParams;
    }

    public void onAdapterChanged(RecyclerView.Adapter oldAdapter, RecyclerView.Adapter newAdapter) {
        this.removeAllViews();
    }

    public Parcelable onSaveInstanceState() {
        if (this.mPendingSavedState != null) {
            return new SavedState(this.mPendingSavedState);
        }
        SavedState savedState = new SavedState();
        if (this.getChildCount() > 0) {
            View firstView = this.getChildClosestToStart();
            savedState.mAnchorPosition = this.getPosition(firstView);
            savedState.mAnchorOffset = this.mOrientationHelper.getDecoratedStart(firstView) - this.mOrientationHelper.getStartAfterPadding();
        } else {
            savedState.invalidateAnchor();
        }
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            this.mPendingSavedState = (SavedState)state;
            this.requestLayout();
        }
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        int endOffset;
        int startOffset;
        int filledToEnd;
        this.mRecycler = recycler;
        this.mState = state;
        int childCount = state.getItemCount();
        if (childCount == 0 && state.isPreLayout()) {
            return;
        }
        this.resolveLayoutDirection();
        this.ensureOrientationHelper();
        this.ensureLayoutState();
        this.mFlexboxHelper.ensureMeasureSpecCache(childCount);
        this.mFlexboxHelper.ensureMeasuredSizeCache(childCount);
        this.mFlexboxHelper.ensureIndexToFlexLine(childCount);
        this.mLayoutState.mShouldRecycle = false;
        if (this.mPendingSavedState != null && this.mPendingSavedState.hasValidAnchor(childCount)) {
            this.mPendingScrollPosition = this.mPendingSavedState.mAnchorPosition;
        }
        if (!this.mAnchorInfo.mValid || this.mPendingScrollPosition != -1 || this.mPendingSavedState != null) {
            this.mAnchorInfo.reset();
            this.updateAnchorInfoForLayout(state, this.mAnchorInfo);
            this.mAnchorInfo.mValid = true;
        }
        this.detachAndScrapAttachedViews(recycler);
        if (this.mAnchorInfo.mLayoutFromEnd) {
            this.updateLayoutStateToFillStart(this.mAnchorInfo, false, true);
        } else {
            this.updateLayoutStateToFillEnd(this.mAnchorInfo, false, true);
        }
        this.updateFlexLines(childCount);
        if (this.mAnchorInfo.mLayoutFromEnd) {
            filledToEnd = this.fill(recycler, state, this.mLayoutState);
            startOffset = this.mLayoutState.mOffset;
            this.updateLayoutStateToFillEnd(this.mAnchorInfo, true, false);
            int filledToStart = this.fill(recycler, state, this.mLayoutState);
            endOffset = this.mLayoutState.mOffset;
        } else {
            filledToEnd = this.fill(recycler, state, this.mLayoutState);
            endOffset = this.mLayoutState.mOffset;
            this.updateLayoutStateToFillStart(this.mAnchorInfo, true, false);
            int filledToStart = this.fill(recycler, state, this.mLayoutState);
            startOffset = this.mLayoutState.mOffset;
        }
        if (this.getChildCount() > 0) {
            int fixOffset;
            if (this.mAnchorInfo.mLayoutFromEnd) {
                fixOffset = this.fixLayoutEndGap(endOffset, recycler, state, true);
                this.fixLayoutStartGap(startOffset += fixOffset, recycler, state, false);
            } else {
                fixOffset = this.fixLayoutStartGap(startOffset, recycler, state, true);
                this.fixLayoutEndGap(endOffset += fixOffset, recycler, state, false);
            }
        }
    }

    private int fixLayoutStartGap(int startOffset, RecyclerView.Recycler recycler, RecyclerView.State state, boolean canOffsetChildren) {
        int gap = startOffset - this.mOrientationHelper.getStartAfterPadding();
        if (gap <= 0) {
            return 0;
        }
        int fixOffset = -this.handleScrolling(gap, recycler, state);
        if (canOffsetChildren && (gap = (startOffset += fixOffset) - this.mOrientationHelper.getStartAfterPadding()) > 0) {
            this.mOrientationHelper.offsetChildren(-gap);
            return fixOffset - gap;
        }
        return fixOffset;
    }

    private int fixLayoutEndGap(int endOffset, RecyclerView.Recycler recycler, RecyclerView.State state, boolean canOffsetChildren) {
        int gap = this.mOrientationHelper.getEndAfterPadding() - endOffset;
        if (gap <= 0) {
            return 0;
        }
        int fixOffset = -this.handleScrolling(-gap, recycler, state);
        if (canOffsetChildren && (gap = this.mOrientationHelper.getEndAfterPadding() - (endOffset += fixOffset)) > 0) {
            this.mOrientationHelper.offsetChildren(gap);
            return gap + fixOffset;
        }
        return fixOffset;
    }

    private void updateFlexLines(int childCount) {
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)this.getWidthMode());
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getHeight(), (int)this.getHeightMode());
        int width = this.getWidth();
        int height = this.getHeight();
        boolean isMainSizeChanged = this.isMainAxisDirectionHorizontal() ? this.mLastWidth != Integer.MIN_VALUE && this.mLastWidth != width : this.mLastHeight != Integer.MIN_VALUE && this.mLastHeight != height;
        this.mLastWidth = width;
        this.mLastHeight = height;
        if (this.mPendingScrollPosition != -1 || isMainSizeChanged) {
            if (this.mAnchorInfo.mLayoutFromEnd) {
                return;
            }
            this.mFlexLines.clear();
            assert (this.mFlexboxHelper.mIndexToFlexLine != null);
            FlexboxHelper.FlexLinesResult flexLinesResult = this.isMainAxisDirectionHorizontal() ? this.mFlexboxHelper.calculateHorizontalFlexLinesToIndex(widthMeasureSpec, heightMeasureSpec, this.mLayoutState.mAvailable, this.mAnchorInfo.mPosition, this.mFlexLines) : this.mFlexboxHelper.calculateVerticalFlexLinesToIndex(widthMeasureSpec, heightMeasureSpec, this.mLayoutState.mAvailable, this.mAnchorInfo.mPosition, this.mFlexLines);
            this.mFlexLines = flexLinesResult.mFlexLines;
            this.mFlexboxHelper.determineMainSize(widthMeasureSpec, heightMeasureSpec);
            this.mFlexboxHelper.stretchViews();
            this.mAnchorInfo.mFlexLinePosition = this.mFlexboxHelper.mIndexToFlexLine[this.mAnchorInfo.mPosition];
            this.mLayoutState.mFlexLinePosition = this.mAnchorInfo.mFlexLinePosition;
        } else {
            FlexboxHelper.FlexLinesResult flexLinesResult;
            if (this.isMainAxisDirectionHorizontal()) {
                if (this.mFlexLines.size() > 0) {
                    this.mFlexboxHelper.clearFlexLines(this.mFlexLines, this.mAnchorInfo.mPosition);
                    flexLinesResult = this.mFlexboxHelper.calculateHorizontalFlexLines(widthMeasureSpec, heightMeasureSpec, this.mLayoutState.mAvailable, this.mAnchorInfo.mPosition, this.mFlexLines);
                } else {
                    this.mFlexboxHelper.ensureIndexToFlexLine(childCount);
                    flexLinesResult = this.mFlexboxHelper.calculateHorizontalFlexLines(widthMeasureSpec, heightMeasureSpec, this.mLayoutState.mAvailable, 0, this.mFlexLines);
                }
            } else if (this.mFlexLines.size() > 0) {
                this.mFlexboxHelper.clearFlexLines(this.mFlexLines, this.mAnchorInfo.mPosition);
                flexLinesResult = this.mFlexboxHelper.calculateVerticalFlexLines(widthMeasureSpec, heightMeasureSpec, this.mLayoutState.mAvailable, this.mAnchorInfo.mPosition, this.mFlexLines);
            } else {
                this.mFlexboxHelper.ensureIndexToFlexLine(childCount);
                flexLinesResult = this.mFlexboxHelper.calculateVerticalFlexLines(widthMeasureSpec, heightMeasureSpec, this.mLayoutState.mAvailable, 0, this.mFlexLines);
            }
            this.mFlexLines = flexLinesResult.mFlexLines;
            this.mFlexboxHelper.determineMainSize(widthMeasureSpec, heightMeasureSpec, this.mAnchorInfo.mPosition);
            this.mFlexboxHelper.stretchViews(this.mAnchorInfo.mPosition);
        }
    }

    public void onLayoutCompleted(RecyclerView.State state) {
        super.onLayoutCompleted(state);
        this.mPendingSavedState = null;
        this.mPendingScrollPosition = -1;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        this.mAnchorInfo.reset();
        this.mViewCache.clear();
    }

    boolean isLayoutRtl() {
        return this.mIsRtl;
    }

    private void resolveLayoutDirection() {
        int layoutDirection = this.getLayoutDirection();
        switch (this.mFlexDirection) {
            case 0: {
                this.mIsRtl = layoutDirection == 1;
                this.mFromBottomToTop = this.mFlexWrap == 2;
                break;
            }
            case 1: {
                this.mIsRtl = layoutDirection != 1;
                this.mFromBottomToTop = this.mFlexWrap == 2;
                break;
            }
            case 2: {
                boolean bl = this.mIsRtl = layoutDirection == 1;
                if (this.mFlexWrap == 2) {
                    this.mIsRtl = !this.mIsRtl;
                }
                this.mFromBottomToTop = false;
                break;
            }
            case 3: {
                boolean bl = this.mIsRtl = layoutDirection == 1;
                if (this.mFlexWrap == 2) {
                    this.mIsRtl = !this.mIsRtl;
                }
                this.mFromBottomToTop = true;
                break;
            }
            default: {
                this.mIsRtl = false;
                this.mFromBottomToTop = false;
            }
        }
    }

    private void updateAnchorInfoForLayout(RecyclerView.State state, AnchorInfo anchorInfo) {
        if (this.updateAnchorFromPendingState(state, anchorInfo, this.mPendingSavedState)) {
            return;
        }
        if (this.updateAnchorFromChildren(state, anchorInfo)) {
            return;
        }
        anchorInfo.assignCoordinateFromPadding();
        anchorInfo.mPosition = 0;
        anchorInfo.mFlexLinePosition = 0;
    }

    private boolean updateAnchorFromPendingState(RecyclerView.State state, AnchorInfo anchorInfo, SavedState savedState) {
        assert (this.mFlexboxHelper.mIndexToFlexLine != null);
        if (state.isPreLayout() || this.mPendingScrollPosition == -1) {
            return false;
        }
        if (this.mPendingScrollPosition < 0 || this.mPendingScrollPosition >= state.getItemCount()) {
            this.mPendingScrollPosition = -1;
            this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
            return false;
        }
        anchorInfo.mPosition = this.mPendingScrollPosition;
        anchorInfo.mFlexLinePosition = this.mFlexboxHelper.mIndexToFlexLine[anchorInfo.mPosition];
        if (this.mPendingSavedState != null && this.mPendingSavedState.hasValidAnchor(state.getItemCount())) {
            anchorInfo.mCoordinate = this.mOrientationHelper.getStartAfterPadding() + savedState.mAnchorOffset;
            anchorInfo.mAssignedFromSavedState = true;
            anchorInfo.mFlexLinePosition = -1;
            return true;
        }
        if (this.mPendingScrollPositionOffset == Integer.MIN_VALUE) {
            View anchorView = this.findViewByPosition(this.mPendingScrollPosition);
            if (anchorView != null) {
                if (this.mOrientationHelper.getDecoratedMeasurement(anchorView) > this.mOrientationHelper.getTotalSpace()) {
                    anchorInfo.assignCoordinateFromPadding();
                    return true;
                }
                int startGap = this.mOrientationHelper.getDecoratedStart(anchorView) - this.mOrientationHelper.getStartAfterPadding();
                if (startGap < 0) {
                    anchorInfo.mCoordinate = this.mOrientationHelper.getStartAfterPadding();
                    anchorInfo.mLayoutFromEnd = false;
                    return true;
                }
                int endGap = this.mOrientationHelper.getEndAfterPadding() - this.mOrientationHelper.getDecoratedEnd(anchorView);
                if (endGap < 0) {
                    anchorInfo.mCoordinate = this.mOrientationHelper.getEndAfterPadding();
                    anchorInfo.mLayoutFromEnd = true;
                    return true;
                }
                anchorInfo.mCoordinate = anchorInfo.mLayoutFromEnd ? this.mOrientationHelper.getDecoratedEnd(anchorView) + this.mOrientationHelper.getTotalSpaceChange() : this.mOrientationHelper.getDecoratedStart(anchorView);
            } else {
                if (this.getChildCount() > 0) {
                    int position = this.getPosition(this.getChildAt(0));
                    anchorInfo.mLayoutFromEnd = this.mPendingScrollPosition < position;
                }
                anchorInfo.assignCoordinateFromPadding();
            }
            return true;
        }
        anchorInfo.mCoordinate = this.mOrientationHelper.getStartAfterPadding() + this.mPendingScrollPositionOffset;
        return true;
    }

    private boolean updateAnchorFromChildren(RecyclerView.State state, AnchorInfo anchorInfo) {
        View referenceChild;
        if (this.getChildCount() == 0) {
            return false;
        }
        View view = referenceChild = anchorInfo.mLayoutFromEnd ? this.findLastReferenceChild(state.getItemCount()) : this.findFirstReferenceChild(state.getItemCount());
        if (referenceChild != null) {
            anchorInfo.assignFromView(referenceChild);
            if (!state.isPreLayout() && this.supportsPredictiveItemAnimations()) {
                boolean notVisible;
                boolean bl = notVisible = this.mOrientationHelper.getDecoratedStart(referenceChild) >= this.mOrientationHelper.getEndAfterPadding() || this.mOrientationHelper.getDecoratedEnd(referenceChild) < this.mOrientationHelper.getStartAfterPadding();
                if (notVisible) {
                    anchorInfo.mCoordinate = anchorInfo.mLayoutFromEnd ? this.mOrientationHelper.getEndAfterPadding() : this.mOrientationHelper.getStartAfterPadding();
                }
            }
            return true;
        }
        return false;
    }

    private View findFirstReferenceChild(int itemCount) {
        assert (this.mFlexboxHelper.mIndexToFlexLine != null);
        View firstFound = this.findReferenceChild(0, this.getChildCount(), itemCount);
        if (firstFound == null) {
            return null;
        }
        int firstFoundPosition = this.getPosition(firstFound);
        int firstFoundLinePosition = this.mFlexboxHelper.mIndexToFlexLine[firstFoundPosition];
        FlexLine firstFoundLine = this.mFlexLines.get(firstFoundLinePosition);
        return this.findFirstReferenceViewInLine(firstFound, firstFoundLine);
    }

    private View findLastReferenceChild(int itemCount) {
        assert (this.mFlexboxHelper.mIndexToFlexLine != null);
        View lastFound = this.findReferenceChild(this.getChildCount() - 1, -1, itemCount);
        if (lastFound == null) {
            return null;
        }
        int lastFoundPosition = this.getPosition(lastFound);
        int lastFoundLinePosition = this.mFlexboxHelper.mIndexToFlexLine[lastFoundPosition];
        FlexLine lastFoundLine = this.mFlexLines.get(lastFoundLinePosition);
        return this.findLastReferenceViewInLine(lastFound, lastFoundLine);
    }

    private View findReferenceChild(int start, int end, int itemCount) {
        this.ensureOrientationHelper();
        this.ensureLayoutState();
        View invalidMatch = null;
        View outOfBoundsMatch = null;
        int boundStart = this.mOrientationHelper.getStartAfterPadding();
        int boundEnd = this.mOrientationHelper.getEndAfterPadding();
        int diff = end > start ? 1 : -1;
        for (int i = start; i != end; i += diff) {
            View view = this.getChildAt(i);
            int position = this.getPosition(view);
            if (position < 0 || position >= itemCount) continue;
            if (((RecyclerView.LayoutParams)view.getLayoutParams()).isItemRemoved()) {
                if (invalidMatch != null) continue;
                invalidMatch = view;
                continue;
            }
            if (this.mOrientationHelper.getDecoratedStart(view) < boundStart || this.mOrientationHelper.getDecoratedEnd(view) > boundEnd) {
                if (outOfBoundsMatch != null) continue;
                outOfBoundsMatch = view;
                continue;
            }
            return view;
        }
        return outOfBoundsMatch != null ? outOfBoundsMatch : invalidMatch;
    }

    private View getChildClosestToStart() {
        return this.getChildAt(0);
    }

    private View getChildClosestToEnd() {
        return this.getChildAt(this.getChildCount() - 1);
    }

    private int fill(RecyclerView.Recycler recycler, RecyclerView.State state, LayoutState layoutState) {
        FlexLine flexLine;
        if (layoutState.mScrollingOffset != Integer.MIN_VALUE) {
            if (layoutState.mAvailable < 0) {
                LayoutState layoutState2 = layoutState;
                layoutState2.mScrollingOffset = layoutState2.mScrollingOffset + layoutState.mAvailable;
            }
            this.recycleByLayoutState(recycler, layoutState);
        }
        int start = layoutState.mAvailable;
        int consumed = 0;
        for (int remainingSpace = layoutState.mAvailable; (remainingSpace > 0 || this.mLayoutState.mInfinite) && layoutState.hasMore(state, this.mFlexLines); remainingSpace -= flexLine.getCrossSize()) {
            flexLine = this.mFlexLines.get(layoutState.mFlexLinePosition);
            layoutState.mPosition = flexLine.mFirstIndex;
            consumed += this.layoutFlexLine(flexLine, layoutState);
            LayoutState layoutState3 = layoutState;
            layoutState3.mOffset = layoutState3.mOffset + flexLine.getCrossSize() * layoutState.mLayoutDirection;
        }
        LayoutState layoutState4 = layoutState;
        layoutState4.mAvailable = layoutState4.mAvailable - consumed;
        if (layoutState.mScrollingOffset != Integer.MIN_VALUE) {
            layoutState4 = layoutState;
            layoutState4.mScrollingOffset = layoutState4.mScrollingOffset + consumed;
            if (layoutState.mAvailable < 0) {
                layoutState4 = layoutState;
                layoutState4.mScrollingOffset = layoutState4.mScrollingOffset + layoutState.mAvailable;
            }
            this.recycleByLayoutState(recycler, layoutState);
        }
        return start - layoutState.mAvailable;
    }

    private void recycleByLayoutState(RecyclerView.Recycler recycler, LayoutState layoutState) {
        if (!layoutState.mShouldRecycle) {
            return;
        }
        if (layoutState.mLayoutDirection == -1) {
            this.recycleFlexLinesFromEnd(recycler, layoutState);
        } else {
            this.recycleFlexLinesFromStart(recycler, layoutState);
        }
    }

    private void recycleFlexLinesFromStart(RecyclerView.Recycler recycler, LayoutState layoutState) {
        View view;
        if (layoutState.mScrollingOffset < 0) {
            return;
        }
        assert (this.mFlexboxHelper.mIndexToFlexLine != null);
        int childCount = this.getChildCount();
        View firstView = this.getChildAt(0);
        int currentLineIndex = this.mFlexboxHelper.mIndexToFlexLine[this.getPosition(firstView)];
        FlexLine flexLine = this.mFlexLines.get(currentLineIndex);
        int recycleTo = -1;
        for (int i = 0; i < childCount && this.mOrientationHelper.getDecoratedEnd(view = this.getChildAt(i)) <= layoutState.mScrollingOffset; ++i) {
            if (flexLine.mLastIndex != this.getPosition(view)) continue;
            recycleTo = i;
            if (currentLineIndex >= this.mFlexLines.size() - 1) break;
            flexLine = this.mFlexLines.get(currentLineIndex += layoutState.mLayoutDirection);
        }
        this.recycleChildren(recycler, 0, recycleTo);
    }

    private void recycleFlexLinesFromEnd(RecyclerView.Recycler recycler, LayoutState layoutState) {
        View view;
        if (layoutState.mScrollingOffset < 0) {
            return;
        }
        assert (this.mFlexboxHelper.mIndexToFlexLine != null);
        int limit = this.mOrientationHelper.getEnd() - layoutState.mScrollingOffset;
        int childCount = this.getChildCount();
        View lastView = this.getChildAt(childCount - 1);
        int currentLineIndex = this.mFlexboxHelper.mIndexToFlexLine[this.getPosition(lastView)];
        int recycleTo = childCount - 1;
        int recycleFrom = childCount;
        FlexLine flexLine = this.mFlexLines.get(currentLineIndex);
        for (int i = childCount - 1; i >= 0 && this.mOrientationHelper.getDecoratedStart(view = this.getChildAt(i)) >= limit; --i) {
            if (flexLine.mFirstIndex != this.getPosition(view)) continue;
            recycleFrom = i;
            if (currentLineIndex <= 0) break;
            flexLine = this.mFlexLines.get(currentLineIndex += layoutState.mLayoutDirection);
        }
        this.recycleChildren(recycler, recycleFrom, recycleTo);
    }

    private void recycleChildren(RecyclerView.Recycler recycler, int startIndex, int endIndex) {
        for (int i = endIndex; i >= startIndex; --i) {
            this.removeAndRecycleViewAt(i, recycler);
        }
    }

    private int layoutFlexLine(FlexLine flexLine, LayoutState layoutState) {
        if (this.isMainAxisDirectionHorizontal()) {
            return this.layoutFlexLineMainAxisHorizontal(flexLine, layoutState);
        }
        return this.layoutFlexLineMainAxisVertical(flexLine, layoutState);
    }

    private int layoutFlexLineMainAxisHorizontal(FlexLine flexLine, LayoutState layoutState) {
        float childRight;
        float childLeft;
        assert (this.mFlexboxHelper.mMeasureSpecCache != null);
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int parentWidth = this.getWidth();
        int childTop = layoutState.mOffset;
        if (layoutState.mLayoutDirection == -1) {
            childTop -= flexLine.mCrossSize;
        }
        int startPosition = layoutState.mPosition;
        float spaceBetweenItem = 0.0f;
        switch (this.mJustifyContent) {
            case 0: {
                childLeft = paddingLeft;
                childRight = parentWidth - paddingRight;
                break;
            }
            case 1: {
                childLeft = parentWidth - flexLine.mMainSize + paddingRight;
                childRight = flexLine.mMainSize - paddingLeft;
                break;
            }
            case 2: {
                childLeft = (float)paddingLeft + (float)(parentWidth - flexLine.mMainSize) / 2.0f;
                childRight = (float)(parentWidth - paddingRight) - (float)(parentWidth - flexLine.mMainSize) / 2.0f;
                break;
            }
            case 4: {
                if (flexLine.mItemCount != 0) {
                    spaceBetweenItem = (float)(parentWidth - flexLine.mMainSize) / (float)flexLine.mItemCount;
                }
                childLeft = (float)paddingLeft + spaceBetweenItem / 2.0f;
                childRight = (float)(parentWidth - paddingRight) - spaceBetweenItem / 2.0f;
                break;
            }
            case 3: {
                childLeft = paddingLeft;
                float denominator = flexLine.mItemCount != 1 ? (float)(flexLine.mItemCount - 1) : 1.0f;
                spaceBetweenItem = (float)(parentWidth - flexLine.mMainSize) / denominator;
                childRight = parentWidth - paddingRight;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid justifyContent is set: " + this.mJustifyContent);
            }
        }
        spaceBetweenItem = Math.max(spaceBetweenItem, 0.0f);
        int indexInFlexLine = 0;
        int itemCount = flexLine.getItemCount();
        for (int i = startPosition; i < startPosition + itemCount; ++i) {
            View view = this.getFlexItemAt(i);
            if (view == null) continue;
            if (layoutState.mLayoutDirection == 1) {
                this.addView(view);
            } else {
                this.addView(view, indexInFlexLine);
                ++indexInFlexLine;
            }
            long measureSpec = this.mFlexboxHelper.mMeasureSpecCache[i];
            int widthSpec = this.mFlexboxHelper.extractLowerInt(measureSpec);
            int heightSpec = this.mFlexboxHelper.extractHigherInt(measureSpec);
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (this.shouldMeasureChild(view, widthSpec, heightSpec, lp)) {
                view.measure(widthSpec, heightSpec);
            }
            childLeft += (float)(lp.leftMargin + this.getLeftDecorationWidth(view));
            childRight -= (float)(lp.rightMargin + this.getRightDecorationWidth(view));
            int topWithDecoration = childTop + this.getTopDecorationHeight(view);
            if (this.mIsRtl) {
                this.mFlexboxHelper.layoutSingleChildHorizontal(view, flexLine, Math.round(childRight) - view.getMeasuredWidth(), topWithDecoration, Math.round(childRight), topWithDecoration + view.getMeasuredHeight());
            } else {
                this.mFlexboxHelper.layoutSingleChildHorizontal(view, flexLine, Math.round(childLeft), topWithDecoration, Math.round(childLeft) + view.getMeasuredWidth(), topWithDecoration + view.getMeasuredHeight());
            }
            childLeft += (float)(view.getMeasuredWidth() + lp.rightMargin + this.getRightDecorationWidth(view)) + spaceBetweenItem;
            childRight -= (float)(view.getMeasuredWidth() + lp.leftMargin + this.getLeftDecorationWidth(view)) + spaceBetweenItem;
            flexLine.updatePositionFromView(view, this.getDecoratedLeft(view), this.getDecoratedTop(view), this.getDecoratedRight(view), this.getDecoratedBottom(view));
        }
        LayoutState layoutState2 = layoutState;
        layoutState2.mFlexLinePosition = layoutState2.mFlexLinePosition + this.mLayoutState.mLayoutDirection;
        return flexLine.getCrossSize();
    }

    private int layoutFlexLineMainAxisVertical(FlexLine flexLine, LayoutState layoutState) {
        float childBottom;
        float childTop;
        assert (this.mFlexboxHelper.mMeasureSpecCache != null);
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int parentHeight = this.getHeight();
        int childLeft = layoutState.mOffset;
        if (layoutState.mLayoutDirection == -1) {
            childLeft -= flexLine.mCrossSize;
        }
        int startPosition = layoutState.mPosition;
        float spaceBetweenItem = 0.0f;
        switch (this.mJustifyContent) {
            case 0: {
                childTop = paddingTop;
                childBottom = parentHeight - paddingBottom;
                break;
            }
            case 1: {
                childTop = parentHeight - flexLine.mMainSize + paddingBottom;
                childBottom = flexLine.mMainSize - paddingTop;
                break;
            }
            case 2: {
                childTop = (float)paddingTop + (float)(parentHeight - flexLine.mMainSize) / 2.0f;
                childBottom = (float)(parentHeight - paddingBottom) - (float)(parentHeight - flexLine.mMainSize) / 2.0f;
                break;
            }
            case 4: {
                if (flexLine.mItemCount != 0) {
                    spaceBetweenItem = (float)(parentHeight - flexLine.mMainSize) / (float)flexLine.mItemCount;
                }
                childTop = (float)paddingTop + spaceBetweenItem / 2.0f;
                childBottom = (float)(parentHeight - paddingBottom) - spaceBetweenItem / 2.0f;
                break;
            }
            case 3: {
                childTop = paddingTop;
                float denominator = flexLine.mItemCount != 1 ? (float)(flexLine.mItemCount - 1) : 1.0f;
                spaceBetweenItem = (float)(parentHeight - flexLine.mMainSize) / denominator;
                childBottom = parentHeight - paddingBottom;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid justifyContent is set: " + this.mJustifyContent);
            }
        }
        spaceBetweenItem = Math.max(spaceBetweenItem, 0.0f);
        int indexInFlexLine = 0;
        int itemCount = flexLine.getItemCount();
        for (int i = startPosition; i < startPosition + itemCount; ++i) {
            LayoutParams lp;
            int heightSpec;
            View view = this.getFlexItemAt(i);
            if (view == null) continue;
            long measureSpec = this.mFlexboxHelper.mMeasureSpecCache[i];
            int widthSpec = this.mFlexboxHelper.extractLowerInt(measureSpec);
            if (this.shouldMeasureChild(view, widthSpec, heightSpec = this.mFlexboxHelper.extractHigherInt(measureSpec), lp = (LayoutParams)view.getLayoutParams())) {
                view.measure(widthSpec, heightSpec);
            }
            childTop += (float)(lp.topMargin + this.getTopDecorationHeight(view));
            childBottom -= (float)(lp.rightMargin + this.getBottomDecorationHeight(view));
            if (layoutState.mLayoutDirection == 1) {
                this.addView(view);
            } else {
                this.addView(view, indexInFlexLine);
                ++indexInFlexLine;
            }
            int leftWidthDecoration = childLeft + this.getLeftDecorationWidth(view);
            if (this.mFromBottomToTop) {
                this.mFlexboxHelper.layoutSingleChildVertical(view, flexLine, this.mIsRtl, leftWidthDecoration, Math.round(childBottom) - view.getMeasuredHeight(), leftWidthDecoration + view.getMeasuredWidth(), Math.round(childBottom));
            } else {
                this.mFlexboxHelper.layoutSingleChildVertical(view, flexLine, this.mIsRtl, leftWidthDecoration, Math.round(childTop), leftWidthDecoration + view.getMeasuredWidth(), Math.round(childTop) + view.getMeasuredHeight());
            }
            childTop += (float)(view.getMeasuredHeight() + lp.topMargin + this.getBottomDecorationHeight(view)) + spaceBetweenItem;
            childBottom -= (float)(view.getMeasuredHeight() + lp.bottomMargin + this.getTopDecorationHeight(view)) + spaceBetweenItem;
            flexLine.updatePositionFromView(view, this.getDecoratedLeft(view), this.getDecoratedTop(view), this.getDecoratedRight(view), this.getDecoratedBottom(view));
        }
        LayoutState layoutState2 = layoutState;
        layoutState2.mFlexLinePosition = layoutState2.mFlexLinePosition + this.mLayoutState.mLayoutDirection;
        return flexLine.getCrossSize();
    }

    @Override
    public boolean isMainAxisDirectionHorizontal() {
        return this.mFlexDirection == 0 || this.mFlexDirection == 1;
    }

    private void updateLayoutStateToFillEnd(AnchorInfo anchorInfo, boolean fromNextLine, boolean considerInfinite) {
        if (considerInfinite) {
            this.resolveInfiniteAmount();
        } else {
            this.mLayoutState.mInfinite = false;
        }
        this.mLayoutState.mAvailable = this.mOrientationHelper.getEndAfterPadding() - anchorInfo.mCoordinate;
        this.mLayoutState.mPosition = anchorInfo.mPosition;
        this.mLayoutState.mItemDirection = 1;
        this.mLayoutState.mLayoutDirection = 1;
        this.mLayoutState.mOffset = anchorInfo.mCoordinate;
        this.mLayoutState.mScrollingOffset = Integer.MIN_VALUE;
        this.mLayoutState.mFlexLinePosition = anchorInfo.mFlexLinePosition;
        if (fromNextLine && this.mFlexLines.size() > 1 && anchorInfo.mFlexLinePosition >= 0 && anchorInfo.mFlexLinePosition < this.mFlexLines.size() - 1) {
            FlexLine currentLine = this.mFlexLines.get(anchorInfo.mFlexLinePosition);
            this.mLayoutState.mFlexLinePosition++;
            LayoutState layoutState = this.mLayoutState;
            layoutState.mPosition = layoutState.mPosition + currentLine.getItemCount();
        }
    }

    private void updateLayoutStateToFillStart(AnchorInfo anchorInfo, boolean fromPreviousLine, boolean considerInfinite) {
        if (considerInfinite) {
            this.resolveInfiniteAmount();
        } else {
            this.mLayoutState.mInfinite = false;
        }
        this.mLayoutState.mAvailable = anchorInfo.mCoordinate - this.mOrientationHelper.getStartAfterPadding();
        this.mLayoutState.mPosition = anchorInfo.mPosition;
        this.mLayoutState.mItemDirection = 1;
        this.mLayoutState.mLayoutDirection = -1;
        this.mLayoutState.mOffset = anchorInfo.mCoordinate;
        this.mLayoutState.mScrollingOffset = Integer.MIN_VALUE;
        this.mLayoutState.mFlexLinePosition = anchorInfo.mFlexLinePosition;
        if (fromPreviousLine && anchorInfo.mFlexLinePosition > 0 && this.mFlexLines.size() > anchorInfo.mFlexLinePosition) {
            FlexLine currentLine = this.mFlexLines.get(anchorInfo.mFlexLinePosition);
            this.mLayoutState.mFlexLinePosition--;
            LayoutState layoutState = this.mLayoutState;
            layoutState.mPosition = layoutState.mPosition - currentLine.getItemCount();
        }
    }

    private void resolveInfiniteAmount() {
        int crossMode = this.isMainAxisDirectionHorizontal() ? this.getHeightMode() : this.getWidthMode();
        this.mLayoutState.mInfinite = crossMode == 0 || crossMode == Integer.MIN_VALUE;
    }

    private void ensureOrientationHelper() {
        if (this.mOrientationHelper != null) {
            return;
        }
        this.mOrientationHelper = this.isMainAxisDirectionHorizontal() ? (this.mFlexWrap == 0 ? OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)this) : OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)this)) : (this.mFlexWrap == 0 ? OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)this) : OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)this));
    }

    private void ensureLayoutState() {
        if (this.mLayoutState == null) {
            this.mLayoutState = new LayoutState();
        }
    }

    public void scrollToPosition(int position) {
        this.mPendingScrollPosition = position;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        if (this.mPendingSavedState != null) {
            this.mPendingSavedState.invalidateAnchor();
        }
        this.requestLayout();
    }

    public boolean getRecycleChildrenOnDetach() {
        return this.mRecycleChildrenOnDetach;
    }

    public void setRecycleChildrenOnDetach(boolean recycleChildrenOnDetach) {
        this.mRecycleChildrenOnDetach = recycleChildrenOnDetach;
    }

    public void onDetachedFromWindow(RecyclerView view, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        if (this.mRecycleChildrenOnDetach) {
            this.removeAndRecycleAllViews(recycler);
            recycler.clear();
        }
    }

    public boolean canScrollHorizontally() {
        return !this.isMainAxisDirectionHorizontal();
    }

    public boolean canScrollVertically() {
        return this.isMainAxisDirectionHorizontal();
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        int scrolled = this.handleScrolling(dx, recycler, state);
        this.mViewCache.clear();
        return scrolled;
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        int scrolled = this.handleScrolling(dy, recycler, state);
        this.mViewCache.clear();
        return scrolled;
    }

    private int handleScrolling(int delta, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getChildCount() == 0 || delta == 0) {
            return 0;
        }
        this.ensureOrientationHelper();
        this.mLayoutState.mShouldRecycle = true;
        int layoutDirection = delta > 0 ? 1 : -1;
        int absDelta = Math.abs(delta);
        this.updateLayoutState(layoutDirection, absDelta);
        int freeScroll = this.mLayoutState.mScrollingOffset;
        int consumed = freeScroll + this.fill(recycler, state, this.mLayoutState);
        if (consumed < 0) {
            return 0;
        }
        int scrolled = absDelta > consumed ? layoutDirection * consumed : delta;
        this.mOrientationHelper.offsetChildren(-scrolled);
        this.mLayoutState.mLastScrollDelta = scrolled;
        return scrolled;
    }

    private void updateLayoutState(int layoutDirection, int absDelta) {
        assert (this.mFlexboxHelper.mIndexToFlexLine != null);
        this.mLayoutState.mLayoutDirection = layoutDirection;
        boolean mainAxisHorizontal = this.isMainAxisDirectionHorizontal();
        if (layoutDirection == 1) {
            View lastVisible = this.getChildAt(this.getChildCount() - 1);
            this.mLayoutState.mOffset = this.mOrientationHelper.getDecoratedEnd(lastVisible);
            int lastVisiblePosition = this.getPosition(lastVisible);
            int lastVisibleLinePosition = this.mFlexboxHelper.mIndexToFlexLine[lastVisiblePosition];
            FlexLine lastVisibleLine = this.mFlexLines.get(lastVisibleLinePosition);
            View referenceView = this.findLastReferenceViewInLine(lastVisible, lastVisibleLine);
            this.mLayoutState.mOffset = this.mOrientationHelper.getDecoratedEnd(referenceView);
            this.mLayoutState.mItemDirection = 1;
            this.mLayoutState.mPosition = lastVisiblePosition + this.mLayoutState.mItemDirection;
            if (this.mFlexboxHelper.mIndexToFlexLine.length <= this.mLayoutState.mPosition) {
                this.mLayoutState.mFlexLinePosition = -1;
            } else {
                this.mLayoutState.mFlexLinePosition = this.mFlexboxHelper.mIndexToFlexLine[this.mLayoutState.mPosition];
            }
            this.mLayoutState.mScrollingOffset = this.mOrientationHelper.getDecoratedEnd(referenceView) - this.mOrientationHelper.getEndAfterPadding();
            if ((this.mLayoutState.mFlexLinePosition == -1 || this.mLayoutState.mFlexLinePosition > this.mFlexLines.size() - 1) && this.mLayoutState.mPosition <= this.getFlexItemCount()) {
                int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)this.getWidthMode());
                int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getHeight(), (int)this.getHeightMode());
                int needsToFill = absDelta - this.mLayoutState.mScrollingOffset;
                if (needsToFill > 0) {
                    if (mainAxisHorizontal) {
                        this.mFlexboxHelper.calculateHorizontalFlexLines(widthMeasureSpec, heightMeasureSpec, needsToFill, this.mLayoutState.mPosition, this.mFlexLines);
                    } else {
                        this.mFlexboxHelper.calculateVerticalFlexLines(widthMeasureSpec, heightMeasureSpec, needsToFill, this.mLayoutState.mPosition, this.mFlexLines);
                    }
                    this.mFlexboxHelper.determineMainSize(widthMeasureSpec, heightMeasureSpec, this.mLayoutState.mPosition);
                    this.mFlexboxHelper.stretchViews(this.mLayoutState.mPosition);
                }
            }
        } else {
            View firstVisible = this.getChildAt(0);
            this.mLayoutState.mOffset = this.mOrientationHelper.getDecoratedStart(firstVisible);
            int firstVisiblePosition = this.getPosition(firstVisible);
            int firstVisibleLinePosition = this.mFlexboxHelper.mIndexToFlexLine[firstVisiblePosition];
            FlexLine firstVisibleLine = this.mFlexLines.get(firstVisibleLinePosition);
            View referenceView = this.findFirstReferenceViewInLine(firstVisible, firstVisibleLine);
            this.mLayoutState.mOffset = this.mOrientationHelper.getDecoratedStart(referenceView);
            this.mLayoutState.mItemDirection = 1;
            int flexLinePosition = this.mFlexboxHelper.mIndexToFlexLine[firstVisiblePosition];
            if (flexLinePosition == -1) {
                flexLinePosition = 0;
            }
            if (flexLinePosition > 0) {
                FlexLine previousLine = this.mFlexLines.get(flexLinePosition - 1);
                this.mLayoutState.mPosition = firstVisiblePosition - previousLine.getItemCount();
            } else {
                this.mLayoutState.mPosition = -1;
            }
            this.mLayoutState.mFlexLinePosition = flexLinePosition > 0 ? flexLinePosition - 1 : 0;
            this.mLayoutState.mScrollingOffset = -this.mOrientationHelper.getDecoratedStart(referenceView) + this.mOrientationHelper.getStartAfterPadding();
        }
        this.mLayoutState.mAvailable = absDelta - this.mLayoutState.mScrollingOffset;
    }

    private View findFirstReferenceViewInLine(View firstView, FlexLine firstVisibleLine) {
        boolean mainAxisHorizontal = this.isMainAxisDirectionHorizontal();
        View referenceView = firstView;
        int to = firstVisibleLine.mItemCount;
        for (int i = 1; i < to; ++i) {
            View viewInSameLine = this.getChildAt(i);
            if (viewInSameLine == null || viewInSameLine.getVisibility() == 8) continue;
            if (this.mIsRtl && !mainAxisHorizontal) {
                if (this.mOrientationHelper.getDecoratedStart(referenceView) >= this.mOrientationHelper.getDecoratedStart(viewInSameLine)) continue;
                referenceView = viewInSameLine;
                continue;
            }
            if (this.mOrientationHelper.getDecoratedStart(referenceView) <= this.mOrientationHelper.getDecoratedStart(viewInSameLine)) continue;
            referenceView = viewInSameLine;
        }
        return referenceView;
    }

    private View findLastReferenceViewInLine(View lastView, FlexLine lastVisibleLine) {
        boolean mainAxisHorizontal = this.isMainAxisDirectionHorizontal();
        View referenceView = lastView;
        int to = this.getChildCount() - lastVisibleLine.mItemCount - 1;
        for (int i = this.getChildCount() - 2; i > to; --i) {
            View viewInSameLine = this.getChildAt(i);
            if (viewInSameLine == null || viewInSameLine.getVisibility() == 8) continue;
            if (this.mIsRtl && !mainAxisHorizontal) {
                if (this.mOrientationHelper.getDecoratedEnd(referenceView) <= this.mOrientationHelper.getDecoratedEnd(viewInSameLine)) continue;
                referenceView = viewInSameLine;
                continue;
            }
            if (this.mOrientationHelper.getDecoratedEnd(referenceView) >= this.mOrientationHelper.getDecoratedEnd(viewInSameLine)) continue;
            referenceView = viewInSameLine;
        }
        return referenceView;
    }

    private boolean shouldMeasureChild(View child, int widthSpec, int heightSpec, RecyclerView.LayoutParams lp) {
        return child.isLayoutRequested() || !this.isMeasurementCacheEnabled() || !FlexboxLayoutManager.isMeasurementUpToDate(child.getWidth(), widthSpec, lp.width) || !FlexboxLayoutManager.isMeasurementUpToDate(child.getHeight(), heightSpec, lp.height);
    }

    private static boolean isMeasurementUpToDate(int childSize, int spec, int dimension) {
        int specMode = View.MeasureSpec.getMode((int)spec);
        int specSize = View.MeasureSpec.getSize((int)spec);
        if (dimension > 0 && childSize != dimension) {
            return false;
        }
        switch (specMode) {
            case 0: {
                return true;
            }
            case -2147483648: {
                return specSize >= childSize;
            }
            case 0x40000000: {
                return specSize == childSize;
            }
        }
        return false;
    }

    private void clearFlexLines() {
        this.mFlexLines.clear();
        this.mAnchorInfo.reset();
    }

    private static class SavedState
    implements Parcelable {
        private int mAnchorPosition;
        private int mAnchorOffset;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mAnchorPosition);
            dest.writeInt(this.mAnchorOffset);
        }

        SavedState() {
        }

        private SavedState(Parcel in) {
            this.mAnchorPosition = in.readInt();
            this.mAnchorOffset = in.readInt();
        }

        private SavedState(SavedState savedState) {
            this.mAnchorPosition = savedState.mAnchorPosition;
            this.mAnchorOffset = savedState.mAnchorOffset;
        }

        private void invalidateAnchor() {
            this.mAnchorPosition = -1;
        }

        private boolean hasValidAnchor(int itemCount) {
            return this.mAnchorPosition >= 0 && this.mAnchorPosition < itemCount;
        }

        public String toString() {
            return "SavedState{mAnchorPosition=" + this.mAnchorPosition + ", mAnchorOffset=" + this.mAnchorOffset + '}';
        }
    }

    private static class LayoutState {
        private static final int SCROLLING_OFFSET_NaN = Integer.MIN_VALUE;
        private static final int LAYOUT_START = -1;
        private static final int LAYOUT_END = 1;
        private static final int ITEM_DIRECTION_TAIL = 1;
        private int mAvailable;
        private boolean mInfinite;
        private int mFlexLinePosition;
        private int mPosition;
        private int mOffset;
        private int mScrollingOffset;
        private int mLastScrollDelta;
        private int mItemDirection = 1;
        private int mLayoutDirection = 1;
        private boolean mShouldRecycle;

        private LayoutState() {
        }

        private boolean hasMore(RecyclerView.State state, List<FlexLine> flexLines) {
            return this.mPosition >= 0 && this.mPosition < state.getItemCount() && this.mFlexLinePosition >= 0 && this.mFlexLinePosition < flexLines.size();
        }

        public String toString() {
            return "LayoutState{mAvailable=" + this.mAvailable + ", mFlexLinePosition=" + this.mFlexLinePosition + ", mPosition=" + this.mPosition + ", mOffset=" + this.mOffset + ", mScrollingOffset=" + this.mScrollingOffset + ", mLastScrollDelta=" + this.mLastScrollDelta + ", mItemDirection=" + this.mItemDirection + ", mLayoutDirection=" + this.mLayoutDirection + '}';
        }
    }

    private class AnchorInfo {
        private int mPosition;
        private int mFlexLinePosition;
        private int mCoordinate;
        private boolean mLayoutFromEnd;
        private boolean mValid;
        private boolean mAssignedFromSavedState;

        private AnchorInfo() {
        }

        private void reset() {
            this.mPosition = -1;
            this.mFlexLinePosition = -1;
            this.mCoordinate = Integer.MIN_VALUE;
            this.mValid = false;
            this.mAssignedFromSavedState = false;
            this.mLayoutFromEnd = FlexboxLayoutManager.this.isMainAxisDirectionHorizontal() ? (FlexboxLayoutManager.this.mFlexWrap == 0 ? FlexboxLayoutManager.this.mFlexDirection == 1 : FlexboxLayoutManager.this.mFlexWrap == 2) : (FlexboxLayoutManager.this.mFlexWrap == 0 ? FlexboxLayoutManager.this.mFlexDirection == 3 : FlexboxLayoutManager.this.mFlexWrap == 2);
        }

        private void assignCoordinateFromPadding() {
            this.mCoordinate = this.mLayoutFromEnd ? FlexboxLayoutManager.this.mOrientationHelper.getEndAfterPadding() : FlexboxLayoutManager.this.mOrientationHelper.getStartAfterPadding();
        }

        private void assignFromView(View view) {
            this.mCoordinate = this.mLayoutFromEnd ? FlexboxLayoutManager.this.mOrientationHelper.getDecoratedEnd(view) + FlexboxLayoutManager.this.mOrientationHelper.getTotalSpaceChange() : FlexboxLayoutManager.this.mOrientationHelper.getDecoratedStart(view);
            this.mPosition = FlexboxLayoutManager.this.getPosition(view);
            this.mAssignedFromSavedState = false;
            assert (((FlexboxLayoutManager)FlexboxLayoutManager.this).mFlexboxHelper.mIndexToFlexLine != null);
            int flexLinePosition = ((FlexboxLayoutManager)FlexboxLayoutManager.this).mFlexboxHelper.mIndexToFlexLine[this.mPosition];
            int n = this.mFlexLinePosition = flexLinePosition != -1 ? flexLinePosition : 0;
            if (FlexboxLayoutManager.this.mFlexLines.size() > this.mFlexLinePosition) {
                this.mPosition = ((FlexLine)((FlexboxLayoutManager)FlexboxLayoutManager.this).mFlexLines.get((int)this.mFlexLinePosition)).mFirstIndex;
            }
        }

        public String toString() {
            return "AnchorInfo{mPosition=" + this.mPosition + ", mFlexLinePosition=" + this.mFlexLinePosition + ", mCoordinate=" + this.mCoordinate + ", mLayoutFromEnd=" + this.mLayoutFromEnd + ", mValid=" + this.mValid + ", mAssignedFromSavedState=" + this.mAssignedFromSavedState + '}';
        }
    }

    public static class LayoutParams
    extends RecyclerView.LayoutParams
    implements FlexItem {
        private float mFlexGrow = 0.0f;
        private float mFlexShrink = 1.0f;
        private int mAlignSelf = -1;
        private float mFlexBasisPercent = -1.0f;
        private int mMinWidth;
        private int mMinHeight;
        private int mMaxWidth = 0xFFFFFF;
        private int mMaxHeight = 0xFFFFFF;
        private boolean mWrapBefore;
        public static final Parcelable.Creator<LayoutParams> CREATOR = new Parcelable.Creator<LayoutParams>(){

            public LayoutParams createFromParcel(Parcel source) {
                return new LayoutParams(source);
            }

            public LayoutParams[] newArray(int size) {
                return new LayoutParams[size];
            }
        };

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public void setWidth(int width) {
            this.width = width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void setHeight(int height) {
            this.height = height;
        }

        @Override
        public float getFlexGrow() {
            return this.mFlexGrow;
        }

        @Override
        public void setFlexGrow(float flexGrow) {
            this.mFlexGrow = flexGrow;
        }

        @Override
        public float getFlexShrink() {
            return this.mFlexShrink;
        }

        @Override
        public void setFlexShrink(float flexShrink) {
            this.mFlexShrink = flexShrink;
        }

        @Override
        public int getAlignSelf() {
            return this.mAlignSelf;
        }

        @Override
        public void setAlignSelf(int alignSelf) {
            this.mAlignSelf = alignSelf;
        }

        @Override
        public int getMinWidth() {
            return this.mMinWidth;
        }

        @Override
        public void setMinWidth(int minWidth) {
            this.mMinWidth = minWidth;
        }

        @Override
        public int getMinHeight() {
            return this.mMinHeight;
        }

        @Override
        public void setMinHeight(int minHeight) {
            this.mMinHeight = minHeight;
        }

        @Override
        public int getMaxWidth() {
            return this.mMaxWidth;
        }

        @Override
        public void setMaxWidth(int maxWidth) {
            this.mMaxWidth = maxWidth;
        }

        @Override
        public int getMaxHeight() {
            return this.mMaxHeight;
        }

        @Override
        public void setMaxHeight(int maxHeight) {
            this.mMaxHeight = maxHeight;
        }

        @Override
        public boolean isWrapBefore() {
            return this.mWrapBefore;
        }

        @Override
        public void setWrapBefore(boolean wrapBefore) {
            this.mWrapBefore = wrapBefore;
        }

        @Override
        public float getFlexBasisPercent() {
            return this.mFlexBasisPercent;
        }

        @Override
        public void setFlexBasisPercent(float flexBasisPercent) {
            this.mFlexBasisPercent = flexBasisPercent;
        }

        @Override
        public int getMarginLeft() {
            return this.leftMargin;
        }

        @Override
        public int getMarginTop() {
            return this.topMargin;
        }

        @Override
        public int getMarginRight() {
            return this.rightMargin;
        }

        @Override
        public int getMarginBottom() {
            return this.bottomMargin;
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(RecyclerView.LayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super((RecyclerView.LayoutParams)source);
            this.mFlexGrow = source.mFlexGrow;
            this.mFlexShrink = source.mFlexShrink;
            this.mAlignSelf = source.mAlignSelf;
            this.mFlexBasisPercent = source.mFlexBasisPercent;
            this.mMinWidth = source.mMinWidth;
            this.mMinHeight = source.mMinHeight;
            this.mMaxWidth = source.mMaxWidth;
            this.mMaxHeight = source.mMaxHeight;
            this.mWrapBefore = source.mWrapBefore;
        }

        @Override
        public int getOrder() {
            return 1;
        }

        @Override
        public void setOrder(int order) {
            throw new UnsupportedOperationException("Setting the order in the FlexboxLayoutManager is not supported. Use FlexboxLayout if you need to reorder using the attribute.");
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeFloat(this.mFlexGrow);
            dest.writeFloat(this.mFlexShrink);
            dest.writeInt(this.mAlignSelf);
            dest.writeFloat(this.mFlexBasisPercent);
            dest.writeInt(this.mMinWidth);
            dest.writeInt(this.mMinHeight);
            dest.writeInt(this.mMaxWidth);
            dest.writeInt(this.mMaxHeight);
            dest.writeByte(this.mWrapBefore ? (byte)1 : 0);
            dest.writeInt(this.bottomMargin);
            dest.writeInt(this.leftMargin);
            dest.writeInt(this.rightMargin);
            dest.writeInt(this.topMargin);
            dest.writeInt(this.height);
            dest.writeInt(this.width);
        }

        protected LayoutParams(Parcel in) {
            super(-2, -2);
            this.mFlexGrow = in.readFloat();
            this.mFlexShrink = in.readFloat();
            this.mAlignSelf = in.readInt();
            this.mFlexBasisPercent = in.readFloat();
            this.mMinWidth = in.readInt();
            this.mMinHeight = in.readInt();
            this.mMaxWidth = in.readInt();
            this.mMaxHeight = in.readInt();
            this.mWrapBefore = in.readByte() != 0;
            this.bottomMargin = in.readInt();
            this.leftMargin = in.readInt();
            this.rightMargin = in.readInt();
            this.topMargin = in.readInt();
            this.height = in.readInt();
            this.width = in.readInt();
        }
    }
}

