/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.utils;

import com.google.android.filament.utils.Float3;
import com.google.android.filament.utils.Quaternion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\u0011\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\b\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0086\b\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0011\u0010\f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\b\u001a\u0011\u0010\r\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\b\u001a\u001e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\b\u001a\u001e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\b\u001a\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a(\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\b\u001a\u0015\u0010\u0014\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\n\u001a\u0015\u0010\u0015\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\n\u001a\u0015\u0010\u0016\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\n\u001a\u0015\u0010\u0017\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0001H\u0086\n\u00a8\u0006\u0018"}, d2={"abs", "Lcom/google/android/filament/utils/Quaternion;", "q", "conjugate", "cross", "a", "b", "dot", "", "eulerAngles", "Lcom/google/android/filament/utils/Float3;", "inverse", "length", "length2", "lerp", "t", "nlerp", "normalize", "slerp", "valueEps", "div", "minus", "plus", "times", "filament-utils-android_release"})
public final class QuaternionKt {
    @NotNull
    public static final Quaternion plus(float $this$plus, @NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$plus = false;
        return new Quaternion($this$plus + q.getX(), $this$plus + q.getY(), $this$plus + q.getZ(), $this$plus + q.getW());
    }

    @NotNull
    public static final Quaternion minus(float $this$minus, @NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$minus = false;
        return new Quaternion($this$minus - q.getX(), $this$minus - q.getY(), $this$minus - q.getZ(), $this$minus - q.getW());
    }

    @NotNull
    public static final Quaternion times(float $this$times, @NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$times = false;
        return new Quaternion($this$times * q.getX(), $this$times * q.getY(), $this$times * q.getZ(), $this$times * q.getW());
    }

    @NotNull
    public static final Quaternion div(float $this$div, @NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$div = false;
        return new Quaternion($this$div / q.getX(), $this$div / q.getY(), $this$div / q.getZ(), $this$div / q.getW());
    }

    @NotNull
    public static final Quaternion abs(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$abs = false;
        return new Quaternion(Math.abs(q.getX()), Math.abs(q.getY()), Math.abs(q.getZ()), Math.abs(q.getW()));
    }

    public static final float length(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$length = false;
        return (float)Math.sqrt(q.getX() * q.getX() + q.getY() * q.getY() + q.getZ() * q.getZ() + q.getW() * q.getW());
    }

    public static final float length2(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$length2 = false;
        return q.getX() * q.getX() + q.getY() * q.getY() + q.getZ() * q.getZ() + q.getW() * q.getW();
    }

    public static final float dot(@NotNull Quaternion a, @NotNull Quaternion b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        boolean $i$f$dot = false;
        return a.getX() * b.getX() + a.getY() * b.getY() + a.getZ() * b.getZ() + a.getW() * b.getW();
    }

    @NotNull
    public static final Quaternion normalize(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$length = false;
        float l = 1.0f / (float)Math.sqrt(q.getX() * q.getX() + q.getY() * q.getY() + q.getZ() * q.getZ() + q.getW() * q.getW());
        return new Quaternion(q.getX() * l, q.getY() * l, q.getZ() * l, q.getW() * l);
    }

    @NotNull
    public static final Quaternion conjugate(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return new Quaternion(-q.getX(), -q.getY(), -q.getZ(), q.getW());
    }

    @NotNull
    public static final Quaternion inverse(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        boolean $i$f$dot = false;
        float d = 1.0f / (q.getX() * q.getX() + q.getY() * q.getY() + q.getZ() * q.getZ() + q.getW() * q.getW());
        return new Quaternion(-q.getX() * d, -q.getY() * d, -q.getZ() * d, q.getW() * d);
    }

    @NotNull
    public static final Quaternion cross(@NotNull Quaternion a, @NotNull Quaternion b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Quaternion this_$iv = a;
        boolean $i$f$times = false;
        Quaternion m = new Quaternion(this_$iv.getW() * b.getX() + this_$iv.getX() * b.getW() + this_$iv.getY() * b.getZ() - this_$iv.getZ() * b.getY(), this_$iv.getW() * b.getY() - this_$iv.getX() * b.getZ() + this_$iv.getY() * b.getW() + this_$iv.getZ() * b.getX(), this_$iv.getW() * b.getZ() + this_$iv.getX() * b.getY() - this_$iv.getY() * b.getX() + this_$iv.getZ() * b.getW(), this_$iv.getW() * b.getW() - this_$iv.getX() * b.getX() - this_$iv.getY() * b.getY() - this_$iv.getZ() * b.getZ());
        return new Quaternion(m.getX(), m.getY(), m.getZ(), 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Quaternion slerp(@NotNull Quaternion a, @NotNull Quaternion b, float t, float valueEps) {
        void q$iv;
        void this_$iv;
        float min$iv;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        boolean $i$f$dot = false;
        float d = a.getX() * b.getX() + a.getY() * b.getY() + a.getZ() * b.getZ() + a.getW() * b.getW();
        float absd = Math.abs(d);
        if (1.0f - absd < valueEps) {
            return QuaternionKt.normalize(QuaternionKt.lerp(d < 0.0f ? a.unaryMinus() : a, b, t));
        }
        boolean $i$f$dot2 = false;
        $i$f$dot2 = false;
        float npq = (float)Math.sqrt((a.getX() * a.getX() + a.getY() * a.getY() + a.getZ() * a.getZ() + a.getW() * a.getW()) * (b.getX() * b.getX() + b.getY() * b.getY() + b.getZ() * b.getZ() + b.getW() * b.getW()));
        float f = absd / npq;
        float f2 = -1.0f;
        float max$iv = 1.0f;
        boolean $i$f$clamp = false;
        float acos = (float)Math.acos(x$iv < min$iv ? min$iv : (x$iv > max$iv ? max$iv : x$iv));
        float acos0 = acos * (1.0f - t);
        float acos1 = acos * t;
        float sina = (float)Math.sin(acos);
        if (sina < valueEps) {
            return QuaternionKt.normalize(QuaternionKt.lerp(a, b, t));
        }
        float isina = 1.0f / sina;
        float s0 = (float)Math.sin(acos0) * isina;
        float s1 = (float)Math.sin(acos1) * isina;
        float $this$times$iv22 = s0;
        boolean $i$f$times = false;
        Quaternion $this$times$iv22 = new Quaternion($this$times$iv22 * a.getX(), $this$times$iv22 * a.getY(), $this$times$iv22 * a.getZ(), $this$times$iv22 * a.getW());
        float $this$times$iv32 = d < 0.0f ? -s1 : s1;
        boolean $i$f$times2 = false;
        Quaternion $this$times$iv32 = new Quaternion($this$times$iv32 * b.getX(), $this$times$iv32 * b.getY(), $this$times$iv32 * b.getZ(), $this$times$iv32 * b.getW());
        boolean $i$f$plus = false;
        return QuaternionKt.normalize(new Quaternion(this_$iv.getX() + q$iv.getX(), this_$iv.getY() + q$iv.getY(), this_$iv.getZ() + q$iv.getZ(), this_$iv.getW() + q$iv.getW()));
    }

    public static /* synthetic */ Quaternion slerp$default(Quaternion quaternion, Quaternion quaternion2, float f, float f2, int n, Object object) {
        if ((n & 8) != 0) {
            f2 = 1.0E-10f;
        }
        return QuaternionKt.slerp(quaternion, quaternion2, f, f2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Quaternion lerp(@NotNull Quaternion a, @NotNull Quaternion b, float t) {
        void q$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        float $this$times$iv22 = 1.0f - t;
        boolean $i$f$times = false;
        Quaternion $this$times$iv22 = new Quaternion($this$times$iv22 * a.getX(), $this$times$iv22 * a.getY(), $this$times$iv22 * a.getZ(), $this$times$iv22 * a.getW());
        float $this$times$iv32 = t;
        boolean $i$f$times2 = false;
        Quaternion $this$times$iv32 = new Quaternion($this$times$iv32 * b.getX(), $this$times$iv32 * b.getY(), $this$times$iv32 * b.getZ(), $this$times$iv32 * b.getW());
        boolean $i$f$plus = false;
        return new Quaternion(this_$iv.getX() + q$iv.getX(), this_$iv.getY() + q$iv.getY(), this_$iv.getZ() + q$iv.getZ(), this_$iv.getW() + q$iv.getW());
    }

    @NotNull
    public static final Quaternion nlerp(@NotNull Quaternion a, @NotNull Quaternion b, float t) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return QuaternionKt.normalize(QuaternionKt.lerp(a, b, t));
    }

    @NotNull
    public static final Float3 eulerAngles(@NotNull Quaternion q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        Quaternion nq = QuaternionKt.normalize(q);
        float v$iv = (float)Math.atan2(2.0f * (nq.getY() * nq.getZ() + nq.getW() * nq.getX()), nq.getW() * nq.getW() - nq.getX() * nq.getX() - nq.getY() * nq.getY() + nq.getZ() * nq.getZ());
        boolean $i$f$degrees = false;
        float f = v$iv * 57.295776f;
        v$iv = (float)Math.asin(-2.0f * (nq.getX() * nq.getZ() - nq.getW() * nq.getY()));
        $i$f$degrees = false;
        float f2 = v$iv * 57.295776f;
        v$iv = (float)Math.atan2(2.0f * (nq.getX() * nq.getY() + nq.getW() * nq.getZ()), nq.getW() * nq.getW() + nq.getX() * nq.getX() - nq.getY() * nq.getY() - nq.getZ() * nq.getZ());
        $i$f$degrees = false;
        return new Float3(f, f2, v$iv * 57.295776f);
    }
}

