/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.utils;

import com.google.android.filament.Engine;
import com.google.android.filament.IndirectLight;
import com.google.android.filament.Skybox;
import com.google.android.filament.Texture;
import java.nio.Buffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\bJ)\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0082 J)\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0082 J)\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0082 J!\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0010H\u0082 \u00a8\u0006\u001d"}, d2={"Lcom/google/android/filament/utils/KTXLoader;", "", "()V", "createIndirectLight", "Lcom/google/android/filament/IndirectLight;", "engine", "Lcom/google/android/filament/Engine;", "buffer", "Ljava/nio/Buffer;", "options", "Lcom/google/android/filament/utils/KTXLoader$Options;", "createSkybox", "Lcom/google/android/filament/Skybox;", "createTexture", "Lcom/google/android/filament/Texture;", "getSphericalHarmonics", "", "nCreateIndirectLight", "", "nativeEngine", "remaining", "", "srgb", "", "nCreateKTXTexture", "nCreateSkybox", "nGetSphericalHarmonics", "outSphericalHarmonics", "Options", "filament-utils-android_release"})
public final class KTXLoader {
    @NotNull
    public static final KTXLoader INSTANCE = new KTXLoader();

    private KTXLoader() {
    }

    @NotNull
    public final Texture createTexture(@NotNull Engine engine, @NotNull Buffer buffer, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        long nativeEngine = engine.getNativeObject();
        long nativeTexture = this.nCreateKTXTexture(nativeEngine, buffer, buffer.remaining(), options.getSrgb());
        return new Texture(nativeTexture);
    }

    public static /* synthetic */ Texture createTexture$default(KTXLoader kTXLoader, Engine engine, Buffer buffer, Options options, int n, Object object) {
        if ((n & 4) != 0) {
            options = new Options();
        }
        return kTXLoader.createTexture(engine, buffer, options);
    }

    @NotNull
    public final IndirectLight createIndirectLight(@NotNull Engine engine, @NotNull Buffer buffer, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        long nativeEngine = engine.getNativeObject();
        long nativeIndirectLight = this.nCreateIndirectLight(nativeEngine, buffer, buffer.remaining(), options.getSrgb());
        return new IndirectLight(nativeIndirectLight);
    }

    public static /* synthetic */ IndirectLight createIndirectLight$default(KTXLoader kTXLoader, Engine engine, Buffer buffer, Options options, int n, Object object) {
        if ((n & 4) != 0) {
            options = new Options();
        }
        return kTXLoader.createIndirectLight(engine, buffer, options);
    }

    @NotNull
    public final Skybox createSkybox(@NotNull Engine engine, @NotNull Buffer buffer, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        long nativeEngine = engine.getNativeObject();
        long nativeSkybox = this.nCreateSkybox(nativeEngine, buffer, buffer.remaining(), options.getSrgb());
        return new Skybox(nativeSkybox);
    }

    public static /* synthetic */ Skybox createSkybox$default(KTXLoader kTXLoader, Engine engine, Buffer buffer, Options options, int n, Object object) {
        if ((n & 4) != 0) {
            options = new Options();
        }
        return kTXLoader.createSkybox(engine, buffer, options);
    }

    @Nullable
    public final float[] getSphericalHarmonics(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        float[] sphericalHarmonics = new float[27];
        boolean success = this.nGetSphericalHarmonics(buffer, buffer.remaining(), sphericalHarmonics);
        return (float[])(success ? sphericalHarmonics : null);
    }

    private final native long nCreateKTXTexture(long var1, Buffer var3, int var4, boolean var5);

    private final native long nCreateIndirectLight(long var1, Buffer var3, int var4, boolean var5);

    private final native boolean nGetSphericalHarmonics(Buffer var1, int var2, float[] var3);

    private final native long nCreateSkybox(long var1, Buffer var3, int var4, boolean var5);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/google/android/filament/utils/KTXLoader$Options;", "", "()V", "srgb", "", "getSrgb", "()Z", "setSrgb", "(Z)V", "filament-utils-android_release"})
    public static final class Options {
        private boolean srgb;

        public final boolean getSrgb() {
            return this.srgb;
        }

        public final void setSrgb(boolean bl) {
            this.srgb = bl;
        }
    }
}

