/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament.utils;

import com.google.android.filament.Engine;
import com.google.android.filament.Texture;

public class IBLPrefilterContext {
    private long mNativeObject;

    public IBLPrefilterContext(Engine engine) {
        this.mNativeObject = IBLPrefilterContext.nCreate(engine.getNativeObject());
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Couldn't create IBLPrefilterContext");
        }
    }

    public void destroy() {
        IBLPrefilterContext.nDestroy(this.getNativeObject());
        this.mNativeObject = 0L;
    }

    protected long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed IBLPrefilterContext");
        }
        return this.mNativeObject;
    }

    private static native long nCreate(long var0);

    private static native void nDestroy(long var0);

    private static native long nCreateEquirectHelper(long var0);

    private static native long nEquirectHelperRun(long var0, long var2);

    private static native void nDestroyEquirectHelper(long var0);

    private static native long nCreateSpecularFilter(long var0);

    private static native long nSpecularFilterRun(long var0, long var2);

    private static native void nDestroySpecularFilter(long var0);

    public static class SpecularFilter {
        private long mNativeObject;

        public SpecularFilter(IBLPrefilterContext context) {
            this.mNativeObject = IBLPrefilterContext.nCreateSpecularFilter(context.getNativeObject());
        }

        public Texture run(Texture skybox) {
            long nativeTexture = IBLPrefilterContext.nSpecularFilterRun(this.getNativeObject(), skybox.getNativeObject());
            return new Texture(nativeTexture);
        }

        public void destroy() {
            IBLPrefilterContext.nDestroySpecularFilter(this.getNativeObject());
            this.mNativeObject = 0L;
        }

        protected long getNativeObject() {
            if (this.mNativeObject == 0L) {
                throw new IllegalStateException("Calling method on destroyed SpecularFilter");
            }
            return this.mNativeObject;
        }
    }

    public static class EquirectangularToCubemap {
        private long mNativeObject;

        public EquirectangularToCubemap(IBLPrefilterContext context) {
            this.mNativeObject = IBLPrefilterContext.nCreateEquirectHelper(context.getNativeObject());
        }

        public Texture run(Texture equirect) {
            long nativeTexture = IBLPrefilterContext.nEquirectHelperRun(this.getNativeObject(), equirect.getNativeObject());
            return new Texture(nativeTexture);
        }

        public void destroy() {
            IBLPrefilterContext.nDestroyEquirectHelper(this.getNativeObject());
            this.mNativeObject = 0L;
        }

        protected long getNativeObject() {
            if (this.mNativeObject == 0L) {
                throw new IllegalStateException("Calling method on destroyed EquirectangularToCubemap");
            }
            return this.mNativeObject;
        }
    }
}

