/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.google.android.filament.Asserts;
import com.google.android.filament.Camera;
import com.google.android.filament.ColorGrading;
import com.google.android.filament.Entity;
import com.google.android.filament.RenderTarget;
import com.google.android.filament.Scene;
import com.google.android.filament.Texture;
import com.google.android.filament.Viewport;
import java.util.EnumSet;

public class View {
    private static final AntiAliasing[] sAntiAliasingValues = AntiAliasing.values();
    private static final Dithering[] sDitheringValues = Dithering.values();
    private static final AmbientOcclusion[] sAmbientOcclusionValues = AmbientOcclusion.values();
    private long mNativeObject;
    private String mName;
    private Scene mScene;
    private Camera mCamera;
    private Viewport mViewport = new Viewport(0, 0, 0, 0);
    private DynamicResolutionOptions mDynamicResolution;
    private RenderQuality mRenderQuality;
    private AmbientOcclusionOptions mAmbientOcclusionOptions;
    private BloomOptions mBloomOptions;
    private FogOptions mFogOptions;
    private RenderTarget mRenderTarget;
    private BlendMode mBlendMode;
    private DepthOfFieldOptions mDepthOfFieldOptions;
    private VignetteOptions mVignetteOptions;
    private ColorGrading mColorGrading;
    private TemporalAntiAliasingOptions mTemporalAntiAliasingOptions;
    private ScreenSpaceReflectionsOptions mScreenSpaceReflectionsOptions;
    private MultiSampleAntiAliasingOptions mMultiSampleAntiAliasingOptions;
    private VsmShadowOptions mVsmShadowOptions;
    private SoftShadowOptions mSoftShadowOptions;

    View(long nativeView) {
        this.mNativeObject = nativeView;
    }

    public void setName(@NonNull String name) {
        this.mName = name;
        View.nSetName(this.getNativeObject(), name);
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    public void setScene(@Nullable Scene scene) {
        this.mScene = scene;
        View.nSetScene(this.getNativeObject(), scene == null ? 0L : scene.getNativeObject());
    }

    @Nullable
    public Scene getScene() {
        return this.mScene;
    }

    public void setCamera(@Nullable Camera camera) {
        this.mCamera = camera;
        View.nSetCamera(this.getNativeObject(), camera == null ? 0L : camera.getNativeObject());
    }

    @Nullable
    public Camera getCamera() {
        return this.mCamera;
    }

    public void setViewport(@NonNull Viewport viewport) {
        this.mViewport = viewport;
        View.nSetViewport(this.getNativeObject(), this.mViewport.left, this.mViewport.bottom, this.mViewport.width, this.mViewport.height);
    }

    @NonNull
    public Viewport getViewport() {
        return this.mViewport;
    }

    public void setBlendMode(BlendMode blendMode) {
        this.mBlendMode = blendMode;
        View.nSetBlendMode(this.getNativeObject(), blendMode.ordinal());
    }

    public BlendMode getBlendMode() {
        return this.mBlendMode;
    }

    public void setVisibleLayers(@IntRange(from=0L, to=255L) int select, @IntRange(from=0L, to=255L) int values) {
        View.nSetVisibleLayers(this.getNativeObject(), select & 0xFF, values & 0xFF);
    }

    public void setShadowingEnabled(boolean enabled) {
        View.nSetShadowingEnabled(this.getNativeObject(), enabled);
    }

    boolean isShadowingEnabled() {
        return View.nIsShadowingEnabled(this.getNativeObject());
    }

    public void setScreenSpaceRefractionEnabled(boolean enabled) {
        View.nSetScreenSpaceRefractionEnabled(this.getNativeObject(), enabled);
    }

    boolean isScreenSpaceRefractionEnabled() {
        return View.nIsScreenSpaceRefractionEnabled(this.getNativeObject());
    }

    public void setRenderTarget(@Nullable RenderTarget target) {
        this.mRenderTarget = target;
        View.nSetRenderTarget(this.getNativeObject(), target != null ? target.getNativeObject() : 0L);
    }

    @Nullable
    public RenderTarget getRenderTarget() {
        return this.mRenderTarget;
    }

    @Deprecated
    public void setSampleCount(int count) {
        View.nSetSampleCount(this.getNativeObject(), count);
    }

    @Deprecated
    public int getSampleCount() {
        return View.nGetSampleCount(this.getNativeObject());
    }

    public void setAntiAliasing(@NonNull AntiAliasing type) {
        View.nSetAntiAliasing(this.getNativeObject(), type.ordinal());
    }

    @NonNull
    public AntiAliasing getAntiAliasing() {
        return sAntiAliasingValues[View.nGetAntiAliasing(this.getNativeObject())];
    }

    public void setMultiSampleAntiAliasingOptions(@NonNull MultiSampleAntiAliasingOptions options) {
        this.mMultiSampleAntiAliasingOptions = options;
        View.nSetMultiSampleAntiAliasingOptions(this.getNativeObject(), options.enabled, options.sampleCount, options.customResolve);
    }

    @NonNull
    public MultiSampleAntiAliasingOptions getMultiSampleAntiAliasingOptions() {
        if (this.mMultiSampleAntiAliasingOptions == null) {
            this.mMultiSampleAntiAliasingOptions = new MultiSampleAntiAliasingOptions();
        }
        return this.mMultiSampleAntiAliasingOptions;
    }

    public void setTemporalAntiAliasingOptions(@NonNull TemporalAntiAliasingOptions options) {
        this.mTemporalAntiAliasingOptions = options;
        View.nSetTemporalAntiAliasingOptions(this.getNativeObject(), options.feedback, options.filterWidth, options.enabled);
    }

    public void setScreenSpaceReflectionsOptions(@NonNull ScreenSpaceReflectionsOptions options) {
        this.mScreenSpaceReflectionsOptions = options;
        View.nSetScreenSpaceReflectionsOptions(this.getNativeObject(), options.thickness, options.bias, options.maxDistance, options.stride, options.enabled);
    }

    @NonNull
    public TemporalAntiAliasingOptions getTemporalAntiAliasingOptions() {
        if (this.mTemporalAntiAliasingOptions == null) {
            this.mTemporalAntiAliasingOptions = new TemporalAntiAliasingOptions();
        }
        return this.mTemporalAntiAliasingOptions;
    }

    @NonNull
    public ScreenSpaceReflectionsOptions getScreenSpaceReflectionsOptions() {
        if (this.mScreenSpaceReflectionsOptions == null) {
            this.mScreenSpaceReflectionsOptions = new ScreenSpaceReflectionsOptions();
        }
        return this.mScreenSpaceReflectionsOptions;
    }

    @Deprecated
    public void setToneMapping(@NonNull ToneMapping type) {
    }

    @Deprecated
    @NonNull
    public ToneMapping getToneMapping() {
        return ToneMapping.ACES;
    }

    public void setColorGrading(@Nullable ColorGrading colorGrading) {
        View.nSetColorGrading(this.getNativeObject(), colorGrading != null ? colorGrading.getNativeObject() : 0L);
        this.mColorGrading = colorGrading;
    }

    public ColorGrading getColorGrading() {
        return this.mColorGrading;
    }

    public void setDithering(@NonNull Dithering dithering) {
        View.nSetDithering(this.getNativeObject(), dithering.ordinal());
    }

    @NonNull
    public Dithering getDithering() {
        return sDitheringValues[View.nGetDithering(this.getNativeObject())];
    }

    public void setDynamicResolutionOptions(@NonNull DynamicResolutionOptions options) {
        this.mDynamicResolution = options;
        View.nSetDynamicResolutionOptions(this.getNativeObject(), options.enabled, options.homogeneousScaling, options.minScale, options.maxScale, options.sharpness, options.quality.ordinal());
    }

    @NonNull
    public DynamicResolutionOptions getDynamicResolutionOptions() {
        if (this.mDynamicResolution == null) {
            this.mDynamicResolution = new DynamicResolutionOptions();
        }
        return this.mDynamicResolution;
    }

    public void setRenderQuality(@NonNull RenderQuality renderQuality) {
        this.mRenderQuality = renderQuality;
        View.nSetRenderQuality(this.getNativeObject(), renderQuality.hdrColorBuffer.ordinal());
    }

    @NonNull
    public RenderQuality getRenderQuality() {
        if (this.mRenderQuality == null) {
            this.mRenderQuality = new RenderQuality();
        }
        return this.mRenderQuality;
    }

    public boolean isPostProcessingEnabled() {
        return View.nIsPostProcessingEnabled(this.getNativeObject());
    }

    public void setPostProcessingEnabled(boolean enabled) {
        View.nSetPostProcessingEnabled(this.getNativeObject(), enabled);
    }

    public boolean isFrontFaceWindingInverted() {
        return View.nIsFrontFaceWindingInverted(this.getNativeObject());
    }

    public void setFrontFaceWindingInverted(boolean inverted) {
        View.nSetFrontFaceWindingInverted(this.getNativeObject(), inverted);
    }

    public void setDynamicLightingOptions(float zLightNear, float zLightFar) {
        View.nSetDynamicLightingOptions(this.getNativeObject(), zLightNear, zLightFar);
    }

    public void setShadowType(ShadowType type) {
        View.nSetShadowType(this.getNativeObject(), type.ordinal());
    }

    public void setVsmShadowOptions(@NonNull VsmShadowOptions options) {
        this.mVsmShadowOptions = options;
        View.nSetVsmShadowOptions(this.getNativeObject(), options.anisotropy, options.mipmapping, options.minVarianceScale, options.lightBleedReduction);
    }

    @NonNull
    public VsmShadowOptions getVsmShadowOptions() {
        if (this.mVsmShadowOptions == null) {
            this.mVsmShadowOptions = new VsmShadowOptions();
        }
        return this.mVsmShadowOptions;
    }

    public void setSoftShadowOptions(@NonNull SoftShadowOptions options) {
        this.mSoftShadowOptions = options;
        View.nSetSoftShadowOptions(this.getNativeObject(), options.penumbraScale, options.penumbraRatioScale);
    }

    @NonNull
    public SoftShadowOptions getSoftShadowOptions() {
        if (this.mSoftShadowOptions == null) {
            this.mSoftShadowOptions = new SoftShadowOptions();
        }
        return this.mSoftShadowOptions;
    }

    @Deprecated
    public void setAmbientOcclusion(@NonNull AmbientOcclusion ao) {
        View.nSetAmbientOcclusion(this.getNativeObject(), ao.ordinal());
    }

    @Deprecated
    @NonNull
    public AmbientOcclusion getAmbientOcclusion() {
        return sAmbientOcclusionValues[View.nGetAmbientOcclusion(this.getNativeObject())];
    }

    public void setAmbientOcclusionOptions(@NonNull AmbientOcclusionOptions options) {
        this.mAmbientOcclusionOptions = options;
        View.nSetAmbientOcclusionOptions(this.getNativeObject(), options.radius, options.bias, options.power, options.resolution, options.intensity, options.bilateralThreshold, options.quality.ordinal(), options.lowPassFilter.ordinal(), options.upsampling.ordinal(), options.enabled, options.bentNormals, options.minHorizonAngleRad);
        View.nSetSSCTOptions(this.getNativeObject(), options.ssctLightConeRad, options.ssctStartTraceDistance, options.ssctContactDistanceMax, options.ssctIntensity, options.ssctLightDirection[0], options.ssctLightDirection[1], options.ssctLightDirection[2], options.ssctDepthBias, options.ssctDepthSlopeBias, options.ssctSampleCount, options.ssctRayCount, options.ssctEnabled);
    }

    @NonNull
    public AmbientOcclusionOptions getAmbientOcclusionOptions() {
        if (this.mAmbientOcclusionOptions == null) {
            this.mAmbientOcclusionOptions = new AmbientOcclusionOptions();
        }
        return this.mAmbientOcclusionOptions;
    }

    public void setBloomOptions(@NonNull BloomOptions options) {
        this.mBloomOptions = options;
        View.nSetBloomOptions(this.getNativeObject(), options.dirt != null ? options.dirt.getNativeObject() : 0L, options.dirtStrength, options.strength, options.resolution, options.anamorphism, options.levels, options.blendingMode.ordinal(), options.threshold, options.enabled, options.highlight, options.lensFlare, options.starburst, options.chromaticAberration, options.ghostCount, options.ghostSpacing, options.ghostThreshold, options.haloThickness, options.haloRadius, options.haloThreshold);
    }

    @NonNull
    public BloomOptions getBloomOptions() {
        if (this.mBloomOptions == null) {
            this.mBloomOptions = new BloomOptions();
        }
        return this.mBloomOptions;
    }

    public void setVignetteOptions(@NonNull VignetteOptions options) {
        Asserts.assertFloat4In(options.color);
        this.mVignetteOptions = options;
        View.nSetVignetteOptions(this.getNativeObject(), options.midPoint, options.roundness, options.feather, options.color[0], options.color[1], options.color[2], options.color[3], options.enabled);
    }

    @NonNull
    public VignetteOptions getVignetteOptions() {
        if (this.mVignetteOptions == null) {
            this.mVignetteOptions = new VignetteOptions();
        }
        return this.mVignetteOptions;
    }

    public void setFogOptions(@NonNull FogOptions options) {
        Asserts.assertFloat3In(options.color);
        this.mFogOptions = options;
        View.nSetFogOptions(this.getNativeObject(), options.distance, options.maximumOpacity, options.height, options.heightFalloff, options.color[0], options.color[1], options.color[2], options.density, options.inScatteringStart, options.inScatteringSize, options.fogColorFromIbl, options.enabled);
    }

    @NonNull
    public FogOptions getFogOptions() {
        if (this.mFogOptions == null) {
            this.mFogOptions = new FogOptions();
        }
        return this.mFogOptions;
    }

    public void setDepthOfFieldOptions(@NonNull DepthOfFieldOptions options) {
        this.mDepthOfFieldOptions = options;
        View.nSetDepthOfFieldOptions(this.getNativeObject(), options.cocScale, options.maxApertureDiameter, options.enabled, options.filter.ordinal(), options.nativeResolution, options.foregroundRingCount, options.backgroundRingCount, options.fastGatherRingCount, options.maxForegroundCOC, options.maxBackgroundCOC);
    }

    @NonNull
    public DepthOfFieldOptions getDepthOfFieldOptions() {
        if (this.mDepthOfFieldOptions == null) {
            this.mDepthOfFieldOptions = new DepthOfFieldOptions();
        }
        return this.mDepthOfFieldOptions;
    }

    public void pick(int x, int y, @Nullable Object handler, @Nullable OnPickCallback callback) {
        InternalOnPickCallback internalCallback = new InternalOnPickCallback(callback);
        View.nPick(this.getNativeObject(), x, y, handler, internalCallback);
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed View");
        }
        return this.mNativeObject;
    }

    void clearNativeObject() {
        this.mNativeObject = 0L;
    }

    private static native void nSetName(long var0, String var2);

    private static native void nSetScene(long var0, long var2);

    private static native void nSetCamera(long var0, long var2);

    private static native void nSetViewport(long var0, int var2, int var3, int var4, int var5);

    private static native void nSetVisibleLayers(long var0, int var2, int var3);

    private static native void nSetShadowingEnabled(long var0, boolean var2);

    private static native void nSetRenderTarget(long var0, long var2);

    private static native void nSetSampleCount(long var0, int var2);

    private static native int nGetSampleCount(long var0);

    private static native void nSetAntiAliasing(long var0, int var2);

    private static native int nGetAntiAliasing(long var0);

    private static native void nSetDithering(long var0, int var2);

    private static native int nGetDithering(long var0);

    private static native void nSetDynamicResolutionOptions(long var0, boolean var2, boolean var3, float var4, float var5, float var6, int var7);

    private static native void nSetRenderQuality(long var0, int var2);

    private static native void nSetDynamicLightingOptions(long var0, float var2, float var3);

    private static native void nSetShadowType(long var0, int var2);

    private static native void nSetVsmShadowOptions(long var0, int var2, boolean var3, float var4, float var5);

    private static native void nSetSoftShadowOptions(long var0, float var2, float var3);

    private static native void nSetColorGrading(long var0, long var2);

    private static native void nSetPostProcessingEnabled(long var0, boolean var2);

    private static native boolean nIsPostProcessingEnabled(long var0);

    private static native void nSetFrontFaceWindingInverted(long var0, boolean var2);

    private static native boolean nIsFrontFaceWindingInverted(long var0);

    private static native void nSetAmbientOcclusion(long var0, int var2);

    private static native int nGetAmbientOcclusion(long var0);

    private static native void nSetAmbientOcclusionOptions(long var0, float var2, float var3, float var4, float var5, float var6, float var7, int var8, int var9, int var10, boolean var11, boolean var12, float var13);

    private static native void nSetSSCTOptions(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, int var11, int var12, boolean var13);

    private static native void nSetBloomOptions(long var0, long var2, float var4, float var5, int var6, float var7, int var8, int var9, boolean var10, boolean var11, float var12, boolean var13, boolean var14, float var15, int var16, float var17, float var18, float var19, float var20, float var21);

    private static native void nSetFogOptions(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, boolean var12, boolean var13);

    private static native void nSetBlendMode(long var0, int var2);

    private static native void nSetDepthOfFieldOptions(long var0, float var2, float var3, boolean var4, int var5, boolean var6, int var7, int var8, int var9, int var10, int var11);

    private static native void nSetVignetteOptions(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, boolean var9);

    private static native void nSetTemporalAntiAliasingOptions(long var0, float var2, float var3, boolean var4);

    private static native void nSetScreenSpaceReflectionsOptions(long var0, float var2, float var3, float var4, float var5, boolean var6);

    private static native void nSetMultiSampleAntiAliasingOptions(long var0, boolean var2, int var3, boolean var4);

    private static native boolean nIsShadowingEnabled(long var0);

    private static native void nSetScreenSpaceRefractionEnabled(long var0, boolean var2);

    private static native boolean nIsScreenSpaceRefractionEnabled(long var0);

    private static native void nPick(long var0, int var2, int var3, Object var4, InternalOnPickCallback var5);

    private static class InternalOnPickCallback
    implements Runnable {
        private final OnPickCallback mUserCallback;
        private final PickingQueryResult mPickingQueryResult = new PickingQueryResult();
        @Entity
        int mRenderable;
        float mDepth;
        float mFragCoordsX;
        float mFragCoordsY;
        float mFragCoordsZ;

        public InternalOnPickCallback(OnPickCallback mUserCallback) {
            this.mUserCallback = mUserCallback;
        }

        @Override
        public void run() {
            this.mPickingQueryResult.renderable = this.mRenderable;
            this.mPickingQueryResult.depth = this.mDepth;
            this.mPickingQueryResult.fragCoords[0] = this.mFragCoordsX;
            this.mPickingQueryResult.fragCoords[1] = this.mFragCoordsY;
            this.mPickingQueryResult.fragCoords[2] = this.mFragCoordsZ;
            this.mUserCallback.onPick(this.mPickingQueryResult);
        }
    }

    public static interface OnPickCallback {
        public void onPick(@NonNull PickingQueryResult var1);
    }

    public static class PickingQueryResult {
        @Entity
        public int renderable;
        public float depth;
        @NonNull
        public float[] fragCoords = new float[3];
    }

    public static enum TargetBufferFlags {
        COLOR0(1),
        COLOR1(2),
        COLOR2(4),
        COLOR3(8),
        DEPTH(16),
        STENCIL(32);

        public static EnumSet<TargetBufferFlags> NONE;
        public static EnumSet<TargetBufferFlags> ALL_COLOR;
        public static EnumSet<TargetBufferFlags> DEPTH_STENCIL;
        public static EnumSet<TargetBufferFlags> ALL;
        private int mFlags;

        private TargetBufferFlags(int flags) {
            this.mFlags = flags;
        }

        static int flags(EnumSet<TargetBufferFlags> flags) {
            int result = 0;
            for (TargetBufferFlags flag : flags) {
                result |= flag.mFlags;
            }
            return result;
        }

        static {
            NONE = EnumSet.noneOf(TargetBufferFlags.class);
            ALL_COLOR = EnumSet.of(COLOR0, COLOR1, COLOR2, COLOR3);
            DEPTH_STENCIL = EnumSet.of(DEPTH, STENCIL);
            ALL = EnumSet.range(COLOR0, STENCIL);
        }
    }

    public static class SoftShadowOptions {
        public float penumbraScale = 1.0f;
        public float penumbraRatioScale = 1.0f;
    }

    public static class VsmShadowOptions {
        public int anisotropy = 0;
        public boolean mipmapping = false;
        public float minVarianceScale = 1.0f;
        public float lightBleedReduction = 0.2f;
    }

    public static enum ShadowType {
        PCF,
        VSM,
        DPCF,
        PCSS;

    }

    public static enum Dithering {
        NONE,
        TEMPORAL;

    }

    @Deprecated
    public static enum ToneMapping {
        LINEAR,
        ACES;

    }

    public static enum AntiAliasing {
        NONE,
        FXAA;

    }

    @Deprecated
    public static enum AmbientOcclusion {
        NONE,
        SSAO;

    }

    public static class RenderQuality {
        public QualityLevel hdrColorBuffer = QualityLevel.HIGH;
    }

    public static class VignetteOptions {
        public float midPoint = 0.5f;
        public float roundness = 0.5f;
        public float feather = 0.5f;
        @NonNull
        @Size(min=4L)
        public float[] color = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        public boolean enabled = false;
    }

    public static class DepthOfFieldOptions {
        public float cocScale = 1.0f;
        public float maxApertureDiameter = 0.01f;
        public boolean enabled = false;
        @NonNull
        public Filter filter = Filter.MEDIAN;
        public boolean nativeResolution = false;
        public int foregroundRingCount = 0;
        public int backgroundRingCount = 0;
        public int fastGatherRingCount = 0;
        public int maxForegroundCOC = 0;
        public int maxBackgroundCOC = 0;

        public static enum Filter {
            NONE,
            MEDIAN;

        }
    }

    public static class FogOptions {
        public float distance = 0.0f;
        public float maximumOpacity = 1.0f;
        public float height = 0.0f;
        public float heightFalloff = 1.0f;
        @NonNull
        @Size(min=3L)
        public float[] color = new float[]{0.5f, 0.5f, 0.5f};
        public float density = 0.1f;
        public float inScatteringStart = 0.0f;
        public float inScatteringSize = -1.0f;
        public boolean fogColorFromIbl = false;
        public boolean enabled = false;
    }

    public static class BloomOptions {
        @Nullable
        public Texture dirt = null;
        public float dirtStrength = 0.2f;
        public float strength = 0.1f;
        public int resolution = 360;
        public float anamorphism = 1.0f;
        public int levels = 6;
        public BlendingMode blendingMode = BlendingMode.ADD;
        public boolean threshold = true;
        public boolean enabled = false;
        public float highlight = 1000.0f;
        public boolean lensFlare = false;
        public boolean starburst = true;
        public float chromaticAberration = 0.005f;
        public int ghostCount = 4;
        public float ghostSpacing = 0.6f;
        public float ghostThreshold = 10.0f;
        public float haloThickness = 0.1f;
        public float haloRadius = 0.4f;
        public float haloThreshold = 10.0f;

        public static enum BlendingMode {
            ADD,
            INTERPOLATE;

        }
    }

    public static class ScreenSpaceReflectionsOptions {
        public float thickness = 0.1f;
        public float bias = 0.01f;
        public float maxDistance = 3.0f;
        public float stride = 2.0f;
        public boolean enabled = false;
    }

    public static class TemporalAntiAliasingOptions {
        public float filterWidth = 1.0f;
        public float feedback = 0.04f;
        public boolean enabled = false;
    }

    public static class MultiSampleAntiAliasingOptions {
        public boolean enabled = false;
        public int sampleCount = 4;
        public boolean customResolve = false;
    }

    public static class AmbientOcclusionOptions {
        public float radius = 0.3f;
        public float bias = 5.0E-4f;
        public float power = 1.0f;
        public float resolution = 0.5f;
        public float intensity = 1.0f;
        public float bilateralThreshold = 0.05f;
        @NonNull
        public QualityLevel quality = QualityLevel.LOW;
        @NonNull
        public QualityLevel lowPassFilter = QualityLevel.MEDIUM;
        @NonNull
        public QualityLevel upsampling = QualityLevel.LOW;
        public boolean enabled = false;
        public boolean bentNormals = false;
        public float minHorizonAngleRad = 0.0f;
        public float ssctLightConeRad = 1.0f;
        public float ssctStartTraceDistance = 0.01f;
        public float ssctContactDistanceMax = 1.0f;
        public float ssctIntensity = 0.8f;
        @NonNull
        @Size(min=3L)
        public float[] ssctLightDirection = new float[]{0.0f, -1.0f, 0.0f};
        public float ssctDepthBias = 0.01f;
        public float ssctDepthSlopeBias = 0.01f;
        public int ssctSampleCount = 4;
        public int ssctRayCount = 1;
        public boolean ssctEnabled = false;
    }

    public static class DynamicResolutionOptions {
        public boolean enabled = false;
        public boolean homogeneousScaling = false;
        public float minScale = 0.5f;
        public float maxScale = 1.0f;
        public float sharpness = 0.9f;
        @NonNull
        public QualityLevel quality = QualityLevel.LOW;
    }

    public static enum BlendMode {
        OPAQUE,
        TRANSLUCENT;

    }

    public static enum QualityLevel {
        LOW,
        MEDIUM,
        HIGH,
        ULTRA;

    }
}

