/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

public class ToneMapper {
    private final long mNativeObject;

    private ToneMapper(long nativeObject) {
        this.mNativeObject = nativeObject;
    }

    public long getNativeObject() {
        if (this.mNativeObject == 0L) {
            throw new IllegalStateException("Calling method on destroyed ToneMapper");
        }
        return this.mNativeObject;
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            ToneMapper.nDestroyToneMapper(this.mNativeObject);
        }
    }

    private static native void nDestroyToneMapper(long var0);

    private static native long nCreateLinearToneMapper();

    private static native long nCreateACESToneMapper();

    private static native long nCreateACESLegacyToneMapper();

    private static native long nCreateFilmicToneMapper();

    private static native long nCreateGenericToneMapper(float var0, float var1, float var2, float var3);

    private static native float nGenericGetContrast(long var0);

    private static native float nGenericGetMidGrayIn(long var0);

    private static native float nGenericGetMidGrayOut(long var0);

    private static native float nGenericGetHdrMax(long var0);

    private static native void nGenericSetContrast(long var0, float var2);

    private static native void nGenericSetMidGrayIn(long var0, float var2);

    private static native void nGenericSetMidGrayOut(long var0, float var2);

    private static native void nGenericSetHdrMax(long var0, float var2);

    public static class Generic
    extends ToneMapper {
        public Generic() {
            this(1.55f, 0.18f, 0.215f, 10.0f);
        }

        public Generic(float contrast, float midGrayIn, float midGrayOut, float hdrMax) {
            super(ToneMapper.nCreateGenericToneMapper(contrast, midGrayIn, midGrayOut, hdrMax));
        }

        public float getContrast() {
            return ToneMapper.nGenericGetContrast(this.getNativeObject());
        }

        public void setContrast(float contrast) {
            ToneMapper.nGenericSetContrast(this.getNativeObject(), contrast);
        }

        public float getMidGrayIn() {
            return ToneMapper.nGenericGetMidGrayIn(this.getNativeObject());
        }

        public void setMidGrayIn(float midGrayIn) {
            ToneMapper.nGenericSetMidGrayIn(this.getNativeObject(), midGrayIn);
        }

        public float getMidGrayOut() {
            return ToneMapper.nGenericGetMidGrayOut(this.getNativeObject());
        }

        public void setMidGrayOut(float midGrayOut) {
            ToneMapper.nGenericSetMidGrayOut(this.getNativeObject(), midGrayOut);
        }

        public float getHdrMax() {
            return ToneMapper.nGenericGetHdrMax(this.getNativeObject());
        }

        public void setHdrMax(float hdrMax) {
            ToneMapper.nGenericSetHdrMax(this.getNativeObject(), hdrMax);
        }
    }

    public static class Filmic
    extends ToneMapper {
        public Filmic() {
            super(ToneMapper.nCreateFilmicToneMapper());
        }
    }

    public static class ACESLegacy
    extends ToneMapper {
        public ACESLegacy() {
            super(ToneMapper.nCreateACESLegacyToneMapper());
        }
    }

    public static class ACES
    extends ToneMapper {
        public ACES() {
            super(ToneMapper.nCreateACESToneMapper());
        }
    }

    public static class Linear
    extends ToneMapper {
        public Linear() {
            super(ToneMapper.nCreateLinearToneMapper());
        }
    }
}

