/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import com.google.android.filament.AndroidPlatform21;
import com.google.android.filament.Platform;
import java.lang.reflect.Method;

final class AndroidPlatform
extends Platform {
    private static final String LOG_TAG = "Filament";

    AndroidPlatform() {
    }

    @Override
    void log(String message) {
        Log.d((String)LOG_TAG, (String)message);
    }

    @Override
    void warn(String message) {
        Log.w((String)LOG_TAG, (String)message);
    }

    @Override
    boolean validateStreamSource(Object object) {
        return object instanceof SurfaceTexture;
    }

    @Override
    boolean validateSurface(Object object) {
        return object instanceof Surface;
    }

    @Override
    boolean validateSharedContext(Object object) {
        return object instanceof EGLContext;
    }

    @Override
    long getSharedContextNativeHandle(Object sharedContext) {
        if (Build.VERSION.SDK_INT >= 21) {
            return AndroidPlatform21.getSharedContextNativeHandle(sharedContext);
        }
        try {
            Method method = EGLContext.class.getDeclaredMethod("getHandle", new Class[0]);
            Integer handle = (Integer)method.invoke(sharedContext, new Object[0]);
            return handle.longValue();
        }
        catch (Exception e) {
            Log.d((String)LOG_TAG, (String)"Could not access shared context's native handle", (Throwable)e);
            return 0L;
        }
    }

    static {
        EGL14.eglGetDisplay((int)0);
    }
}

