/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.google.android.filament.Asserts;
import com.google.android.filament.Engine;
import com.google.android.filament.Entity;
import com.google.android.filament.EntityInstance;

public class LightManager {
    private static final Type[] sTypeValues = Type.values();
    private long mNativeObject;
    public static final float EFFICIENCY_INCANDESCENT = 0.022f;
    public static final float EFFICIENCY_HALOGEN = 0.0707f;
    public static final float EFFICIENCY_FLUORESCENT = 0.0878f;
    public static final float EFFICIENCY_LED = 0.1171f;

    LightManager(long nativeLightManager) {
        this.mNativeObject = nativeLightManager;
    }

    public int getComponentCount() {
        return LightManager.nGetComponentCount(this.mNativeObject);
    }

    public boolean hasComponent(@Entity int entity) {
        return LightManager.nHasComponent(this.mNativeObject, entity);
    }

    @EntityInstance
    public int getInstance(@Entity int entity) {
        return LightManager.nGetInstance(this.mNativeObject, entity);
    }

    public void destroy(@Entity int entity) {
        LightManager.nDestroy(this.mNativeObject, entity);
    }

    @NonNull
    public Type getType(@EntityInstance int i) {
        return sTypeValues[LightManager.nGetType(this.mNativeObject, i)];
    }

    boolean isDirectional(@EntityInstance int i) {
        Type type = this.getType(i);
        return type == Type.DIRECTIONAL || type == Type.SUN;
    }

    boolean isPointLight(@EntityInstance int i) {
        return this.getType(i) == Type.POINT;
    }

    boolean isSpotLight(@EntityInstance int i) {
        Type type = this.getType(i);
        return type == Type.SPOT || type == Type.FOCUSED_SPOT;
    }

    public void setLightChannel(@EntityInstance int i, @IntRange(from=0L, to=7L) int channel, boolean enable) {
        LightManager.nSetLightChannel(this.mNativeObject, i, channel, enable);
    }

    public boolean getLightChannel(@EntityInstance int i, @IntRange(from=0L, to=7L) int channel) {
        return LightManager.nGetLightChannel(this.mNativeObject, i, channel);
    }

    public void setPosition(@EntityInstance int i, float x, float y, float z) {
        LightManager.nSetPosition(this.mNativeObject, i, x, y, z);
    }

    @NonNull
    public float[] getPosition(@EntityInstance int i, @Nullable @Size(min=3L) float[] out) {
        out = Asserts.assertFloat3(out);
        LightManager.nGetPosition(this.mNativeObject, i, out);
        return out;
    }

    public void setDirection(@EntityInstance int i, float x, float y, float z) {
        LightManager.nSetDirection(this.mNativeObject, i, x, y, z);
    }

    @NonNull
    public float[] getDirection(@EntityInstance int i, @Nullable @Size(min=3L) float[] out) {
        out = Asserts.assertFloat3(out);
        LightManager.nGetDirection(this.mNativeObject, i, out);
        return out;
    }

    public void setColor(@EntityInstance int i, float linearR, float linearG, float linearB) {
        LightManager.nSetColor(this.mNativeObject, i, linearR, linearG, linearB);
    }

    @NonNull
    public float[] getColor(@EntityInstance int i, @Nullable @Size(min=3L) float[] out) {
        out = Asserts.assertFloat3(out);
        LightManager.nGetColor(this.mNativeObject, i, out);
        return out;
    }

    public void setIntensity(@EntityInstance int i, float intensity) {
        LightManager.nSetIntensity(this.mNativeObject, i, intensity);
    }

    public void setIntensityCandela(@EntityInstance int i, float intensity) {
        LightManager.nSetIntensityCandela(this.mNativeObject, i, intensity);
    }

    public void setIntensity(@EntityInstance int i, float watts, float efficiency) {
        LightManager.nSetIntensity(this.mNativeObject, i, watts, efficiency);
    }

    public float getIntensity(@EntityInstance int i) {
        return LightManager.nGetIntensity(this.mNativeObject, i);
    }

    public void setFalloff(@EntityInstance int i, float falloff) {
        LightManager.nSetFalloff(this.mNativeObject, i, falloff);
    }

    public float getFalloff(@EntityInstance int i) {
        return LightManager.nGetFalloff(this.mNativeObject, i);
    }

    public void setSpotLightCone(@EntityInstance int i, float inner, float outer) {
        LightManager.nSetSpotLightCone(this.mNativeObject, i, inner, outer);
    }

    public void setSunAngularRadius(@EntityInstance int i, float angularRadius) {
        LightManager.nSetSunAngularRadius(this.mNativeObject, i, angularRadius);
    }

    public float getSunAngularRadius(@EntityInstance int i) {
        return LightManager.nGetSunAngularRadius(this.mNativeObject, i);
    }

    public void setSunHaloSize(@EntityInstance int i, float haloSize) {
        LightManager.nSetSunHaloSize(this.mNativeObject, i, haloSize);
    }

    public float getSunHaloSize(@EntityInstance int i) {
        return LightManager.nGetSunHaloSize(this.mNativeObject, i);
    }

    public void setSunHaloFalloff(@EntityInstance int i, float haloFalloff) {
        LightManager.nSetSunHaloFalloff(this.mNativeObject, i, haloFalloff);
    }

    public float getSunHaloFalloff(@EntityInstance int i) {
        return LightManager.nGetSunHaloFalloff(this.mNativeObject, i);
    }

    public void setShadowCaster(@EntityInstance int i, boolean shadowCaster) {
        LightManager.nSetShadowCaster(this.mNativeObject, i, shadowCaster);
    }

    public boolean isShadowCaster(@EntityInstance int i) {
        return LightManager.nIsShadowCaster(this.mNativeObject, i);
    }

    public float getOuterConeAngle(@EntityInstance int i) {
        return LightManager.nGetOuterConeAngle(this.mNativeObject, i);
    }

    public float getInnerConeAngle(@EntityInstance int i) {
        return LightManager.nGetInnerConeAngle(this.mNativeObject, i);
    }

    public long getNativeObject() {
        return this.mNativeObject;
    }

    private static native int nGetComponentCount(long var0);

    private static native boolean nHasComponent(long var0, int var2);

    private static native int nGetInstance(long var0, int var2);

    private static native void nDestroy(long var0, int var2);

    private static native long nCreateBuilder(int var0);

    private static native void nDestroyBuilder(long var0);

    private static native boolean nBuilderBuild(long var0, long var2, int var4);

    private static native void nBuilderCastShadows(long var0, boolean var2);

    private static native void nBuilderShadowOptions(long var0, int var2, int var3, float[] var4, float var5, float var6, float var7, float var8, float var9, boolean var10, float var11, float var12, boolean var13, int var14, float var15, int var16, float var17, float var18);

    private static native void nBuilderCastLight(long var0, boolean var2);

    private static native void nBuilderPosition(long var0, float var2, float var3, float var4);

    private static native void nBuilderDirection(long var0, float var2, float var3, float var4);

    private static native void nBuilderColor(long var0, float var2, float var3, float var4);

    private static native void nBuilderIntensity(long var0, float var2);

    private static native void nBuilderIntensity(long var0, float var2, float var3);

    private static native void nBuilderIntensityCandela(long var0, float var2);

    private static native void nBuilderFalloff(long var0, float var2);

    private static native void nBuilderSpotLightCone(long var0, float var2, float var3);

    private static native void nBuilderAngularRadius(long var0, float var2);

    private static native void nBuilderHaloSize(long var0, float var2);

    private static native void nBuilderHaloFalloff(long var0, float var2);

    private static native void nBuilderLightChannel(long var0, int var2, boolean var3);

    private static native void nComputeUniformSplits(float[] var0, int var1);

    private static native void nComputeLogSplits(float[] var0, int var1, float var2, float var3);

    private static native void nComputePracticalSplits(float[] var0, int var1, float var2, float var3, float var4);

    private static native int nGetType(long var0, int var2);

    private static native void nSetPosition(long var0, int var2, float var3, float var4, float var5);

    private static native void nGetPosition(long var0, int var2, float[] var3);

    private static native void nSetDirection(long var0, int var2, float var3, float var4, float var5);

    private static native void nGetDirection(long var0, int var2, float[] var3);

    private static native void nSetColor(long var0, int var2, float var3, float var4, float var5);

    private static native void nGetColor(long var0, int var2, float[] var3);

    private static native void nSetIntensity(long var0, int var2, float var3);

    private static native void nSetIntensity(long var0, int var2, float var3, float var4);

    private static native void nSetIntensityCandela(long var0, int var2, float var3);

    private static native float nGetIntensity(long var0, int var2);

    private static native void nSetFalloff(long var0, int var2, float var3);

    private static native float nGetFalloff(long var0, int var2);

    private static native void nSetSpotLightCone(long var0, int var2, float var3, float var4);

    private static native void nSetSunAngularRadius(long var0, int var2, float var3);

    private static native float nGetSunAngularRadius(long var0, int var2);

    private static native void nSetSunHaloSize(long var0, int var2, float var3);

    private static native float nGetSunHaloSize(long var0, int var2);

    private static native void nSetSunHaloFalloff(long var0, int var2, float var3);

    private static native float nGetSunHaloFalloff(long var0, int var2);

    private static native void nSetShadowCaster(long var0, int var2, boolean var3);

    private static native boolean nIsShadowCaster(long var0, int var2);

    private static native float nGetOuterConeAngle(long var0, int var2);

    private static native float nGetInnerConeAngle(long var0, int var2);

    private static native void nSetLightChannel(long var0, int var2, int var3, boolean var4);

    private static native boolean nGetLightChannel(long var0, int var2, int var3);

    public static class Builder {
        private final BuilderFinalizer mFinalizer;
        private final long mNativeBuilder;

        public Builder(@NonNull Type type) {
            this.mNativeBuilder = LightManager.nCreateBuilder(type.ordinal());
            this.mFinalizer = new BuilderFinalizer(this.mNativeBuilder);
        }

        @NonNull
        public Builder lightChannel(@IntRange(from=0L, to=7L) int channel, boolean enable) {
            LightManager.nBuilderLightChannel(this.mNativeBuilder, channel, enable);
            return this;
        }

        @NonNull
        public Builder castShadows(boolean enable) {
            LightManager.nBuilderCastShadows(this.mNativeBuilder, enable);
            return this;
        }

        @NonNull
        public Builder shadowOptions(@NonNull ShadowOptions options) {
            LightManager.nBuilderShadowOptions(this.mNativeBuilder, options.mapSize, options.shadowCascades, options.cascadeSplitPositions, options.constantBias, options.normalBias, options.shadowFar, options.shadowNearHint, options.shadowFarHint, options.stable, options.polygonOffsetConstant, options.polygonOffsetSlope, options.screenSpaceContactShadows, options.stepCount, options.maxShadowDistance, options.vsmMsaaSamples, options.blurWidth, options.shadowBulbRadius);
            return this;
        }

        @NonNull
        public Builder castLight(boolean enabled) {
            LightManager.nBuilderCastLight(this.mNativeBuilder, enabled);
            return this;
        }

        @NonNull
        public Builder position(float x, float y, float z) {
            LightManager.nBuilderPosition(this.mNativeBuilder, x, y, z);
            return this;
        }

        @NonNull
        public Builder direction(float x, float y, float z) {
            LightManager.nBuilderDirection(this.mNativeBuilder, x, y, z);
            return this;
        }

        @NonNull
        public Builder color(float linearR, float linearG, float linearB) {
            LightManager.nBuilderColor(this.mNativeBuilder, linearR, linearG, linearB);
            return this;
        }

        @NonNull
        public Builder intensity(float intensity) {
            LightManager.nBuilderIntensity(this.mNativeBuilder, intensity);
            return this;
        }

        @NonNull
        public Builder intensity(float watts, float efficiency) {
            LightManager.nBuilderIntensity(this.mNativeBuilder, watts, efficiency);
            return this;
        }

        @NonNull
        public Builder intensityCandela(float intensity) {
            LightManager.nBuilderIntensityCandela(this.mNativeBuilder, intensity);
            return this;
        }

        @NonNull
        public Builder falloff(float radius) {
            LightManager.nBuilderFalloff(this.mNativeBuilder, radius);
            return this;
        }

        @NonNull
        public Builder spotLightCone(float inner, float outer) {
            LightManager.nBuilderSpotLightCone(this.mNativeBuilder, inner, outer);
            return this;
        }

        @NonNull
        public Builder sunAngularRadius(float angularRadius) {
            LightManager.nBuilderAngularRadius(this.mNativeBuilder, angularRadius);
            return this;
        }

        @NonNull
        public Builder sunHaloSize(float haloSize) {
            LightManager.nBuilderHaloSize(this.mNativeBuilder, haloSize);
            return this;
        }

        @NonNull
        public Builder sunHaloFalloff(float haloFalloff) {
            LightManager.nBuilderHaloFalloff(this.mNativeBuilder, haloFalloff);
            return this;
        }

        public void build(@NonNull Engine engine, @Entity int entity) {
            if (!LightManager.nBuilderBuild(this.mNativeBuilder, engine.getNativeObject(), entity)) {
                throw new IllegalStateException("Couldn't create Light component for entity " + entity + ", see log.");
            }
        }

        private static class BuilderFinalizer {
            private final long mNativeObject;

            BuilderFinalizer(long nativeObject) {
                this.mNativeObject = nativeObject;
            }

            public void finalize() {
                try {
                    super.finalize();
                }
                catch (Throwable throwable) {
                }
                finally {
                    LightManager.nDestroyBuilder(this.mNativeObject);
                }
            }
        }
    }

    public static class ShadowCascades {
        public static void computeUniformSplits(@NonNull @Size(min=1L) float[] splitPositions, @IntRange(from=1L, to=4L) int cascades) {
            if (splitPositions.length < cascades - 1) {
                throw new ArrayIndexOutOfBoundsException(String.format("splitPositions array length must be at least %d", cascades - 1));
            }
            LightManager.nComputeUniformSplits(splitPositions, cascades);
        }

        public static void computeLogSplits(@NonNull @Size(min=1L) float[] splitPositions, @IntRange(from=1L, to=4L) int cascades, float near, float far) {
            if (splitPositions.length < cascades - 1) {
                throw new ArrayIndexOutOfBoundsException(String.format("splitPositions array length must be at least %d", cascades - 1));
            }
            LightManager.nComputeLogSplits(splitPositions, cascades, near, far);
        }

        public static void computePracticalSplits(@NonNull @Size(min=1L) float[] splitPositions, @IntRange(from=1L, to=4L) int cascades, float near, float far, float lambda) {
            if (splitPositions.length < cascades - 1) {
                throw new ArrayIndexOutOfBoundsException(String.format("splitPositions array length must be at least %d", cascades - 1));
            }
            LightManager.nComputePracticalSplits(splitPositions, cascades, near, far, lambda);
        }
    }

    public static class ShadowOptions {
        public int mapSize = 1024;
        @IntRange(from=1L, to=4L)
        public int shadowCascades = 1;
        @NonNull
        @Size(min=3L)
        public float[] cascadeSplitPositions = new float[]{0.25f, 0.5f, 0.75f};
        public float constantBias = 0.001f;
        public float normalBias = 1.0f;
        public float shadowFar = 0.0f;
        public float shadowNearHint = 1.0f;
        public float shadowFarHint = 100.0f;
        public boolean stable = false;
        float polygonOffsetConstant = 0.5f;
        float polygonOffsetSlope = 2.0f;
        public boolean screenSpaceContactShadows = false;
        public int stepCount = 8;
        public float maxShadowDistance = 0.3f;
        @IntRange(from=1L)
        public int vsmMsaaSamples = 1;
        public float blurWidth = 0.0f;
        public float shadowBulbRadius = 0.02f;
    }

    public static enum Type {
        SUN,
        DIRECTIONAL,
        POINT,
        FOCUSED_SPOT,
        SPOT;

    }
}

