/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.rtmp;

import android.net.Uri;
import android.support.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import java.io.IOException;
import net.butterflytv.rtmp_client.RtmpClient;

public final class RtmpDataSource
implements DataSource {
    @Nullable
    private final TransferListener<? super RtmpDataSource> listener;
    private RtmpClient rtmpClient;
    private Uri uri;

    public RtmpDataSource() {
        this(null);
    }

    public RtmpDataSource(@Nullable TransferListener<? super RtmpDataSource> listener) {
        this.listener = listener;
    }

    public long open(DataSpec dataSpec) throws RtmpClient.RtmpIOException {
        this.rtmpClient = new RtmpClient();
        this.rtmpClient.open(dataSpec.uri.toString(), false);
        this.uri = dataSpec.uri;
        if (this.listener != null) {
            this.listener.onTransferStart((Object)this, dataSpec);
        }
        return -1L;
    }

    public int read(byte[] buffer, int offset, int readLength) throws IOException {
        int bytesRead = this.rtmpClient.read(buffer, offset, readLength);
        if (bytesRead == -1) {
            return -1;
        }
        if (this.listener != null) {
            this.listener.onBytesTransferred((Object)this, bytesRead);
        }
        return bytesRead;
    }

    public void close() {
        if (this.uri != null) {
            this.uri = null;
            if (this.listener != null) {
                this.listener.onTransferEnd((Object)this);
            }
        }
        if (this.rtmpClient != null) {
            this.rtmpClient.close();
            this.rtmpClient = null;
        }
    }

    public Uri getUri() {
        return this.uri;
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.rtmp");
    }
}

