/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.okhttp;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Predicate;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpDataSource
implements HttpDataSource {
    private static final AtomicReference<byte[]> skipBufferReference;
    @NonNull
    private final Call.Factory callFactory;
    @NonNull
    private final HttpDataSource.RequestProperties requestProperties;
    @Nullable
    private final String userAgent;
    @Nullable
    private final Predicate<String> contentTypePredicate;
    @Nullable
    private final TransferListener<? super OkHttpDataSource> listener;
    @Nullable
    private final CacheControl cacheControl;
    @Nullable
    private final HttpDataSource.RequestProperties defaultRequestProperties;
    private DataSpec dataSpec;
    private Response response;
    private InputStream responseByteStream;
    private boolean opened;
    private long bytesToSkip;
    private long bytesToRead;
    private long bytesSkipped;
    private long bytesRead;

    public OkHttpDataSource(@NonNull Call.Factory callFactory, @Nullable String userAgent, @Nullable Predicate<String> contentTypePredicate) {
        this(callFactory, userAgent, contentTypePredicate, null);
    }

    public OkHttpDataSource(@NonNull Call.Factory callFactory, @Nullable String userAgent, @Nullable Predicate<String> contentTypePredicate, @Nullable TransferListener<? super OkHttpDataSource> listener) {
        this(callFactory, userAgent, contentTypePredicate, listener, null, null);
    }

    public OkHttpDataSource(@NonNull Call.Factory callFactory, @Nullable String userAgent, @Nullable Predicate<String> contentTypePredicate, @Nullable TransferListener<? super OkHttpDataSource> listener, @Nullable CacheControl cacheControl, @Nullable HttpDataSource.RequestProperties defaultRequestProperties) {
        this.callFactory = (Call.Factory)Assertions.checkNotNull((Object)callFactory);
        this.userAgent = userAgent;
        this.contentTypePredicate = contentTypePredicate;
        this.listener = listener;
        this.cacheControl = cacheControl;
        this.defaultRequestProperties = defaultRequestProperties;
        this.requestProperties = new HttpDataSource.RequestProperties();
    }

    public Uri getUri() {
        return this.response == null ? null : Uri.parse((String)this.response.request().url().toString());
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.response == null ? null : this.response.headers().toMultimap();
    }

    public void setRequestProperty(String name, String value) {
        Assertions.checkNotNull((Object)name);
        Assertions.checkNotNull((Object)value);
        this.requestProperties.set(name, value);
    }

    public void clearRequestProperty(String name) {
        Assertions.checkNotNull((Object)name);
        this.requestProperties.remove(name);
    }

    public void clearAllRequestProperties() {
        this.requestProperties.clear();
    }

    public long open(DataSpec dataSpec) throws HttpDataSource.HttpDataSourceException {
        long contentLength;
        String contentType;
        this.dataSpec = dataSpec;
        this.bytesRead = 0L;
        this.bytesSkipped = 0L;
        Request request = this.makeRequest(dataSpec);
        try {
            this.response = this.callFactory.newCall(request).execute();
            this.responseByteStream = this.response.body().byteStream();
        }
        catch (IOException e) {
            throw new HttpDataSource.HttpDataSourceException("Unable to connect to " + dataSpec.uri.toString(), e, dataSpec, 1);
        }
        int responseCode = this.response.code();
        if (!this.response.isSuccessful()) {
            Map headers = request.headers().toMultimap();
            this.closeConnectionQuietly();
            HttpDataSource.InvalidResponseCodeException exception = new HttpDataSource.InvalidResponseCodeException(responseCode, headers, dataSpec);
            if (responseCode == 416) {
                exception.initCause((Throwable)new DataSourceException(0));
            }
            throw exception;
        }
        MediaType mediaType = this.response.body().contentType();
        String string = contentType = mediaType != null ? mediaType.toString() : null;
        if (this.contentTypePredicate != null && !this.contentTypePredicate.evaluate((Object)contentType)) {
            this.closeConnectionQuietly();
            throw new HttpDataSource.InvalidContentTypeException(contentType, dataSpec);
        }
        long l = this.bytesToSkip = responseCode == 200 && dataSpec.position != 0L ? dataSpec.position : 0L;
        this.bytesToRead = dataSpec.length != -1L ? dataSpec.length : ((contentLength = this.response.body().contentLength()) != -1L ? contentLength - this.bytesToSkip : -1L);
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart((Object)this, dataSpec);
        }
        return this.bytesToRead;
    }

    public int read(byte[] buffer, int offset, int readLength) throws HttpDataSource.HttpDataSourceException {
        try {
            this.skipInternal();
            return this.readInternal(buffer, offset, readLength);
        }
        catch (IOException e) {
            throw new HttpDataSource.HttpDataSourceException(e, this.dataSpec, 2);
        }
    }

    public void close() throws HttpDataSource.HttpDataSourceException {
        if (this.opened) {
            this.opened = false;
            if (this.listener != null) {
                this.listener.onTransferEnd((Object)this);
            }
            this.closeConnectionQuietly();
        }
    }

    protected final long bytesSkipped() {
        return this.bytesSkipped;
    }

    protected final long bytesRead() {
        return this.bytesRead;
    }

    protected final long bytesRemaining() {
        return this.bytesToRead == -1L ? this.bytesToRead : this.bytesToRead - this.bytesRead;
    }

    private Request makeRequest(DataSpec dataSpec) {
        long position = dataSpec.position;
        long length = dataSpec.length;
        boolean allowGzip = dataSpec.isFlagSet(1);
        HttpUrl url = HttpUrl.parse((String)dataSpec.uri.toString());
        Request.Builder builder = new Request.Builder().url(url);
        if (this.cacheControl != null) {
            builder.cacheControl(this.cacheControl);
        }
        if (this.defaultRequestProperties != null) {
            for (Map.Entry property : this.defaultRequestProperties.getSnapshot().entrySet()) {
                builder.header((String)property.getKey(), (String)property.getValue());
            }
        }
        for (Map.Entry property : this.requestProperties.getSnapshot().entrySet()) {
            builder.header((String)property.getKey(), (String)property.getValue());
        }
        if (position != 0L || length != -1L) {
            String rangeRequest = "bytes=" + position + "-";
            if (length != -1L) {
                rangeRequest = rangeRequest + (position + length - 1L);
            }
            builder.addHeader("Range", rangeRequest);
        }
        if (this.userAgent != null) {
            builder.addHeader("User-Agent", this.userAgent);
        }
        if (!allowGzip) {
            builder.addHeader("Accept-Encoding", "identity");
        }
        if (dataSpec.postBody != null) {
            builder.post(RequestBody.create(null, (byte[])dataSpec.postBody));
        }
        return builder.build();
    }

    private void skipInternal() throws IOException {
        if (this.bytesSkipped == this.bytesToSkip) {
            return;
        }
        byte[] skipBuffer = skipBufferReference.getAndSet(null);
        if (skipBuffer == null) {
            skipBuffer = new byte[4096];
        }
        while (this.bytesSkipped != this.bytesToSkip) {
            int readLength = (int)Math.min(this.bytesToSkip - this.bytesSkipped, (long)skipBuffer.length);
            int read = this.responseByteStream.read(skipBuffer, 0, readLength);
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            if (read == -1) {
                throw new EOFException();
            }
            this.bytesSkipped += (long)read;
            if (this.listener == null) continue;
            this.listener.onBytesTransferred((Object)this, read);
        }
        skipBufferReference.set(skipBuffer);
    }

    private int readInternal(byte[] buffer, int offset, int readLength) throws IOException {
        int read;
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesToRead != -1L) {
            long bytesRemaining = this.bytesToRead - this.bytesRead;
            if (bytesRemaining == 0L) {
                return -1;
            }
            readLength = (int)Math.min((long)readLength, bytesRemaining);
        }
        if ((read = this.responseByteStream.read(buffer, offset, readLength)) == -1) {
            if (this.bytesToRead != -1L) {
                throw new EOFException();
            }
            return -1;
        }
        this.bytesRead += (long)read;
        if (this.listener != null) {
            this.listener.onBytesTransferred((Object)this, read);
        }
        return read;
    }

    private void closeConnectionQuietly() {
        this.response.body().close();
        this.response = null;
        this.responseByteStream = null;
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.okhttp");
        skipBufferReference = new AtomicReference();
    }
}

