/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.util.Pair;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.effect.DebugTraceUtil;
import com.google.android.exoplayer2.effect.Presentation;
import com.google.android.exoplayer2.mediacodec.MediaCodecUtil;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.EditedMediaItem;
import com.google.android.exoplayer2.transformer.EncoderUtil;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.SamplePipeline;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Consumer;
import com.google.android.exoplayer2.util.DebugViewProvider;
import com.google.android.exoplayer2.util.Effect;
import com.google.android.exoplayer2.util.FrameInfo;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.OnInputFrameProcessedListener;
import com.google.android.exoplayer2.util.Size;
import com.google.android.exoplayer2.util.SurfaceInfo;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.util.VideoFrameProcessingException;
import com.google.android.exoplayer2.util.VideoFrameProcessor;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.dataflow.qual.Pure;

@Deprecated
final class VideoSamplePipeline
extends SamplePipeline {
    private static final String TAG = "VideoSamplePipeline";
    private final AtomicLong mediaItemOffsetUs = new AtomicLong();
    private final VideoFrameProcessor videoFrameProcessor;
    private final ColorInfo videoFrameProcessorInputColor;
    private final EncoderWrapper encoderWrapper;
    private final DecoderInputBuffer encoderOutputBuffer = new DecoderInputBuffer(0);
    private volatile boolean encoderExpectsTimestampZero;
    private volatile long finalFramePresentationTimeUs = -9223372036854775807L;

    public VideoSamplePipeline(Context context, Format firstInputFormat, TransformationRequest transformationRequest, ImmutableList<Effect> effects, @Nullable Presentation presentation, VideoFrameProcessor.Factory videoFrameProcessorFactory, Codec.EncoderFactory encoderFactory, MuxerWrapper muxerWrapper, final Consumer<ExportException> errorConsumer, FallbackListener fallbackListener, DebugViewProvider debugViewProvider) throws ExportException {
        super(firstInputFormat, muxerWrapper);
        boolean isGlToneMapping;
        ColorInfo decoderInputColor;
        if (firstInputFormat.colorInfo == null || !firstInputFormat.colorInfo.isValid()) {
            Log.d((String)TAG, (String)"colorInfo is null or invalid. Defaulting to SDR_BT709_LIMITED.");
            decoderInputColor = ColorInfo.SDR_BT709_LIMITED;
        } else {
            decoderInputColor = firstInputFormat.colorInfo;
        }
        this.encoderWrapper = new EncoderWrapper(encoderFactory, firstInputFormat.buildUpon().setColorInfo(decoderInputColor).build(), (List<String>)muxerWrapper.getSupportedSampleMimeTypes(2), transformationRequest, fallbackListener);
        boolean isMediaCodecToneMapping = this.encoderWrapper.getHdrModeAfterFallback() == 1 && ColorInfo.isTransferHdr((ColorInfo)decoderInputColor);
        this.videoFrameProcessorInputColor = isMediaCodecToneMapping ? ColorInfo.SDR_BT709_LIMITED : decoderInputColor;
        boolean bl = isGlToneMapping = ColorInfo.isTransferHdr((ColorInfo)decoderInputColor) && transformationRequest.hdrMode == 2;
        ColorInfo videoFrameProcessorOutputColor = this.videoFrameProcessorInputColor.colorTransfer == 2 ? ColorInfo.SDR_BT709_LIMITED : (isGlToneMapping ? new ColorInfo.Builder().setColorSpace(1).setColorRange(2).setColorTransfer(10).build() : this.videoFrameProcessorInputColor);
        ArrayList<Effect> effectsWithPresentation = new ArrayList<Effect>((Collection<Effect>)effects);
        if (presentation != null) {
            effectsWithPresentation.add((Effect)presentation);
        }
        try {
            this.videoFrameProcessor = videoFrameProcessorFactory.create(context, effectsWithPresentation, debugViewProvider, this.videoFrameProcessorInputColor, videoFrameProcessorOutputColor, true, MoreExecutors.directExecutor(), new VideoFrameProcessor.Listener(){
                private long lastProcessedFramePresentationTimeUs;

                public void onOutputSizeChanged(int width, int height) {
                    try {
                        ((VideoFrameProcessor)Assertions.checkNotNull((Object)VideoSamplePipeline.this.videoFrameProcessor)).setOutputSurfaceInfo(VideoSamplePipeline.this.encoderWrapper.getSurfaceInfo(width, height));
                    }
                    catch (ExportException exception) {
                        errorConsumer.accept((Object)exception);
                    }
                }

                public void onOutputFrameAvailableForRendering(long presentationTimeUs) {
                    if (presentationTimeUs == 0L) {
                        VideoSamplePipeline.this.encoderExpectsTimestampZero = true;
                    }
                    this.lastProcessedFramePresentationTimeUs = presentationTimeUs;
                }

                public void onError(VideoFrameProcessingException exception) {
                    errorConsumer.accept((Object)ExportException.createForVideoFrameProcessingException(exception));
                }

                public void onEnded() {
                    VideoSamplePipeline.this.finalFramePresentationTimeUs = this.lastProcessedFramePresentationTimeUs;
                    try {
                        VideoSamplePipeline.this.encoderWrapper.signalEndOfInputStream();
                    }
                    catch (ExportException exception) {
                        errorConsumer.accept((Object)exception);
                    }
                }
            });
        }
        catch (VideoFrameProcessingException e) {
            throw ExportException.createForVideoFrameProcessingException(e);
        }
    }

    @Override
    public void onMediaItemChanged(EditedMediaItem editedMediaItem, long durationUs, @Nullable Format trackFormat, boolean isLast) {
        if (trackFormat != null) {
            Size decodedSize = VideoSamplePipeline.getDecodedSize(trackFormat);
            this.videoFrameProcessor.registerInputStream(VideoSamplePipeline.getInputType((String)Assertions.checkNotNull((Object)trackFormat.sampleMimeType)));
            this.videoFrameProcessor.setInputFrameInfo(new FrameInfo.Builder(decodedSize.getWidth(), decodedSize.getHeight()).setPixelWidthHeightRatio(trackFormat.pixelWidthHeightRatio).setOffsetToAddUs(this.mediaItemOffsetUs.get()).build());
        }
        this.mediaItemOffsetUs.addAndGet(durationUs);
    }

    @Override
    public boolean queueInputBitmap(Bitmap inputBitmap, long durationUs, int frameRate) {
        this.videoFrameProcessor.queueInputBitmap(inputBitmap, durationUs, (float)frameRate);
        return true;
    }

    @Override
    public void setOnInputFrameProcessedListener(OnInputFrameProcessedListener listener) {
        this.videoFrameProcessor.setOnInputFrameProcessedListener(listener);
    }

    @Override
    public boolean queueInputTexture(int texId, long presentationTimeUs) {
        this.videoFrameProcessor.queueInputTexture(texId, presentationTimeUs);
        return true;
    }

    @Override
    public Surface getInputSurface() {
        return this.videoFrameProcessor.getInputSurface();
    }

    @Override
    public ColorInfo getExpectedInputColorInfo() {
        return this.videoFrameProcessorInputColor;
    }

    @Override
    public boolean registerVideoFrame(long presentationTimeUs) {
        this.videoFrameProcessor.registerInputFrame();
        return true;
    }

    @Override
    public int getPendingVideoFrameCount() {
        return this.videoFrameProcessor.getPendingInputFrameCount();
    }

    @Override
    public void signalEndOfVideoInput() {
        this.videoFrameProcessor.signalEndOfInput();
    }

    @Override
    public void release() {
        this.videoFrameProcessor.release();
        this.encoderWrapper.release();
    }

    @Override
    @Nullable
    protected Format getMuxerInputFormat() throws ExportException {
        return this.encoderWrapper.getOutputFormat();
    }

    @Override
    @Nullable
    protected DecoderInputBuffer getMuxerInputBuffer() throws ExportException {
        this.encoderOutputBuffer.data = this.encoderWrapper.getOutputBuffer();
        if (this.encoderOutputBuffer.data == null) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo = (MediaCodec.BufferInfo)Assertions.checkNotNull((Object)this.encoderWrapper.getOutputBufferInfo());
        if (bufferInfo.presentationTimeUs == 0L) {
            if (this.encoderExpectsTimestampZero) {
                this.encoderExpectsTimestampZero = false;
            } else if (this.finalFramePresentationTimeUs != -9223372036854775807L && bufferInfo.size > 0) {
                bufferInfo.presentationTimeUs = this.finalFramePresentationTimeUs;
            }
        }
        DebugTraceUtil.recordEncodedFrame();
        this.encoderOutputBuffer.timeUs = bufferInfo.presentationTimeUs;
        this.encoderOutputBuffer.setFlags(bufferInfo.flags);
        return this.encoderOutputBuffer;
    }

    @Override
    protected void releaseMuxerInputBuffer() throws ExportException {
        this.encoderWrapper.releaseOutputBuffer(false);
    }

    @Override
    protected boolean isMuxerInputEnded() {
        return this.encoderWrapper.isEnded();
    }

    private static int getInputType(String sampleMimeType) {
        if (MimeTypes.isImage((String)sampleMimeType)) {
            return 2;
        }
        if (sampleMimeType.equals("video/raw")) {
            return 3;
        }
        if (MimeTypes.isVideo((String)sampleMimeType)) {
            return 1;
        }
        throw new IllegalArgumentException("MIME type not supported " + sampleMimeType);
    }

    private static Size getDecodedSize(Format format) {
        int decodedWidth = format.rotationDegrees % 180 == 0 ? format.width : format.height;
        int decodedHeight = format.rotationDegrees % 180 == 0 ? format.height : format.width;
        return new Size(decodedWidth, decodedHeight);
    }

    @VisibleForTesting
    static final class EncoderWrapper {
        private static final String DEFAULT_OUTPUT_MIME_TYPE = "video/hevc";
        private final Codec.EncoderFactory encoderFactory;
        private final Format inputFormat;
        private final List<String> muxerSupportedMimeTypes;
        private final TransformationRequest transformationRequest;
        private final FallbackListener fallbackListener;
        private final String requestedOutputMimeType;
        private final int hdrModeAfterFallback;
        private @MonotonicNonNull SurfaceInfo encoderSurfaceInfo;
        private volatile @MonotonicNonNull Codec encoder;
        private volatile int outputRotationDegrees;
        private volatile boolean releaseEncoder;

        public EncoderWrapper(Codec.EncoderFactory encoderFactory, Format inputFormat, List<String> muxerSupportedMimeTypes, TransformationRequest transformationRequest, FallbackListener fallbackListener) {
            Assertions.checkArgument((inputFormat.colorInfo != null ? 1 : 0) != 0);
            this.encoderFactory = encoderFactory;
            this.inputFormat = inputFormat;
            this.muxerSupportedMimeTypes = muxerSupportedMimeTypes;
            this.transformationRequest = transformationRequest;
            this.fallbackListener = fallbackListener;
            Pair<String, Integer> outputMimeTypeAndHdrModeAfterFallback = EncoderWrapper.getRequestedOutputMimeTypeAndHdrModeAfterFallback(inputFormat, transformationRequest);
            this.requestedOutputMimeType = (String)outputMimeTypeAndHdrModeAfterFallback.first;
            this.hdrModeAfterFallback = (Integer)outputMimeTypeAndHdrModeAfterFallback.second;
        }

        private static Pair<String, Integer> getRequestedOutputMimeTypeAndHdrModeAfterFallback(Format inputFormat, TransformationRequest transformationRequest) {
            String inputSampleMimeType = (String)Assertions.checkNotNull((Object)inputFormat.sampleMimeType);
            String requestedOutputMimeType = transformationRequest.videoMimeType != null ? transformationRequest.videoMimeType : (MimeTypes.isImage((String)inputSampleMimeType) ? DEFAULT_OUTPUT_MIME_TYPE : inputSampleMimeType);
            int hdrMode = transformationRequest.hdrMode;
            if (hdrMode == 0 && ColorInfo.isTransferHdr((ColorInfo)inputFormat.colorInfo)) {
                String alternativeMimeType;
                ImmutableList<MediaCodecInfo> hdrEncoders = EncoderUtil.getSupportedEncodersForHdrEditing(requestedOutputMimeType, inputFormat.colorInfo);
                if (hdrEncoders.isEmpty() && (alternativeMimeType = MediaCodecUtil.getAlternativeCodecMimeType((Format)inputFormat)) != null) {
                    requestedOutputMimeType = alternativeMimeType;
                    hdrEncoders = EncoderUtil.getSupportedEncodersForHdrEditing(alternativeMimeType, inputFormat.colorInfo);
                }
                if (hdrEncoders.isEmpty()) {
                    hdrMode = 1;
                }
            }
            return Pair.create((Object)requestedOutputMimeType, (Object)hdrMode);
        }

        public int getHdrModeAfterFallback() {
            return this.hdrModeAfterFallback;
        }

        @Nullable
        public SurfaceInfo getSurfaceInfo(int requestedWidth, int requestedHeight) throws ExportException {
            if (this.releaseEncoder) {
                return null;
            }
            if (this.encoderSurfaceInfo != null) {
                return this.encoderSurfaceInfo;
            }
            if (requestedWidth < requestedHeight) {
                int temp = requestedWidth;
                requestedWidth = requestedHeight;
                requestedHeight = temp;
                this.outputRotationDegrees = 90;
            }
            Format requestedEncoderFormat = new Format.Builder().setWidth(requestedWidth).setHeight(requestedHeight).setRotationDegrees(0).setFrameRate(this.inputFormat.frameRate).setSampleMimeType(this.requestedOutputMimeType).setColorInfo(this.getSupportedInputColor()).build();
            this.encoder = this.encoderFactory.createForVideoEncoding(requestedEncoderFormat.buildUpon().setSampleMimeType(SamplePipeline.findSupportedMimeTypeForEncoderAndMuxer(requestedEncoderFormat, this.muxerSupportedMimeTypes)).build());
            Format actualEncoderFormat = this.encoder.getConfigurationFormat();
            this.fallbackListener.onTransformationRequestFinalized(EncoderWrapper.createSupportedTransformationRequest(this.transformationRequest, this.outputRotationDegrees != 0, requestedEncoderFormat, actualEncoderFormat, this.hdrModeAfterFallback));
            this.encoderSurfaceInfo = new SurfaceInfo(this.encoder.getInputSurface(), actualEncoderFormat.width, actualEncoderFormat.height, this.outputRotationDegrees);
            if (this.releaseEncoder) {
                this.encoder.release();
            }
            return this.encoderSurfaceInfo;
        }

        private ColorInfo getSupportedInputColor() {
            boolean isInputToneMapped;
            boolean bl = isInputToneMapped = ColorInfo.isTransferHdr((ColorInfo)this.inputFormat.colorInfo) && this.hdrModeAfterFallback != 0;
            if (isInputToneMapped) {
                return ColorInfo.SDR_BT709_LIMITED;
            }
            if (ColorInfo.SRGB_BT709_FULL.equals((Object)this.inputFormat.colorInfo)) {
                return ColorInfo.SDR_BT709_LIMITED;
            }
            return (ColorInfo)Assertions.checkNotNull((Object)this.inputFormat.colorInfo);
        }

        @Pure
        private static TransformationRequest createSupportedTransformationRequest(TransformationRequest transformationRequest, boolean hasOutputFormatRotation, Format requestedFormat, Format supportedFormat, int supportedHdrMode) {
            TransformationRequest.Builder supportedRequestBuilder = transformationRequest.buildUpon();
            if (transformationRequest.hdrMode != supportedHdrMode) {
                supportedRequestBuilder.setHdrMode(supportedHdrMode);
            }
            if (!Util.areEqual((Object)requestedFormat.sampleMimeType, (Object)supportedFormat.sampleMimeType)) {
                supportedRequestBuilder.setVideoMimeType(supportedFormat.sampleMimeType);
            }
            if (hasOutputFormatRotation) {
                if (requestedFormat.width != supportedFormat.width) {
                    supportedRequestBuilder.setResolution(supportedFormat.width);
                }
            } else if (requestedFormat.height != supportedFormat.height) {
                supportedRequestBuilder.setResolution(supportedFormat.height);
            }
            return supportedRequestBuilder.build();
        }

        public void signalEndOfInputStream() throws ExportException {
            if (this.encoder != null) {
                this.encoder.signalEndOfInputStream();
            }
        }

        @Nullable
        public Format getOutputFormat() throws ExportException {
            if (this.encoder == null) {
                return null;
            }
            Format outputFormat = this.encoder.getOutputFormat();
            if (outputFormat != null && this.outputRotationDegrees != 0) {
                outputFormat = outputFormat.buildUpon().setRotationDegrees(this.outputRotationDegrees).build();
            }
            return outputFormat;
        }

        @Nullable
        public ByteBuffer getOutputBuffer() throws ExportException {
            return this.encoder != null ? this.encoder.getOutputBuffer() : null;
        }

        @Nullable
        public MediaCodec.BufferInfo getOutputBufferInfo() throws ExportException {
            return this.encoder != null ? this.encoder.getOutputBufferInfo() : null;
        }

        public void releaseOutputBuffer(boolean render) throws ExportException {
            if (this.encoder != null) {
                this.encoder.releaseOutputBuffer(render);
            }
        }

        public boolean isEnded() {
            return this.encoder != null && this.encoder.isEnded();
        }

        public void release() {
            if (this.encoder != null) {
                this.encoder.release();
            }
            this.releaseEncoder = true;
        }
    }
}

