/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.effect.Presentation;
import com.google.android.exoplayer2.effect.ScaleAndRotateTransformation;
import com.google.android.exoplayer2.transformer.AssetLoader;
import com.google.android.exoplayer2.transformer.AudioSamplePipeline;
import com.google.android.exoplayer2.transformer.CapturingEncoderFactory;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.Composition;
import com.google.android.exoplayer2.transformer.EditedMediaItem;
import com.google.android.exoplayer2.transformer.EditedMediaItemSequence;
import com.google.android.exoplayer2.transformer.EncodedSamplePipeline;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.transformer.ExportResult;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.OnMediaItemChangedListener;
import com.google.android.exoplayer2.transformer.ProgressHolder;
import com.google.android.exoplayer2.transformer.SampleConsumer;
import com.google.android.exoplayer2.transformer.SamplePipeline;
import com.google.android.exoplayer2.transformer.SequenceAssetLoader;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.transformer.TransformerUtil;
import com.google.android.exoplayer2.transformer.VideoSamplePipeline;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.ConditionVariable;
import com.google.android.exoplayer2.util.Consumer;
import com.google.android.exoplayer2.util.DebugViewProvider;
import com.google.android.exoplayer2.util.Effect;
import com.google.android.exoplayer2.util.HandlerWrapper;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.VideoFrameProcessor;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
final class TransformerInternal
implements MuxerWrapper.Listener {
    private static final int END_REASON_COMPLETED = 0;
    private static final int END_REASON_CANCELLED = 1;
    private static final int END_REASON_ERROR = 2;
    private static final int MSG_START = 0;
    private static final int MSG_REGISTER_SAMPLE_PIPELINE = 1;
    private static final int MSG_DRAIN_PIPELINES = 2;
    private static final int MSG_END = 3;
    private static final int MSG_UPDATE_PROGRESS = 4;
    private static final String TAG = "TransformerInternal";
    private static final int DRAIN_PIPELINES_DELAY_MS = 10;
    private final Context context;
    private final Composition composition;
    private final boolean compositionHasLoopingSequence;
    private final CapturingEncoderFactory encoderFactory;
    private final Listener listener;
    private final HandlerWrapper applicationHandler;
    private final Clock clock;
    private final HandlerThread internalHandlerThread;
    private final HandlerWrapper internalHandler;
    private final List<SequenceAssetLoader> sequenceAssetLoaders;
    private final AtomicInteger trackCountsToReport;
    private final AtomicInteger tracksToAdd;
    private final AtomicBoolean outputHasAudio;
    private final AtomicBoolean outputHasVideo;
    private final List<SamplePipeline> samplePipelines;
    private final Object setMaxSequenceDurationUsLock;
    private final MuxerWrapper muxerWrapper;
    private final ConditionVariable transformerConditionVariable;
    private final ExportResult.Builder exportResultBuilder;
    private boolean isDrainingPipelines;
    private long currentMaxSequenceDurationUs;
    private int nonLoopingSequencesWithNonFinalDuration;
    private int progressState;
    private @MonotonicNonNull RuntimeException cancelException;
    private volatile boolean released;

    public TransformerInternal(Context context, Composition composition, String outputPath, TransformationRequest transformationRequest, AssetLoader.Factory assetLoaderFactory, VideoFrameProcessor.Factory videoFrameProcessorFactory, Codec.EncoderFactory encoderFactory, Muxer.Factory muxerFactory, Listener listener, FallbackListener fallbackListener, HandlerWrapper applicationHandler, DebugViewProvider debugViewProvider, Clock clock) {
        MuxerWrapper muxerWrapper;
        HandlerWrapper internalHandler;
        this.context = context;
        this.composition = composition;
        this.encoderFactory = new CapturingEncoderFactory(encoderFactory);
        this.listener = listener;
        this.applicationHandler = applicationHandler;
        this.clock = clock;
        this.internalHandlerThread = new HandlerThread("Transformer:Internal");
        this.internalHandlerThread.start();
        this.sequenceAssetLoaders = new ArrayList<SequenceAssetLoader>();
        Looper internalLooper = this.internalHandlerThread.getLooper();
        for (int i = 0; i < composition.sequences.size(); ++i) {
            SequenceAssetLoaderListener sequenceAssetLoaderListener = new SequenceAssetLoaderListener(i, composition, transformationRequest, videoFrameProcessorFactory, fallbackListener, debugViewProvider);
            EditedMediaItemSequence sequence = (EditedMediaItemSequence)composition.sequences.get(i);
            this.sequenceAssetLoaders.add(new SequenceAssetLoader(sequence, composition.forceAudioTrack, assetLoaderFactory, internalLooper, sequenceAssetLoaderListener, clock));
            if (sequence.isLooping) continue;
            ++this.nonLoopingSequencesWithNonFinalDuration;
        }
        this.compositionHasLoopingSequence = this.nonLoopingSequencesWithNonFinalDuration != composition.sequences.size();
        this.trackCountsToReport = new AtomicInteger(composition.sequences.size());
        this.tracksToAdd = new AtomicInteger();
        this.outputHasAudio = new AtomicBoolean();
        this.outputHasVideo = new AtomicBoolean();
        this.samplePipelines = new ArrayList<SamplePipeline>();
        this.setMaxSequenceDurationUsLock = new Object();
        this.transformerConditionVariable = new ConditionVariable();
        this.exportResultBuilder = new ExportResult.Builder();
        this.internalHandler = internalHandler = clock.createHandler(internalLooper, this::handleMessage);
        this.muxerWrapper = muxerWrapper = new MuxerWrapper(outputPath, muxerFactory, this);
    }

    public void start() {
        this.internalHandler.sendEmptyMessage(0);
    }

    public int getProgress(ProgressHolder progressHolder) {
        if (this.released) {
            return 0;
        }
        this.internalHandler.obtainMessage(4, (Object)progressHolder).sendToTarget();
        this.transformerConditionVariable.blockUninterruptible();
        this.transformerConditionVariable.close();
        return this.progressState;
    }

    public void cancel() {
        if (this.released) {
            return;
        }
        this.internalHandler.obtainMessage(3, 1, 0, null).sendToTarget();
        this.clock.onThreadBlocked();
        this.transformerConditionVariable.blockUninterruptible();
        this.transformerConditionVariable.close();
        if (this.cancelException != null) {
            throw this.cancelException;
        }
    }

    @Override
    public void onTrackEnded(int trackType, Format format, int averageBitrate, int sampleCount) {
        if (trackType == 1) {
            this.exportResultBuilder.setAverageAudioBitrate(averageBitrate);
            if (format.channelCount != -1) {
                this.exportResultBuilder.setChannelCount(format.channelCount);
            }
            if (format.sampleRate != -1) {
                this.exportResultBuilder.setSampleRate(format.sampleRate);
            }
        } else if (trackType == 2) {
            this.exportResultBuilder.setAverageVideoBitrate(averageBitrate).setColorInfo(format.colorInfo).setVideoFrameCount(sampleCount);
            if (format.height != -1) {
                this.exportResultBuilder.setHeight(format.height);
            }
            if (format.width != -1) {
                this.exportResultBuilder.setWidth(format.width);
            }
        }
    }

    @Override
    public void onEnded(long durationMs, long fileSizeBytes) {
        this.exportResultBuilder.setDurationMs(durationMs).setFileSizeBytes(fileSizeBytes);
        this.internalHandler.obtainMessage(3, 0, 0, null).sendToTarget();
    }

    @Override
    public void onError(ExportException exportException) {
        this.internalHandler.obtainMessage(3, 2, 0, (Object)exportException).sendToTarget();
    }

    private boolean handleMessage(Message msg) {
        if (this.released && msg.what != 3 && msg.what != 4) {
            return true;
        }
        try {
            switch (msg.what) {
                case 0: {
                    this.startInternal();
                    break;
                }
                case 1: {
                    this.registerSamplePipelineInternal((SamplePipeline)msg.obj);
                    break;
                }
                case 2: {
                    this.drainPipelinesInternal();
                    break;
                }
                case 3: {
                    this.endInternal(msg.arg1, (ExportException)msg.obj);
                    break;
                }
                case 4: {
                    this.updateProgressInternal((ProgressHolder)msg.obj);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (ExportException e) {
            this.endInternal(2, e);
        }
        catch (RuntimeException e) {
            this.endInternal(2, ExportException.createForUnexpected(e));
        }
        return true;
    }

    private void startInternal() {
        for (int i = 0; i < this.sequenceAssetLoaders.size(); ++i) {
            this.sequenceAssetLoaders.get(i).start();
        }
    }

    private void registerSamplePipelineInternal(SamplePipeline samplePipeline) {
        this.samplePipelines.add(samplePipeline);
        if (!this.isDrainingPipelines) {
            this.internalHandler.sendEmptyMessage(2);
            this.isDrainingPipelines = true;
        }
    }

    private void drainPipelinesInternal() throws ExportException {
        for (int i = 0; i < this.samplePipelines.size(); ++i) {
            while (this.samplePipelines.get(i).processData()) {
            }
        }
        if (!this.muxerWrapper.isEnded()) {
            this.internalHandler.sendEmptyMessageDelayed(2, 10);
        }
    }

    private void endInternal(int endReason, @Nullable ExportException exportException) {
        ImmutableList.Builder processedInputsBuilder = new ImmutableList.Builder();
        for (int i = 0; i < this.sequenceAssetLoaders.size(); ++i) {
            processedInputsBuilder.addAll(this.sequenceAssetLoaders.get(i).getProcessedInputs());
        }
        this.exportResultBuilder.setProcessedInputs((ImmutableList<ExportResult.ProcessedInput>)processedInputsBuilder.build()).setAudioEncoderName(this.encoderFactory.getAudioEncoderName()).setVideoEncoderName(this.encoderFactory.getVideoEncoderName());
        boolean forCancellation = endReason == 1;
        ExportException releaseExportException = null;
        boolean releasedPreviously = this.released;
        if (!this.released) {
            block18: {
                int i;
                this.released = true;
                for (i = 0; i < this.samplePipelines.size(); ++i) {
                    try {
                        this.samplePipelines.get(i).release();
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (releaseExportException != null) continue;
                        releaseExportException = ExportException.createForUnexpected(e);
                        this.cancelException = e;
                    }
                }
                for (i = 0; i < this.sequenceAssetLoaders.size(); ++i) {
                    try {
                        this.sequenceAssetLoaders.get(i).release();
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (releaseExportException != null) continue;
                        releaseExportException = ExportException.createForUnexpected(e);
                        this.cancelException = e;
                    }
                }
                try {
                    this.muxerWrapper.release(forCancellation);
                }
                catch (Muxer.MuxerException e) {
                    if (releaseExportException == null) {
                        releaseExportException = ExportException.createForMuxer(e, 7001);
                    }
                }
                catch (RuntimeException e) {
                    if (releaseExportException != null) break block18;
                    releaseExportException = ExportException.createForUnexpected(e);
                    this.cancelException = e;
                }
            }
            this.internalHandler.post(() -> ((HandlerThread)this.internalHandlerThread).quitSafely());
        }
        if (forCancellation) {
            this.transformerConditionVariable.open();
            return;
        }
        ExportException exception = exportException;
        if (exception == null) {
            exception = releaseExportException;
        }
        if (exception != null) {
            if (releasedPreviously) {
                Log.w((String)TAG, (String)"Export error after export ended", (Throwable)exception);
                return;
            }
            ExportException finalException = exception;
            this.applicationHandler.post(() -> this.listener.onError(this.exportResultBuilder.setExportException(finalException).build(), finalException));
        } else {
            if (releasedPreviously) {
                return;
            }
            this.applicationHandler.post(() -> this.listener.onCompleted(this.exportResultBuilder.build()));
        }
    }

    private void updateProgressInternal(ProgressHolder progressHolder) {
        int progressSum = 0;
        int progressCount = 0;
        ProgressHolder individualProgressHolder = new ProgressHolder();
        for (int i = 0; i < this.sequenceAssetLoaders.size(); ++i) {
            if (((EditedMediaItemSequence)this.composition.sequences.get((int)i)).isLooping) continue;
            this.progressState = this.sequenceAssetLoaders.get(i).getProgress(individualProgressHolder);
            if (this.progressState != 2) {
                this.transformerConditionVariable.open();
                return;
            }
            progressSum += individualProgressHolder.progress;
            ++progressCount;
        }
        progressHolder.progress = progressSum / progressCount;
        this.transformerConditionVariable.open();
    }

    private final class SequenceAssetLoaderListener
    implements AssetLoader.Listener {
        private final int sequenceIndex;
        private final ImmutableList<EditedMediaItem> editedMediaItems;
        private final Composition composition;
        private final TransformationRequest transformationRequest;
        private final VideoFrameProcessor.Factory videoFrameProcessorFactory;
        private final FallbackListener fallbackListener;
        private final DebugViewProvider debugViewProvider;
        private final Map<Integer, AddedTrackInfo> addedTrackInfoByTrackType;
        private long currentSequenceDurationUs;

        public SequenceAssetLoaderListener(int sequenceIndex, Composition composition, TransformationRequest transformationRequest, VideoFrameProcessor.Factory videoFrameProcessorFactory, FallbackListener fallbackListener, DebugViewProvider debugViewProvider) {
            this.sequenceIndex = sequenceIndex;
            this.editedMediaItems = ((EditedMediaItemSequence)composition.sequences.get((int)sequenceIndex)).editedMediaItems;
            this.composition = composition;
            this.transformationRequest = transformationRequest;
            this.videoFrameProcessorFactory = videoFrameProcessorFactory;
            this.fallbackListener = fallbackListener;
            this.debugViewProvider = debugViewProvider;
            this.addedTrackInfoByTrackType = new HashMap<Integer, AddedTrackInfo>();
        }

        @Override
        public void onDurationUs(long durationUs) {
        }

        @Override
        public void onTrackCount(int trackCount) {
            if (trackCount <= 0) {
                this.onError(ExportException.createForAssetLoader(new IllegalStateException("AssetLoader instances must provide at least 1 track."), 1001));
                return;
            }
            TransformerInternal.this.tracksToAdd.addAndGet(trackCount);
            TransformerInternal.this.trackCountsToReport.decrementAndGet();
        }

        @Override
        public boolean onTrackAdded(Format firstAssetLoaderInputFormat, int supportedOutputTypes) {
            int trackType = TransformerUtil.getProcessedTrackType(firstAssetLoaderInputFormat.sampleMimeType);
            AddedTrackInfo trackInfo = new AddedTrackInfo(firstAssetLoaderInputFormat, supportedOutputTypes);
            this.addedTrackInfoByTrackType.put(trackType, trackInfo);
            if (trackType == 1) {
                TransformerInternal.this.outputHasAudio.set(true);
            } else {
                TransformerInternal.this.outputHasVideo.set(true);
            }
            if (TransformerInternal.this.tracksToAdd.decrementAndGet() == 0 && TransformerInternal.this.trackCountsToReport.get() == 0) {
                int outputTrackCount = (TransformerInternal.this.outputHasAudio.get() ? 1 : 0) + (TransformerInternal.this.outputHasVideo.get() ? 1 : 0);
                TransformerInternal.this.muxerWrapper.setTrackCount(outputTrackCount);
                this.fallbackListener.setTrackCount(outputTrackCount);
            }
            return trackInfo.shouldTranscode;
        }

        @Override
        @Nullable
        public SampleConsumer onOutputFormat(Format assetLoaderOutputFormat) throws ExportException {
            if (TransformerInternal.this.trackCountsToReport.get() > 0 || TransformerInternal.this.tracksToAdd.get() > 0) {
                return null;
            }
            int trackType = TransformerUtil.getProcessedTrackType(assetLoaderOutputFormat.sampleMimeType);
            AddedTrackInfo trackInfo = (AddedTrackInfo)Assertions.checkStateNotNull((Object)this.addedTrackInfoByTrackType.get(trackType));
            SamplePipeline samplePipeline = this.getSamplePipeline(assetLoaderOutputFormat, trackInfo);
            OnMediaItemChangedListener onMediaItemChangedListener = (editedMediaItem, durationUs, trackFormat, isLast) -> {
                this.onMediaItemChanged(trackType, durationUs, isLast);
                samplePipeline.onMediaItemChanged(editedMediaItem, durationUs, trackFormat, isLast);
            };
            ((SequenceAssetLoader)TransformerInternal.this.sequenceAssetLoaders.get(this.sequenceIndex)).addOnMediaItemChangedListener(onMediaItemChangedListener, trackType);
            TransformerInternal.this.internalHandler.obtainMessage(1, (Object)samplePipeline).sendToTarget();
            return samplePipeline;
        }

        @Override
        public void onError(ExportException exportException) {
            TransformerInternal.this.onError(exportException);
        }

        private SamplePipeline getSamplePipeline(Format firstAssetLoaderOutputFormat, AddedTrackInfo addedTrackInfo) throws ExportException {
            if (addedTrackInfo.shouldTranscode) {
                EditedMediaItem firstEditedMediaItem = (EditedMediaItem)this.editedMediaItems.get(0);
                if (MimeTypes.isAudio((String)firstAssetLoaderOutputFormat.sampleMimeType)) {
                    return new AudioSamplePipeline(addedTrackInfo.firstAssetLoaderInputFormat, firstAssetLoaderOutputFormat, this.transformationRequest, firstEditedMediaItem.flattenForSlowMotion, firstEditedMediaItem.effects.audioProcessors, TransformerInternal.this.encoderFactory, TransformerInternal.this.muxerWrapper, this.fallbackListener);
                }
                ImmutableList<Effect> compositionVideoEffects = this.composition.effects.videoEffects;
                Presentation compositionPresentation = compositionVideoEffects.isEmpty() ? null : (Presentation)compositionVideoEffects.get(0);
                return new VideoSamplePipeline(TransformerInternal.this.context, addedTrackInfo.firstAssetLoaderInputFormat, this.transformationRequest, firstEditedMediaItem.effects.videoEffects, compositionPresentation, this.videoFrameProcessorFactory, TransformerInternal.this.encoderFactory, TransformerInternal.this.muxerWrapper, (Consumer<ExportException>)((Consumer)this::onError), this.fallbackListener, this.debugViewProvider);
            }
            return new EncodedSamplePipeline(firstAssetLoaderOutputFormat, this.transformationRequest, TransformerInternal.this.muxerWrapper, this.fallbackListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onMediaItemChanged(int trackType, long durationUs, boolean isLast) {
            if (!TransformerInternal.this.compositionHasLoopingSequence) {
                return;
            }
            if (this.addedTrackInfoByTrackType.size() > 1 && trackType == 2) {
                return;
            }
            if (((EditedMediaItemSequence)this.composition.sequences.get((int)this.sequenceIndex)).isLooping) {
                return;
            }
            Assertions.checkState((durationUs != -9223372036854775807L ? 1 : 0) != 0, (Object)"MediaItem duration required for sequence looping could not be extracted.");
            this.currentSequenceDurationUs += durationUs;
            Object object = TransformerInternal.this.setMaxSequenceDurationUsLock;
            synchronized (object) {
                boolean isMaxSequenceDurationUsFinal;
                if (isLast) {
                    TransformerInternal.this.nonLoopingSequencesWithNonFinalDuration--;
                }
                boolean bl = isMaxSequenceDurationUsFinal = TransformerInternal.this.nonLoopingSequencesWithNonFinalDuration == 0;
                if (this.currentSequenceDurationUs > TransformerInternal.this.currentMaxSequenceDurationUs || isMaxSequenceDurationUsFinal) {
                    TransformerInternal.this.currentMaxSequenceDurationUs = Math.max(this.currentSequenceDurationUs, TransformerInternal.this.currentMaxSequenceDurationUs);
                    for (int i = 0; i < TransformerInternal.this.sequenceAssetLoaders.size(); ++i) {
                        ((SequenceAssetLoader)TransformerInternal.this.sequenceAssetLoaders.get(i)).setMaxSequenceDurationUs(TransformerInternal.this.currentMaxSequenceDurationUs, isMaxSequenceDurationUsFinal);
                    }
                }
            }
        }

        private final class AddedTrackInfo {
            public final Format firstAssetLoaderInputFormat;
            public final boolean shouldTranscode;

            public AddedTrackInfo(Format firstAssetLoaderInputFormat, int supportedOutputTypes) {
                this.firstAssetLoaderInputFormat = firstAssetLoaderInputFormat;
                this.shouldTranscode = this.shouldTranscode(firstAssetLoaderInputFormat, supportedOutputTypes);
            }

            private boolean shouldTranscode(Format inputFormat, int supportedOutputTypes) {
                boolean assetLoaderCanOutputDecoded = (supportedOutputTypes & 2) != 0;
                boolean assetLoaderCanOutputEncoded = (supportedOutputTypes & 1) != 0;
                Assertions.checkArgument((assetLoaderCanOutputDecoded || assetLoaderCanOutputEncoded ? 1 : 0) != 0);
                int trackType = TransformerUtil.getProcessedTrackType(inputFormat.sampleMimeType);
                boolean shouldTranscode = false;
                if (!assetLoaderCanOutputEncoded) {
                    shouldTranscode = true;
                } else if (trackType == 1) {
                    shouldTranscode = this.shouldTranscodeAudio(inputFormat);
                } else if (trackType == 2) {
                    shouldTranscode = this.shouldTranscodeVideo(inputFormat);
                }
                Assertions.checkState((!shouldTranscode || assetLoaderCanOutputDecoded ? 1 : 0) != 0);
                return shouldTranscode;
            }

            private boolean shouldTranscodeAudio(Format inputFormat) {
                if (((SequenceAssetLoaderListener)SequenceAssetLoaderListener.this).composition.sequences.size() > 1 || SequenceAssetLoaderListener.this.editedMediaItems.size() > 1) {
                    return !((SequenceAssetLoaderListener)SequenceAssetLoaderListener.this).composition.transmuxAudio;
                }
                if (TransformerInternal.this.encoderFactory.audioNeedsEncoding()) {
                    return true;
                }
                if (((SequenceAssetLoaderListener)SequenceAssetLoaderListener.this).transformationRequest.audioMimeType != null && !((SequenceAssetLoaderListener)SequenceAssetLoaderListener.this).transformationRequest.audioMimeType.equals(inputFormat.sampleMimeType)) {
                    return true;
                }
                if (((SequenceAssetLoaderListener)SequenceAssetLoaderListener.this).transformationRequest.audioMimeType == null && !TransformerInternal.this.muxerWrapper.supportsSampleMimeType(inputFormat.sampleMimeType)) {
                    return true;
                }
                EditedMediaItem firstEditedMediaItem = (EditedMediaItem)SequenceAssetLoaderListener.this.editedMediaItems.get(0);
                if (firstEditedMediaItem.flattenForSlowMotion && TransformerUtil.containsSlowMotionData(inputFormat)) {
                    return true;
                }
                return !firstEditedMediaItem.effects.audioProcessors.isEmpty();
            }

            private boolean shouldTranscodeVideo(Format inputFormat) {
                if (((SequenceAssetLoaderListener)SequenceAssetLoaderListener.this).composition.sequences.size() > 1 || SequenceAssetLoaderListener.this.editedMediaItems.size() > 1) {
                    return !((SequenceAssetLoaderListener)SequenceAssetLoaderListener.this).composition.transmuxVideo;
                }
                EditedMediaItem firstEditedMediaItem = (EditedMediaItem)SequenceAssetLoaderListener.this.editedMediaItems.get(0);
                if (firstEditedMediaItem.mediaItem.clippingConfiguration.startPositionMs > 0L && !firstEditedMediaItem.mediaItem.clippingConfiguration.startsAtKeyFrame) {
                    return true;
                }
                if (TransformerInternal.this.encoderFactory.videoNeedsEncoding()) {
                    return true;
                }
                if (((SequenceAssetLoaderListener)SequenceAssetLoaderListener.this).transformationRequest.hdrMode != 0) {
                    return true;
                }
                if (((SequenceAssetLoaderListener)SequenceAssetLoaderListener.this).transformationRequest.videoMimeType != null && !((SequenceAssetLoaderListener)SequenceAssetLoaderListener.this).transformationRequest.videoMimeType.equals(inputFormat.sampleMimeType)) {
                    return true;
                }
                if (((SequenceAssetLoaderListener)SequenceAssetLoaderListener.this).transformationRequest.videoMimeType == null && !TransformerInternal.this.muxerWrapper.supportsSampleMimeType(inputFormat.sampleMimeType)) {
                    return true;
                }
                if (inputFormat.pixelWidthHeightRatio != 1.0f) {
                    return true;
                }
                ImmutableList<Effect> videoEffects = firstEditedMediaItem.effects.videoEffects;
                return !videoEffects.isEmpty() && !TransformerUtil.areVideoEffectsAllNoOp(videoEffects, inputFormat) && !this.hasOnlyRegularRotationEffect(videoEffects);
            }

            private boolean hasOnlyRegularRotationEffect(ImmutableList<Effect> videoEffects) {
                if (videoEffects.size() != 1) {
                    return false;
                }
                Effect videoEffect = (Effect)videoEffects.get(0);
                if (!(videoEffect instanceof ScaleAndRotateTransformation)) {
                    return false;
                }
                ScaleAndRotateTransformation scaleAndRotateTransformation = (ScaleAndRotateTransformation)videoEffect;
                if (scaleAndRotateTransformation.scaleX != 1.0f || scaleAndRotateTransformation.scaleY != 1.0f) {
                    return false;
                }
                float rotationDegrees = scaleAndRotateTransformation.rotationDegrees;
                if (rotationDegrees == 90.0f || rotationDegrees == 180.0f || rotationDegrees == 270.0f) {
                    TransformerInternal.this.muxerWrapper.setAdditionalRotationDegrees(360 - Math.round(rotationDegrees));
                    return true;
                }
                return false;
            }
        }
    }

    public static interface Listener {
        public void onCompleted(ExportResult var1);

        public void onError(ExportResult var1, ExportException var2);
    }
}

