/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.transformer.ExportResult;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
public final class TransformationResult {
    public final ImmutableList<ProcessedInput> processedInputs;
    public final long durationMs;
    public final long fileSizeBytes;
    public final int averageAudioBitrate;
    public final int channelCount;
    public final int sampleRate;
    @Nullable
    public final String audioEncoderName;
    public final int averageVideoBitrate;
    @Nullable
    public final ColorInfo colorInfo;
    public final int height;
    public final int width;
    public final int videoFrameCount;
    @Nullable
    public final String videoEncoderName;
    @Nullable
    public final TransformationException transformationException;

    private TransformationResult(ImmutableList<ProcessedInput> processedInputs, long durationMs, long fileSizeBytes, int averageAudioBitrate, int channelCount, int sampleRate, @Nullable String audioEncoderName, int averageVideoBitrate, @Nullable ColorInfo colorInfo, int height, int width, int videoFrameCount, @Nullable String videoEncoderName, @Nullable TransformationException transformationException) {
        this.processedInputs = processedInputs;
        this.durationMs = durationMs;
        this.fileSizeBytes = fileSizeBytes;
        this.averageAudioBitrate = averageAudioBitrate;
        this.channelCount = channelCount;
        this.sampleRate = sampleRate;
        this.audioEncoderName = audioEncoderName;
        this.averageVideoBitrate = averageVideoBitrate;
        this.colorInfo = colorInfo;
        this.height = height;
        this.width = width;
        this.videoFrameCount = videoFrameCount;
        this.videoEncoderName = videoEncoderName;
        this.transformationException = transformationException;
    }

    public Builder buildUpon() {
        return new Builder().setProcessedInputs(this.processedInputs).setDurationMs(this.durationMs).setFileSizeBytes(this.fileSizeBytes).setAverageAudioBitrate(this.averageAudioBitrate).setChannelCount(this.channelCount).setSampleRate(this.sampleRate).setAudioEncoderName(this.audioEncoderName).setAverageVideoBitrate(this.averageVideoBitrate).setColorInfo(this.colorInfo).setHeight(this.height).setWidth(this.width).setVideoFrameCount(this.videoFrameCount).setVideoEncoderName(this.videoEncoderName).setTransformationException(this.transformationException);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransformationResult)) {
            return false;
        }
        TransformationResult result = (TransformationResult)o;
        return Objects.equals(this.processedInputs, result.processedInputs) && this.durationMs == result.durationMs && this.fileSizeBytes == result.fileSizeBytes && this.averageAudioBitrate == result.averageAudioBitrate && this.channelCount == result.channelCount && this.sampleRate == result.sampleRate && Objects.equals(this.audioEncoderName, result.audioEncoderName) && this.averageVideoBitrate == result.averageVideoBitrate && Objects.equals(this.colorInfo, result.colorInfo) && this.height == result.height && this.width == result.width && this.videoFrameCount == result.videoFrameCount && Objects.equals(this.videoEncoderName, result.videoEncoderName) && Objects.equals(this.transformationException, result.transformationException);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.processedInputs);
        result = 31 * result + (int)this.durationMs;
        result = 31 * result + (int)this.fileSizeBytes;
        result = 31 * result + this.averageAudioBitrate;
        result = 31 * result + this.channelCount;
        result = 31 * result + this.sampleRate;
        result = 31 * result + Objects.hashCode(this.audioEncoderName);
        result = 31 * result + this.averageVideoBitrate;
        result = 31 * result + Objects.hashCode(this.colorInfo);
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        result = 31 * result + this.videoFrameCount;
        result = 31 * result + Objects.hashCode(this.videoEncoderName);
        result = 31 * result + Objects.hashCode(this.transformationException);
        return result;
    }

    @Deprecated
    public static final class ProcessedInput {
        public final MediaItem mediaItem;
        public final @MonotonicNonNull String audioDecoderName;
        public final @MonotonicNonNull String videoDecoderName;

        public ProcessedInput(MediaItem mediaItem, @Nullable String audioDecoderName, @Nullable String videoDecoderName) {
            this.mediaItem = mediaItem;
            this.audioDecoderName = audioDecoderName;
            this.videoDecoderName = videoDecoderName;
        }
    }

    @Deprecated
    public static final class Builder {
        private ImmutableList<ProcessedInput> processedInputs;
        private long durationMs;
        private long fileSizeBytes;
        private int averageAudioBitrate;
        private int channelCount;
        private int sampleRate;
        @Nullable
        private String audioEncoderName;
        private int averageVideoBitrate;
        @Nullable
        ColorInfo colorInfo;
        private int height;
        private int width;
        private int videoFrameCount;
        @Nullable
        private String videoEncoderName;
        @Nullable
        private TransformationException transformationException;

        public Builder() {
            this.processedInputs = ImmutableList.of();
            this.durationMs = -9223372036854775807L;
            this.fileSizeBytes = -1L;
            this.averageAudioBitrate = -2147483647;
            this.channelCount = -1;
            this.sampleRate = -2147483647;
            this.averageVideoBitrate = -2147483647;
            this.height = -1;
            this.width = -1;
        }

        Builder(ExportResult exportResult) {
            ImmutableList.Builder processedInputsBuilder = new ImmutableList.Builder();
            for (int i = 0; i < exportResult.processedInputs.size(); ++i) {
                ExportResult.ProcessedInput processedInput = (ExportResult.ProcessedInput)exportResult.processedInputs.get(i);
                processedInputsBuilder.add((Object)new ProcessedInput(processedInput.mediaItem, processedInput.audioDecoderName, processedInput.videoDecoderName));
            }
            this.processedInputs = processedInputsBuilder.build();
            this.durationMs = exportResult.durationMs;
            this.fileSizeBytes = exportResult.fileSizeBytes;
            this.averageAudioBitrate = exportResult.averageAudioBitrate;
            this.channelCount = exportResult.channelCount;
            this.sampleRate = exportResult.sampleRate;
            this.audioEncoderName = exportResult.audioEncoderName;
            this.averageVideoBitrate = exportResult.averageVideoBitrate;
            this.colorInfo = exportResult.colorInfo;
            this.height = exportResult.height;
            this.width = exportResult.width;
            this.videoFrameCount = exportResult.videoFrameCount;
            this.videoEncoderName = exportResult.videoEncoderName;
            if (exportResult.exportException != null) {
                this.transformationException = new TransformationException(exportResult.exportException);
            }
        }

        @CanIgnoreReturnValue
        public Builder setProcessedInputs(ImmutableList<ProcessedInput> processedInputs) {
            this.processedInputs = processedInputs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDurationMs(long durationMs) {
            Assertions.checkArgument((durationMs >= 0L || durationMs == -9223372036854775807L ? 1 : 0) != 0);
            this.durationMs = durationMs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFileSizeBytes(long fileSizeBytes) {
            Assertions.checkArgument((fileSizeBytes > 0L || fileSizeBytes == -1L ? 1 : 0) != 0);
            this.fileSizeBytes = fileSizeBytes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAverageAudioBitrate(int averageAudioBitrate) {
            Assertions.checkArgument((averageAudioBitrate > 0 || averageAudioBitrate == -2147483647 ? 1 : 0) != 0);
            this.averageAudioBitrate = averageAudioBitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setChannelCount(int channelCount) {
            Assertions.checkArgument((channelCount > 0 || channelCount == -1 ? 1 : 0) != 0);
            this.channelCount = channelCount;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSampleRate(int sampleRate) {
            Assertions.checkArgument((sampleRate > 0 || sampleRate == -2147483647 ? 1 : 0) != 0);
            this.sampleRate = sampleRate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAudioEncoderName(@Nullable String audioEncoderName) {
            this.audioEncoderName = audioEncoderName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAverageVideoBitrate(int averageVideoBitrate) {
            Assertions.checkArgument((averageVideoBitrate > 0 || averageVideoBitrate == -2147483647 ? 1 : 0) != 0);
            this.averageVideoBitrate = averageVideoBitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setColorInfo(@Nullable ColorInfo colorInfo) {
            this.colorInfo = colorInfo;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHeight(int height) {
            Assertions.checkArgument((height > 0 || height == -1 ? 1 : 0) != 0);
            this.height = height;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWidth(int width) {
            Assertions.checkArgument((width > 0 || width == -1 ? 1 : 0) != 0);
            this.width = width;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setVideoFrameCount(int videoFrameCount) {
            Assertions.checkArgument((videoFrameCount >= 0 ? 1 : 0) != 0);
            this.videoFrameCount = videoFrameCount;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setVideoEncoderName(@Nullable String videoEncoderName) {
            this.videoEncoderName = videoEncoderName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTransformationException(@Nullable TransformationException transformationException) {
            this.transformationException = transformationException;
            return this;
        }

        public TransformationResult build() {
            return new TransformationResult(this.processedInputs, this.durationMs, this.fileSizeBytes, this.averageAudioBitrate, this.channelCount, this.sampleRate, this.audioEncoderName, this.averageVideoBitrate, this.colorInfo, this.height, this.width, this.videoFrameCount, this.videoEncoderName, this.transformationException);
        }
    }
}

