/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Deprecated
public final class TransformationRequest {
    public static final int HDR_MODE_KEEP_HDR = 0;
    public static final int HDR_MODE_TONE_MAP_HDR_TO_SDR_USING_MEDIACODEC = 1;
    public static final int HDR_MODE_TONE_MAP_HDR_TO_SDR_USING_OPEN_GL = 2;
    public static final int HDR_MODE_EXPERIMENTAL_FORCE_INTERPRET_HDR_AS_SDR = 3;
    public final int outputHeight;
    @Nullable
    public final String audioMimeType;
    @Nullable
    public final String videoMimeType;
    public final int hdrMode;

    private TransformationRequest(int outputHeight, @Nullable String audioMimeType, @Nullable String videoMimeType, int hdrMode) {
        this.outputHeight = outputHeight;
        this.audioMimeType = audioMimeType;
        this.videoMimeType = videoMimeType;
        this.hdrMode = hdrMode;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransformationRequest)) {
            return false;
        }
        TransformationRequest that = (TransformationRequest)o;
        return this.outputHeight == that.outputHeight && Util.areEqual((Object)this.audioMimeType, (Object)that.audioMimeType) && Util.areEqual((Object)this.videoMimeType, (Object)that.videoMimeType) && this.hdrMode == that.hdrMode;
    }

    public int hashCode() {
        int result = this.outputHeight;
        result = 31 * result + (this.audioMimeType != null ? this.audioMimeType.hashCode() : 0);
        result = 31 * result + (this.videoMimeType != null ? this.videoMimeType.hashCode() : 0);
        result = 31 * result + this.hdrMode;
        return result;
    }

    public String toString() {
        return "TransformationRequest{outputHeight=" + this.outputHeight + ", audioMimeType='" + this.audioMimeType + '\'' + ", videoMimeType='" + this.videoMimeType + '\'' + ", hdrMode=" + this.hdrMode + '}';
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public static final class Builder {
        private int outputHeight;
        @Nullable
        private String audioMimeType;
        @Nullable
        private String videoMimeType;
        private int hdrMode;

        public Builder() {
            this.outputHeight = -1;
        }

        private Builder(TransformationRequest transformationRequest) {
            this.outputHeight = transformationRequest.outputHeight;
            this.audioMimeType = transformationRequest.audioMimeType;
            this.videoMimeType = transformationRequest.videoMimeType;
            this.hdrMode = transformationRequest.hdrMode;
        }

        @CanIgnoreReturnValue
        public Builder setVideoMimeType(@Nullable String videoMimeType) {
            Assertions.checkArgument((videoMimeType == null || MimeTypes.isVideo((String)videoMimeType) ? 1 : 0) != 0, (Object)("Not a video MIME type: " + videoMimeType));
            this.videoMimeType = videoMimeType;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAudioMimeType(@Nullable String audioMimeType) {
            Assertions.checkArgument((audioMimeType == null || MimeTypes.isAudio((String)audioMimeType) ? 1 : 0) != 0, (Object)("Not an audio MIME type: " + audioMimeType));
            this.audioMimeType = audioMimeType;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHdrMode(int hdrMode) {
            this.hdrMode = hdrMode;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder setEnableRequestSdrToneMapping(boolean enableRequestSdrToneMapping) {
            if (enableRequestSdrToneMapping) {
                return this.setHdrMode(1);
            }
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder experimental_setEnableHdrEditing(boolean enableHdrEditing) {
            if (enableHdrEditing) {
                return this.setHdrMode(0);
            }
            return this;
        }

        @CanIgnoreReturnValue
        Builder setResolution(int outputHeight) {
            this.outputHeight = outputHeight;
            return this;
        }

        public TransformationRequest build() {
            return new TransformationRequest(this.outputHeight, this.audioMimeType, this.videoMimeType, this.hdrMode);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface HdrMode {
    }
}

