/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.util.VideoFrameProcessingException;
import com.google.common.collect.ImmutableBiMap;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Deprecated
public final class TransformationException
extends Exception {
    public static final int ERROR_CODE_UNSPECIFIED = 1000;
    public static final int ERROR_CODE_FAILED_RUNTIME_CHECK = 1001;
    public static final int ERROR_CODE_IO_UNSPECIFIED = 2000;
    public static final int ERROR_CODE_IO_NETWORK_CONNECTION_FAILED = 2001;
    public static final int ERROR_CODE_IO_NETWORK_CONNECTION_TIMEOUT = 2002;
    public static final int ERROR_CODE_IO_INVALID_HTTP_CONTENT_TYPE = 2003;
    public static final int ERROR_CODE_IO_BAD_HTTP_STATUS = 2004;
    public static final int ERROR_CODE_IO_FILE_NOT_FOUND = 2005;
    public static final int ERROR_CODE_IO_NO_PERMISSION = 2006;
    public static final int ERROR_CODE_IO_CLEARTEXT_NOT_PERMITTED = 2007;
    public static final int ERROR_CODE_IO_READ_POSITION_OUT_OF_RANGE = 2008;
    public static final int ERROR_CODE_DECODER_INIT_FAILED = 3001;
    public static final int ERROR_CODE_DECODING_FAILED = 3002;
    public static final int ERROR_CODE_DECODING_FORMAT_UNSUPPORTED = 3003;
    public static final int ERROR_CODE_ENCODER_INIT_FAILED = 4001;
    public static final int ERROR_CODE_ENCODING_FAILED = 4002;
    public static final int ERROR_CODE_ENCODING_FORMAT_UNSUPPORTED = 4003;
    public static final int ERROR_CODE_VIDEO_FRAME_PROCESSING_FAILED = 5001;
    public static final int ERROR_CODE_AUDIO_PROCESSING_FAILED = 6001;
    public static final int ERROR_CODE_MUXING_FAILED = 7001;
    static final ImmutableBiMap<String, Integer> NAME_TO_ERROR_CODE = new ImmutableBiMap.Builder().put((Object)"ERROR_CODE_FAILED_RUNTIME_CHECK", (Object)1001).put((Object)"ERROR_CODE_IO_UNSPECIFIED", (Object)2000).put((Object)"ERROR_CODE_IO_NETWORK_CONNECTION_FAILED", (Object)2001).put((Object)"ERROR_CODE_IO_NETWORK_CONNECTION_TIMEOUT", (Object)2002).put((Object)"ERROR_CODE_IO_INVALID_HTTP_CONTENT_TYPE", (Object)2003).put((Object)"ERROR_CODE_IO_BAD_HTTP_STATUS", (Object)2004).put((Object)"ERROR_CODE_IO_FILE_NOT_FOUND", (Object)2005).put((Object)"ERROR_CODE_IO_NO_PERMISSION", (Object)2006).put((Object)"ERROR_CODE_IO_CLEARTEXT_NOT_PERMITTED", (Object)2007).put((Object)"ERROR_CODE_IO_READ_POSITION_OUT_OF_RANGE", (Object)2008).put((Object)"ERROR_CODE_DECODER_INIT_FAILED", (Object)3001).put((Object)"ERROR_CODE_DECODING_FAILED", (Object)3002).put((Object)"ERROR_CODE_DECODING_FORMAT_UNSUPPORTED", (Object)3003).put((Object)"ERROR_CODE_ENCODER_INIT_FAILED", (Object)4001).put((Object)"ERROR_CODE_ENCODING_FAILED", (Object)4002).put((Object)"ERROR_CODE_ENCODING_FORMAT_UNSUPPORTED", (Object)4003).put((Object)"ERROR_CODE_VIDEO_FRAME_PROCESSING_FAILED", (Object)5001).put((Object)"ERROR_CODE_AUDIO_PROCESSING_FAILED", (Object)6001).put((Object)"ERROR_CODE_MUXING_FAILED", (Object)7001).buildOrThrow();
    public final int errorCode;
    public final long timestampMs;

    public static String getErrorCodeName(int errorCode) {
        return (String)NAME_TO_ERROR_CODE.inverse().getOrDefault((Object)errorCode, (Object)"invalid error code");
    }

    public String getErrorCodeName() {
        return TransformationException.getErrorCodeName(this.errorCode);
    }

    public static TransformationException createForAssetLoader(Throwable cause, int errorCode) {
        return new TransformationException("Asset loader error", cause, errorCode);
    }

    public static TransformationException createForCodec(Throwable cause, int errorCode, boolean isVideo, boolean isDecoder, Format format) {
        String details = "format=" + format;
        return TransformationException.createForCodec(cause, errorCode, isVideo, isDecoder, details);
    }

    public static TransformationException createForCodec(Throwable cause, int errorCode, boolean isVideo, boolean isDecoder, String details) {
        String componentName = (isVideo ? "Video" : "Audio") + (isDecoder ? "Decoder" : "Encoder");
        String errorMessage = componentName + " error: " + details;
        return new TransformationException(errorMessage, cause, errorCode);
    }

    public static TransformationException createForAudioProcessing(Throwable cause, AudioProcessor.AudioFormat audioFormat) {
        return new TransformationException("Audio processing error, audio_format=" + audioFormat, cause, 6001);
    }

    static TransformationException createForVideoFrameProcessingException(VideoFrameProcessingException cause, int errorCode) {
        return new TransformationException("Video frame processing error", (Throwable)cause, errorCode);
    }

    static TransformationException createForMuxer(Throwable cause, int errorCode) {
        return new TransformationException("Muxer error", cause, errorCode);
    }

    public static TransformationException createForUnexpected(Exception cause) {
        if (cause instanceof RuntimeException) {
            return new TransformationException("Unexpected runtime error", cause, 1001);
        }
        return new TransformationException("Unexpected error", cause, 1000);
    }

    private TransformationException(@Nullable String message, @Nullable Throwable cause, int errorCode) {
        super(message, cause);
        this.errorCode = errorCode;
        this.timestampMs = Clock.DEFAULT.elapsedRealtime();
    }

    TransformationException(ExportException exportException) {
        super(exportException.getMessage(), exportException.getCause());
        this.errorCode = exportException.errorCode;
        this.timestampMs = exportException.timestampMs;
    }

    public boolean errorInfoEquals(@Nullable TransformationException other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Throwable thisCause = this.getCause();
        Throwable thatCause = other.getCause();
        if (thisCause != null && thatCause != null) {
            if (!Util.areEqual((Object)thisCause.getMessage(), (Object)thatCause.getMessage())) {
                return false;
            }
            if (!Util.areEqual(thisCause.getClass(), thatCause.getClass())) {
                return false;
            }
        } else if (thisCause != null || thatCause != null) {
            return false;
        }
        return this.errorCode == other.errorCode && Util.areEqual((Object)this.getMessage(), (Object)other.getMessage()) && this.timestampMs == other.timestampMs;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface ErrorCode {
    }
}

