/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.transformer.AssetLoader;
import com.google.android.exoplayer2.transformer.EditedMediaItem;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.transformer.ProgressHolder;
import com.google.android.exoplayer2.transformer.SampleConsumer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.OnInputFrameProcessedListener;
import com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
public final class TextureAssetLoader
implements AssetLoader {
    private final EditedMediaItem editedMediaItem;
    private final AssetLoader.Listener assetLoaderListener;
    private final Format format;
    private final OnInputFrameProcessedListener frameProcessedListener;
    private @MonotonicNonNull SampleConsumer sampleConsumer;
    private int progressState;
    private boolean isTrackAdded;
    private volatile boolean isStarted;
    private volatile long lastQueuedPresentationTimeUs;

    public TextureAssetLoader(EditedMediaItem editedMediaItem, AssetLoader.Listener assetLoaderListener, Format format, OnInputFrameProcessedListener frameProcessedListener) {
        Assertions.checkArgument((editedMediaItem.durationUs != -9223372036854775807L ? 1 : 0) != 0);
        Assertions.checkArgument((format.height != -1 && format.width != -1 ? 1 : 0) != 0);
        this.editedMediaItem = editedMediaItem;
        this.assetLoaderListener = assetLoaderListener;
        this.format = format.buildUpon().setSampleMimeType("video/raw").build();
        this.frameProcessedListener = frameProcessedListener;
        this.progressState = 0;
    }

    @Override
    public void start() {
        this.progressState = 2;
        this.assetLoaderListener.onDurationUs(this.editedMediaItem.durationUs);
        this.assetLoaderListener.onTrackCount(1);
        this.isStarted = true;
    }

    @Override
    public int getProgress(ProgressHolder progressHolder) {
        if (this.progressState == 2) {
            progressHolder.progress = Math.round((float)this.lastQueuedPresentationTimeUs / (float)this.editedMediaItem.durationUs * 100.0f);
        }
        return this.progressState;
    }

    @Override
    public ImmutableMap<Integer, String> getDecoderNames() {
        return ImmutableMap.of();
    }

    @Override
    public void release() {
        this.progressState = 0;
    }

    public boolean queueInputTexture(int texId, long presentationTimeUs) {
        try {
            if (!this.isTrackAdded) {
                if (!this.isStarted) {
                    return false;
                }
                this.assetLoaderListener.onTrackAdded(this.format, 2);
                this.isTrackAdded = true;
            }
            if (this.sampleConsumer == null) {
                SampleConsumer sampleConsumer = this.assetLoaderListener.onOutputFormat(this.format);
                if (sampleConsumer == null) {
                    return false;
                }
                this.sampleConsumer = sampleConsumer;
                sampleConsumer.setOnInputFrameProcessedListener(this.frameProcessedListener);
            }
            if (!this.sampleConsumer.queueInputTexture(texId, presentationTimeUs)) {
                return false;
            }
            this.lastQueuedPresentationTimeUs = presentationTimeUs;
            return true;
        }
        catch (ExportException e) {
            this.assetLoaderListener.onError(e);
        }
        catch (RuntimeException e) {
            this.assetLoaderListener.onError(ExportException.createForAssetLoader(e, 1000));
        }
        return false;
    }

    public void signalEndOfVideoInput() {
        try {
            ((SampleConsumer)Assertions.checkNotNull((Object)this.sampleConsumer)).signalEndOfVideoInput();
        }
        catch (RuntimeException e) {
            this.assetLoaderListener.onError(ExportException.createForAssetLoader(e, 1000));
        }
    }
}

