/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.util.SparseArray;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.effect.DebugTraceUtil;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@Deprecated
final class MuxerWrapper {
    private static final String TIMER_THREAD_NAME = "Muxer:Timer";
    private static final String MUXER_TIMEOUT_ERROR_FORMAT_STRING = "Abort: no output sample written in the last %d milliseconds. DebugTrace: %s";
    private static final long MAX_TRACK_WRITE_AHEAD_US = Util.msToUs((long)500L);
    private final String outputPath;
    private final Muxer.Factory muxerFactory;
    private final Listener listener;
    private final SparseArray<TrackInfo> trackTypeToInfo;
    private final ScheduledExecutorService abortScheduledExecutorService;
    private boolean isReady;
    private boolean isEnded;
    private int previousTrackType;
    private long minTrackTimeUs;
    private long maxEndedTrackTimeUs;
    private @MonotonicNonNull ScheduledFuture<?> abortScheduledFuture;
    private boolean isAborted;
    private @MonotonicNonNull Muxer muxer;
    private volatile int additionalRotationDegrees;
    private volatile int trackCount;

    public MuxerWrapper(String outputPath, Muxer.Factory muxerFactory, Listener listener) {
        this.outputPath = outputPath;
        this.muxerFactory = muxerFactory;
        this.listener = listener;
        this.trackTypeToInfo = new SparseArray();
        this.previousTrackType = -2;
        this.abortScheduledExecutorService = Util.newSingleThreadScheduledExecutor((String)TIMER_THREAD_NAME);
    }

    public void setAdditionalRotationDegrees(int additionalRotationDegrees) {
        Assertions.checkState((this.trackTypeToInfo.size() == 0 ? 1 : 0) != 0, (Object)"The additional rotation cannot be changed after adding track formats.");
        this.additionalRotationDegrees = additionalRotationDegrees;
    }

    public void setTrackCount(@IntRange(from=1L) int trackCount) {
        Assertions.checkState((this.trackTypeToInfo.size() == 0 ? 1 : 0) != 0, (Object)"The track count cannot be changed after adding track formats.");
        this.trackCount = trackCount;
    }

    public boolean supportsSampleMimeType(@Nullable String mimeType) {
        int trackType = MimeTypes.getTrackType((String)mimeType);
        return this.getSupportedSampleMimeTypes(trackType).contains((Object)mimeType);
    }

    public ImmutableList<String> getSupportedSampleMimeTypes(int trackType) {
        return this.muxerFactory.getSupportedSampleMimeTypes(trackType);
    }

    public void addTrackFormat(Format format) throws Muxer.MuxerException {
        int trackCount = this.trackCount;
        Assertions.checkState((trackCount > 0 ? 1 : 0) != 0, (Object)"The track count should be set before the formats are added.");
        Assertions.checkState((this.trackTypeToInfo.size() < trackCount ? 1 : 0) != 0, (Object)"All track formats have already been added.");
        String sampleMimeType = format.sampleMimeType;
        int trackType = MimeTypes.getTrackType((String)sampleMimeType);
        Assertions.checkArgument((trackType == 1 || trackType == 2 ? 1 : 0) != 0, (Object)("Unsupported track format: " + sampleMimeType));
        Assertions.checkState((this.trackTypeToInfo.get(trackType) == null ? 1 : 0) != 0, (Object)("There is already a track of type " + trackType));
        this.ensureMuxerInitialized();
        if (trackType == 2) {
            format = format.buildUpon().setRotationDegrees((format.rotationDegrees + this.additionalRotationDegrees) % 360).build();
        }
        TrackInfo trackInfo = new TrackInfo(format, this.muxer.addTrack(format));
        this.trackTypeToInfo.put(trackType, (Object)trackInfo);
        if (format.metadata != null) {
            this.muxer.addMetadata(format.metadata);
        }
        if (this.trackTypeToInfo.size() == trackCount) {
            this.isReady = true;
            this.resetAbortTimer();
        }
    }

    public boolean writeSample(int trackType, ByteBuffer data, boolean isKeyFrame, long presentationTimeUs) throws Muxer.MuxerException {
        TrackInfo trackInfo = (TrackInfo)this.trackTypeToInfo.get(trackType);
        Assertions.checkArgument((trackInfo != null ? 1 : 0) != 0, (Object)("Could not write sample because there is no track of type " + trackType));
        boolean canWriteSample = this.canWriteSample(trackType, presentationTimeUs);
        DebugTraceUtil.recordMuxerCanAddSample((int)trackType, (boolean)canWriteSample);
        if (!canWriteSample) {
            return false;
        }
        ++trackInfo.sampleCount;
        trackInfo.bytesWritten += (long)data.remaining();
        trackInfo.timeUs = Math.max(trackInfo.timeUs, presentationTimeUs);
        Assertions.checkNotNull((Object)this.muxer);
        this.resetAbortTimer();
        this.muxer.writeSampleData(trackInfo.index, data, presentationTimeUs, isKeyFrame ? 1 : 0);
        DebugTraceUtil.recordMuxerInput((int)trackType);
        this.previousTrackType = trackType;
        return true;
    }

    public void endTrack(int trackType) {
        TrackInfo trackInfo = (TrackInfo)this.trackTypeToInfo.get(trackType);
        if (trackInfo == null) {
            return;
        }
        this.maxEndedTrackTimeUs = Math.max(this.maxEndedTrackTimeUs, trackInfo.timeUs);
        this.listener.onTrackEnded(trackType, trackInfo.format, trackInfo.getAverageBitrate(), trackInfo.sampleCount);
        DebugTraceUtil.recordMuxerTrackEnded((int)trackType);
        this.trackTypeToInfo.delete(trackType);
        if (this.trackTypeToInfo.size() == 0) {
            this.abortScheduledExecutorService.shutdownNow();
            if (!this.isEnded) {
                this.isEnded = true;
                this.listener.onEnded(Util.usToMs((long)this.maxEndedTrackTimeUs), this.getCurrentOutputSizeBytes());
            }
        }
    }

    public boolean isEnded() {
        return this.isEnded;
    }

    public void release(boolean forCancellation) throws Muxer.MuxerException {
        this.isReady = false;
        this.abortScheduledExecutorService.shutdownNow();
        if (this.muxer != null) {
            this.muxer.release(forCancellation);
        }
    }

    private boolean canWriteSample(int trackType, long presentationTimeUs) {
        if (!this.isReady) {
            return false;
        }
        if (this.trackTypeToInfo.size() == 1) {
            return true;
        }
        if (presentationTimeUs - ((TrackInfo)this.trackTypeToInfo.get((int)trackType)).timeUs > MAX_TRACK_WRITE_AHEAD_US) {
            TrackInfo trackInfoWithMinTimeUs = (TrackInfo)Assertions.checkNotNull((Object)MuxerWrapper.getTrackInfoWithMinTimeUs(this.trackTypeToInfo));
            if (MimeTypes.getTrackType((String)trackInfoWithMinTimeUs.format.sampleMimeType) == trackType) {
                return true;
            }
        }
        if (trackType != this.previousTrackType) {
            this.minTrackTimeUs = ((TrackInfo)Assertions.checkNotNull((Object)MuxerWrapper.getTrackInfoWithMinTimeUs(this.trackTypeToInfo))).timeUs;
        }
        return presentationTimeUs - this.minTrackTimeUs <= MAX_TRACK_WRITE_AHEAD_US;
    }

    @RequiresNonNull(value={"muxer"})
    private void resetAbortTimer() {
        long maxDelayBetweenSamplesMs = this.muxer.getMaxDelayBetweenSamplesMs();
        if (maxDelayBetweenSamplesMs == -9223372036854775807L) {
            return;
        }
        if (this.abortScheduledFuture != null) {
            this.abortScheduledFuture.cancel(false);
        }
        this.abortScheduledFuture = this.abortScheduledExecutorService.schedule(() -> {
            if (this.isAborted) {
                return;
            }
            this.isAborted = true;
            this.listener.onError(ExportException.createForMuxer(new IllegalStateException(Util.formatInvariant((String)MUXER_TIMEOUT_ERROR_FORMAT_STRING, (Object[])new Object[]{maxDelayBetweenSamplesMs, DebugTraceUtil.generateTrace()})), 7002));
        }, maxDelayBetweenSamplesMs, TimeUnit.MILLISECONDS);
    }

    @EnsuresNonNull(value={"muxer"})
    private void ensureMuxerInitialized() throws Muxer.MuxerException {
        if (this.muxer == null) {
            this.muxer = this.muxerFactory.create(this.outputPath);
        }
    }

    private long getCurrentOutputSizeBytes() {
        long fileSize = new File(this.outputPath).length();
        return fileSize > 0L ? fileSize : -1L;
    }

    @Nullable
    private static TrackInfo getTrackInfoWithMinTimeUs(SparseArray<TrackInfo> trackTypeToInfo) {
        if (trackTypeToInfo.size() == 0) {
            return null;
        }
        TrackInfo trackInfoWithMinTimeUs = (TrackInfo)trackTypeToInfo.valueAt(0);
        for (int i = 1; i < trackTypeToInfo.size(); ++i) {
            TrackInfo trackInfo = (TrackInfo)trackTypeToInfo.valueAt(i);
            if (trackInfo.timeUs >= trackInfoWithMinTimeUs.timeUs) continue;
            trackInfoWithMinTimeUs = trackInfo;
        }
        return trackInfoWithMinTimeUs;
    }

    private static final class TrackInfo {
        public final Format format;
        public final int index;
        public long bytesWritten;
        public int sampleCount;
        public long timeUs;

        public TrackInfo(Format format, int index) {
            this.format = format;
            this.index = index;
        }

        public int getAverageBitrate() {
            if (this.timeUs <= 0L || this.bytesWritten <= 0L) {
                return -2147483647;
            }
            return (int)Util.scaleLargeTimestamp((long)this.bytesWritten, (long)8000000L, (long)this.timeUs);
        }
    }

    public static interface Listener {
        public void onTrackEnded(int var1, Format var2, int var3, int var4);

        public void onEnded(long var1, long var3);

        public void onError(ExportException var1);
    }
}

