/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.MediaCodec;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.container.CreationTime;
import com.google.android.exoplayer2.container.Mp4LocationData;
import com.google.android.exoplayer2.container.XmpData;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.mp4.MdtaMetadataEntry;
import com.google.android.exoplayer2.muxer.Mp4Muxer;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.transformer.TransformerUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

@Deprecated
public final class InAppMuxer
implements Muxer {
    private final Mp4Muxer mp4Muxer;
    private final long maxDelayBetweenSamplesMs;
    private final @Nullable MetadataProvider metadataProvider;
    private final List<Mp4Muxer.TrackToken> trackTokenList;
    private final MediaCodec.BufferInfo bufferInfo;
    private final Set<Metadata.Entry> metadataEntries;

    private InAppMuxer(Mp4Muxer mp4Muxer, long maxDelayBetweenSamplesMs, @Nullable MetadataProvider metadataProvider) {
        this.mp4Muxer = mp4Muxer;
        this.maxDelayBetweenSamplesMs = maxDelayBetweenSamplesMs;
        this.metadataProvider = metadataProvider;
        this.trackTokenList = new ArrayList<Mp4Muxer.TrackToken>();
        this.bufferInfo = new MediaCodec.BufferInfo();
        this.metadataEntries = new LinkedHashSet<Metadata.Entry>();
    }

    @Override
    public int addTrack(Format format) {
        Mp4Muxer.TrackToken trackToken = this.mp4Muxer.addTrack(0, format);
        this.trackTokenList.add(trackToken);
        if (MimeTypes.isVideo((String)format.sampleMimeType)) {
            this.mp4Muxer.setOrientation(format.rotationDegrees);
        }
        return this.trackTokenList.size() - 1;
    }

    @Override
    public void writeSampleData(int trackIndex, ByteBuffer data, long presentationTimeUs, int flags) throws Muxer.MuxerException {
        int size = data.remaining();
        this.bufferInfo.set(data.position(), size, presentationTimeUs, TransformerUtil.getMediaCodecFlags(flags));
        try {
            this.mp4Muxer.writeSampleData(this.trackTokenList.get(trackIndex), data, this.bufferInfo);
        }
        catch (IOException e) {
            throw new Muxer.MuxerException("Failed to write sample for trackIndex=" + trackIndex + ", presentationTimeUs=" + presentationTimeUs + ", size=" + size, e);
        }
    }

    @Override
    public void addMetadata(Metadata metadata) {
        for (int i = 0; i < metadata.length(); ++i) {
            Metadata.Entry entry = metadata.get(i);
            if (!(entry instanceof Mp4LocationData) && !(entry instanceof XmpData) && !(entry instanceof CreationTime) && (!(entry instanceof MdtaMetadataEntry) || !((MdtaMetadataEntry)entry).key.equals("com.android.capture.fps") && ((MdtaMetadataEntry)entry).typeIndicator != 1 && ((MdtaMetadataEntry)entry).typeIndicator != 23)) continue;
            this.metadataEntries.add(entry);
        }
    }

    @Override
    public void release(boolean forCancellation) throws Muxer.MuxerException {
        this.writeMetadata();
        try {
            this.mp4Muxer.close();
        }
        catch (IOException e) {
            throw new Muxer.MuxerException("Error closing muxer", e);
        }
    }

    @Override
    public long getMaxDelayBetweenSamplesMs() {
        return this.maxDelayBetweenSamplesMs;
    }

    private void writeMetadata() {
        if (this.metadataProvider != null) {
            LinkedHashSet<Metadata.Entry> metadataEntriesCopy = new LinkedHashSet<Metadata.Entry>(this.metadataEntries);
            this.metadataProvider.updateMetadataEntries(metadataEntriesCopy);
            this.metadataEntries.clear();
            this.metadataEntries.addAll(metadataEntriesCopy);
        }
        for (Metadata.Entry entry : this.metadataEntries) {
            if (entry instanceof Mp4LocationData) {
                this.mp4Muxer.setLocation(((Mp4LocationData)entry).latitude, ((Mp4LocationData)entry).longitude);
                continue;
            }
            if (entry instanceof XmpData) {
                this.mp4Muxer.addXmp(ByteBuffer.wrap(((XmpData)entry).data));
                continue;
            }
            if (entry instanceof CreationTime) {
                this.mp4Muxer.setModificationTime(((CreationTime)entry).timestampMs);
                continue;
            }
            if (entry instanceof MdtaMetadataEntry) {
                MdtaMetadataEntry mdtaMetadataEntry = (MdtaMetadataEntry)entry;
                if (mdtaMetadataEntry.key.equals("com.android.capture.fps")) {
                    byte[] captureFps = mdtaMetadataEntry.value;
                    this.mp4Muxer.setCaptureFps(ByteBuffer.wrap(captureFps).getFloat());
                    continue;
                }
                if (mdtaMetadataEntry.typeIndicator == 1) {
                    this.mp4Muxer.addMetadata(mdtaMetadataEntry.key, (Object)Util.fromUtf8Bytes((byte[])mdtaMetadataEntry.value));
                    continue;
                }
                if (mdtaMetadataEntry.typeIndicator == 23) {
                    this.mp4Muxer.addMetadata(mdtaMetadataEntry.key, (Object)Float.valueOf(Util.toFloat((byte[])mdtaMetadataEntry.value)));
                    continue;
                }
                throw new IllegalStateException("Unsupported MdtaMetadataEntry " + mdtaMetadataEntry.key);
            }
            throw new IllegalStateException("Unsupported Metadata.Entry " + entry.getClass().getName());
        }
    }

    public static final class Factory
    implements Muxer.Factory {
        private final long maxDelayBetweenSamplesMs;
        private final @Nullable MetadataProvider metadataProvider;

        public Factory() {
            this(10000L, null);
        }

        public Factory(long maxDelayBetweenSamplesMs, @Nullable MetadataProvider metadataProvider) {
            this.maxDelayBetweenSamplesMs = maxDelayBetweenSamplesMs;
            this.metadataProvider = metadataProvider;
        }

        @Override
        public InAppMuxer create(String path) throws Muxer.MuxerException {
            FileOutputStream outputStream;
            try {
                outputStream = new FileOutputStream(path);
            }
            catch (FileNotFoundException e) {
                throw new Muxer.MuxerException("Error creating file output stream", e);
            }
            Mp4Muxer mp4Muxer = new Mp4Muxer.Builder(outputStream).build();
            return new InAppMuxer(mp4Muxer, this.maxDelayBetweenSamplesMs, this.metadataProvider);
        }

        @Override
        public ImmutableList<String> getSupportedSampleMimeTypes(int trackType) {
            if (trackType == 2) {
                return Mp4Muxer.SUPPORTED_VIDEO_SAMPLE_MIME_TYPES;
            }
            if (trackType == 1) {
                return Mp4Muxer.SUPPORTED_AUDIO_SAMPLE_MIME_TYPES;
            }
            return ImmutableList.of();
        }
    }

    public static interface MetadataProvider {
        public void updateMetadataEntries(Set<Metadata.Entry> var1);
    }
}

