/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.transformer.AssetLoader;
import com.google.android.exoplayer2.transformer.EditedMediaItem;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.transformer.ProgressHolder;
import com.google.android.exoplayer2.transformer.SampleConsumer;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSourceBitmapLoader;
import com.google.android.exoplayer2.upstream.DefaultDataSource;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@Deprecated
public final class ImageAssetLoader
implements AssetLoader {
    public static final String MIME_TYPE_IMAGE_ALL = "image/*";
    private static final int QUEUE_BITMAP_INTERVAL_MS = 10;
    private final EditedMediaItem editedMediaItem;
    private final DataSource.Factory dataSourceFactory;
    private final AssetLoader.Listener listener;
    private final ScheduledExecutorService scheduledExecutorService;
    @Nullable
    private SampleConsumer sampleConsumer;
    private int progressState;
    private volatile int progress;

    private ImageAssetLoader(Context context, EditedMediaItem editedMediaItem, AssetLoader.Listener listener) {
        Assertions.checkState((editedMediaItem.durationUs != -9223372036854775807L ? 1 : 0) != 0);
        Assertions.checkState((editedMediaItem.frameRate != -2147483647 ? 1 : 0) != 0);
        this.editedMediaItem = editedMediaItem;
        this.dataSourceFactory = new DefaultDataSource.Factory(context);
        this.listener = listener;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.progressState = 0;
    }

    @Override
    public void start() {
        this.progressState = 2;
        this.listener.onDurationUs(this.editedMediaItem.durationUs);
        this.listener.onTrackCount(1);
        DataSourceBitmapLoader bitmapLoader = new DataSourceBitmapLoader((ListeningExecutorService)MoreExecutors.listeningDecorator((ScheduledExecutorService)this.scheduledExecutorService), this.dataSourceFactory);
        MediaItem.LocalConfiguration localConfiguration = (MediaItem.LocalConfiguration)Assertions.checkNotNull((Object)this.editedMediaItem.mediaItem.localConfiguration);
        ListenableFuture future = bitmapLoader.loadBitmap(localConfiguration.uri);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Bitmap>(){

            public void onSuccess(Bitmap bitmap) {
                ImageAssetLoader.this.progress = 50;
                try {
                    Format format = new Format.Builder().setHeight(bitmap.getHeight()).setWidth(bitmap.getWidth()).setSampleMimeType(ImageAssetLoader.MIME_TYPE_IMAGE_ALL).setColorInfo(ColorInfo.SRGB_BT709_FULL).build();
                    ImageAssetLoader.this.listener.onTrackAdded(format, 2);
                    ImageAssetLoader.this.scheduledExecutorService.submit(() -> ImageAssetLoader.this.queueBitmapInternal(bitmap, format));
                }
                catch (RuntimeException e) {
                    ImageAssetLoader.this.listener.onError(ExportException.createForAssetLoader(e, 1000));
                }
            }

            public void onFailure(Throwable t) {
                ImageAssetLoader.this.listener.onError(ExportException.createForAssetLoader(t, 2000));
            }
        }, (Executor)this.scheduledExecutorService);
    }

    @Override
    public int getProgress(ProgressHolder progressHolder) {
        if (this.progressState == 2) {
            progressHolder.progress = this.progress;
        }
        return this.progressState;
    }

    @Override
    public ImmutableMap<Integer, String> getDecoderNames() {
        return ImmutableMap.of();
    }

    @Override
    public void release() {
        this.progressState = 0;
        this.scheduledExecutorService.shutdownNow();
    }

    private void queueBitmapInternal(Bitmap bitmap, Format format) {
        try {
            if (this.sampleConsumer == null) {
                this.sampleConsumer = this.listener.onOutputFormat(format);
            }
            if (this.sampleConsumer == null || !this.sampleConsumer.queueInputBitmap(bitmap, this.editedMediaItem.durationUs, this.editedMediaItem.frameRate)) {
                this.scheduledExecutorService.schedule(() -> this.queueBitmapInternal(bitmap, format), 10L, TimeUnit.MILLISECONDS);
                return;
            }
            this.sampleConsumer.signalEndOfVideoInput();
            this.progress = 100;
        }
        catch (ExportException e) {
            this.listener.onError(e);
        }
        catch (RuntimeException e) {
            this.listener.onError(ExportException.createForAssetLoader(e, 1000));
        }
    }

    public static final class Factory
    implements AssetLoader.Factory {
        private final Context context;

        public Factory(Context context) {
            this.context = context.getApplicationContext();
        }

        @Override
        public AssetLoader createAssetLoader(EditedMediaItem editedMediaItem, Looper looper, AssetLoader.Listener listener) {
            return new ImageAssetLoader(this.context, editedMediaItem, listener);
        }
    }
}

