/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.IntRange;
import com.google.android.exoplayer2.transformer.Composition;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.transformer.Transformer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.HandlerWrapper;
import com.google.android.exoplayer2.util.ListenerSet;
import com.google.android.exoplayer2.util.Util;
import java.util.concurrent.atomic.AtomicInteger;

@Deprecated
final class FallbackListener {
    private final Composition composition;
    private final ListenerSet<Transformer.Listener> transformerListeners;
    private final HandlerWrapper transformerListenerHandler;
    private final TransformationRequest originalTransformationRequest;
    private final AtomicInteger trackCount;
    private TransformationRequest fallbackTransformationRequest;

    public FallbackListener(Composition composition, ListenerSet<Transformer.Listener> transformerListeners, HandlerWrapper transformerListenerHandler, TransformationRequest originalTransformationRequest) {
        this.composition = composition;
        this.transformerListeners = transformerListeners;
        this.transformerListenerHandler = transformerListenerHandler;
        this.originalTransformationRequest = originalTransformationRequest;
        this.fallbackTransformationRequest = originalTransformationRequest;
        this.trackCount = new AtomicInteger();
    }

    public void setTrackCount(@IntRange(from=1L) int trackCount) {
        this.trackCount.set(trackCount);
    }

    public void onTransformationRequestFinalized(TransformationRequest transformationRequest) {
        TransformationRequest newFallbackTransformationRequest;
        Assertions.checkState((this.trackCount.getAndDecrement() > 0 ? 1 : 0) != 0);
        TransformationRequest.Builder fallbackRequestBuilder = this.fallbackTransformationRequest.buildUpon();
        if (!Util.areEqual((Object)transformationRequest.audioMimeType, (Object)this.originalTransformationRequest.audioMimeType)) {
            fallbackRequestBuilder.setAudioMimeType(transformationRequest.audioMimeType);
        }
        if (!Util.areEqual((Object)transformationRequest.videoMimeType, (Object)this.originalTransformationRequest.videoMimeType)) {
            fallbackRequestBuilder.setVideoMimeType(transformationRequest.videoMimeType);
        }
        if (transformationRequest.outputHeight != this.originalTransformationRequest.outputHeight) {
            fallbackRequestBuilder.setResolution(transformationRequest.outputHeight);
        }
        if (transformationRequest.hdrMode != this.originalTransformationRequest.hdrMode) {
            fallbackRequestBuilder.setHdrMode(transformationRequest.hdrMode);
        }
        this.fallbackTransformationRequest = newFallbackTransformationRequest = fallbackRequestBuilder.build();
        if (this.trackCount.get() == 0 && !this.originalTransformationRequest.equals(this.fallbackTransformationRequest)) {
            this.transformerListenerHandler.post(() -> this.transformerListeners.sendEvent(-1, listener -> listener.onFallbackApplied(this.composition, this.originalTransformationRequest, newFallbackTransformationRequest)));
        }
    }
}

