/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.MediaCodec;
import android.view.Surface;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.effect.DebugTraceUtil;
import com.google.android.exoplayer2.transformer.AssetLoader;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.ExoAssetLoaderBaseRenderer;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.transformer.SefSlowMotionFlattener;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.video.ColorInfo;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@Deprecated
final class ExoAssetLoaderVideoRenderer
extends ExoAssetLoaderBaseRenderer {
    private static final String TAG = "ExoAssetLoaderVideoRenderer";
    private final boolean flattenForSlowMotion;
    private final Codec.DecoderFactory decoderFactory;
    private final boolean forceInterpretHdrAsSdr;
    private final List<Long> decodeOnlyPresentationTimestamps;
    private @MonotonicNonNull SefSlowMotionFlattener sefVideoSlowMotionFlattener;
    private int maxDecoderPendingFrameCount;

    public ExoAssetLoaderVideoRenderer(boolean flattenForSlowMotion, Codec.DecoderFactory decoderFactory, boolean forceInterpretHdrAsSdr, TransformerMediaClock mediaClock, AssetLoader.Listener assetLoaderListener) {
        super(2, mediaClock, assetLoaderListener);
        this.flattenForSlowMotion = flattenForSlowMotion;
        this.decoderFactory = decoderFactory;
        this.forceInterpretHdrAsSdr = forceInterpretHdrAsSdr;
        this.decodeOnlyPresentationTimestamps = new ArrayList<Long>();
    }

    public String getName() {
        return TAG;
    }

    @Override
    protected Format overrideFormat(Format inputFormat) {
        if (this.forceInterpretHdrAsSdr && ColorInfo.isTransferHdr((ColorInfo)inputFormat.colorInfo)) {
            return inputFormat.buildUpon().setColorInfo(ColorInfo.SDR_BT709_LIMITED).build();
        }
        return inputFormat;
    }

    @Override
    protected void onInputFormatRead(Format inputFormat) {
        DebugTraceUtil.recordLatestVideoInputFormat((Format)inputFormat);
        if (this.flattenForSlowMotion) {
            this.sefVideoSlowMotionFlattener = new SefSlowMotionFlattener(inputFormat);
        }
    }

    @Override
    protected void initDecoder(Format inputFormat) throws ExportException {
        Assertions.checkStateNotNull((Object)this.sampleConsumer);
        boolean isDecoderToneMappingRequired = ColorInfo.isTransferHdr((ColorInfo)inputFormat.colorInfo) && !ColorInfo.isTransferHdr((ColorInfo)this.sampleConsumer.getExpectedInputColorInfo());
        this.decoder = this.decoderFactory.createForVideoDecoding(inputFormat, (Surface)Assertions.checkNotNull((Object)this.sampleConsumer.getInputSurface()), isDecoderToneMappingRequired);
        this.maxDecoderPendingFrameCount = this.decoder.getMaxPendingFrameCount();
    }

    @Override
    protected boolean shouldDropInputBuffer(DecoderInputBuffer inputBuffer) {
        if (inputBuffer.isEndOfStream()) {
            return false;
        }
        ByteBuffer inputBytes = (ByteBuffer)Assertions.checkNotNull((Object)inputBuffer.data);
        if (this.sefVideoSlowMotionFlattener != null) {
            long presentationTimeUs = inputBuffer.timeUs - this.streamOffsetUs;
            boolean shouldDropInputBuffer = this.sefVideoSlowMotionFlattener.dropOrTransformSample(inputBytes, presentationTimeUs);
            if (shouldDropInputBuffer) {
                inputBytes.clear();
                return true;
            }
            inputBuffer.timeUs = this.streamOffsetUs + this.sefVideoSlowMotionFlattener.getSamplePresentationTimeUs();
        }
        if (this.decoder == null) {
            inputBuffer.timeUs -= this.streamStartPositionUs;
        }
        return false;
    }

    @Override
    protected void onDecoderInputReady(DecoderInputBuffer inputBuffer) {
        if (inputBuffer.isDecodeOnly()) {
            this.decodeOnlyPresentationTimestamps.add(inputBuffer.timeUs);
        }
    }

    @Override
    @RequiresNonNull(value={"sampleConsumer", "decoder"})
    protected boolean feedConsumerFromDecoder() throws ExportException {
        if (this.decoder.isEnded()) {
            DebugTraceUtil.recordDecoderSignalEos();
            this.sampleConsumer.signalEndOfVideoInput();
            this.isEnded = true;
            return false;
        }
        MediaCodec.BufferInfo decoderOutputBufferInfo = this.decoder.getOutputBufferInfo();
        if (decoderOutputBufferInfo == null) {
            return false;
        }
        long presentationTimeUs = decoderOutputBufferInfo.presentationTimeUs - this.streamStartPositionUs;
        if (presentationTimeUs < 0L || this.isDecodeOnlyBuffer(decoderOutputBufferInfo.presentationTimeUs)) {
            this.decoder.releaseOutputBuffer(false);
            return true;
        }
        if (this.sampleConsumer.getPendingVideoFrameCount() == this.maxDecoderPendingFrameCount) {
            return false;
        }
        if (!this.sampleConsumer.registerVideoFrame(presentationTimeUs)) {
            return false;
        }
        this.decoder.releaseOutputBuffer(presentationTimeUs);
        DebugTraceUtil.recordDecodedFrame();
        return true;
    }

    private boolean isDecodeOnlyBuffer(long presentationTimeUs) {
        int size = this.decodeOnlyPresentationTimestamps.size();
        for (int i = 0; i < size; ++i) {
            if (this.decodeOnlyPresentationTimestamps.get(i) != presentationTimeUs) continue;
            this.decodeOnlyPresentationTimestamps.remove(i);
            return true;
        }
        return false;
    }
}

