/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.CamcorderProfile;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Pair;
import android.util.Range;
import android.util.Size;
import androidx.annotation.DoNotInline;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.common.base.Ascii;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.util.Collection;

@Deprecated
public final class EncoderUtil {
    public static final int LEVEL_UNSET = -1;
    @GuardedBy(value="EncoderUtil.class")
    private static final ArrayListMultimap<String, MediaCodecInfo> mimeTypeToEncoders = ArrayListMultimap.create();

    public static synchronized ImmutableList<MediaCodecInfo> getSupportedEncoders(String mimeType) {
        EncoderUtil.maybePopulateEncoderInfo();
        return ImmutableList.copyOf((Collection)mimeTypeToEncoders.get((Object)Ascii.toLowerCase((String)mimeType)));
    }

    public static synchronized ImmutableSet<String> getSupportedMimeTypes() {
        EncoderUtil.maybePopulateEncoderInfo();
        return ImmutableSet.copyOf((Collection)mimeTypeToEncoders.keySet());
    }

    @VisibleForTesting
    public static synchronized void clearCachedEncoders() {
        mimeTypeToEncoders.clear();
    }

    public static ImmutableList<MediaCodecInfo> getSupportedEncodersForHdrEditing(String mimeType, @Nullable ColorInfo colorInfo) {
        if (Util.SDK_INT < 33 || colorInfo == null) {
            return ImmutableList.of();
        }
        ImmutableList<MediaCodecInfo> encoders = EncoderUtil.getSupportedEncoders(mimeType);
        ImmutableList<Integer> allowedColorProfiles = EncoderUtil.getCodecProfilesForHdrFormat(mimeType, colorInfo.colorTransfer);
        ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
        for (int i = 0; i < encoders.size(); ++i) {
            MediaCodecInfo mediaCodecInfo = (MediaCodecInfo)encoders.get(i);
            if (mediaCodecInfo.isAlias() || !EncoderUtil.isFeatureSupported(mediaCodecInfo, mimeType, "hdr-editing")) continue;
            for (MediaCodecInfo.CodecProfileLevel codecProfileLevel : mediaCodecInfo.getCapabilitiesForType((String)mimeType).profileLevels) {
                if (!allowedColorProfiles.contains((Object)codecProfileLevel.profile)) continue;
                resultBuilder.add((Object)mediaCodecInfo);
            }
        }
        return resultBuilder.build();
    }

    public static ImmutableList<Integer> getCodecProfilesForHdrFormat(String mimeType, int colorTransfer) {
        switch (mimeType) {
            case "video/x-vnd.on2.vp9": {
                if (colorTransfer != 7 && colorTransfer != 6) break;
                return ImmutableList.of((Object)4096, (Object)8192);
            }
            case "video/avc": {
                if (colorTransfer != 7) break;
                return ImmutableList.of((Object)16);
            }
            case "video/hevc": {
                if (colorTransfer == 7) {
                    return ImmutableList.of((Object)2);
                }
                if (colorTransfer != 6) break;
                return ImmutableList.of((Object)4096);
            }
            case "video/av01": {
                if (colorTransfer == 7) {
                    return ImmutableList.of((Object)2);
                }
                if (colorTransfer != 6) break;
                return ImmutableList.of((Object)4096);
            }
        }
        return ImmutableList.of();
    }

    public static boolean isSizeSupported(MediaCodecInfo encoderInfo, String mimeType, int width, int height) {
        if (encoderInfo.getCapabilitiesForType(mimeType).getVideoCapabilities().isSizeSupported(width, height)) {
            return true;
        }
        if (width == 1920 && height == 1080) {
            return CamcorderProfile.hasProfile((int)6);
        }
        if (width == 3840 && height == 2160) {
            return CamcorderProfile.hasProfile((int)8);
        }
        return false;
    }

    public static Range<Integer> getSupportedHeights(MediaCodecInfo encoderInfo, String mimeType, int width) {
        return encoderInfo.getCapabilitiesForType(mimeType).getVideoCapabilities().getSupportedHeightsFor(width);
    }

    public static Pair<Range<Integer>, Range<Integer>> getSupportedResolutionRanges(MediaCodecInfo encoderInfo, String mimeType) {
        MediaCodecInfo.VideoCapabilities videoCapabilities = encoderInfo.getCapabilitiesForType(mimeType).getVideoCapabilities();
        return Pair.create((Object)videoCapabilities.getSupportedWidths(), (Object)videoCapabilities.getSupportedHeights());
    }

    @Nullable
    public static Size getSupportedResolution(MediaCodecInfo encoderInfo, String mimeType, int width, int height) {
        float[] reductionFactors;
        int newHeight;
        MediaCodecInfo.VideoCapabilities videoCapabilities = encoderInfo.getCapabilitiesForType(mimeType).getVideoCapabilities();
        int widthAlignment = videoCapabilities.getWidthAlignment();
        int heightAlignment = videoCapabilities.getHeightAlignment();
        int newWidth = EncoderUtil.alignResolution(width, widthAlignment);
        if (EncoderUtil.isSizeSupported(encoderInfo, mimeType, newWidth, newHeight = EncoderUtil.alignResolution(height, heightAlignment))) {
            return new Size(newWidth, newHeight);
        }
        for (float reductionFactor : reductionFactors = new float[]{0.95f, 0.9f, 0.85f, 0.8f, 0.75f, 0.7f, 0.6666667f, 0.6f, 0.55f, 0.5f, 0.4f, 0.33333334f, 0.25f}) {
            newWidth = EncoderUtil.alignResolution(Math.round((float)width * reductionFactor), widthAlignment);
            if (!EncoderUtil.isSizeSupported(encoderInfo, mimeType, newWidth, newHeight = EncoderUtil.alignResolution(Math.round((float)height * reductionFactor), heightAlignment))) continue;
            return new Size(newWidth, newHeight);
        }
        int supportedWidth = (Integer)videoCapabilities.getSupportedWidths().clamp((Comparable)Integer.valueOf(width));
        int adjustedHeight = (Integer)videoCapabilities.getSupportedHeightsFor(supportedWidth).clamp((Comparable)Integer.valueOf(height));
        if (adjustedHeight != height) {
            width = EncoderUtil.alignResolution((int)Math.round((double)width * (double)adjustedHeight / (double)height), widthAlignment);
            height = EncoderUtil.alignResolution(adjustedHeight, heightAlignment);
        }
        return EncoderUtil.isSizeSupported(encoderInfo, mimeType, width, height) ? new Size(width, height) : null;
    }

    public static ImmutableSet<Integer> findSupportedEncodingProfiles(MediaCodecInfo encoderInfo, String mimeType) {
        MediaCodecInfo.CodecProfileLevel[] profileLevels = encoderInfo.getCapabilitiesForType((String)mimeType).profileLevels;
        ImmutableSet.Builder supportedProfilesBuilder = new ImmutableSet.Builder();
        for (MediaCodecInfo.CodecProfileLevel profileLevel : profileLevels) {
            supportedProfilesBuilder.add((Object)profileLevel.profile);
        }
        return supportedProfilesBuilder.build();
    }

    public static int findHighestSupportedEncodingLevel(MediaCodecInfo encoderInfo, String mimeType, int profile) {
        MediaCodecInfo.CodecProfileLevel[] profileLevels = encoderInfo.getCapabilitiesForType((String)mimeType).profileLevels;
        int maxSupportedLevel = -1;
        for (MediaCodecInfo.CodecProfileLevel profileLevel : profileLevels) {
            if (profileLevel.profile != profile) continue;
            maxSupportedLevel = Math.max(maxSupportedLevel, profileLevel.level);
        }
        return maxSupportedLevel;
    }

    @Nullable
    public static String findCodecForFormat(MediaFormat format, boolean isDecoder) {
        String mediaCodecName;
        MediaCodecList mediaCodecList = new MediaCodecList(0);
        float frameRate = -1.0f;
        if (Util.SDK_INT == 21 && format.containsKey("frame-rate")) {
            try {
                frameRate = format.getFloat("frame-rate");
            }
            catch (ClassCastException e) {
                frameRate = format.getInteger("frame-rate");
            }
            format.setString("frame-rate", null);
        }
        String string = mediaCodecName = isDecoder ? mediaCodecList.findDecoderForFormat(format) : mediaCodecList.findEncoderForFormat(format);
        if (Util.SDK_INT == 21) {
            MediaFormatUtil.maybeSetInteger((MediaFormat)format, (String)"frame-rate", (int)Math.round(frameRate));
        }
        return mediaCodecName;
    }

    public static Range<Integer> getSupportedBitrateRange(MediaCodecInfo encoderInfo, String mimeType) {
        return encoderInfo.getCapabilitiesForType(mimeType).getVideoCapabilities().getBitrateRange();
    }

    public static boolean isBitrateModeSupported(MediaCodecInfo encoderInfo, String mimeType, int bitrateMode) {
        return encoderInfo.getCapabilitiesForType(mimeType).getEncoderCapabilities().isBitrateModeSupported(bitrateMode);
    }

    public static ImmutableList<Integer> getSupportedColorFormats(MediaCodecInfo encoderInfo, String mimeType) {
        return ImmutableList.copyOf((Collection)Ints.asList((int[])encoderInfo.getCapabilitiesForType((String)mimeType).colorFormats));
    }

    public static boolean isHardwareAccelerated(MediaCodecInfo encoderInfo, String mimeType) {
        if (Util.SDK_INT >= 29) {
            return Api29.isHardwareAccelerated(encoderInfo);
        }
        return !EncoderUtil.isSoftwareOnly(encoderInfo, mimeType);
    }

    public static boolean isFeatureSupported(MediaCodecInfo encoderInfo, String mimeType, String featureName) {
        return encoderInfo.getCapabilitiesForType(mimeType).isFeatureSupported(featureName);
    }

    @RequiresApi(value=23)
    public static int getMaxSupportedInstances(MediaCodecInfo encoderInfo, String mimeType) {
        return encoderInfo.getCapabilitiesForType(mimeType).getMaxSupportedInstances();
    }

    private static boolean isSoftwareOnly(MediaCodecInfo encoderInfo, String mimeType) {
        if (Util.SDK_INT >= 29) {
            return Api29.isSoftwareOnly(encoderInfo);
        }
        if (MimeTypes.isAudio((String)mimeType)) {
            return true;
        }
        String codecName = Ascii.toLowerCase((String)encoderInfo.getName());
        if (codecName.startsWith("arc.")) {
            return false;
        }
        return codecName.startsWith("omx.google.") || codecName.startsWith("omx.ffmpeg.") || codecName.startsWith("omx.sec.") && codecName.contains(".sw.") || codecName.equals("omx.qcom.video.decoder.hevcswvdec") || codecName.startsWith("c2.android.") || codecName.startsWith("c2.google.") || !codecName.startsWith("omx.") && !codecName.startsWith("c2.");
    }

    private static int alignResolution(int size, int alignment) {
        boolean shouldRoundDown = false;
        if (size % 10 == 1) {
            shouldRoundDown = true;
        }
        return shouldRoundDown ? (int)((double)alignment * Math.floor((float)size / (float)alignment)) : alignment * Math.round((float)size / (float)alignment);
    }

    private static synchronized void maybePopulateEncoderInfo() {
        MediaCodecInfo[] allCodecInfos;
        if (!mimeTypeToEncoders.isEmpty()) {
            return;
        }
        MediaCodecList mediaCodecList = new MediaCodecList(0);
        for (MediaCodecInfo mediaCodecInfo : allCodecInfos = mediaCodecList.getCodecInfos()) {
            String[] supportedMimeTypes;
            if (!mediaCodecInfo.isEncoder()) continue;
            for (String mimeType : supportedMimeTypes = mediaCodecInfo.getSupportedTypes()) {
                mimeTypeToEncoders.put((Object)Ascii.toLowerCase((String)mimeType), (Object)mediaCodecInfo);
            }
        }
    }

    private EncoderUtil() {
    }

    @RequiresApi(value=29)
    private static final class Api29 {
        private Api29() {
        }

        @DoNotInline
        public static boolean isHardwareAccelerated(MediaCodecInfo encoderInfo) {
            return encoderInfo.isHardwareAccelerated();
        }

        @DoNotInline
        public static boolean isSoftwareOnly(MediaCodecInfo encoderInfo) {
            return encoderInfo.isSoftwareOnly();
        }
    }
}

