/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.EditedMediaItem;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.SamplePipeline;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;

@Deprecated
final class EncodedSamplePipeline
extends SamplePipeline {
    private static final int MAX_INPUT_BUFFER_COUNT = 10;
    private final Format format;
    private final AtomicLong nextMediaItemOffsetUs;
    private final Queue<DecoderInputBuffer> availableInputBuffers;
    private final Queue<DecoderInputBuffer> pendingInputBuffers;
    private long mediaItemOffsetUs;
    private volatile boolean inputEnded;

    public EncodedSamplePipeline(Format format, TransformationRequest transformationRequest, MuxerWrapper muxerWrapper, FallbackListener fallbackListener) {
        super(format, muxerWrapper);
        this.format = format;
        this.nextMediaItemOffsetUs = new AtomicLong();
        this.availableInputBuffers = new ConcurrentLinkedDeque<DecoderInputBuffer>();
        ByteBuffer emptyBuffer = ByteBuffer.allocateDirect(0).order(ByteOrder.nativeOrder());
        for (int i = 0; i < 10; ++i) {
            DecoderInputBuffer inputBuffer = new DecoderInputBuffer(2);
            inputBuffer.data = emptyBuffer;
            this.availableInputBuffers.add(inputBuffer);
        }
        this.pendingInputBuffers = new ConcurrentLinkedDeque<DecoderInputBuffer>();
        fallbackListener.onTransformationRequestFinalized(transformationRequest);
    }

    @Override
    public void onMediaItemChanged(EditedMediaItem editedMediaItem, long durationUs, @Nullable Format trackFormat, boolean isLast) {
        this.mediaItemOffsetUs = this.nextMediaItemOffsetUs.get();
        this.nextMediaItemOffsetUs.addAndGet(durationUs);
    }

    @Override
    @Nullable
    public DecoderInputBuffer getInputBuffer() {
        return this.availableInputBuffers.peek();
    }

    @Override
    public boolean queueInputBuffer() {
        DecoderInputBuffer inputBuffer = this.availableInputBuffers.remove();
        if (inputBuffer.isEndOfStream()) {
            this.inputEnded = true;
        } else {
            inputBuffer.timeUs += this.mediaItemOffsetUs;
            this.pendingInputBuffers.add(inputBuffer);
        }
        return true;
    }

    @Override
    public void release() {
    }

    @Override
    protected Format getMuxerInputFormat() {
        return this.format;
    }

    @Override
    @Nullable
    protected DecoderInputBuffer getMuxerInputBuffer() {
        return this.pendingInputBuffers.peek();
    }

    @Override
    protected void releaseMuxerInputBuffer() {
        DecoderInputBuffer inputBuffer = this.pendingInputBuffers.remove();
        inputBuffer.clear();
        inputBuffer.timeUs = 0L;
        this.availableInputBuffers.add(inputBuffer);
    }

    @Override
    protected boolean isMuxerInputEnded() {
        return this.inputEnded && this.pendingInputBuffers.isEmpty();
    }
}

