/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.IntRange;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.transformer.Effects;
import com.google.android.exoplayer2.util.Assertions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@Deprecated
public final class EditedMediaItem {
    public final MediaItem mediaItem;
    public final boolean removeAudio;
    public final boolean removeVideo;
    public final boolean flattenForSlowMotion;
    public final long durationUs;
    @IntRange(from=0L)
    public final int frameRate;
    public final Effects effects;

    private EditedMediaItem(MediaItem mediaItem, boolean removeAudio, boolean removeVideo, boolean flattenForSlowMotion, long durationUs, int frameRate, Effects effects) {
        Assertions.checkState((!removeAudio || !removeVideo ? 1 : 0) != 0, (Object)"Audio and video cannot both be removed");
        this.mediaItem = mediaItem;
        this.removeAudio = removeAudio;
        this.removeVideo = removeVideo;
        this.flattenForSlowMotion = flattenForSlowMotion;
        this.durationUs = durationUs;
        this.frameRate = frameRate;
        this.effects = effects;
    }

    public static final class Builder {
        private final MediaItem mediaItem;
        private boolean removeAudio;
        private boolean removeVideo;
        private boolean flattenForSlowMotion;
        private long durationUs;
        private int frameRate;
        private Effects effects;

        public Builder(MediaItem mediaItem) {
            this.mediaItem = mediaItem;
            this.durationUs = -9223372036854775807L;
            this.frameRate = -2147483647;
            this.effects = Effects.EMPTY;
        }

        @CanIgnoreReturnValue
        public Builder setRemoveAudio(boolean removeAudio) {
            this.removeAudio = removeAudio;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRemoveVideo(boolean removeVideo) {
            this.removeVideo = removeVideo;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFlattenForSlowMotion(boolean flattenForSlowMotion) {
            Assertions.checkArgument((this.mediaItem.clippingConfiguration.equals((Object)MediaItem.ClippingConfiguration.UNSET) || !flattenForSlowMotion ? 1 : 0) != 0, (Object)"Slow motion flattening is not supported when clipping is requested");
            this.flattenForSlowMotion = flattenForSlowMotion;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDurationUs(long durationUs) {
            Assertions.checkArgument((durationUs > 0L ? 1 : 0) != 0);
            this.durationUs = durationUs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFrameRate(@IntRange(from=0L) int frameRate) {
            Assertions.checkArgument((frameRate > 0 ? 1 : 0) != 0);
            this.frameRate = frameRate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setEffects(Effects effects) {
            this.effects = effects;
            return this;
        }

        public EditedMediaItem build() {
            return new EditedMediaItem(this.mediaItem, this.removeAudio, this.removeVideo, this.flattenForSlowMotion, this.durationUs, this.frameRate, this.effects);
        }
    }
}

