/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Pair;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.mediacodec.MediaCodecInfo;
import com.google.android.exoplayer2.mediacodec.MediaCodecSelector;
import com.google.android.exoplayer2.mediacodec.MediaCodecUtil;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.DefaultCodec;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.ColorInfo;
import java.util.List;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@Deprecated
final class DefaultDecoderFactory
implements Codec.DecoderFactory {
    private static final String TAG = "DefaultDecoderFactory";
    private final Context context;
    private final boolean decoderSupportsKeyAllowFrameDrop;

    public DefaultDecoderFactory(Context context) {
        this.context = context;
        this.decoderSupportsKeyAllowFrameDrop = Util.SDK_INT >= 29 && context.getApplicationContext().getApplicationInfo().targetSdkVersion >= 29;
    }

    @Override
    public Codec createForAudioDecoding(Format format) throws ExportException {
        String mediaCodecName;
        Assertions.checkNotNull((Object)format.sampleMimeType);
        MediaFormat mediaFormat = MediaFormatUtil.createMediaFormatFromFormat((Format)format);
        try {
            MediaCodecInfo decoderInfo = DefaultDecoderFactory.getDecoderInfo(format);
            if (decoderInfo == null) {
                throw DefaultDecoderFactory.createExportException(format, "No decoders for format");
            }
            mediaCodecName = decoderInfo.name;
            String codecMimeType = decoderInfo.codecMimeType;
            mediaFormat.setString("mime", codecMimeType);
        }
        catch (MediaCodecUtil.DecoderQueryException e) {
            Log.e((String)TAG, (String)"Error querying decoders", (Throwable)e);
            throw DefaultDecoderFactory.createExportException(format, "Querying codecs failed.");
        }
        return new DefaultCodec(this.context, format, mediaFormat, mediaCodecName, true, null);
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    public Codec createForVideoDecoding(Format format, Surface outputSurface, boolean requestSdrToneMapping) throws ExportException {
        String mediaCodecName;
        Assertions.checkNotNull((Object)format.sampleMimeType);
        if (ColorInfo.isTransferHdr((ColorInfo)format.colorInfo)) {
            if (requestSdrToneMapping && (Util.SDK_INT < 31 || DefaultDecoderFactory.deviceNeedsDisableToneMappingWorkaround(((ColorInfo)Assertions.checkNotNull((Object)format.colorInfo)).colorTransfer))) {
                throw DefaultDecoderFactory.createExportException(format, "Tone-mapping HDR is not supported on this device.");
            }
            if (Util.SDK_INT < 29) {
                throw DefaultDecoderFactory.createExportException(format, "Decoding HDR is not supported on this device.");
            }
        }
        MediaFormat mediaFormat = MediaFormatUtil.createMediaFormatFromFormat((Format)format);
        if (this.decoderSupportsKeyAllowFrameDrop) {
            mediaFormat.setInteger("allow-frame-drop", 0);
        }
        if (Util.SDK_INT >= 31 && requestSdrToneMapping) {
            mediaFormat.setInteger("color-transfer-request", 3);
        }
        try {
            MediaCodecInfo decoderInfo = DefaultDecoderFactory.getDecoderInfo(format);
            if (decoderInfo == null) {
                throw DefaultDecoderFactory.createExportException(format, "No decoders for format");
            }
            mediaCodecName = decoderInfo.name;
            String codecMimeType = decoderInfo.codecMimeType;
            mediaFormat.setString("mime", codecMimeType);
        }
        catch (MediaCodecUtil.DecoderQueryException e) {
            Log.e((String)TAG, (String)"Error querying decoders", (Throwable)e);
            throw DefaultDecoderFactory.createExportException(format, "Querying codecs failed");
        }
        Pair codecProfileAndLevel = MediaCodecUtil.getCodecProfileAndLevel((Format)format);
        if (codecProfileAndLevel != null) {
            MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"profile", (int)((Integer)codecProfileAndLevel.first));
            MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"level", (int)((Integer)codecProfileAndLevel.second));
        }
        return new DefaultCodec(this.context, format, mediaFormat, mediaCodecName, true, outputSurface);
    }

    private static boolean deviceNeedsDisableToneMappingWorkaround(int colorTransfer) {
        if (Util.MANUFACTURER.equals("Google") && Build.ID.startsWith("TP1A")) {
            return true;
        }
        return colorTransfer == 7 && (Util.MODEL.startsWith("SM-F936") || Util.MODEL.startsWith("SM-F916"));
    }

    @RequiresNonNull(value={"#1.sampleMimeType"})
    private static ExportException createExportException(Format format, String reason) {
        return ExportException.createForCodec((Throwable)new IllegalArgumentException(reason), 3003, MimeTypes.isVideo((String)format.sampleMimeType), true, format);
    }

    @VisibleForTesting
    @Nullable
    static MediaCodecInfo getDecoderInfo(Format format) throws MediaCodecUtil.DecoderQueryException {
        Assertions.checkNotNull((Object)format.sampleMimeType);
        List decoderInfos = MediaCodecUtil.getDecoderInfosSortedByFormatSupport((List)MediaCodecUtil.getDecoderInfosSoftMatch((MediaCodecSelector)MediaCodecSelector.DEFAULT, (Format)format, (boolean)false, (boolean)false), (Format)format);
        if (decoderInfos.isEmpty()) {
            return null;
        }
        return (MediaCodecInfo)decoderInfos.get(0);
    }
}

