/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.effect.DebugTraceUtil;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
public final class DefaultCodec
implements Codec {
    public static final int DEFAULT_PCM_ENCODING = 2;
    private static final String TAG = "DefaultCodec";
    private final MediaCodec.BufferInfo outputBufferInfo;
    private final MediaFormat configurationMediaFormat;
    private final Format configurationFormat;
    private final MediaCodec mediaCodec;
    @Nullable
    private final Surface inputSurface;
    private final int maxPendingFrameCount;
    private final boolean isDecoder;
    private final boolean isVideo;
    private @MonotonicNonNull Format outputFormat;
    @Nullable
    private ByteBuffer outputBuffer;
    private int inputBufferIndex;
    private int outputBufferIndex;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;

    public DefaultCodec(Context context, Format configurationFormat, MediaFormat configurationMediaFormat, String mediaCodecName, boolean isDecoder, @Nullable Surface outputSurface) throws ExportException {
        this.configurationFormat = configurationFormat;
        this.configurationMediaFormat = configurationMediaFormat;
        this.isDecoder = isDecoder;
        this.isVideo = MimeTypes.isVideo((String)((String)Assertions.checkNotNull((Object)configurationFormat.sampleMimeType)));
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.inputBufferIndex = -1;
        this.outputBufferIndex = -1;
        MediaCodec mediaCodec = null;
        Surface inputSurface = null;
        boolean requestedHdrToneMapping = DefaultCodec.isSdrToneMappingEnabled(configurationMediaFormat);
        try {
            mediaCodec = MediaCodec.createByCodecName((String)mediaCodecName);
            DefaultCodec.configureCodec(mediaCodec, configurationMediaFormat, isDecoder, outputSurface);
            if (requestedHdrToneMapping) {
                Assertions.checkArgument((boolean)DefaultCodec.isSdrToneMappingEnabled(mediaCodec.getInputFormat()), (Object)"Tone-mapping requested but not supported by the decoder.");
            }
            if (this.isVideo && !isDecoder) {
                inputSurface = mediaCodec.createInputSurface();
            }
            DefaultCodec.startCodec(mediaCodec);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"MediaCodec error", (Throwable)e);
            if (inputSurface != null) {
                inputSurface.release();
            }
            if (mediaCodec != null) {
                mediaCodec.release();
            }
            int errorCode = e instanceof IOException || e instanceof MediaCodec.CodecException ? (isDecoder ? 3001 : 4001) : (e instanceof IllegalArgumentException ? (isDecoder ? 3003 : 4003) : 1001);
            throw this.createExportException(e, errorCode, mediaCodecName);
        }
        this.mediaCodec = mediaCodec;
        this.inputSurface = inputSurface;
        this.maxPendingFrameCount = Util.getMaxPendingFramesCountForMediaCodecDecoders((Context)context, (String)mediaCodecName, (boolean)requestedHdrToneMapping);
    }

    @Override
    public Format getConfigurationFormat() {
        return this.configurationFormat;
    }

    @Override
    public Surface getInputSurface() {
        return (Surface)Assertions.checkStateNotNull((Object)this.inputSurface);
    }

    @Override
    public int getMaxPendingFrameCount() {
        return this.maxPendingFrameCount;
    }

    @Override
    @EnsuresNonNullIf(expression={"#1.data"}, result=true)
    public boolean maybeDequeueInputBuffer(DecoderInputBuffer inputBuffer) throws ExportException {
        if (this.inputStreamEnded) {
            return false;
        }
        if (this.inputBufferIndex < 0) {
            try {
                this.inputBufferIndex = this.mediaCodec.dequeueInputBuffer(0L);
            }
            catch (RuntimeException e) {
                Log.d((String)TAG, (String)"MediaCodec error", (Throwable)e);
                throw this.createExportException(e);
            }
            if (this.inputBufferIndex < 0) {
                return false;
            }
            try {
                inputBuffer.data = this.mediaCodec.getInputBuffer(this.inputBufferIndex);
            }
            catch (RuntimeException e) {
                Log.d((String)TAG, (String)"MediaCodec error", (Throwable)e);
                throw this.createExportException(e);
            }
            inputBuffer.clear();
        }
        Assertions.checkNotNull((Object)inputBuffer.data);
        return true;
    }

    @Override
    public void queueInputBuffer(DecoderInputBuffer inputBuffer) throws ExportException {
        Assertions.checkState((!this.inputStreamEnded ? 1 : 0) != 0, (Object)"Input buffer can not be queued after the input stream has ended.");
        int offset = 0;
        int size = 0;
        if (inputBuffer.data != null && inputBuffer.data.hasRemaining()) {
            offset = inputBuffer.data.position();
            size = inputBuffer.data.remaining();
        }
        int flags = 0;
        if (inputBuffer.isEndOfStream()) {
            this.inputStreamEnded = true;
            flags = 4;
            if (this.isVideo && this.isDecoder) {
                DebugTraceUtil.recordDecoderReceiveEos();
            }
        }
        try {
            this.mediaCodec.queueInputBuffer(this.inputBufferIndex, offset, size, inputBuffer.timeUs, flags);
        }
        catch (RuntimeException e) {
            Log.d((String)TAG, (String)"MediaCodec error", (Throwable)e);
            throw this.createExportException(e);
        }
        this.inputBufferIndex = -1;
        inputBuffer.data = null;
    }

    @Override
    public void signalEndOfInputStream() throws ExportException {
        DebugTraceUtil.recordEncoderReceiveEos();
        try {
            this.mediaCodec.signalEndOfInputStream();
        }
        catch (RuntimeException e) {
            Log.d((String)TAG, (String)"MediaCodec error", (Throwable)e);
            throw this.createExportException(e);
        }
    }

    @Override
    @Nullable
    public Format getOutputFormat() throws ExportException {
        this.maybeDequeueOutputBuffer(false);
        return this.outputFormat;
    }

    @Override
    @Nullable
    public ByteBuffer getOutputBuffer() throws ExportException {
        return this.maybeDequeueOutputBuffer(true) ? this.outputBuffer : null;
    }

    @Override
    @Nullable
    public MediaCodec.BufferInfo getOutputBufferInfo() throws ExportException {
        return this.maybeDequeueOutputBuffer(false) ? this.outputBufferInfo : null;
    }

    @Override
    public void releaseOutputBuffer(boolean render) throws ExportException {
        this.releaseOutputBuffer(render, ((MediaCodec.BufferInfo)Assertions.checkStateNotNull((Object)this.outputBufferInfo)).presentationTimeUs);
    }

    @Override
    public void releaseOutputBuffer(long renderPresentationTimeUs) throws ExportException {
        this.releaseOutputBuffer(true, renderPresentationTimeUs);
    }

    private void releaseOutputBuffer(boolean render, long renderPresentationTimeUs) throws ExportException {
        this.outputBuffer = null;
        try {
            if (render) {
                this.mediaCodec.releaseOutputBuffer(this.outputBufferIndex, renderPresentationTimeUs * 1000L);
            } else {
                this.mediaCodec.releaseOutputBuffer(this.outputBufferIndex, false);
            }
        }
        catch (RuntimeException e) {
            Log.d((String)TAG, (String)"MediaCodec error", (Throwable)e);
            throw this.createExportException(e);
        }
        this.outputBufferIndex = -1;
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded && this.outputBufferIndex == -1;
    }

    @Override
    public void release() {
        this.outputBuffer = null;
        if (this.inputSurface != null) {
            this.inputSurface.release();
        }
        this.mediaCodec.release();
    }

    @Override
    public String getName() {
        return Util.SDK_INT >= 29 ? Api29.getCanonicalName(this.mediaCodec) : this.mediaCodec.getName();
    }

    @VisibleForTesting
    MediaFormat getConfigurationMediaFormat() {
        return this.configurationMediaFormat;
    }

    private boolean maybeDequeueOutputBuffer(boolean setOutputBuffer) throws ExportException {
        if (this.outputBufferIndex >= 0) {
            return true;
        }
        if (this.outputStreamEnded) {
            return false;
        }
        try {
            this.outputBufferIndex = this.mediaCodec.dequeueOutputBuffer(this.outputBufferInfo, 0L);
        }
        catch (RuntimeException e) {
            Log.d((String)TAG, (String)"MediaCodec error", (Throwable)e);
            throw this.createExportException(e);
        }
        if (this.outputBufferIndex < 0) {
            if (this.outputBufferIndex == -2) {
                this.outputFormat = DefaultCodec.convertToFormat(this.mediaCodec.getOutputFormat(), this.isDecoder);
            }
            return false;
        }
        if ((this.outputBufferInfo.flags & 4) != 0) {
            this.outputStreamEnded = true;
            if (this.outputBufferInfo.size == 0) {
                this.releaseOutputBuffer(false);
                return false;
            }
            this.outputBufferInfo.flags &= 0xFFFFFFFB;
        }
        if ((this.outputBufferInfo.flags & 2) != 0) {
            this.releaseOutputBuffer(false);
            return false;
        }
        if (setOutputBuffer) {
            try {
                this.outputBuffer = (ByteBuffer)Assertions.checkNotNull((Object)this.mediaCodec.getOutputBuffer(this.outputBufferIndex));
            }
            catch (RuntimeException e) {
                Log.d((String)TAG, (String)"MediaCodec error", (Throwable)e);
                throw this.createExportException(e);
            }
            this.outputBuffer.position(this.outputBufferInfo.offset);
            this.outputBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
        }
        return true;
    }

    private ExportException createExportException(Exception cause) {
        return this.createExportException(cause, this.isDecoder ? 3002 : 4002, this.getName());
    }

    private ExportException createExportException(@UnknownInitialization DefaultCodec this, Exception cause, int errorCode, String mediaCodecName) {
        String codecDetails = "mediaFormat=" + this.configurationMediaFormat + ", mediaCodecName=" + mediaCodecName;
        return ExportException.createForCodec((Throwable)cause, errorCode, this.isVideo, this.isDecoder, codecDetails);
    }

    private static Format convertToFormat(MediaFormat mediaFormat, boolean isDecoder) {
        Format.Builder formatBuilder = MediaFormatUtil.createFormatFromMediaFormat((MediaFormat)mediaFormat).buildUpon();
        if (isDecoder) {
            formatBuilder.setPcmEncoding(2);
        }
        return formatBuilder.build();
    }

    private static void configureCodec(MediaCodec codec, MediaFormat mediaFormat, boolean isDecoder, @Nullable Surface outputSurface) {
        TraceUtil.beginSection((String)"configureCodec");
        codec.configure(mediaFormat, outputSurface, null, isDecoder ? 0 : 1);
        TraceUtil.endSection();
    }

    private static void startCodec(MediaCodec codec) {
        TraceUtil.beginSection((String)"startCodec");
        codec.start();
        TraceUtil.endSection();
    }

    private static boolean isSdrToneMappingEnabled(MediaFormat mediaFormat) {
        return Util.SDK_INT >= 31 && MediaFormatUtil.getInteger((MediaFormat)mediaFormat, (String)"color-transfer-request", (int)0) == 3;
    }

    @RequiresApi(value=29)
    private static final class Api29 {
        private Api29() {
        }

        @DoNotInline
        public static String getCanonicalName(MediaCodec mediaCodec) {
            return mediaCodec.getCanonicalName();
        }
    }
}

