/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.transformer.AssetLoader;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.EditedMediaItem;
import com.google.android.exoplayer2.transformer.ExoPlayerAssetLoader;
import com.google.android.exoplayer2.transformer.ImageAssetLoader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
public final class DefaultAssetLoaderFactory
implements AssetLoader.Factory {
    private final Context context;
    private final Codec.DecoderFactory decoderFactory;
    private final boolean forceInterpretHdrAsSdr;
    private final Clock clock;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @MonotonicNonNull MediaSource.Factory mediaSourceFactory;
    private @MonotonicNonNull AssetLoader.Factory imageAssetLoaderFactory;
    private @MonotonicNonNull AssetLoader.Factory exoPlayerAssetLoaderFactory;

    public DefaultAssetLoaderFactory(Context context, Codec.DecoderFactory decoderFactory, boolean forceInterpretHdrAsSdr, Clock clock) {
        this.context = context.getApplicationContext();
        this.decoderFactory = decoderFactory;
        this.forceInterpretHdrAsSdr = forceInterpretHdrAsSdr;
        this.clock = clock;
        this.mediaSourceFactory = null;
    }

    public DefaultAssetLoaderFactory(Context context, Codec.DecoderFactory decoderFactory, boolean forceInterpretHdrAsSdr, Clock clock, MediaSource.Factory mediaSourceFactory) {
        this.context = context.getApplicationContext();
        this.decoderFactory = decoderFactory;
        this.forceInterpretHdrAsSdr = forceInterpretHdrAsSdr;
        this.clock = clock;
        this.mediaSourceFactory = mediaSourceFactory;
    }

    @Override
    public AssetLoader createAssetLoader(EditedMediaItem editedMediaItem, Looper looper, AssetLoader.Listener listener) {
        MediaItem mediaItem = editedMediaItem.mediaItem;
        if (DefaultAssetLoaderFactory.isImage(mediaItem.localConfiguration)) {
            if (this.imageAssetLoaderFactory == null) {
                this.imageAssetLoaderFactory = new ImageAssetLoader.Factory(this.context);
            }
            return this.imageAssetLoaderFactory.createAssetLoader(editedMediaItem, looper, listener);
        }
        if (this.exoPlayerAssetLoaderFactory == null) {
            this.exoPlayerAssetLoaderFactory = this.mediaSourceFactory != null ? new ExoPlayerAssetLoader.Factory(this.context, this.decoderFactory, this.forceInterpretHdrAsSdr, this.clock, this.mediaSourceFactory) : new ExoPlayerAssetLoader.Factory(this.context, this.decoderFactory, this.forceInterpretHdrAsSdr, this.clock);
        }
        return this.exoPlayerAssetLoaderFactory.createAssetLoader(editedMediaItem, looper, listener);
    }

    private static boolean isImage(@Nullable MediaItem.LocalConfiguration localConfiguration) {
        if (localConfiguration == null) {
            return false;
        }
        if (localConfiguration.mimeType != null) {
            return MimeTypes.isImage((String)localConfiguration.mimeType);
        }
        ImmutableList supportedImageTypes = ImmutableList.of((Object)".png", (Object)".webp", (Object)".jpg", (Object)".jpeg", (Object)".heic", (Object)".heif", (Object)".bmp");
        String uriPath = (String)Assertions.checkNotNull((Object)localConfiguration.uri.getPath());
        int fileExtensionStart = uriPath.lastIndexOf(".");
        if (fileExtensionStart < 0) {
            return false;
        }
        String extension = Ascii.toLowerCase((String)uriPath.substring(fileExtensionStart));
        return supportedImageTypes.contains((Object)extension);
    }
}

