/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.MediaCodec;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.audio.AudioProcessingPipeline;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.EditedMediaItem;
import com.google.android.exoplayer2.transformer.ExportException;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.SamplePipeline;
import com.google.android.exoplayer2.transformer.SegmentSpeedProvider;
import com.google.android.exoplayer2.transformer.SilentAudioGenerator;
import com.google.android.exoplayer2.transformer.SpeedChangingAudioProcessor;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.checkerframework.dataflow.qual.Pure;

@Deprecated
final class AudioSamplePipeline
extends SamplePipeline {
    private static final int MAX_INPUT_BUFFER_COUNT = 10;
    private static final int DEFAULT_ENCODER_BITRATE = 131072;
    private final SilentAudioGenerator silentAudioGenerator;
    private final Queue<DecoderInputBuffer> availableInputBuffers = new ConcurrentLinkedDeque<DecoderInputBuffer>();
    private final Queue<DecoderInputBuffer> pendingInputBuffers;
    private final AudioProcessingPipeline audioProcessingPipeline;
    private final Codec encoder;
    private final AudioProcessor.AudioFormat encoderInputAudioFormat;
    private final DecoderInputBuffer encoderInputBuffer;
    private final DecoderInputBuffer encoderOutputBuffer;
    private long encoderTotalInputBytes;
    private volatile boolean queueEndOfStreamAfterSilence;

    public AudioSamplePipeline(Format firstAssetLoaderInputFormat, Format firstPipelineInputFormat, TransformationRequest transformationRequest, boolean flattenForSlowMotion, ImmutableList<AudioProcessor> audioProcessors, Codec.EncoderFactory encoderFactory, MuxerWrapper muxerWrapper, FallbackListener fallbackListener) throws ExportException {
        super(firstAssetLoaderInputFormat, muxerWrapper);
        ByteBuffer emptyBuffer = ByteBuffer.allocateDirect(0).order(ByteOrder.nativeOrder());
        for (int i = 0; i < 10; ++i) {
            DecoderInputBuffer inputBuffer = new DecoderInputBuffer(2);
            inputBuffer.data = emptyBuffer;
            this.availableInputBuffers.add(inputBuffer);
        }
        this.pendingInputBuffers = new ConcurrentLinkedDeque<DecoderInputBuffer>();
        this.encoderInputBuffer = new DecoderInputBuffer(0);
        this.encoderOutputBuffer = new DecoderInputBuffer(0);
        Assertions.checkArgument((firstPipelineInputFormat.pcmEncoding != -1 ? 1 : 0) != 0);
        AudioProcessor.AudioFormat inputAudioFormat = new AudioProcessor.AudioFormat(firstPipelineInputFormat.sampleRate, firstPipelineInputFormat.channelCount, firstPipelineInputFormat.pcmEncoding);
        this.silentAudioGenerator = new SilentAudioGenerator(inputAudioFormat);
        if (flattenForSlowMotion && firstAssetLoaderInputFormat.metadata != null) {
            audioProcessors = new ImmutableList.Builder().add((Object)new SpeedChangingAudioProcessor(new SegmentSpeedProvider(firstAssetLoaderInputFormat.metadata))).addAll(audioProcessors).build();
        }
        this.audioProcessingPipeline = new AudioProcessingPipeline(audioProcessors);
        try {
            this.encoderInputAudioFormat = this.audioProcessingPipeline.configure(inputAudioFormat);
        }
        catch (AudioProcessor.UnhandledAudioFormatException unhandledAudioFormatException) {
            throw ExportException.createForAudioProcessing(unhandledAudioFormatException, inputAudioFormat);
        }
        this.audioProcessingPipeline.flush();
        Format requestedEncoderFormat = new Format.Builder().setSampleMimeType(transformationRequest.audioMimeType != null ? transformationRequest.audioMimeType : (String)Assertions.checkNotNull((Object)firstAssetLoaderInputFormat.sampleMimeType)).setSampleRate(this.encoderInputAudioFormat.sampleRate).setChannelCount(this.encoderInputAudioFormat.channelCount).setPcmEncoding(this.encoderInputAudioFormat.encoding).setAverageBitrate(131072).build();
        this.encoder = encoderFactory.createForAudioEncoding(requestedEncoderFormat.buildUpon().setSampleMimeType(AudioSamplePipeline.findSupportedMimeTypeForEncoderAndMuxer(requestedEncoderFormat, muxerWrapper.getSupportedSampleMimeTypes(1))).build());
        fallbackListener.onTransformationRequestFinalized(AudioSamplePipeline.createFallbackTransformationRequest(transformationRequest, requestedEncoderFormat, this.encoder.getConfigurationFormat()));
    }

    @Override
    public void onMediaItemChanged(EditedMediaItem editedMediaItem, long durationUs, @Nullable Format trackFormat, boolean isLast) {
        if (trackFormat == null) {
            Assertions.checkState((durationUs != -9223372036854775807L ? 1 : 0) != 0, (Object)"Could not generate silent audio because duration is unknown.");
            this.silentAudioGenerator.addSilence(durationUs);
            if (isLast) {
                this.queueEndOfStreamAfterSilence = true;
            }
        }
    }

    @Override
    @Nullable
    public DecoderInputBuffer getInputBuffer() {
        if (this.shouldGenerateSilence()) {
            return null;
        }
        return this.availableInputBuffers.peek();
    }

    @Override
    public boolean queueInputBuffer() {
        DecoderInputBuffer inputBuffer = this.availableInputBuffers.remove();
        this.pendingInputBuffers.add(inputBuffer);
        return true;
    }

    @Override
    public void release() {
        this.audioProcessingPipeline.reset();
        this.encoder.release();
    }

    @Override
    protected boolean processDataUpToMuxer() throws ExportException {
        if (!this.audioProcessingPipeline.isOperational()) {
            return this.feedEncoderFromInput();
        }
        return this.feedEncoderFromProcessingPipeline() || this.feedProcessingPipelineFromInput();
    }

    @Override
    @Nullable
    protected Format getMuxerInputFormat() throws ExportException {
        return this.encoder.getOutputFormat();
    }

    @Override
    @Nullable
    protected DecoderInputBuffer getMuxerInputBuffer() throws ExportException {
        this.encoderOutputBuffer.data = this.encoder.getOutputBuffer();
        if (this.encoderOutputBuffer.data == null) {
            return null;
        }
        this.encoderOutputBuffer.timeUs = ((MediaCodec.BufferInfo)Assertions.checkNotNull((Object)this.encoder.getOutputBufferInfo())).presentationTimeUs;
        this.encoderOutputBuffer.setFlags(1);
        return this.encoderOutputBuffer;
    }

    @Override
    protected void releaseMuxerInputBuffer() throws ExportException {
        this.encoder.releaseOutputBuffer(false);
    }

    @Override
    protected boolean isMuxerInputEnded() {
        return this.encoder.isEnded();
    }

    private boolean feedEncoderFromInput() throws ExportException {
        if (!this.encoder.maybeDequeueInputBuffer(this.encoderInputBuffer)) {
            return false;
        }
        if (this.shouldGenerateSilence()) {
            this.feedEncoder(this.silentAudioGenerator.getBuffer());
            return true;
        }
        if (this.pendingInputBuffers.isEmpty()) {
            if (!this.silentAudioGenerator.hasRemaining() && this.queueEndOfStreamAfterSilence) {
                this.queueEndOfStreamToEncoder();
            }
            return false;
        }
        DecoderInputBuffer pendingInputBuffer = this.pendingInputBuffers.element();
        if (pendingInputBuffer.isEndOfStream()) {
            this.queueEndOfStreamToEncoder();
            this.removePendingInputBuffer();
            return false;
        }
        ByteBuffer inputData = (ByteBuffer)Assertions.checkNotNull((Object)pendingInputBuffer.data);
        this.feedEncoder(inputData);
        if (!inputData.hasRemaining()) {
            this.removePendingInputBuffer();
        }
        return true;
    }

    private boolean feedEncoderFromProcessingPipeline() throws ExportException {
        if (!this.encoder.maybeDequeueInputBuffer(this.encoderInputBuffer)) {
            return false;
        }
        ByteBuffer processingPipelineOutputBuffer = this.audioProcessingPipeline.getOutput();
        if (!processingPipelineOutputBuffer.hasRemaining()) {
            if (this.audioProcessingPipeline.isEnded()) {
                this.queueEndOfStreamToEncoder();
            }
            return false;
        }
        this.feedEncoder(processingPipelineOutputBuffer);
        return true;
    }

    private boolean feedProcessingPipelineFromInput() {
        if (this.shouldGenerateSilence()) {
            ByteBuffer inputData = this.silentAudioGenerator.getBuffer();
            this.audioProcessingPipeline.queueInput(inputData);
            return !inputData.hasRemaining();
        }
        if (this.pendingInputBuffers.isEmpty()) {
            if (!this.silentAudioGenerator.hasRemaining() && this.queueEndOfStreamAfterSilence) {
                this.audioProcessingPipeline.queueEndOfStream();
            }
            return false;
        }
        DecoderInputBuffer pendingInputBuffer = this.pendingInputBuffers.element();
        if (pendingInputBuffer.isEndOfStream()) {
            this.audioProcessingPipeline.queueEndOfStream();
            this.removePendingInputBuffer();
            return false;
        }
        ByteBuffer inputData = (ByteBuffer)Assertions.checkNotNull((Object)pendingInputBuffer.data);
        this.audioProcessingPipeline.queueInput(inputData);
        if (inputData.hasRemaining()) {
            return false;
        }
        this.removePendingInputBuffer();
        return true;
    }

    private void removePendingInputBuffer() {
        DecoderInputBuffer inputBuffer = this.pendingInputBuffers.remove();
        inputBuffer.clear();
        inputBuffer.timeUs = 0L;
        this.availableInputBuffers.add(inputBuffer);
    }

    private void feedEncoder(ByteBuffer inputBuffer) throws ExportException {
        ByteBuffer encoderInputBufferData = (ByteBuffer)Assertions.checkNotNull((Object)this.encoderInputBuffer.data);
        int bufferLimit = inputBuffer.limit();
        inputBuffer.limit(Math.min(bufferLimit, inputBuffer.position() + encoderInputBufferData.capacity()));
        encoderInputBufferData.put(inputBuffer);
        this.encoderInputBuffer.timeUs = this.getOutputAudioDurationUs();
        this.encoderTotalInputBytes += (long)encoderInputBufferData.position();
        this.encoderInputBuffer.setFlags(0);
        this.encoderInputBuffer.flip();
        inputBuffer.limit(bufferLimit);
        this.encoder.queueInputBuffer(this.encoderInputBuffer);
    }

    private void queueEndOfStreamToEncoder() throws ExportException {
        Assertions.checkState((((ByteBuffer)Assertions.checkNotNull((Object)this.encoderInputBuffer.data)).position() == 0 ? 1 : 0) != 0);
        this.encoderInputBuffer.timeUs = this.getOutputAudioDurationUs();
        this.encoderInputBuffer.addFlag(4);
        this.encoderInputBuffer.flip();
        this.encoder.queueInputBuffer(this.encoderInputBuffer);
    }

    @Pure
    private static TransformationRequest createFallbackTransformationRequest(TransformationRequest transformationRequest, Format requestedFormat, Format actualFormat) {
        if (Util.areEqual((Object)requestedFormat.sampleMimeType, (Object)actualFormat.sampleMimeType)) {
            return transformationRequest;
        }
        return transformationRequest.buildUpon().setAudioMimeType(actualFormat.sampleMimeType).build();
    }

    private long getOutputAudioDurationUs() {
        long totalFramesWritten = this.encoderTotalInputBytes / (long)this.encoderInputAudioFormat.bytesPerFrame;
        return totalFramesWritten * 1000000L / (long)this.encoderInputAudioFormat.sampleRate;
    }

    private boolean shouldGenerateSilence() {
        return this.silentAudioGenerator.hasRemaining() && this.pendingInputBuffers.isEmpty();
    }
}

