/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.ChannelMixingMatrix;
import com.google.android.exoplayer2.transformer.AudioMixer;
import com.google.android.exoplayer2.transformer.AudioMixingAlgorithm;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@Deprecated
final class AudioMixerImpl
implements AudioMixer {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocateDirect(0).order(ByteOrder.nativeOrder());
    private final SparseArray<SourceInfo> sources = new SparseArray();
    private int nextSourceId;
    private AudioProcessor.AudioFormat outputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
    @Nullable
    private AudioMixingAlgorithm mixingAlgorithm;
    private int bufferSizeFrames = -1;
    private MixingBuffer[] mixingBuffers = new MixingBuffer[0];
    private long mixerStartTimeUs = -9223372036854775807L;
    private long inputLimit = -1L;
    private long outputPosition;
    private long endPosition = Long.MAX_VALUE;

    @Override
    public void configure(AudioProcessor.AudioFormat outputAudioFormat, int bufferSizeMs, long startTimeUs) throws AudioProcessor.UnhandledAudioFormatException {
        Assertions.checkState((!this.isConfigured() ? 1 : 0) != 0, (Object)"Audio mixer already configured.");
        this.mixingAlgorithm = AudioMixingAlgorithm.create(outputAudioFormat);
        this.outputAudioFormat = outputAudioFormat;
        this.bufferSizeFrames = bufferSizeMs * outputAudioFormat.sampleRate / 1000;
        this.mixerStartTimeUs = startTimeUs;
        this.mixingBuffers = new MixingBuffer[]{this.allocateMixingBuffer(0L), this.allocateMixingBuffer(this.bufferSizeFrames)};
        this.updateInputFrameLimit();
    }

    @Override
    public void setEndTimeUs(long endTimeUs) {
        this.checkStateIsConfigured();
        Assertions.checkArgument((endTimeUs >= this.mixerStartTimeUs ? 1 : 0) != 0, (Object)"End time must be at least the configured start time.");
        this.endPosition = Util.scaleLargeTimestamp((long)(endTimeUs - this.mixerStartTimeUs), (long)this.outputAudioFormat.sampleRate, (long)1000000L);
        this.updateInputFrameLimit();
    }

    @Override
    public boolean supportsSourceAudioFormat(AudioProcessor.AudioFormat sourceFormat) {
        this.checkStateIsConfigured();
        return ((AudioMixingAlgorithm)Assertions.checkStateNotNull((Object)this.mixingAlgorithm)).supportsSourceAudioFormat(sourceFormat);
    }

    @Override
    public int addSource(AudioProcessor.AudioFormat sourceFormat, long startTimeUs) throws AudioProcessor.UnhandledAudioFormatException {
        this.checkStateIsConfigured();
        if (!this.supportsSourceAudioFormat(sourceFormat)) {
            throw new AudioProcessor.UnhandledAudioFormatException(sourceFormat);
        }
        long startFrameOffset = Util.scaleLargeTimestamp((long)(startTimeUs - this.mixerStartTimeUs), (long)sourceFormat.sampleRate, (long)1000000L);
        int sourceId = this.nextSourceId++;
        this.sources.append(sourceId, (Object)new SourceInfo(sourceFormat, ChannelMixingMatrix.create((int)sourceFormat.channelCount, (int)this.outputAudioFormat.channelCount), startFrameOffset));
        return sourceId;
    }

    @Override
    public void setSourceVolume(int sourceId, float volume) {
        this.checkStateIsConfigured();
        Assertions.checkArgument((volume >= 0.0f ? 1 : 0) != 0, (Object)"Volume must be non-negative.");
        SourceInfo source = this.getSourceById(sourceId);
        source.setVolume(volume);
    }

    @Override
    public void removeSource(int sourceId) {
        this.checkStateIsConfigured();
        this.sources.delete(sourceId);
    }

    @Override
    public void queueInput(int sourceId, ByteBuffer sourceBuffer) {
        this.checkStateIsConfigured();
        SourceInfo source = this.getSourceById(sourceId);
        if (source.position >= this.inputLimit) {
            return;
        }
        long newSourcePosition = Math.min(source.getPositionAfterBuffer(sourceBuffer), this.inputLimit);
        if (source.getChannelMixingMatrix().isZero()) {
            source.discardTo(sourceBuffer, newSourcePosition);
            return;
        }
        if (source.position < this.outputPosition) {
            source.discardTo(sourceBuffer, Math.min(newSourcePosition, this.outputPosition));
            if (source.position == newSourcePosition) {
                return;
            }
        }
        for (MixingBuffer mixingBuffer : this.mixingBuffers) {
            if (source.position >= mixingBuffer.limit) continue;
            int mixingBufferPositionOffset = (int)(source.position - mixingBuffer.position) * this.outputAudioFormat.bytesPerFrame;
            mixingBuffer.buffer.position(mixingBuffer.buffer.position() + mixingBufferPositionOffset);
            source.mixTo(sourceBuffer, Math.min(newSourcePosition, mixingBuffer.limit), (AudioMixingAlgorithm)Assertions.checkNotNull((Object)this.mixingAlgorithm), mixingBuffer.buffer);
            mixingBuffer.buffer.reset();
            if (source.position != newSourcePosition) continue;
            return;
        }
    }

    @Override
    public ByteBuffer getOutput() {
        this.checkStateIsConfigured();
        long minSourcePosition = this.endPosition;
        for (int i = 0; i < this.sources.size(); ++i) {
            minSourcePosition = Math.min(minSourcePosition, ((SourceInfo)this.sources.valueAt((int)i)).position);
        }
        if (minSourcePosition <= this.outputPosition) {
            return EMPTY_BUFFER;
        }
        MixingBuffer mixingBuffer = this.mixingBuffers[0];
        long newOutputPosition = Math.min(minSourcePosition, mixingBuffer.limit);
        ByteBuffer outputBuffer = mixingBuffer.buffer.duplicate();
        outputBuffer.position((int)(this.outputPosition - mixingBuffer.position) * this.outputAudioFormat.bytesPerFrame).limit((int)(newOutputPosition - mixingBuffer.position) * this.outputAudioFormat.bytesPerFrame);
        outputBuffer = outputBuffer.slice().order(ByteOrder.nativeOrder());
        if (newOutputPosition == mixingBuffer.limit) {
            this.mixingBuffers[0] = this.mixingBuffers[1];
            this.mixingBuffers[1] = this.allocateMixingBuffer(this.mixingBuffers[1].limit);
        }
        this.outputPosition = newOutputPosition;
        this.updateInputFrameLimit();
        return outputBuffer;
    }

    @Override
    public boolean isEnded() {
        this.checkStateIsConfigured();
        return this.outputPosition >= this.endPosition;
    }

    @Override
    public void reset() {
        this.sources.clear();
        this.nextSourceId = 0;
        this.outputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.mixingAlgorithm = null;
        this.bufferSizeFrames = -1;
        this.mixingBuffers = new MixingBuffer[0];
        this.mixerStartTimeUs = -9223372036854775807L;
        this.inputLimit = -1L;
        this.outputPosition = 0L;
        this.endPosition = Long.MAX_VALUE;
    }

    private boolean isConfigured() {
        return this.mixingAlgorithm != null;
    }

    private void checkStateIsConfigured() {
        Assertions.checkState((boolean)this.isConfigured(), (Object)"Audio mixer is not configured.");
    }

    private MixingBuffer allocateMixingBuffer(long position) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.bufferSizeFrames * this.outputAudioFormat.bytesPerFrame).order(ByteOrder.nativeOrder());
        buffer.mark();
        return new MixingBuffer(buffer, position, position + (long)this.bufferSizeFrames);
    }

    private void updateInputFrameLimit() {
        this.inputLimit = Math.min(this.endPosition, this.outputPosition + (long)this.bufferSizeFrames);
    }

    private SourceInfo getSourceById(int sourceId) {
        return (SourceInfo)Assertions.checkStateNotNull((Object)((SourceInfo)this.sources.get(sourceId)), (Object)"Source not found.");
    }

    private static class SourceInfo {
        public long position;
        private final AudioProcessor.AudioFormat audioFormat;
        private final ChannelMixingMatrix baseChannelMixingMatrix;
        private ChannelMixingMatrix channelMixingMatrix;

        public SourceInfo(AudioProcessor.AudioFormat audioFormat, ChannelMixingMatrix baseChannelMixingMatrix, long startFrameOffset) {
            this.audioFormat = audioFormat;
            this.baseChannelMixingMatrix = baseChannelMixingMatrix;
            this.position = startFrameOffset;
            this.channelMixingMatrix = baseChannelMixingMatrix;
        }

        public ChannelMixingMatrix getChannelMixingMatrix() {
            return this.channelMixingMatrix;
        }

        public void setVolume(float volume) {
            this.channelMixingMatrix = this.baseChannelMixingMatrix.scaleBy(volume);
        }

        public long getPositionAfterBuffer(ByteBuffer sourceBuffer) {
            int sourceBufferFrameCount = sourceBuffer.remaining() / this.audioFormat.bytesPerFrame;
            return this.position + (long)sourceBufferFrameCount;
        }

        public void discardTo(ByteBuffer sourceBuffer, long newPosition) {
            Assertions.checkArgument((newPosition >= this.position ? 1 : 0) != 0);
            int framesToDiscard = (int)(newPosition - this.position);
            sourceBuffer.position(sourceBuffer.position() + framesToDiscard * this.audioFormat.bytesPerFrame);
            this.position = newPosition;
        }

        public void mixTo(ByteBuffer sourceBuffer, long newPosition, AudioMixingAlgorithm mixingAlgorithm, ByteBuffer mixingBuffer) {
            Assertions.checkArgument((newPosition >= this.position ? 1 : 0) != 0);
            int framesToMix = (int)(newPosition - this.position);
            mixingAlgorithm.mix(sourceBuffer, this.audioFormat, this.channelMixingMatrix, framesToMix, mixingBuffer);
            this.position = newPosition;
        }
    }

    private static class MixingBuffer {
        public final ByteBuffer buffer;
        public final long position;
        public final long limit;

        public MixingBuffer(ByteBuffer buffer, long position, long limit) {
            this.buffer = buffer;
            this.position = position;
            this.limit = limit;
        }
    }
}

