/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

public final class TransformationResult {
    public final long durationMs;
    public final long fileSizeBytes;
    public final int averageAudioBitrate;
    public final int averageVideoBitrate;
    public final int videoFrameCount;

    private TransformationResult(long durationMs, long fileSizeBytes, int averageAudioBitrate, int averageVideoBitrate, int videoFrameCount) {
        this.durationMs = durationMs;
        this.fileSizeBytes = fileSizeBytes;
        this.averageAudioBitrate = averageAudioBitrate;
        this.averageVideoBitrate = averageVideoBitrate;
        this.videoFrameCount = videoFrameCount;
    }

    public Builder buildUpon() {
        return new Builder().setDurationMs(this.durationMs).setFileSizeBytes(this.fileSizeBytes).setAverageAudioBitrate(this.averageAudioBitrate).setAverageVideoBitrate(this.averageVideoBitrate).setVideoFrameCount(this.videoFrameCount);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransformationResult)) {
            return false;
        }
        TransformationResult result = (TransformationResult)o;
        return this.durationMs == result.durationMs && this.fileSizeBytes == result.fileSizeBytes && this.averageAudioBitrate == result.averageAudioBitrate && this.averageVideoBitrate == result.averageVideoBitrate && this.videoFrameCount == result.videoFrameCount;
    }

    public int hashCode() {
        int result = (int)this.durationMs;
        result = 31 * result + (int)this.fileSizeBytes;
        result = 31 * result + this.averageAudioBitrate;
        result = 31 * result + this.averageVideoBitrate;
        result = 31 * result + this.videoFrameCount;
        return result;
    }

    public static final class Builder {
        private long durationMs = -9223372036854775807L;
        private long fileSizeBytes = -1L;
        private int averageAudioBitrate = -2147483647;
        private int averageVideoBitrate = -2147483647;
        private int videoFrameCount;

        @CanIgnoreReturnValue
        public Builder setDurationMs(long durationMs) {
            Assertions.checkArgument((durationMs > 0L || durationMs == -9223372036854775807L ? 1 : 0) != 0);
            this.durationMs = durationMs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFileSizeBytes(long fileSizeBytes) {
            Assertions.checkArgument((fileSizeBytes > 0L || fileSizeBytes == -1L ? 1 : 0) != 0);
            this.fileSizeBytes = fileSizeBytes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAverageAudioBitrate(int averageAudioBitrate) {
            Assertions.checkArgument((averageAudioBitrate > 0 || averageAudioBitrate == -2147483647 ? 1 : 0) != 0);
            this.averageAudioBitrate = averageAudioBitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAverageVideoBitrate(int averageVideoBitrate) {
            Assertions.checkArgument((averageVideoBitrate > 0 || averageVideoBitrate == -2147483647 ? 1 : 0) != 0);
            this.averageVideoBitrate = averageVideoBitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setVideoFrameCount(int videoFrameCount) {
            Assertions.checkArgument((videoFrameCount >= 0 ? 1 : 0) != 0);
            this.videoFrameCount = videoFrameCount;
            return this;
        }

        public TransformationResult build() {
            return new TransformationResult(this.durationMs, this.fileSizeBytes, this.averageAudioBitrate, this.averageVideoBitrate, this.videoFrameCount);
        }
    }
}

