/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import com.google.android.exoplayer2.BaseRenderer;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.SamplePipeline;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.transformer.Transformer;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.util.MediaClock;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.errorprone.annotations.ForOverride;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

abstract class TransformerBaseRenderer
extends BaseRenderer {
    protected final MuxerWrapper muxerWrapper;
    protected final TransformerMediaClock mediaClock;
    protected final TransformationRequest transformationRequest;
    protected final Transformer.AsyncErrorListener asyncErrorListener;
    protected final FallbackListener fallbackListener;
    private boolean isTransformationRunning;
    protected long streamOffsetUs;
    protected long streamStartPositionUs;
    protected @MonotonicNonNull SamplePipeline samplePipeline;

    public TransformerBaseRenderer(int trackType, MuxerWrapper muxerWrapper, TransformerMediaClock mediaClock, TransformationRequest transformationRequest, Transformer.AsyncErrorListener asyncErrorListener, FallbackListener fallbackListener) {
        super(trackType);
        this.muxerWrapper = muxerWrapper;
        this.mediaClock = mediaClock;
        this.transformationRequest = transformationRequest;
        this.asyncErrorListener = asyncErrorListener;
        this.fallbackListener = fallbackListener;
    }

    public final int supportsFormat(Format format) {
        return RendererCapabilities.create((int)(MimeTypes.getTrackType((String)format.sampleMimeType) == this.getTrackType() ? 4 : 0));
    }

    public final MediaClock getMediaClock() {
        return this.mediaClock;
    }

    public final boolean isReady() {
        return this.isSourceReady();
    }

    public final boolean isEnded() {
        return this.samplePipeline != null && this.samplePipeline.isEnded();
    }

    public final void render(long positionUs, long elapsedRealtimeUs) {
        try {
            if (!this.isTransformationRunning || this.isEnded() || !this.ensureConfigured()) {
                return;
            }
            while (this.samplePipeline.processData() || this.feedPipelineFromInput()) {
            }
        }
        catch (TransformationException e) {
            this.isTransformationRunning = false;
            this.asyncErrorListener.onTransformationException(e);
        }
    }

    protected final void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs) {
        this.streamOffsetUs = offsetUs;
        this.streamStartPositionUs = startPositionUs;
    }

    protected final void onEnabled(boolean joining, boolean mayRenderStartOfStream) {
        this.muxerWrapper.registerTrack();
        this.fallbackListener.registerTrack();
        this.mediaClock.updateTimeForTrackType(this.getTrackType(), 0L);
    }

    protected final void onStarted() {
        this.isTransformationRunning = true;
    }

    protected final void onStopped() {
        this.isTransformationRunning = false;
    }

    protected final void onReset() {
        if (this.samplePipeline != null) {
            this.samplePipeline.release();
        }
    }

    @EnsuresNonNullIf(expression={"samplePipeline"}, result=true)
    @ForOverride
    protected abstract boolean ensureConfigured() throws TransformationException;

    @RequiresNonNull(value={"samplePipeline"})
    private boolean feedPipelineFromInput() throws TransformationException {
        DecoderInputBuffer samplePipelineInputBuffer = this.samplePipeline.dequeueInputBuffer();
        if (samplePipelineInputBuffer == null) {
            return false;
        }
        int result = this.readSource(this.getFormatHolder(), samplePipelineInputBuffer, 0);
        switch (result) {
            case -4: {
                samplePipelineInputBuffer.flip();
                if (samplePipelineInputBuffer.isEndOfStream()) {
                    this.samplePipeline.queueInputBuffer();
                    return false;
                }
                this.mediaClock.updateTimeForTrackType(this.getTrackType(), samplePipelineInputBuffer.timeUs);
                this.samplePipeline.queueInputBuffer();
                return true;
            }
            case -5: {
                throw new IllegalStateException("Format changes are not supported.");
            }
        }
        return false;
    }
}

